/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.signer;

import br.com.elotech.protocolo.domain.AssinaturaConfiguracao;
import br.com.elotech.protocolo.domain.ProcessoArquivo;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.enums.AssinaturaSituacaoEnum;
import br.com.elotech.protocolo.service.arquivo.ArquivoService;
import br.com.elotech.protocolo.signer.AssinaturaPosicaoDTO;
import br.com.elotech.protocolo.signer.PdfSigner;
import br.com.elotech.protocolo.signer.PdfSignerNewKind;
import br.com.elotech.protocolo.signer.PdfSignerOldKind;
import br.com.elotech.protocolo.utils.PdfUtils;
import br.com.elotech.unico.client.dto.EloArquivoDTO;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class PdfSignerFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PdfSignerFactory.class);
    static final long MAX_ASSINATURAS_POR_COLUNA = 10L;
    private static final int ZERO = 0;
    public static final String MSG_LIMITE = "O arquivo esgotou o limite de assinaturas autom\u00e1ticas";

    private PdfSignerFactory() {
    }

    public static PdfSigner getPdfSigner(ArquivoService arquivoService, ProcessoArquivo arquivo, AssinaturaConfiguracao assinaturaConfiguracao, EloArquivoDTO eloArquivoCertificadoDigital, Usuario usuario, EloArquivoDTO eloArquivoDTO, AssinaturaPosicaoDTO assinaturaPosicaoDTO, boolean forceUseOldKind) throws IOException {
        byte[] binary = eloArquivoCertificadoDigital.getContent().getBinary();
        try (ByteArrayInputStream binaryStream = new ByteArrayInputStream(binary);){
            boolean usingNewKind;
            boolean bl = usingNewKind = !forceUseOldKind && (AssinaturaPosicaoDTO.isValid((AssinaturaPosicaoDTO)assinaturaPosicaoDTO) || PdfSignerFactory.utilizaAssinaturaPosicional((ArquivoService)arquivoService, (AssinaturaConfiguracao)assinaturaConfiguracao, (ProcessoArquivo)arquivo, (EloArquivoDTO)eloArquivoDTO));
            if (usingNewKind) {
                if (!Boolean.TRUE.equals(arquivo.getObrigaPosicionamentoAssinatura())) {
                    log.info("Arquivo {} n\u00e3o obriga posicionamento de assinatura, mas est\u00e1 sendo for\u00e7ado a usar assinatura posicional", (Object)arquivo);
                    arquivo.setObrigaPosicionamentoAssinatura(Boolean.valueOf(true));
                }
                PdfSignerNewKind pdfSignerNewKind = new PdfSignerNewKind(binaryStream, assinaturaConfiguracao, usuario, arquivo);
                return pdfSignerNewKind;
            }
            PdfSignerOldKind pdfSignerOldKind = new PdfSignerOldKind(binaryStream, assinaturaConfiguracao, usuario, arquivo);
            return pdfSignerOldKind;
        }
    }

    public static boolean arquivoPrecisaUsarAssinaturaPosicional(ArquivoService arquivoService, AssinaturaConfiguracao configuracao, ProcessoArquivo arquivo, EloArquivoDTO eloArquivo, AtomicReference<String> reason) {
        if (Boolean.TRUE.equals(arquivo.getAgrupamento())) {
            return Boolean.TRUE.equals(arquivo.getObrigaPosicionamentoAssinatura());
        }
        return PdfSignerFactory.pdfAssinadoPeloSigner((ProcessoArquivo)arquivo, reason) || PdfSignerFactory.arquivoConfiguradoParaPosicionar((ProcessoArquivo)arquivo, reason) || PdfSignerFactory.atingiuLimiteAssinaturasAntigas((AssinaturaConfiguracao)configuracao, (ProcessoArquivo)arquivo, reason) || PdfSignerFactory.pdfAssinadoPorFora((ArquivoService)arquivoService, (ProcessoArquivo)arquivo, (EloArquivoDTO)eloArquivo, reason);
    }

    public static boolean utilizaAssinaturaPosicional(ArquivoService arquivoService, AssinaturaConfiguracao configuracao, ProcessoArquivo arquivo, EloArquivoDTO eloArquivo) {
        return PdfSignerFactory.configuracaoObrigaPosicionar((AssinaturaConfiguracao)configuracao) || PdfSignerFactory.arquivoPrecisaUsarAssinaturaPosicional((ArquivoService)arquivoService, (AssinaturaConfiguracao)configuracao, (ProcessoArquivo)arquivo, (EloArquivoDTO)eloArquivo, new AtomicReference());
    }

    static boolean arquivoConfiguradoParaPosicionar(ProcessoArquivo arquivo, AtomicReference<String> reason) {
        if (Boolean.TRUE.equals(arquivo.getObrigaPosicionamentoAssinatura())) {
            log.debug("Arquivo est\u00e1 obrigando posicionamento de assinatura");
            reason.set("A assinatura precisa ser posicionada");
            return true;
        }
        return false;
    }

    static boolean configuracaoObrigaPosicionar(AssinaturaConfiguracao configuracao) {
        if (Boolean.TRUE.equals(configuracao.getPosicionaAssinatura())) {
            log.debug("Assinatura posicional configurada");
            return true;
        }
        return false;
    }

    static boolean pdfAssinadoPeloSigner(ProcessoArquivo arquivo, AtomicReference<String> reason) {
        if (Objects.nonNull(arquivo.getUrlS3()) && arquivo.getUrlS3().endsWith("_signed")) {
            log.info("Arquivo {} foi assinado pelo Signer, ent\u00e3o precisa de assinatura posicional", (Object)arquivo);
            reason.set("O arquivo foi assinado digitalmente");
            return true;
        }
        return false;
    }

    static boolean pdfAssinadoPorFora(ArquivoService arquivoService, ProcessoArquivo arquivo, EloArquivoDTO eloArquivo, AtomicReference<String> reason) {
        boolean result;
        if (Objects.nonNull(arquivo.getPossuiAssinaturaExterna())) {
            log.debug("Arquivo {} possuiAssinaturaExterna={}", (Object)arquivo, (Object)arquivo.getPossuiAssinaturaExterna());
            return arquivo.getPossuiAssinaturaExterna();
        }
        if (arquivo.getQtdAssinaturas() > 0L) {
            log.debug("Arquivo {} j\u00e1 foi assinado pela elotech, ent\u00e3o pode continuar assinando", (Object)arquivo);
            return false;
        }
        if (Objects.isNull(eloArquivo)) {
            eloArquivo = (EloArquivoDTO)arquivoService.downloadArquivo(arquivo.getIdArquivo()).orElseThrow();
        }
        if (result = PdfUtils.pdfHasSignatures((byte[])eloArquivo.getContent().getBinary())) {
            log.info("Presen\u00e7a de assinaturas no arquivo {} \u00e9 {}. Ent\u00e3o {} precisa de assinatura posicional", new Object[]{arquivo, result, result ? "" : "n\u00e3o "});
            reason.set("O arquivo possui assinaturas externas");
        }
        arquivo.setPossuiAssinaturaExterna(Boolean.valueOf(result));
        return result;
    }

    static boolean atingiuLimiteAssinaturasAntigas(AssinaturaConfiguracao configuracao, ProcessoArquivo arquivo, AtomicReference<String> reason) {
        if (arquivo.getAssinaturas().isEmpty()) {
            return false;
        }
        long maxAssinaturas = Optional.ofNullable(configuracao.getQuantidadeColunas()).orElse(1L) * 10L;
        long assinaturas = arquivo.getAssinaturas().stream().filter(a -> AssinaturaSituacaoEnum.ASSINADO.equals((Object)a.getSituacao())).count();
        boolean result = assinaturas >= maxAssinaturas;
        log.info("Arquivo {} j\u00e1 tem {} assinaturas, ent\u00e3o {} precisa de assinatura posicional pois o m\u00e1ximo \u00e9 {}", new Object[]{arquivo, assinaturas, result ? "" : "n\u00e3o ", maxAssinaturas});
        if (result) {
            reason.set("O arquivo esgotou o limite de assinaturas autom\u00e1ticas");
        }
        return result;
    }
}

