/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.signer;

import br.com.elotech.domain.Signature;
import br.com.elotech.protocolo.domain.AssinaturaConfiguracao;
import br.com.elotech.protocolo.domain.ProcessoArquivo;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.signer.AssinaturaPosicaoDTO;
import br.com.elotech.protocolo.utils.PdfUtils;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import br.com.elotech.utils.pdf.sign.PdfSignerUtil;
import br.com.elotech.utils.pdf.sign.PdfStamper;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.apache.pdfbox.util.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PdfSigner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PdfSigner.class);
    private static final int QUADRANTE3 = 3;
    private static final int QUADRANTE2 = 2;
    private static final int QUADRANTE1 = 1;
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfSigner.class);
    private static final String KEY_STORE_TYPE = "jks";
    private static final int MDP_PROTECTION_LEVEL = 2;
    private static final String MDP_VERSION = "1.2";
    private final AssinaturaConfiguracao assinaturaConfiguracao;
    private final Usuario usuario;
    private final ByteArrayInputStream keyStoreFile;
    private final String keyStorePassword;
    private final String certificateAlias;
    private final String carimboNome;
    private final Long fontSize;
    private final ProcessoArquivo processoArquivo;
    private String urlAutenticidade;
    private byte[] carimbo;

    protected PdfSigner(ByteArrayInputStream keyStoreFile, AssinaturaConfiguracao assinaturaConfiguracao, Usuario usuario, ProcessoArquivo processoArquivo) {
        this.assinaturaConfiguracao = assinaturaConfiguracao;
        this.keyStoreFile = keyStoreFile;
        this.keyStorePassword = assinaturaConfiguracao.getSenhaCertificado();
        this.certificateAlias = assinaturaConfiguracao.getAliasCertificado();
        this.carimboNome = assinaturaConfiguracao.getNomeArquivoCarimbo();
        this.usuario = usuario;
        this.fontSize = Objects.requireNonNullElse(assinaturaConfiguracao.getTamanhoFonte(), 10L);
        this.processoArquivo = processoArquivo;
    }

    public abstract boolean isNewKind();

    public boolean isOldKind() {
        return !this.isNewKind();
    }

    public Path signPdf(byte[] pdfToSign, AssinaturaPosicaoDTO assinaturaPosicaoDTO) throws CertificateExpiredException {
        try {
            KeyStore keyStore = this.getKeyStore();
            Signature signature = new Signature(keyStore, this.keyStorePassword.toCharArray(), this.certificateAlias, null);
            this.validPageNumber(pdfToSign, assinaturaPosicaoDTO.getPage());
            File pdfFile = File.createTempFile("pdf", "pdf");
            FileUtils.writeByteArrayToFile((File)pdfFile, (byte[])pdfToSign);
            File signedPdf = File.createTempFile("signedPdf", "pdf");
            this.signDetached((SignatureInterface)signature, pdfFile, signedPdf, assinaturaPosicaoDTO);
            pdfFile.deleteOnExit();
            signedPdf.deleteOnExit();
            return signedPdf.toPath();
        }
        catch (CertificateExpiredException e) {
            LOGGER.error("Expired Certificate", (Throwable)e);
            throw new CertificateExpiredException(String.format("O certificado informado est\u00e1 expirado. %s", e.getMessage()));
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            LOGGER.error("Cannot obtain proper KeyStore or Certificate", (Throwable)e);
            throw new CertificateExpiredException(String.format("Cannot obtain proper KeyStore or Certificate. %s", e.getMessage()));
        }
        catch (IOException e) {
            LOGGER.error("Cannot obtain proper file", (Throwable)e);
            throw new CertificateExpiredException(String.format("Cannot obtain proper file. %s", e.getMessage()));
        }
    }

    protected KeyStore getKeyStore() throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        KeyStore keyStore = KeyStore.getInstance(KEY_STORE_TYPE);
        keyStore.load(this.keyStoreFile, this.keyStorePassword.toCharArray());
        return keyStore;
    }

    protected File prepareSignature(File inFile) {
        return inFile;
    }

    protected void signDetached(SignatureInterface signature, File inFile, File outFile, AssinaturaPosicaoDTO assinaturaPosicaoDTO) throws IOException {
        this.validateFileExists(inFile);
        File newInFile = this.prepareSignature(inFile);
        this.validateFileExists(newInFile);
        try (FileOutputStream fos = new FileOutputStream(outFile);
             PDDocument doc = Loader.loadPDF((File)newInFile);){
            this.signDetached(signature, doc, (OutputStream)fos, assinaturaPosicaoDTO);
        }
    }

    private void validateFileExists(File inFile) throws FileNotFoundException {
        if (inFile == null || !inFile.exists()) {
            throw new FileNotFoundException(String.format("Arquivo %s n\u00e3o encontrado", inFile));
        }
    }

    private void validPageNumber(byte[] pdfInput, Integer pageNumber) throws IOException {
        int totalPages = PdfStamper.builder().pdfInput(pdfInput).build().getPdfTotalPages();
        if (pageNumber < 1 || pageNumber > totalPages) {
            throw new IllegalArgumentException(String.format("A p\u00e1gina informada [%s] deve ser >= 1 e <= %s", pageNumber, totalPages));
        }
    }

    protected String getSignatureText() {
        StringBuilder signatureText = new StringBuilder(String.format("Assinado por: %s", this.getUsuario().getNome()));
        if (Boolean.TRUE.equals(this.getAssinaturaConfiguracao().getShowCpf())) {
            signatureText.append(String.format(" - %s", this.getUsuario().getCpf()));
        }
        if (Boolean.TRUE.equals(this.getAssinaturaConfiguracao().getShowData())) {
            signatureText.append(String.format(" %s", LocalDate.now().format(DateTimeFormatter.ofPattern("dd/MM/yyyy"))));
        }
        if (Boolean.TRUE.equals(this.getAssinaturaConfiguracao().getShowHora())) {
            signatureText.append(String.format(" %s", LocalTime.now().format(DateTimeFormatter.ofPattern("HH:mm:ss"))));
        }
        if (Objects.nonNull(this.getAssinaturaConfiguracao().getDecreto())) {
            signatureText.append(String.format(" %s", this.getAssinaturaConfiguracao().getDecreto()));
        }
        return signatureText.toString();
    }

    public void signDetached(SignatureInterface signature, PDDocument doc, OutputStream output, AssinaturaPosicaoDTO assinaturaPosicaoDTO) throws IOException {
        assinaturaPosicaoDTO.setPage(Integer.valueOf(assinaturaPosicaoDTO.getPage() - 1));
        String signatureText = this.getSignatureText();
        PDSignature pdSignature = new PDSignature();
        pdSignature.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
        pdSignature.setSubFilter(PDSignature.SUBFILTER_ADBE_PKCS7_DETACHED);
        pdSignature.setName(signatureText);
        pdSignature.setReason((String)StringUtils.firstNonBlank((CharSequence[])new String[]{this.assinaturaConfiguracao.getDecreto(), signatureText}));
        pdSignature.setContactInfo(this.urlAutenticidade);
        pdSignature.setLocation(RequestHeaderHelper.getEntidadeContextHolder().getCidadeCompleta());
        pdSignature.setSignDate(Calendar.getInstance());
        if (Boolean.TRUE.equals(this.assinaturaConfiguracao.getAplicarProtecaoDocMdp())) {
            this.aplicarDocMDP(pdSignature);
        }
        try (SignatureOptions signatureOptions = new SignatureOptions();){
            signatureOptions.setPreferredSignatureSize(20000);
            signatureOptions.setVisualSignature((InputStream)this.getVisualSignatureTemplate(doc, assinaturaPosicaoDTO));
            signatureOptions.setPage(assinaturaPosicaoDTO.getPage().intValue());
            doc.addSignature(pdSignature, signature, signatureOptions);
            doc.saveIncremental(output);
        }
    }

    protected Rectangle2D createSignatureBox(String text, Float posX, Float posY) {
        return Optional.ofNullable(text).map(t -> {
            float margem = 19.6f;
            int fontSize = this.getFontSize().intValue();
            float textHeight = PdfSignerUtil.getTextAsImageHeight(Optional.of(fontSize), Optional.empty());
            float imageHeight = textHeight + margem;
            float imageWight = PdfUtils.getTextAsImageWidth((String)t, Optional.of(fontSize)) + margem;
            return new Rectangle2D.Float(posX.floatValue(), posY.floatValue(), imageWight + 50.0f, imageHeight + 30.0f);
        }).orElse(new Rectangle2D.Float(0.0f, 0.0f, 0.1f, 0.1f));
    }

    protected PDRectangle createSignatureRectangle(PDDocument doc, Rectangle2D humanRect, int pageNum) {
        float x = (float)humanRect.getX();
        float y = (float)humanRect.getY();
        float width = (float)humanRect.getWidth();
        float height = (float)humanRect.getHeight();
        PDPage page = doc.getPage(pageNum);
        PDRectangle pageRect = page.getCropBox();
        PDRectangle rect = new PDRectangle();
        switch (page.getRotation()) {
            case 90: {
                rect.setLowerLeftY(x);
                rect.setUpperRightY(x + width);
                rect.setLowerLeftX(y);
                rect.setUpperRightX(y + height);
                break;
            }
            case 180: {
                rect.setUpperRightX(pageRect.getWidth() - x);
                rect.setLowerLeftX(pageRect.getWidth() - x - width);
                rect.setLowerLeftY(y);
                rect.setUpperRightY(y + height);
                break;
            }
            case 270: {
                rect.setLowerLeftY(pageRect.getHeight() - x - width);
                rect.setUpperRightY(pageRect.getHeight() - x);
                rect.setLowerLeftX(pageRect.getWidth() - y - height);
                rect.setUpperRightX(pageRect.getWidth() - y);
                break;
            }
            default: {
                rect.setLowerLeftX(x);
                rect.setUpperRightX(x + width);
                rect.setLowerLeftY(pageRect.getHeight() - y - height - 10.0f);
                rect.setUpperRightY(pageRect.getHeight() - y);
            }
        }
        rect.setUpperRightX(rect.getUpperRightX() + pageRect.getLowerLeftX());
        rect.setLowerLeftX(rect.getLowerLeftX() + pageRect.getLowerLeftX());
        rect.setUpperRightY(rect.getUpperRightY() + pageRect.getLowerLeftY());
        rect.setLowerLeftY(rect.getLowerLeftY() + pageRect.getLowerLeftY());
        return rect;
    }

    protected abstract Rectangle2D getHumanRect(AssinaturaPosicaoDTO var1);

    private ByteArrayInputStream getVisualSignatureTemplate(PDDocument srcDoc, AssinaturaPosicaoDTO assinaturaPosicaoDTO) throws IOException {
        int pageNum = assinaturaPosicaoDTO.getPage();
        Rectangle2D humanRect = this.getHumanRect(assinaturaPosicaoDTO);
        PDRectangle rect = this.createSignatureRectangle(srcDoc, humanRect, pageNum);
        try (PDDocument doc = new PDDocument();){
            PDPage page = new PDPage(srcDoc.getPage(pageNum).getMediaBox());
            doc.addPage(page);
            PDAcroForm acroForm = new PDAcroForm(doc);
            doc.getDocumentCatalog().setAcroForm(acroForm);
            PDSignatureField signatureField = new PDSignatureField(acroForm);
            PDAnnotationWidget widget = (PDAnnotationWidget)signatureField.getWidgets().getFirst();
            List acroFormFields = acroForm.getFields();
            acroForm.setSignaturesExist(true);
            acroForm.setAppendOnly(true);
            acroForm.getCOSObject().setDirect(true);
            acroFormFields.add(signatureField);
            widget.setRectangle(rect);
            PDStream stream = new PDStream(doc);
            PDFormXObject form = new PDFormXObject(stream);
            PDResources res = new PDResources();
            form.setResources(res);
            form.setFormType(1);
            PDRectangle bbox = new PDRectangle(rect.getWidth(), rect.getHeight());
            float height = bbox.getHeight();
            float width = bbox.getWidth();
            Matrix initialScale = null;
            switch (srcDoc.getPage(pageNum).getRotation()) {
                case 90: {
                    form.setMatrix(AffineTransform.getQuadrantRotateInstance(1));
                    initialScale = Matrix.getScaleInstance((float)(bbox.getWidth() / bbox.getHeight()), (float)(bbox.getHeight() / bbox.getWidth()));
                    height = bbox.getWidth();
                    width = bbox.getHeight();
                    break;
                }
                case 180: {
                    form.setMatrix(AffineTransform.getQuadrantRotateInstance(2));
                    break;
                }
                case 270: {
                    form.setMatrix(AffineTransform.getQuadrantRotateInstance(3));
                    initialScale = Matrix.getScaleInstance((float)(bbox.getWidth() / bbox.getHeight()), (float)(bbox.getHeight() / bbox.getWidth()));
                    height = bbox.getWidth();
                    width = bbox.getHeight();
                    break;
                }
            }
            form.setBBox(bbox);
            PDAppearanceDictionary appearance = new PDAppearanceDictionary();
            appearance.getCOSObject().setDirect(true);
            PDAppearanceStream appearanceStream = new PDAppearanceStream(form.getCOSObject());
            appearance.setNormalAppearance(appearanceStream);
            widget.setAppearance(appearance);
            try (PDPageContentStream cs = new PDPageContentStream(doc, appearanceStream);){
                cs.moveTo(0.0f, 0.0f);
                if (initialScale != null) {
                    cs.transform(initialScale);
                }
                this.setSignatureVisual(cs, doc, height, width, assinaturaPosicaoDTO);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            doc.save((OutputStream)baos);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
            return byteArrayInputStream;
        }
    }

    private void aplicarDocMDP(PDSignature signature) {
        log.debug("Aplicando prote\u00e7\u00e3o DocMDP na assinatura");
        COSDictionary sigDict = signature.getCOSObject();
        COSDictionary transformParams = new COSDictionary();
        transformParams.setName(COSName.TYPE.getName(), COSName.TRANSFORM_PARAMS.getName());
        transformParams.setInt("P", 2);
        transformParams.setName("V", MDP_VERSION);
        COSDictionary sigRef = new COSDictionary();
        sigRef.setName(COSName.TYPE.getName(), COSName.SIG_REF.getName());
        sigRef.setName(COSName.TRANSFORM_METHOD, COSName.DOCMDP.getName());
        sigRef.setItem(COSName.TRANSFORM_PARAMS, (COSBase)transformParams);
        COSArray referenceArray = new COSArray();
        referenceArray.add((COSBase)sigRef);
        sigDict.setItem(COSName.REFERENCE, (COSBase)referenceArray);
    }

    protected abstract void setSignatureVisual(PDPageContentStream var1, PDDocument var2, float var3, float var4, AssinaturaPosicaoDTO var5) throws IOException;

    @Generated
    public void setUrlAutenticidade(String urlAutenticidade) {
        this.urlAutenticidade = urlAutenticidade;
    }

    @Generated
    public void setCarimbo(byte[] carimbo) {
        this.carimbo = carimbo;
    }

    @Generated
    protected AssinaturaConfiguracao getAssinaturaConfiguracao() {
        return this.assinaturaConfiguracao;
    }

    @Generated
    protected Usuario getUsuario() {
        return this.usuario;
    }

    @Generated
    protected ByteArrayInputStream getKeyStoreFile() {
        return this.keyStoreFile;
    }

    @Generated
    protected String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @Generated
    protected String getCertificateAlias() {
        return this.certificateAlias;
    }

    @Generated
    protected String getCarimboNome() {
        return this.carimboNome;
    }

    @Generated
    protected Long getFontSize() {
        return this.fontSize;
    }

    @Generated
    protected ProcessoArquivo getProcessoArquivo() {
        return this.processoArquivo;
    }

    @Generated
    protected String getUrlAutenticidade() {
        return this.urlAutenticidade;
    }

    @Generated
    protected byte[] getCarimbo() {
        return this.carimbo;
    }
}

