/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.signer;

import br.com.elotech.domain.PDFonts;
import br.com.elotech.protocolo.domain.AssinaturaConfiguracao;
import br.com.elotech.protocolo.domain.ProcessoArquivo;
import br.com.elotech.protocolo.exception.AssinadorDigitalException;
import br.com.elotech.protocolo.utils.PdfUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccessStreamCache;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationSquare;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.util.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class PdfMarginaliaUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PdfMarginaliaUtils.class);
    private static final int QRCODE_LEN = 35;
    private static final float MARGINALIA_FONT = 6.0f;
    private static final float MARGINALIA_BORDA = 10.0f;
    private static final PDFont FONT_CONTENT = PDFonts.HELVETICA.getFont();
    private static final float BORDA = 5.0f;
    private static final float MARGINALIA_FONT_FACTOR = 0.006f;
    private static final float QRCODE_LEN_WITH_BORDER = 40.0f;

    public static void addMarginalia(AssinaturaConfiguracao assinaturaConfiguracao, ProcessoArquivo processoArquivo, File input, File output, Boolean hasAssinaturas) throws IOException {
        log.debug("Iniciando processo para adicionar margin\u00e1lia no arquivo {}", (Object)processoArquivo);
        try (FileOutputStream fos = new FileOutputStream(output);
             PDDocument doc = Loader.loadPDF((File)input, (RandomAccessStreamCache.StreamCacheCreateFunction)IOUtils.createTempFileOnlyStreamCache());){
            String text;
            StringJoiner sj = new StringJoiner(" - ");
            sj.add(Boolean.TRUE.equals(hasAssinaturas) ? "Assinatura eletr\u00f4nica" : "Valida\u00e7\u00e3o do Arquivo");
            String urlAutenticidade = assinaturaConfiguracao.getUrlAutenticidade();
            if (StringUtils.isNotBlank((CharSequence)urlAutenticidade)) {
                sj.add(String.format("Verifique pelo QRCode ou pelo link %s", urlAutenticidade));
            }
            String textIdentificador = String.format("Identificador: %s", processoArquivo.getIdentificador());
            sj.add(textIdentificador);
            String textDefault = sj.toString();
            String amparo = StringUtils.trim((String)assinaturaConfiguracao.getDecreto());
            String string = text = Boolean.TRUE.equals(hasAssinaturas) && StringUtils.isNotBlank((CharSequence)amparo) ? String.format("%s%n%s", amparo, textDefault) : textDefault;
            if (PdfMarginaliaUtils.shouldAddMarginalia((ProcessoArquivo)processoArquivo, (PDDocument)doc, (String)textIdentificador)) {
                AtomicInteger pageNumber = new AtomicInteger(1);
                doc.getPages().forEach(page -> PdfMarginaliaUtils.addPageMarginalia((AssinaturaConfiguracao)assinaturaConfiguracao, (ProcessoArquivo)processoArquivo, (PDDocument)doc, (PDPage)page, (String)text, (int)pageNumber.getAndIncrement()));
            }
            try {
                doc.saveIncremental((OutputStream)fos);
            }
            catch (IOException e) {
                throw new AssinadorDigitalException("Falha ao salvar o arquivo com a margin\u00e1lia: " + e.getLocalizedMessage(), (Exception)e);
            }
        }
    }

    private static boolean shouldAddMarginalia(ProcessoArquivo processoArquivo, PDDocument doc, String text) {
        String pdfText = PdfUtils.extractPdfText((PDDocument)doc).replaceAll("\\s+", "");
        boolean alreadyInDoc = pdfText.contains(text.replaceAll("\\s+", ""));
        if (alreadyInDoc) {
            log.debug("A margin\u00e1lia j\u00e1 est\u00e1 no documento {}", (Object)processoArquivo);
        }
        return !alreadyInDoc;
    }

    private static void addPageMarginalia(AssinaturaConfiguracao assinaturaConfiguracao, ProcessoArquivo processoArquivo, PDDocument doc, PDPage page, String text, int pageNumber) {
        try {
            log.debug("Adicionando margin\u00e1lia na p\u00e1gina {} do arquivo {}", (Object)pageNumber, (Object)processoArquivo);
            PDRectangle mediaBox = page.getMediaBox();
            float pageWidth = mediaBox.getWidth();
            float pageHeight = mediaBox.getHeight();
            String pageText = String.format("%s - P\u00e1gina %d/%d", text, pageNumber, doc.getNumberOfPages());
            List lines = Arrays.stream(pageText.split("[\\r\\n]+")).collect(Collectors.toList());
            float textWidth = 0.0f;
            for (String line : lines) {
                textWidth = Math.max(textWidth, FONT_CONTENT.getStringWidth(line) * 0.006f);
            }
            float lineHeight = FONT_CONTENT.getFontDescriptor().getFontBoundingBox().getHeight() * 0.006f;
            float textHeight = lineHeight * (float)lines.size();
            PDRectangle box = PdfMarginaliaUtils.getBox((AssinaturaConfiguracao)assinaturaConfiguracao, (float)textWidth, (float)textHeight);
            float posX = pageWidth - 10.0f - box.getWidth();
            float posY = (pageHeight - box.getHeight()) / 2.0f;
            PDRectangle rect = new PDRectangle(posX, posY, box.getWidth(), box.getHeight());
            PDAnnotationSquare annotation = new PDAnnotationSquare();
            annotation.setRectangle(rect);
            annotation.setPage(page);
            annotation.setLockedContents(true);
            annotation.setLocked(true);
            annotation.setNoRotate(false);
            annotation.setReadOnly(true);
            annotation.setPrinted(true);
            PDAppearanceStream appearanceStream = new PDAppearanceStream(doc);
            appearanceStream.setBBox(new PDRectangle(rect.getWidth(), rect.getHeight()));
            appearanceStream.setResources(new PDResources());
            PdfMarginaliaUtils.addPageMarginaliaQrCode((AssinaturaConfiguracao)assinaturaConfiguracao, (ProcessoArquivo)processoArquivo, (PDDocument)doc, (PDAppearanceStream)appearanceStream, (float)textHeight, (float)box.getWidth(), lines, (float)lineHeight);
            PDAppearanceDictionary appearanceDict = new PDAppearanceDictionary();
            appearanceDict.setNormalAppearance(appearanceStream);
            annotation.setAppearance(appearanceDict);
            page.getAnnotations().add(annotation);
        }
        catch (IOException e) {
            log.error("Erro ao adicionar margin\u00e1lia na p\u00e1gina {} do arquivo {}: {}", new Object[]{pageNumber, processoArquivo, e.getMessage()});
            throw new AssinadorDigitalException("Erro ao adicionar margin\u00e1lia no PDF: " + e.getMessage(), (Exception)e);
        }
    }

    private static PDRectangle getBox(AssinaturaConfiguracao assinaturaConfiguracao, float textWidth, float textHeight) {
        float boxH = textWidth;
        float boxW = Math.max(35.0f, textHeight);
        if (StringUtils.isNotBlank((CharSequence)assinaturaConfiguracao.getUrlAutenticidade())) {
            boxH += 40.0f;
            boxW = Math.max(35.0f, boxW);
        }
        return new PDRectangle(boxW, boxH);
    }

    private static void addPageMarginaliaQrCode(AssinaturaConfiguracao assinaturaConfiguracao, ProcessoArquivo processoArquivo, PDDocument doc, PDAppearanceStream appearanceStream, float textHeight, float boxW, List<String> lines, float lineHeight) throws IOException {
        try (PDPageContentStream cs = new PDPageContentStream(doc, appearanceStream);){
            cs.beginText();
            cs.setFont(FONT_CONTENT, 6.0f);
            cs.setTextMatrix(Matrix.getRotateInstance((double)1.5707963267948966, (float)0.0f, (float)0.0f));
            float tx = 40.0f;
            float ty = textHeight - boxW;
            cs.newLineAtOffset(tx, ty);
            for (String line : lines) {
                cs.showText(line);
                cs.newLineAtOffset(0.0f, -lineHeight);
            }
            cs.endText();
            if (!StringUtils.isBlank((CharSequence)assinaturaConfiguracao.getUrlAutenticidade())) {
                String url = String.format("%s?identificador=%s", assinaturaConfiguracao.getUrlAutenticidade(), processoArquivo.getIdentificador());
                PDImageXObject pdImage = PdfUtils.generateQRCodePdImage((PDDocument)doc, (String)url, (int)35);
                cs.drawImage(pdImage, 0.0f, 0.0f, 35.0f, 35.0f);
            }
        }
    }

    @Generated
    private PdfMarginaliaUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

