/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service.util;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Arrays;
import org.apache.fontbox.util.BoundingBox;
import org.apache.pdfbox.contentstream.PDFGraphicsStreamEngine;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType2;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType3CharProc;
import org.apache.pdfbox.pdmodel.font.PDType3Font;
import org.apache.pdfbox.pdmodel.font.PDVectorFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.Vector;

public class BoundingBoxFinder
extends PDFGraphicsStreamEngine {
    Rectangle2D rectanglePath = null;
    Rectangle2D rectangle = null;

    public BoundingBoxFinder(PDPage page) {
        super(page);
    }

    public Rectangle2D getBoundingBox() {
        return this.rectangle;
    }

    protected void showGlyph(Matrix textRenderingMatrix, PDFont font, int code, Vector displacement) throws IOException {
        super.showGlyph(textRenderingMatrix, font, code, displacement);
        Shape shape = this.calculateGlyphBounds(textRenderingMatrix, font, code);
        if (shape != null) {
            Rectangle2D rect = shape.getBounds2D();
            this.add(rect);
        }
    }

    private Shape calculateGlyphBounds(Matrix textRenderingMatrix, PDFont font, int code) throws IOException {
        GeneralPath path = null;
        AffineTransform at = textRenderingMatrix.createAffineTransform();
        at.concatenate(font.getFontMatrix().createAffineTransform());
        if (font instanceof PDType3Font) {
            PDType3Font t3Font = (PDType3Font)font;
            PDType3CharProc charProc = t3Font.getCharProc(code);
            if (charProc != null) {
                BoundingBox fontBBox = t3Font.getBoundingBox();
                PDRectangle glyphBBox = charProc.getGlyphBBox();
                if (glyphBBox != null) {
                    glyphBBox.setLowerLeftX(Math.max(fontBBox.getLowerLeftX(), glyphBBox.getLowerLeftX()));
                    glyphBBox.setLowerLeftY(Math.max(fontBBox.getLowerLeftY(), glyphBBox.getLowerLeftY()));
                    glyphBBox.setUpperRightX(Math.min(fontBBox.getUpperRightX(), glyphBBox.getUpperRightX()));
                    glyphBBox.setUpperRightY(Math.min(fontBBox.getUpperRightY(), glyphBBox.getUpperRightY()));
                    path = glyphBBox.toGeneralPath();
                }
            }
        } else if (font instanceof PDVectorFont) {
            PDType0Font t0font;
            int unitsPerEm;
            PDVectorFont vectorFont = (PDVectorFont)font;
            path = vectorFont.getPath(code);
            if (font instanceof PDTrueTypeFont) {
                PDTrueTypeFont ttFont = (PDTrueTypeFont)font;
                unitsPerEm = ttFont.getTrueTypeFont().getHeader().getUnitsPerEm();
                at.scale(1000.0 / (double)unitsPerEm, 1000.0 / (double)unitsPerEm);
            }
            if (font instanceof PDType0Font && (t0font = (PDType0Font)font).getDescendantFont() instanceof PDCIDFontType2) {
                unitsPerEm = ((PDCIDFontType2)t0font.getDescendantFont()).getTrueTypeFont().getHeader().getUnitsPerEm();
                at.scale(1000.0 / (double)unitsPerEm, 1000.0 / (double)unitsPerEm);
            }
        } else if (font instanceof PDSimpleFont) {
            PDSimpleFont simpleFont = (PDSimpleFont)font;
            String name = simpleFont.getEncoding().getName(code);
            path = simpleFont.getPath(name);
        } else {
            System.out.println("Unknown font class: " + String.valueOf(font.getClass()));
        }
        if (path == null) {
            return null;
        }
        return at.createTransformedShape(path.getBounds2D());
    }

    public void drawImage(PDImage pdImage) throws IOException {
        Matrix ctm = this.getGraphicsState().getCurrentTransformationMatrix();
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 2; ++y) {
                this.add(new Point2D[]{ctm.transformPoint((float)x, (float)y)});
            }
        }
    }

    public void appendRectangle(Point2D p0, Point2D p1, Point2D p2, Point2D p3) throws IOException {
        this.addToPath(new Point2D[]{p0, p1, p2, p3});
    }

    public void clip(int windingRule) throws IOException {
    }

    public void moveTo(float x, float y) throws IOException {
        this.addToPath((double)x, (double)y);
    }

    public void lineTo(float x, float y) throws IOException {
        this.addToPath((double)x, (double)y);
    }

    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) throws IOException {
        this.addToPath((double)x1, (double)y1);
        this.addToPath((double)x2, (double)y2);
        this.addToPath((double)x3, (double)y3);
    }

    public Point2D getCurrentPoint() throws IOException {
        return new Point2D.Float();
    }

    public void closePath() throws IOException {
    }

    public void endPath() throws IOException {
        this.rectanglePath = null;
    }

    public void strokePath() throws IOException {
        this.addPath();
    }

    public void fillPath(int windingRule) throws IOException {
        this.addPath();
    }

    public void fillAndStrokePath(int windingRule) throws IOException {
        this.addPath();
    }

    public void shadingFill(COSName shadingName) throws IOException {
    }

    void addToPath(Point2D ... points) {
        Arrays.asList(points).forEach(p -> this.addToPath(p.getX(), p.getY()));
    }

    void addToPath(double newx, double newy) {
        if (this.rectanglePath == null) {
            this.rectanglePath = new Rectangle2D.Double(newx, newy, 0.0, 0.0);
        } else {
            this.rectanglePath.add(newx, newy);
        }
    }

    void addPath() {
        if (this.rectanglePath != null) {
            this.add(this.rectanglePath);
            this.rectanglePath = null;
        }
    }

    void add(Rectangle2D rect) {
        if (this.rectangle == null) {
            this.rectangle = new Rectangle2D.Double();
            this.rectangle.setRect(rect);
        } else {
            this.rectangle.add(rect);
        }
    }

    void add(Point2D ... points) {
        for (Point2D point : points) {
            this.add(point.getX(), point.getY());
        }
    }

    void add(double newx, double newy) {
        if (this.rectangle == null) {
            this.rectangle = new Rectangle2D.Double(newx, newy, 0.0, 0.0);
        } else {
            this.rectangle.add(newx, newy);
        }
    }
}

