/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service.stub;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.protocolo.domain.Pessoa;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.dto.PessoaDTO;
import br.com.elotech.protocolo.dto.ProcessoDTO;
import br.com.elotech.protocolo.dto.ProcessoInteressadoDTO;
import br.com.elotech.protocolo.repository.PessoaRepository;
import br.com.elotech.protocolo.service.PessoaService;
import java.util.List;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Profile(value={"test & !standalone & !cloud"})
@Service
public class PessoaServiceStub
extends CrudService<Pessoa, Long>
implements PessoaService {
    private final ProtocoloMapper protocoloMapper;

    public PessoaServiceStub(ProtocoloMapper protocoloMapper) {
        this.protocoloMapper = protocoloMapper;
    }

    public PessoaRepository getPessoas() {
        return (PessoaRepository)this.getRepository();
    }

    public PessoaDTO savePessoa(PessoaDTO pessoaDTO) {
        Pessoa pessoa = this.protocoloMapper.toPessoa(pessoaDTO);
        return this.protocoloMapper.toPessoaDTO((Pessoa)this.getPessoas().save((Object)pessoa));
    }

    public PessoaDTO savePessoaProcessoExterno(ProcessoDTO processoDTO) {
        return this.savePessoa(processoDTO.getPessoa());
    }

    public PessoaDTO savePessoaProcessoInteressadoExterno(ProcessoInteressadoDTO interessadoDTO) {
        return this.savePessoa(interessadoDTO.getPessoa());
    }

    public List<Pessoa> getPessoaDuplicateByCpfCnpj(String cnpjCpf) {
        return this.getPessoas().findAllBycnpjCpf(cnpjCpf);
    }

    public List<Pessoa> getPessoaByCnpjCpfOrderById(String cnpjCpf) {
        return this.getPessoas().findAllByCnpjCpfOrderById(cnpjCpf);
    }

    public List<Pessoa> findAllByAtivoIsTrueAndCnpjCpfOrderById(String cnpjCpf) {
        return this.getPessoas().findAllByAtivoIsTrueAndCnpjCpfOrderById(cnpjCpf);
    }
}

