/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service.assinatura.validators;

import br.com.elotech.protocolo.conditional.StandaloneSemUnicoConditional;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.service.assinatura.validators.UsuarioSenhaValidator;
import org.springframework.context.annotation.Conditional;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={StandaloneSemUnicoConditional.class})
public class UsuarioSenhaStandaloneValidator
implements UsuarioSenhaValidator {
    private final AuthenticationManager authenticationManager;

    public UsuarioSenhaStandaloneValidator(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public Boolean validarSenha(String senha, Usuario usuario) {
        UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)usuario.getId(), (Object)senha);
        try {
            Authentication authentication = this.authenticationManager.authenticate((Authentication)authenticationToken);
            return authentication.isAuthenticated();
        }
        catch (BadCredentialsException e) {
            return Boolean.FALSE;
        }
    }
}

