/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service.assinatura.validators;

import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.service.assinatura.validators.UsuarioSenhaValidator;
import br.com.elotech.unico.client.AuthenticationClientUnicoFeign;
import br.com.elotech.unico.client.domain.AuthenticationDetails;
import br.com.elotech.unico.client.dto.LoginDTO;
import feign.FeignException;
import java.util.Objects;
import org.springframework.context.annotation.Profile;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"onpremise", "unico"})
public class UsuarioSenhaOnpremiseValidator
implements UsuarioSenhaValidator {
    private final AuthenticationClientUnicoFeign clientUnicoFeign;

    public UsuarioSenhaOnpremiseValidator(PasswordEncoder encoder, AuthenticationClientUnicoFeign clientUnicoFeign) {
        this.clientUnicoFeign = clientUnicoFeign;
    }

    public Boolean validarSenha(String senha, Usuario usuario) {
        try {
            AuthenticationDetails authenticate = this.clientUnicoFeign.authenticate(LoginDTO.builder().username(usuario.getId()).password(String.valueOf(senha)).rememberMe(true).build());
            return !Objects.isNull(authenticate.getToken());
        }
        catch (FeignException e) {
            return Boolean.FALSE;
        }
    }
}

