/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service.assinatura;

import br.com.elotech.adm.exception.AlteracaoNaoPermitidaException;
import br.com.elotech.client.painel.feign.NotificationFeign;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.lib.painel.dto.DataNotificationDTO;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.outbox.domain.OutboxActions;
import br.com.elotech.protocolo.converter.HashMapConverter;
import br.com.elotech.protocolo.domain.FluxoAssinatura;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.ProcessoArquivo;
import br.com.elotech.protocolo.domain.ProcessoArquivoAssinatura;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.dto.UsuarioAssinanteDTO;
import br.com.elotech.protocolo.enums.AssinaturaSituacaoEnum;
import br.com.elotech.protocolo.enums.TipoIntegracaoEnum;
import br.com.elotech.protocolo.mail.senders.impl.ProcessoArquivoAssinaturaEmailSender;
import br.com.elotech.protocolo.repository.ProcessoArquivoRepository;
import br.com.elotech.protocolo.service.FluxoAssinaturaService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.UsuarioService;
import br.com.elotech.protocolo.service.assinatura.AssinaturaIntegracaoService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AssinaturaSolicitaService {
    private final ProcessoArquivoAssinaturaEmailSender emailSender;
    private final ParametroService parametroService;
    private final UsuarioService usuarioService;
    private final ProcessoArquivoRepository processoArquivoRepository;
    private final FluxoAssinaturaService fluxoAssinaturaService;
    private final AssinaturaIntegracaoService assinaturaIntegracaoService;
    private final NotificationFeign notificationFeign;

    public AssinaturaSolicitaService(ProcessoArquivoAssinaturaEmailSender emailSender, ParametroService parametroService, UsuarioService usuarioService, ProcessoArquivoRepository processoArquivoRepository, FluxoAssinaturaService fluxoAssinaturaService, AssinaturaIntegracaoService assinaturaIntegracaoService, NotificationFeign notificationFeign) {
        this.emailSender = emailSender;
        this.parametroService = parametroService;
        this.usuarioService = usuarioService;
        this.processoArquivoRepository = processoArquivoRepository;
        this.fluxoAssinaturaService = fluxoAssinaturaService;
        this.assinaturaIntegracaoService = assinaturaIntegracaoService;
        this.notificationFeign = notificationFeign;
    }

    @Transactional
    public void solicitarAssinatura(String identificador, List<String> usuarios, String usuarioSolicitanteId) {
        this.solicitarAssinatura(identificador, usuarios, usuarioSolicitanteId, null, null);
    }

    @Transactional
    public void solicitarAssinatura(String identificador, List<String> usuarios, String usuarioSolicitanteId, Long fluxoAssinanteSequencia, String tipoAssinante) {
        boolean permiteSolicitacaoDuplicada = this.parametroService.getParamValueAsBoolean(ParametroEnum.PERMITE_SOLICITACAO_ASSINATURA_USUARIO_DUPLICADA_ARQUIVO.getCodigo());
        ProcessoArquivo processoArquivo = this.processoArquivoRepository.findByIdentificador(identificador);
        ArrayList notificaLista = new ArrayList();
        usuarios.forEach(usuarioId -> {
            boolean usuarioDuplicado = processoArquivo.getAssinaturas().stream().anyMatch(a -> a.getUsuario().getId().equals(usuarioId));
            if (usuarioDuplicado && !permiteSolicitacaoDuplicada) {
                throw new AlteracaoNaoPermitidaException(ProcessoArquivoAssinatura.class, String.format("Assinatura j\u00e1 foi solicitada para o usu\u00e1rio %s", usuarioId));
            }
            Usuario usuarioSolicitante = new Usuario();
            usuarioSolicitante.setId(usuarioSolicitanteId);
            Usuario usuario = this.usuarioService.findUsuarioByName(usuarioId);
            ProcessoArquivoAssinatura processoArquivoAssinatura = new ProcessoArquivoAssinatura();
            processoArquivoAssinatura.setArquivo(processoArquivo);
            processoArquivoAssinatura.setUsuario(usuario);
            processoArquivoAssinatura.setUsuarioSolicitante(usuarioSolicitante);
            processoArquivoAssinatura.setFluxoAssinanteSequencia(fluxoAssinanteSequencia);
            processoArquivoAssinatura.setTipoAssinante(tipoAssinante);
            processoArquivoAssinatura.setSituacao(AssinaturaSituacaoEnum.PENDENTE);
            processoArquivo.getAssinaturas().add(processoArquivoAssinatura);
            notificaLista.add(processoArquivoAssinatura);
        });
        this.processoArquivoRepository.saveAndFlush((Object)processoArquivo);
        notificaLista.forEach(arg_0 -> ((ProcessoArquivoAssinaturaEmailSender)this.emailSender).enviarEmailSolicitandoAssinatura(arg_0));
    }

    public void enviaNotificacao(String usuarioId) {
        DataNotificationDTO dataNotificationDTO = new DataNotificationDTO();
        dataNotificationDTO.setStatus(NotificationStatus.COMPLETED);
        dataNotificationDTO.setModulo(Modulo.OXY_PROCESSOS);
        dataNotificationDTO.setUsername(usuarioId);
        dataNotificationDTO.setMessage("Solicita\u00e7\u00e3o de Assinatura.");
        dataNotificationDTO.setMessageDetail("Clique aqui para visualizar esta solicita\u00e7\u00e3o de assinatura.");
        dataNotificationDTO.setLink(String.format("/protocolo/arquivos-assinatura?filters==situacao_Igual=PENDENTE,usuario.id_Igual=%s", usuarioId));
        dataNotificationDTO.setCidadao(Boolean.TRUE);
        this.notificationFeign.publishMessage(dataNotificationDTO);
    }

    @Transactional
    public void gerarProximaSolicitacaoAssinaturaDoFluxo(ProcessoArquivo processoArquivo, String usuarioAtual) {
        TipoIntegracaoEnum tipoIntegracao = processoArquivo.getId().getProcesso().getTipoIntegracaoAssinatura();
        Long entidadeId = processoArquivo.getId().getProcesso().getId().getEntidade().getId();
        Long sequenciaAtual = processoArquivo.getFluxoSequenciaAtual();
        FluxoAssinatura fluxoAssinatura = this.fluxoAssinaturaService.getFluxoAssinatura(tipoIntegracao, entidadeId);
        HashMap variaveis = HashMapConverter.toHashMap((String)processoArquivo.getVariaveis());
        List usuarioAssinantes = this.fluxoAssinaturaService.getUsuarioAssinantesDTO(sequenciaAtual, fluxoAssinatura, variaveis);
        List usuarios = usuarioAssinantes.stream().map(UsuarioAssinanteDTO::getUsuario).collect(Collectors.toList());
        if (usuarioAssinantes.isEmpty()) {
            this.assinaturaIntegracaoService.finalizarProcessoAssinatura(processoArquivo.getId().getProcesso(), usuarioAtual);
        } else {
            this.solicitarAssinatura(processoArquivo.getIdentificador(), usuarios, processoArquivo.getUsuario(), ((UsuarioAssinanteDTO)usuarioAssinantes.get(0)).getSequencia(), ((UsuarioAssinanteDTO)usuarioAssinantes.get(0)).getGrupo());
            this.assinaturaIntegracaoService.atualizarProcessoAssinaturaParaEmAndamento(processoArquivo.getId().getProcesso());
        }
        this.assinaturaIntegracaoService.publicarAtualizacaoArquivo(processoArquivo, OutboxActions.UPDATED);
    }

    @Transactional
    public ProcessoArquivoAssinatura solicitarAssinaturaDigital(String identificador) {
        ProcessoArquivo processoArquivo = this.processoArquivoRepository.findByIdentificador(identificador);
        Usuario usuario = this.usuarioService.findUsuarioByName(SecurityContextHolder.getContext().getAuthentication().getName());
        Predicate<ProcessoArquivoAssinatura> possuiAssinaturaPendente = processoArquivoAssinaturaFilter -> usuario.getId().equals(processoArquivoAssinaturaFilter.getUsuario().getId()) && Objects.isNull(processoArquivoAssinaturaFilter.getDataAssinatura());
        ProcessoArquivoAssinatura processoArquivoAssinatura = processoArquivo.getAssinaturas().stream().filter(possuiAssinaturaPendente).findFirst().orElse(new ProcessoArquivoAssinatura());
        if (!processoArquivoAssinatura.isNew()) {
            return processoArquivoAssinatura;
        }
        processoArquivoAssinatura.setArquivo(processoArquivo);
        processoArquivoAssinatura.setUsuario(usuario);
        processoArquivoAssinatura.setUsuarioSolicitante(usuario);
        processoArquivo.getAssinaturas().add(processoArquivoAssinatura);
        this.processoArquivoRepository.saveAndFlush((Object)processoArquivo);
        return processoArquivoAssinatura;
    }
}

