/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service.assinatura;

import br.com.elotech.adm.exception.ExclusaoNaoPermitidaException;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.web.request.ContextHolder;
import br.com.elotech.outbox.domain.OutboxActions;
import br.com.elotech.protocolo.domain.AssinaturaConfiguracao;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.ProcessoArquivo;
import br.com.elotech.protocolo.domain.ProcessoArquivoAssinatura;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.dto.AssinaturaDTO;
import br.com.elotech.protocolo.dto.AssinaturaDigitalFinalizadaDTO;
import br.com.elotech.protocolo.dto.RejeitarAssinaturaLoteDTO;
import br.com.elotech.protocolo.enums.AssinaturaSituacaoEnum;
import br.com.elotech.protocolo.exception.PDFPrecisaPosicionar;
import br.com.elotech.protocolo.exception.RegistroNaoEncontradoException;
import br.com.elotech.protocolo.repository.ProcessoArquivoAssinaturaRepository;
import br.com.elotech.protocolo.repository.ProcessoArquivoRepository;
import br.com.elotech.protocolo.service.AssinaturaConfiguracaoService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.ProcessoIntegracaoService;
import br.com.elotech.protocolo.service.ProtocoloConfigService;
import br.com.elotech.protocolo.service.UsuarioService;
import br.com.elotech.protocolo.service.arquivo.ArquivoService;
import br.com.elotech.protocolo.service.assinatura.AssinaturaIntegracaoService;
import br.com.elotech.protocolo.service.assinatura.AssinaturaSolicitaService;
import br.com.elotech.protocolo.signer.AssinaturaPosicaoDTO;
import br.com.elotech.protocolo.signer.PdfSigner;
import br.com.elotech.protocolo.signer.PdfSignerFactory;
import br.com.elotech.protocolo.utils.PdfUtils;
import br.com.elotech.unico.client.dto.EloArquivoDTO;
import com.google.zxing.WriterException;
import java.io.IOException;
import java.nio.file.Path;
import java.security.cert.CertificateExpiredException;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AssinaturaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssinaturaService.class);
    public static final String MENSAGEM_CERTIFICADO_INVALIDO = "Dados do certificado expirado ou inv\u00e1lido.";
    public static final int TWO = 2;
    public static final String SIGNED_SUFFIX = "_signed";
    private final ParametroService parametroService;
    private final UsuarioService usuarioService;
    private final AssinaturaConfiguracaoService assinaturaConfiguracaoService;
    private final ProcessoArquivoRepository repository;
    private final ProcessoArquivoAssinaturaRepository processoArquivoAssinaturaRepository;
    private final ArquivoService arquivoService;
    private final AssinaturaIntegracaoService assinaturaIntegracaoService;
    private final ProcessoIntegracaoService processoIntegracaoService;
    private final AssinaturaSolicitaService assinaturaSolicitaService;
    private final ProtocoloConfigService protocoloConfigService;

    @Transactional
    public boolean utilizaAssinaturaPosicional(String identificadorProcessoArquivo) {
        AssinaturaConfiguracao configuracao = this.assinaturaConfiguracaoService.getAssinaturaConfiguracao(Long.valueOf(ContextHolder.getHeaderValueEntidade().intValue()));
        ProcessoArquivo arquivo = (ProcessoArquivo)this.repository.findByIdentificadorIn(List.of(identificadorProcessoArquivo)).stream().findFirst().orElseThrow();
        Boolean oldObrigaPosicionamentoAssinatura = arquivo.getObrigaPosicionamentoAssinatura();
        Boolean oldPossuiAssinaturaExterna = arquivo.getPossuiAssinaturaExterna();
        boolean result = PdfSignerFactory.utilizaAssinaturaPosicional((ArquivoService)this.arquivoService, (AssinaturaConfiguracao)configuracao, (ProcessoArquivo)arquivo, null);
        if (!Objects.equals(oldObrigaPosicionamentoAssinatura, arquivo.getObrigaPosicionamentoAssinatura()) || !Objects.equals(oldPossuiAssinaturaExterna, arquivo.getPossuiAssinaturaExterna())) {
            log.info("Assinatura posicional alterada para o arquivo {}, obrigaPosicionamentoAssinatura: {}, possuiAssinaturaExterna: {}", new Object[]{arquivo.getIdentificador(), arquivo.getObrigaPosicionamentoAssinatura(), arquivo.getPossuiAssinaturaExterna()});
            this.repository.saveAndFlush((Object)arquivo);
        }
        return result;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void assinarIndividual(AssinaturaDTO assinaturaDTO) throws EloValidationException, IOException, WriterException, PDFPrecisaPosicionar {
        Usuario usuario = this.usuarioService.findUsuarioByName(SecurityContextHolder.getContext().getAuthentication().getName());
        if (Boolean.FALSE.equals(this.usuarioService.validarSenha(assinaturaDTO.getSenha(), usuario))) {
            throw new EloValidationException("Senha n\u00e3o confere!");
        }
        AssinaturaConfiguracao configuracaoAssinatura = this.assinaturaConfiguracaoService.getAssinaturaConfiguracao(Long.valueOf(ContextHolder.getHeaderValueEntidade().intValue()));
        EloArquivoDTO eloArquivoCertificadoDigital = this.assinaturaConfiguracaoService.getEloArquivoCertificadoDigital(configuracaoAssinatura);
        EloArquivoDTO eloArquivoCarimbo = this.assinaturaConfiguracaoService.getEloArquivoCarimbo(configuracaoAssinatura);
        ProcessoArquivo processoArquivo = this.repository.findByIdentificador(assinaturaDTO.getIdentificador());
        processoArquivo.verificaSeExisteSolicitacaoAssinaturaParaUsuario(usuario);
        try {
            this.assinar(null, assinaturaDTO.getIdentificador(), usuario, configuracaoAssinatura, eloArquivoCertificadoDigital, eloArquivoCarimbo, assinaturaDTO.getPosicao(), false);
        }
        catch (CertificateExpiredException e) {
            throw new EloValidationException("Dados do certificado expirado ou inv\u00e1lido.");
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public boolean assinar(Long idAssinatura, String identificadoProcessoArquivo, Usuario usuario, AssinaturaConfiguracao configuracaoAssinatura, EloArquivoDTO eloArquivoCertificadoDigital, EloArquivoDTO eloArquivoCarimbo, AssinaturaPosicaoDTO assinaturaPosicaoDTO, boolean isLote) throws EloValidationException, CertificateExpiredException, IOException, WriterException, PDFPrecisaPosicionar {
        ProcessoArquivo processoArquivo = this.repository.findByIdentificador(identificadoProcessoArquivo);
        ProcessoArquivoAssinatura processoArquivoAssinatura = this.getOrCreateProcessoArquivoAssinatura(processoArquivo, usuario, idAssinatura);
        if (processoArquivoAssinatura.aindaNaoFoiAssinadaOuRecusada()) {
            Path arquivoAssinado = this.assinarArquivoPdf(processoArquivo, usuario, configuracaoAssinatura, eloArquivoCertificadoDigital, eloArquivoCarimbo, assinaturaPosicaoDTO, isLote);
            this.salvarAssinatura(processoArquivoAssinatura, processoArquivo);
            this.arquivoService.updateContent(processoArquivo, arquivoAssinado);
            this.processoIntegracaoService.salvarProcessoIntegracao(processoArquivo.getId().getProcesso());
            return true;
        }
        return false;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void voltarAssinaturaParaPendente(Long idAssinatura, String erro) {
        ProcessoArquivoAssinatura assinatura = (ProcessoArquivoAssinatura)this.processoArquivoAssinaturaRepository.findOne((Object)idAssinatura);
        assinatura.setSituacao(AssinaturaSituacaoEnum.PENDENTE);
        assinatura.setDataAssinatura(null);
        assinatura.setErro(StringUtils.left((String)erro, (int)500));
        this.processoArquivoAssinaturaRepository.saveAndFlush((Object)assinatura);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void setObrigaPosicionamentoAssinatura(String identificador) {
        this.repository.setObrigaPosicionamentoAssinatura(identificador);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void voltarAssinaturasParaPendenteByIdProcessamento(String idProcessamento, String erro) {
        this.processoArquivoAssinaturaRepository.voltarAssinaturasParaPendente(StringUtils.left((String)erro, (int)500), idProcessamento);
    }

    @Transactional
    public void cancelarAssinatura(Long idAssinatura) {
        ProcessoArquivoAssinatura assinatura = (ProcessoArquivoAssinatura)this.processoArquivoAssinaturaRepository.findOne((Object)idAssinatura);
        if (!AssinaturaSituacaoEnum.ASSINANDO.equals((Object)assinatura.getSituacao())) {
            throw new EloValidationException("A assinatura n\u00e3o est\u00e1 em processamento.");
        }
        assinatura.setSituacao(AssinaturaSituacaoEnum.PENDENTE);
        assinatura.setErro("Assinatura cancelada pelo usu\u00e1rio.");
        this.processoArquivoAssinaturaRepository.saveAndFlush((Object)assinatura);
    }

    private Path assinarArquivoPdf(ProcessoArquivo processoArquivo, Usuario usuario, AssinaturaConfiguracao configuracaoAssinatura, EloArquivoDTO eloArquivoCertificadoDigital, EloArquivoDTO eloArquivoCarimbo, AssinaturaPosicaoDTO assinaturaPosicaoDTO, boolean isLote) throws IOException, CertificateExpiredException, PDFPrecisaPosicionar {
        EloArquivoDTO eloArquivoDTO = this.getEloArquivoAssinatura(processoArquivo);
        PdfSigner pdfSign = PdfSignerFactory.getPdfSigner((ArquivoService)this.arquivoService, (ProcessoArquivo)processoArquivo, (AssinaturaConfiguracao)configuracaoAssinatura, (EloArquivoDTO)eloArquivoCertificadoDigital, (Usuario)usuario, (EloArquivoDTO)eloArquivoDTO, (AssinaturaPosicaoDTO)assinaturaPosicaoDTO, (boolean)isLote);
        byte[] pdfBinary = eloArquivoDTO.getContent().getBinary();
        String urlConsultaAutenticidade = "";
        if (Objects.nonNull(configuracaoAssinatura.getUrlAutenticidade())) {
            urlConsultaAutenticidade = configuracaoAssinatura.getUrlAutenticidade().concat(String.format("?identificador=%s", processoArquivo.getIdentificador()));
        }
        pdfSign.setUrlAutenticidade(urlConsultaAutenticidade);
        pdfSign.setCarimbo(eloArquivoCarimbo.getContent().getBinary());
        if (this.shouldCreateAssianturaPosicao(assinaturaPosicaoDTO, pdfSign)) {
            long quantidadeAssinaturas = AssinaturaService.getQuantidadeAssinaturas((ProcessoArquivo)processoArquivo);
            AtomicReference reason = new AtomicReference();
            boolean arquivoPrecisaPosicionar = PdfSignerFactory.arquivoPrecisaUsarAssinaturaPosicional((ArquivoService)this.arquivoService, (AssinaturaConfiguracao)configuracaoAssinatura, (ProcessoArquivo)processoArquivo, (EloArquivoDTO)eloArquivoDTO, reason);
            boolean estaPosicionando = pdfSign.isNewKind();
            boolean precisa = arquivoPrecisaPosicionar || estaPosicionando;
            String reasonMsg = (String)reason.get();
            if (precisa) {
                throw new PDFPrecisaPosicionar(String.format("N\u00e3o \u00e9 poss\u00edvel %s: %s. Por favor, assine o arquivo %s manualmente ou tente novamente", quantidadeAssinaturas == 0L ? "inserir uma nova p\u00e1gina para assinaturas" : "assinar o arquivo em lote", reasonMsg, processoArquivo.getNome()));
            }
            if (quantidadeAssinaturas == 0L) {
                pdfBinary = PdfUtils.addBlankPageAndPrepareToPdf((byte[])eloArquivoDTO.getContent().getBinary(), (String)urlConsultaAutenticidade, (String)processoArquivo.getIdentificador());
            }
            assinaturaPosicaoDTO = new AssinaturaPosicaoDTO();
            AssinaturaService.fulfillNewAssinaturaPosicao((AssinaturaConfiguracao)configuracaoAssinatura, (long)quantidadeAssinaturas, (byte[])pdfBinary, (AssinaturaPosicaoDTO)assinaturaPosicaoDTO);
        }
        return pdfSign.signPdf(pdfBinary, assinaturaPosicaoDTO);
    }

    private boolean shouldCreateAssianturaPosicao(AssinaturaPosicaoDTO assinaturaPosicaoDTO, PdfSigner pdfSign) {
        return pdfSign.isOldKind() || !AssinaturaPosicaoDTO.isValid((AssinaturaPosicaoDTO)assinaturaPosicaoDTO);
    }

    private static void fulfillNewAssinaturaPosicao(AssinaturaConfiguracao configuracaoAssinatura, long quantidadeAssinaturas, byte[] pdfBinary, AssinaturaPosicaoDTO assinaturaPosicaoDTO) {
        long factorY = quantidadeAssinaturas;
        assinaturaPosicaoDTO.setX(Float.valueOf(5.0f));
        if (quantidadeAssinaturas > 0L && configuracaoAssinatura.getQuantidadeColunas() == 2L) {
            if (quantidadeAssinaturas % 2L != 0L) {
                assinaturaPosicaoDTO.setX(Float.valueOf(290.0f));
            }
            factorY /= 2L;
        }
        assinaturaPosicaoDTO.setY(Float.valueOf(100.0f + 65.0f * (float)factorY));
        assinaturaPosicaoDTO.setPage(PdfUtils.getNumberOfPages((byte[])pdfBinary));
    }

    private static long getQuantidadeAssinaturas(ProcessoArquivo processoArquivo) {
        return processoArquivo.getAssinaturas().stream().map(ProcessoArquivoAssinatura::getDataAssinatura).filter(Objects::nonNull).count();
    }

    private EloArquivoDTO getEloArquivoAssinatura(ProcessoArquivo processoArquivo) {
        try {
            return (EloArquivoDTO)this.arquivoService.downloadArquivo(processoArquivo.getIdArquivo()).orElseThrow();
        }
        catch (Exception e) {
            log.error("Erro na assinatura, n\u00e3o foi poss\u00edvel fazer o download do arquivo, idAarquivo: {}:", (Object)processoArquivo.getIdArquivo(), (Object)e);
            throw new EloValidationException(String.format("Problemas com download do arquivo. Idarquivo: %S", processoArquivo.getIdArquivo()));
        }
    }

    public Long getQuantidadeAssinaturasPendentesByUsuarioAndEntidade(String usuario, Long entidade) {
        return this.processoArquivoAssinaturaRepository.countProcessosPendentesByUsuarioAndEntidade(usuario, entidade);
    }

    @Transactional
    public void removerPendentes(String identificador) {
        this.protocoloConfigService.throwExceptionIfSomenteLeitura();
        Boolean permiteExcluirSolicitacoes = this.parametroService.getParamValueAsBoolean(ParametroEnum.PERMITE_EXCLUSAO_SOLICITACOES_ASSINATURA_SOLICITANTE.getCodigo());
        if (Boolean.FALSE.equals(permiteExcluirSolicitacoes)) {
            throw new ExclusaoNaoPermitidaException(ProcessoArquivoAssinatura.class);
        }
        ProcessoArquivo processoArquivo = this.repository.findByIdentificador(identificador);
        List assinados = processoArquivo.getAssinaturas().stream().filter(a -> AssinaturaSituacaoEnum.ASSINADO.equals((Object)a.getSituacao())).collect(Collectors.toList());
        processoArquivo.getAssinaturas().clear();
        processoArquivo.getAssinaturas().addAll(assinados);
        this.repository.saveAndFlush((Object)processoArquivo);
    }

    @Transactional
    public void assinarArquivosDigitalmente(AssinaturaDigitalFinalizadaDTO assinaturaDigitalFinalizadaDTO) {
        HashSet updatedProcessos = new HashSet();
        assinaturaDigitalFinalizadaDTO.getIds().forEach(idAssinatura -> {
            ProcessoArquivoAssinatura processoArquivoAssinatura = (ProcessoArquivoAssinatura)this.processoArquivoAssinaturaRepository.findById(idAssinatura).orElseThrow();
            ProcessoArquivo processoArquivo = processoArquivoAssinatura.getArquivo();
            String userName = SecurityContextHolder.getContext().getAuthentication().getName();
            if (!userName.equals(processoArquivoAssinatura.getUsuario().getId())) {
                throw new BadRequestException("N\u00e3o existe solicita\u00e7\u00e3o para seu usu\u00e1rio!");
            }
            if (!processoArquivo.getUrlS3().endsWith("_signed")) {
                this.arquivoService.markAsSigned(processoArquivo.getIdArquivo());
                processoArquivo.setUrlS3(processoArquivo.getUrlS3().concat("_signed"));
            }
            processoArquivo.setObrigaPosicionamentoAssinatura(Boolean.valueOf(true));
            this.salvarAssinatura(processoArquivoAssinatura, processoArquivo);
            updatedProcessos.add(processoArquivo.getId().getProcesso());
        });
        updatedProcessos.forEach(arg_0 -> ((ProcessoIntegracaoService)this.processoIntegracaoService).salvarProcessoIntegracao(arg_0));
    }

    @Transactional
    public void deleteOutrasSolicitacoesDoMesmoTipo(ProcessoArquivoAssinatura processoArquivoAssinatura) {
        ProcessoArquivo processoArquivo = processoArquivoAssinatura.getArquivo();
        if (StringUtils.isNotBlank((CharSequence)processoArquivoAssinatura.getTipoAssinante())) {
            processoArquivo.getAssinaturas().removeIf(a -> Objects.nonNull(a.getTipoAssinante()) && a.getTipoAssinante().equals(processoArquivoAssinatura.getTipoAssinante()) && !a.getId().equals(processoArquivoAssinatura.getId()) && AssinaturaSituacaoEnum.PENDENTE.equals((Object)a.getSituacao()));
            this.repository.saveAndFlush((Object)processoArquivo);
        }
    }

    @Transactional
    public void rejeitarAssinatura(String identificadorArquivo, String motivo) {
        this.protocoloConfigService.throwExceptionIfSomenteLeitura();
        Usuario usuario = this.usuarioService.findUsuarioByName(SecurityContextHolder.getContext().getAuthentication().getName());
        ProcessoArquivo processoArquivo = this.repository.findByIdentificador(identificadorArquivo);
        Predicate<ProcessoArquivoAssinatura> predAssinaturaPendenteUsuario = a -> a.getUsuario().getId().equals(usuario.getId()) && Objects.isNull(a.getDataRecusa()) && Objects.isNull(a.getDataAssinatura());
        ProcessoArquivoAssinatura processoArquivoAssinatura = processoArquivo.getAssinaturas().stream().filter(predAssinaturaPendenteUsuario).findFirst().orElseThrow(() -> new EloValidationException("Esse arquivo n\u00e3o possui nenhuma solicita\u00e7\u00e3o de assinatura pendente, para ser recusada."));
        this.rejeitarProcessoArquivoAssinatura(processoArquivoAssinatura, motivo);
        if (this.deveDescartarAssinaturasAoRejeitar(processoArquivo).booleanValue()) {
            Predicate<ProcessoArquivoAssinatura> predAssinaturaNaoAssinada = a -> Objects.isNull(a.getDataAssinatura()) && !a.equals((Object)processoArquivoAssinatura);
            processoArquivo.getAssinaturas().stream().filter(predAssinaturaNaoAssinada).forEach(processoArquivoAssinatura1 -> this.rejeitarProcessoArquivoAssinatura(processoArquivoAssinatura1, null));
        }
        this.assinaturaIntegracaoService.finalizarRecusaAssinatura(processoArquivoAssinatura, motivo);
        this.assinaturaIntegracaoService.publicarAtualizacaoArquivo(processoArquivo, OutboxActions.UPDATED);
    }

    private void salvarAssinatura(ProcessoArquivoAssinatura processoArquivoAssinatura, ProcessoArquivo processoArquivo) {
        this.protocoloConfigService.throwExceptionIfSomenteLeitura();
        processoArquivoAssinatura.setDataAssinatura(LocalDateTime.now());
        processoArquivoAssinatura.setSituacao(AssinaturaSituacaoEnum.ASSINADO);
        processoArquivoAssinatura.setErro(null);
        this.repository.saveAndFlush((Object)processoArquivo);
        if (!processoArquivo.integraFila()) {
            this.assinaturaIntegracaoService.publicarAtualizacaoArquivo(processoArquivo, OutboxActions.UPDATED);
            return;
        }
        this.deleteOutrasSolicitacoesDoMesmoTipo(processoArquivoAssinatura);
        if (processoArquivo.wasLastSignature(processoArquivoAssinatura.getId())) {
            if (processoArquivoAssinatura.getFluxoAssinanteSequencia() != null) {
                this.assinaturaSolicitaService.gerarProximaSolicitacaoAssinaturaDoFluxo(processoArquivo, processoArquivoAssinatura.getUsuario().getId());
                return;
            }
            this.assinaturaIntegracaoService.finalizarProcessoAssinatura(processoArquivo.getId().getProcesso(), processoArquivoAssinatura.getUsuario().getId());
        }
        this.assinaturaIntegracaoService.publicarAtualizacaoArquivo(processoArquivo, OutboxActions.UPDATED);
    }

    private ProcessoArquivoAssinatura getOrCreateProcessoArquivoAssinatura(ProcessoArquivo processoArquivo, Usuario usuario, Long idAssinatura) {
        ProcessoArquivoAssinatura processoArquivoAssinatura;
        if (Objects.nonNull(idAssinatura)) {
            processoArquivoAssinatura = processoArquivo.getAssinaturas().stream().filter(a -> a.getId().equals(idAssinatura)).findFirst().orElseThrow(() -> new RegistroNaoEncontradoException(String.format("Assinatura n\u00e3o encontrada. \nIdentificadorArquivo: %s \nIdAssinatura: %s Usuario: %s", processoArquivo.getIdentificador(), idAssinatura, usuario.getId())));
        } else {
            Predicate<ProcessoArquivoAssinatura> possuiAssinaturaPendente = processoArquivoAssinaturaFilter -> usuario.getId().equals(processoArquivoAssinaturaFilter.getUsuario().getId()) && Objects.isNull(processoArquivoAssinaturaFilter.getDataAssinatura());
            processoArquivoAssinatura = processoArquivo.getAssinaturas().stream().filter(possuiAssinaturaPendente).findFirst().orElse(new ProcessoArquivoAssinatura());
            if (processoArquivoAssinatura.isNew()) {
                processoArquivoAssinatura.setUsuarioSolicitante(usuario);
                processoArquivoAssinatura.setSituacao(AssinaturaSituacaoEnum.ASSINANDO);
                processoArquivoAssinatura.setUsuario(usuario);
                processoArquivoAssinatura.setArquivo(processoArquivo);
                processoArquivo.addArquivoAssinatura(processoArquivoAssinatura);
            }
        }
        return processoArquivoAssinatura;
    }

    public void removerAssinatura(Long id) {
        this.protocoloConfigService.throwExceptionIfSomenteLeitura();
        Boolean permiteExcluirSolicitacoes = this.parametroService.getParamValueAsBoolean(ParametroEnum.PERMITE_EXCLUSAO_SOLICITACOES_ASSINATURA_SOLICITANTE.getCodigo());
        if (Boolean.FALSE.equals(permiteExcluirSolicitacoes)) {
            throw new ExclusaoNaoPermitidaException(ProcessoArquivoAssinatura.class);
        }
        Optional toRemove = this.processoArquivoAssinaturaRepository.findById((Object)id);
        if (toRemove.isEmpty()) {
            throw new EloValidationException("Arquivo n\u00e3o foi encontrado.");
        }
        if (((ProcessoArquivoAssinatura)toRemove.get()).getSituacao().equals((Object)AssinaturaSituacaoEnum.ASSINADO)) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel remover uma solicita\u00e7\u00e3o j\u00e1 assinada.");
        }
        this.processoArquivoAssinaturaRepository.delete((Object)((ProcessoArquivoAssinatura)toRemove.get()));
    }

    @Transactional
    public void rejeitarAssinaturasEmLote(RejeitarAssinaturaLoteDTO rejeitarAssinaturaLoteDTO) {
        for (String identificador : rejeitarAssinaturaLoteDTO.getIdentificadores()) {
            this.rejeitarAssinatura(identificador, rejeitarAssinaturaLoteDTO.getMotivo());
        }
    }

    private void rejeitarProcessoArquivoAssinatura(ProcessoArquivoAssinatura processoArquivoAssinatura, String motivo) {
        processoArquivoAssinatura.setDataRecusa(LocalDateTime.now());
        processoArquivoAssinatura.setSituacao(AssinaturaSituacaoEnum.REJEITADO);
        processoArquivoAssinatura.setMotivoRecusa(motivo);
        this.processoArquivoAssinaturaRepository.saveAndFlush((Object)processoArquivoAssinatura);
    }

    private Boolean deveDescartarAssinaturasAoRejeitar(ProcessoArquivo processoArquivo) {
        Boolean descartaDemaisAssinaturasParam = this.parametroService.getParamValueAsBoolean(ParametroEnum.DESCARTA_ASSINATURAS_AO_REJEITAR.getCodigo());
        boolean isArquivoOuProcessoIntegracao = processoArquivo.isArquivoIntegracao() || processoArquivo.getId().getProcesso().hasFilaIntegracaoAssinatura();
        return descartaDemaisAssinaturasParam != false || isArquivoOuProcessoIntegracao;
    }

    @Generated
    public AssinaturaService(ParametroService parametroService, UsuarioService usuarioService, AssinaturaConfiguracaoService assinaturaConfiguracaoService, ProcessoArquivoRepository repository, ProcessoArquivoAssinaturaRepository processoArquivoAssinaturaRepository, ArquivoService arquivoService, AssinaturaIntegracaoService assinaturaIntegracaoService, ProcessoIntegracaoService processoIntegracaoService, AssinaturaSolicitaService assinaturaSolicitaService, ProtocoloConfigService protocoloConfigService) {
        this.parametroService = parametroService;
        this.usuarioService = usuarioService;
        this.assinaturaConfiguracaoService = assinaturaConfiguracaoService;
        this.repository = repository;
        this.processoArquivoAssinaturaRepository = processoArquivoAssinaturaRepository;
        this.arquivoService = arquivoService;
        this.assinaturaIntegracaoService = assinaturaIntegracaoService;
        this.processoIntegracaoService = processoIntegracaoService;
        this.assinaturaSolicitaService = assinaturaSolicitaService;
        this.protocoloConfigService = protocoloConfigService;
    }
}

