/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service.assinatura;

import br.com.elotech.adm.service.AsyncContext;
import br.com.elotech.client.painel.feign.NotificationFeign;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.web.request.ContextHolder;
import br.com.elotech.lib.painel.dto.DataNotificationDTO;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.protocolo.domain.AssinaturaConfiguracao;
import br.com.elotech.protocolo.domain.ProcessoArquivoAssinatura;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.dto.LoteProcessamentoAssinaturaDTO;
import br.com.elotech.protocolo.enums.AssinaturaSituacaoEnum;
import br.com.elotech.protocolo.exception.PDFPrecisaPosicionar;
import br.com.elotech.protocolo.feign.AssinaturaProtocClientFeign;
import br.com.elotech.protocolo.repository.ProcessoArquivoAssinaturaRepository;
import br.com.elotech.protocolo.repository.UsuarioRepository;
import br.com.elotech.protocolo.service.AssinaturaConfiguracaoService;
import br.com.elotech.protocolo.service.assinatura.AssinaturaService;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import br.com.elotech.unico.client.dto.EloArquivoDTO;
import java.security.cert.CertificateExpiredException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AssinaturaProcessaLoteThreadService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssinaturaProcessaLoteThreadService.class);
    public static final int TEMPO_ESPERA = 5000;
    private static final String NENHUMA_ASSINATURA_PENDENTE = "Nenhuma assinatura pendente";
    private final AssinaturaService assinaturaService;
    private final AssinaturaConfiguracaoService assinaturaConfiguracaoService;
    private final ProcessoArquivoAssinaturaRepository repository;
    private final UsuarioRepository usuarioRepository;
    private final NotificationFeign notificationFeign;
    private final AssinaturaProtocClientFeign assinaturaProtocClientFeign;

    @Transactional
    private boolean assinarArquivoAssinatura(ProcessoArquivoAssinatura arquivoAssinatura, Usuario usuario, AssinaturaConfiguracao configuracaoAssinatura, EloArquivoDTO eloArquivoCertificadoDigital, EloArquivoDTO eloArquivoCarimbo) throws CertificateExpiredException {
        String identificador = arquivoAssinatura.getIdentificador();
        try {
            return this.assinaturaService.assinar(arquivoAssinatura.getId(), identificador, usuario, configuracaoAssinatura, eloArquivoCertificadoDigital, eloArquivoCarimbo, null, true);
        }
        catch (CertificateExpiredException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof PDFPrecisaPosicionar) {
                this.assinaturaService.setObrigaPosicionamentoAssinatura(identificador);
            }
            this.assinaturaService.voltarAssinaturaParaPendente(arquivoAssinatura.getId(), e.getMessage());
            AssinaturaProcessaLoteThreadService.logException(Set.of(EloValidationException.class, PDFPrecisaPosicionar.class), (Exception)e);
            return false;
        }
    }

    @Transactional
    public Boolean assinarLoteProximo(LoteProcessamentoAssinaturaDTO loteProcessamentoAssinaturaDTO) {
        long qtdAssinadas = 0L;
        int qtdAssinaturas = 0;
        boolean erroGeral = false;
        String mensagemErroGeral = "";
        try {
            List assinaturas = this.repository.findIdByIdProcessamento(loteProcessamentoAssinaturaDTO.getId());
            qtdAssinaturas = assinaturas.size();
            qtdAssinadas = assinaturas.stream().filter(assinatura -> !AssinaturaSituacaoEnum.ASSINANDO.equals((Object)assinatura.getSituacao())).count();
            AssinaturaConfiguracao configuracaoAssinatura = this.assinaturaConfiguracaoService.getAssinaturaConfiguracao(loteProcessamentoAssinaturaDTO.getEntidade());
            EloArquivoDTO eloArquivoCertificadoDigital = this.assinaturaConfiguracaoService.getEloArquivoCertificadoDigital(configuracaoAssinatura);
            EloArquivoDTO eloArquivoCarimbo = this.assinaturaConfiguracaoService.getEloArquivoCarimbo(configuracaoAssinatura);
            Usuario usuario = this.getUsuario(loteProcessamentoAssinaturaDTO);
            ProcessoArquivoAssinatura arquivoAssinatura = assinaturas.stream().filter(assinatura -> AssinaturaSituacaoEnum.ASSINANDO.equals((Object)assinatura.getSituacao())).findAny().orElseThrow(() -> new EloValidationException("Nenhuma assinatura pendente"));
            try {
                if (this.assinarArquivoAssinatura(arquivoAssinatura, usuario, configuracaoAssinatura, eloArquivoCertificadoDigital, eloArquivoCarimbo)) {
                    ++qtdAssinadas;
                }
            }
            catch (CertificateExpiredException e) {
                log.warn("Problemas ao processar assinaturas em lote. \n {} \n", (Object)mensagemErroGeral, (Object)e);
                erroGeral = true;
                mensagemErroGeral = "Dados do certificado expirado ou inv\u00e1lido.";
            }
        }
        catch (Exception e) {
            mensagemErroGeral = e.getMessage();
            erroGeral = !"Nenhuma assinatura pendente".equals(mensagemErroGeral);
            AssinaturaProcessaLoteThreadService.logException(Set.of(EloValidationException.class), (Exception)e);
        }
        if (erroGeral) {
            this.assinaturaService.voltarAssinaturasParaPendenteByIdProcessamento(loteProcessamentoAssinaturaDTO.getId(), mensagemErroGeral);
            return false;
        }
        return (long)qtdAssinaturas > qtdAssinadas;
    }

    @Transactional
    @Async
    public void processarAssinaturaLoteOnPremise(LoteProcessamentoAssinaturaDTO loteProcessamentoAssinaturaDTO, AsyncContext context) {
        log.debug("Vai iniciar processamento de assinaturas do lote {}", (Object)loteProcessamentoAssinaturaDTO);
        context.restoreContext();
        Long entidadeLogada = RequestHeaderHelper.getEntidadeLogada();
        Integer exercicioLogado = ContextHolder.getHeaderValueExercicio();
        log.debug("Vai iniciar processamento de assinaturas do lote {}. Entidade logada: {}. Exerc\u00edcio logado: {}", new Object[]{loteProcessamentoAssinaturaDTO, entidadeLogada, exercicioLogado});
        if (Objects.isNull(loteProcessamentoAssinaturaDTO)) {
            return;
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            log.warn("Falha ao esperar thread", (Throwable)e);
        }
        try {
            while (Boolean.TRUE.equals(this.assinaturaProtocClientFeign.assinarLoteProximo(loteProcessamentoAssinaturaDTO))) {
                log.debug("Vai processar mais um item do lote {}", (Object)loteProcessamentoAssinaturaDTO);
            }
        }
        catch (Exception e) {
            log.warn(String.format("Falha ao processar lote %s: %s", loteProcessamentoAssinaturaDTO, e.getMessage()), (Throwable)e);
            this.assinaturaService.voltarAssinaturasParaPendenteByIdProcessamento(loteProcessamentoAssinaturaDTO.getId(), e.getMessage());
        }
        log.debug("Finalizou processamento do lote {}", (Object)loteProcessamentoAssinaturaDTO);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void processarAssinaturaLote(LoteProcessamentoAssinaturaDTO loteProcessamentoAssinaturaDTO) {
        log.debug("Iniciando processo de assinatura em lote: {}", (Object)loteProcessamentoAssinaturaDTO);
        int qtdAssinadas = 0;
        int qtdAssinaturas = 0;
        boolean erroGeral = false;
        String mensagemErroGeral = "";
        try {
            Set assinaturas = this.repository.findIdsByIdProcessamento(loteProcessamentoAssinaturaDTO.getId());
            qtdAssinaturas = assinaturas.size();
            AssinaturaConfiguracao configuracaoAssinatura = this.assinaturaConfiguracaoService.getAssinaturaConfiguracao(loteProcessamentoAssinaturaDTO.getEntidade());
            EloArquivoDTO eloArquivoCertificadoDigital = this.assinaturaConfiguracaoService.getEloArquivoCertificadoDigital(configuracaoAssinatura);
            EloArquivoDTO eloArquivoCarimbo = this.assinaturaConfiguracaoService.getEloArquivoCarimbo(configuracaoAssinatura);
            Usuario usuario = this.getUsuario(loteProcessamentoAssinaturaDTO);
            for (Long idAssinatura : assinaturas) {
                ProcessoArquivoAssinatura arquivoAssinatura = (ProcessoArquivoAssinatura)this.repository.findOne((Object)idAssinatura);
                if (Objects.isNull(arquivoAssinatura) || !AssinaturaSituacaoEnum.ASSINANDO.equals((Object)arquivoAssinatura.getSituacao())) {
                    --qtdAssinaturas;
                    continue;
                }
                try {
                    if (!this.assinarArquivoAssinatura(arquivoAssinatura, usuario, configuracaoAssinatura, eloArquivoCertificadoDigital, eloArquivoCarimbo)) continue;
                    ++qtdAssinadas;
                }
                catch (CertificateExpiredException e) {
                    log.warn("Problemas ao processar assinaturas em lote. \n {} \n", (Object)mensagemErroGeral, (Object)e);
                    erroGeral = true;
                    mensagemErroGeral = "Dados do certificado expirado ou inv\u00e1lido.";
                    break;
                }
            }
        }
        catch (Exception e) {
            erroGeral = true;
            mensagemErroGeral = e.getMessage();
            AssinaturaProcessaLoteThreadService.logException(Set.of(EloValidationException.class), (Exception)e);
        }
        this.finalizarAssinaturaLote(loteProcessamentoAssinaturaDTO, erroGeral, mensagemErroGeral, qtdAssinaturas, qtdAssinadas);
    }

    private void finalizarAssinaturaLote(LoteProcessamentoAssinaturaDTO loteProcessamentoAssinaturaDTO, boolean erroGeral, String mensagemErroGeral, int qtdAssinaturas, int qtdAssinadas) {
        if (erroGeral) {
            this.assinaturaService.voltarAssinaturasParaPendenteByIdProcessamento(loteProcessamentoAssinaturaDTO.getId(), mensagemErroGeral);
            this.notificarFalhaProcesamento(loteProcessamentoAssinaturaDTO.getId(), loteProcessamentoAssinaturaDTO.getIdNotificacao(), mensagemErroGeral, loteProcessamentoAssinaturaDTO.getUsuario());
            return;
        }
        String mensagemConclusao = String.format("Assinaturas:%s Conclu\u00eddas:%s ", qtdAssinaturas, qtdAssinadas);
        if (qtdAssinadas < qtdAssinaturas) {
            this.notificarFalhaProcesamento(loteProcessamentoAssinaturaDTO.getId(), loteProcessamentoAssinaturaDTO.getIdNotificacao(), mensagemConclusao, loteProcessamentoAssinaturaDTO.getUsuario());
            return;
        }
        this.notificarConclusaoProcesamento(loteProcessamentoAssinaturaDTO.getId(), loteProcessamentoAssinaturaDTO.getIdNotificacao(), mensagemConclusao, loteProcessamentoAssinaturaDTO.getUsuario());
    }

    private Usuario getUsuario(LoteProcessamentoAssinaturaDTO loteProcessamentoAssinaturaDTO) {
        return (Usuario)this.usuarioRepository.findById((Object)loteProcessamentoAssinaturaDTO.getUsuario()).orElseThrow(() -> new EloValidationException(String.format("Usu\u00e1rio %s n\u00e3o encontrado", loteProcessamentoAssinaturaDTO.getUsuario())));
    }

    private static void logException(Set<Class<? extends Exception>> classes, Exception e) {
        if (classes.stream().anyMatch(c -> c.isInstance(e))) {
            log.warn("Problemas ao processar assinaturas em lote. \n", (Throwable)e);
        } else {
            log.error("Erro ao processar assinaturas em lote. \n", (Throwable)e);
        }
    }

    private void notificarConclusaoProcesamento(String idProcessamento, UUID idNotificacao, String mensagemDetalhes, String usuario) {
        try {
            DataNotificationDTO dataNotificationDTO = new DataNotificationDTO();
            dataNotificationDTO.setId(idNotificacao);
            dataNotificationDTO.setStatus(NotificationStatus.COMPLETED);
            dataNotificationDTO.setModulo(Modulo.OXY_PROCESSOS);
            dataNotificationDTO.setType("Notifica\u00e7\u00e3o");
            dataNotificationDTO.setUsername(usuario);
            dataNotificationDTO.setMessage("Conclu\u00eddo processamento de assinaturas.");
            dataNotificationDTO.setMessageDetail(mensagemDetalhes + " \n Clique aqui para visualiza-las");
            dataNotificationDTO.setLink(String.format("/protocolo/arquivos-assinatura?filters==idProcessamento_Igual=%s", idProcessamento));
            this.notificationFeign.publishMessage(dataNotificationDTO);
        }
        catch (Exception e) {
            log.error("Erro ao notificar conclus\u00e3o do processamento de assinatura. \nmessage: {} \ncause: {} \n stackTrace {}", new Object[]{e.getMessage(), e.getCause(), Arrays.toString(e.getStackTrace())});
        }
    }

    private void notificarFalhaProcesamento(String idProcessamento, UUID idNotificacao, String mensagemErro, String usuario) {
        try {
            DataNotificationDTO dataNotificationDTO = new DataNotificationDTO();
            dataNotificationDTO.setId(idNotificacao);
            dataNotificationDTO.setStatus(NotificationStatus.FAILED);
            dataNotificationDTO.setModulo(Modulo.OXY_PROCESSOS);
            dataNotificationDTO.setType("Notifica\u00e7\u00e3o");
            dataNotificationDTO.setUsername(usuario);
            dataNotificationDTO.setMessage("Falhou o processamento de assinaturas.");
            dataNotificationDTO.setMessageDetail(String.format("Verifique o erro, que tamb\u00e9m pode ser visualizado clicando sobre o campo situa\u00e7\u00e3o, e tente novamente \n %s", mensagemErro));
            dataNotificationDTO.setLink(String.format("/protocolo/arquivos-assinatura?filters==idProcessamento_Igual=%s", idProcessamento));
            this.notificationFeign.publishMessage(dataNotificationDTO);
        }
        catch (Exception e) {
            log.error("Erro ao notificar falha no processamento da assinatura. \nmessage: {} \ncause: {} \n stackTrace {}", new Object[]{e.getMessage(), e.getCause(), Arrays.toString(e.getStackTrace())});
        }
    }

    @Generated
    public AssinaturaProcessaLoteThreadService(AssinaturaService assinaturaService, AssinaturaConfiguracaoService assinaturaConfiguracaoService, ProcessoArquivoAssinaturaRepository repository, UsuarioRepository usuarioRepository, NotificationFeign notificationFeign, AssinaturaProtocClientFeign assinaturaProtocClientFeign) {
        this.assinaturaService = assinaturaService;
        this.assinaturaConfiguracaoService = assinaturaConfiguracaoService;
        this.repository = repository;
        this.usuarioRepository = usuarioRepository;
        this.notificationFeign = notificationFeign;
        this.assinaturaProtocClientFeign = assinaturaProtocClientFeign;
    }
}

