/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service.assinatura;

import br.com.elotech.adm.service.AsyncContext;
import br.com.elotech.client.painel.feign.NotificationFeign;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.lib.painel.dto.DataNotificationDTO;
import br.com.elotech.lib.painel.dto.NotificationDTO;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.outbox.domain.EntityEvent;
import br.com.elotech.outbox.domain.OutboxActions;
import br.com.elotech.outbox.publisher.Publisher;
import br.com.elotech.protocolo.domain.ProcessoArquivoAssinatura;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.dto.AssinaturaLoteDTO;
import br.com.elotech.protocolo.dto.LoteProcessamentoAssinaturaDTO;
import br.com.elotech.protocolo.repository.ProcessoArquivoAssinaturaRepository;
import br.com.elotech.protocolo.service.EntidadeService;
import br.com.elotech.protocolo.service.ProtocoloConfigService;
import br.com.elotech.protocolo.service.UsuarioService;
import br.com.elotech.protocolo.service.assinatura.AssinaturaProcessaLoteThreadService;
import br.com.elotech.protocolo.specs.ProcessoArquivoAssinaturaSpecificationHelper;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import com.google.common.base.Strings;
import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AssinaturaLoteService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssinaturaLoteService.class);
    private static final String FILTER_ASSINATURA_LOTE = "entidade==%d  and usuario.id==%s  and situacao=='PENDENTE' %s ";
    private final UsuarioService usuarioService;
    private final EntidadeService entidadeService;
    private final ProcessoArquivoAssinaturaRepository repositoryArquivoAssinatura;
    private final EntityManager entityManager;
    private final Publisher publisher;
    private final NotificationFeign notificationFeign;
    private final ProtocoloConfigService protocoloConfigService;
    private final AssinaturaProcessaLoteThreadService assinaturaProcessaLoteThreadService;

    @Transactional
    public String criarProcessamentoEmLote(AssinaturaLoteDTO dto) {
        this.validarSenhaUsuario(dto);
        this.protocoloConfigService.throwExceptionIfSomenteLeitura();
        String usuario = SecurityContextHolder.getContext().getAuthentication().getName();
        UUID idProcessamento = UUID.randomUUID();
        List idsSelecionados = this.getIdsSelecionados(dto);
        String tenant = TenantContextHolder.getTenantId().orElse("");
        LoteProcessamentoAssinaturaDTO loteProcessamentoAssinaturaDTO = new LoteProcessamentoAssinaturaDTO(tenant, usuario, this.entidadeService.getEntidadeLogada(), idProcessamento.toString(), this.notificarCriacaoProcesamento(idProcessamento.toString()).getId());
        this.repositoryArquivoAssinatura.atualizarAssinaturasPendentesParaAssinando(idsSelecionados, idProcessamento.toString(), LocalDateTime.now());
        if (this.protocoloConfigService.isModoCloud()) {
            this.publisher.publish(OutboxActions.CREATED, (EntityEvent)loteProcessamentoAssinaturaDTO);
        } else {
            this.assinaturaProcessaLoteThreadService.processarAssinaturaLoteOnPremise(loteProcessamentoAssinaturaDTO, AsyncContext.getContext());
            this.callProcessarAssinaturaLoteOnPremise(loteProcessamentoAssinaturaDTO);
        }
        return idProcessamento.toString();
    }

    public void callProcessarAssinaturaLoteOnPremise(LoteProcessamentoAssinaturaDTO loteProcessamentoAssinaturaDTO) {
        this.assinaturaProcessaLoteThreadService.processarAssinaturaLoteOnPremise(loteProcessamentoAssinaturaDTO, AsyncContext.getContext());
    }

    public Long getQuantidadeAssinarLote(String rsql) {
        String search = String.format("entidade==%d  and usuario.id==%s  and situacao=='PENDENTE' %s ", RequestHeaderHelper.getEntidadeLogada(), SecurityContextHolder.getContext().getAuthentication().getName(), Strings.isNullOrEmpty((String)rsql) ? rsql : " and ".concat(rsql));
        return this.repositoryArquivoAssinatura.count(RsqlUtils.createSpecFrom((EntityManager)this.entityManager, (String)search));
    }

    private NotificationDTO notificarCriacaoProcesamento(String idProcessamento) {
        DataNotificationDTO dataNotificationDTO = new DataNotificationDTO();
        dataNotificationDTO.setStatus(NotificationStatus.STARTED);
        dataNotificationDTO.setModulo(Modulo.OXY_PROCESSOS);
        dataNotificationDTO.setType("Notifica\u00e7\u00e3o");
        dataNotificationDTO.setUsername(SecurityContextHolder.getContext().getAuthentication().getName());
        dataNotificationDTO.setMessage("Iniciado processamento de assinaturas.");
        dataNotificationDTO.setMessageDetail("Clique aqui para visualizar as assinaturadas que est\u00e3o sendo processadas.");
        dataNotificationDTO.setLink(String.format("/protocolo/arquivos-assinatura?filters==idProcessamento_Igual=%s", idProcessamento));
        return this.notificationFeign.publishMessage(dataNotificationDTO);
    }

    private List<Long> getIdsSelecionados(AssinaturaLoteDTO dto) {
        if (!dto.getIsAllSelected().booleanValue()) {
            return dto.getSelectedIds();
        }
        String search = AssinaturaLoteService.buildSearch((AssinaturaLoteDTO)dto);
        Specification specification = RsqlUtils.createSpecFrom((EntityManager)this.entityManager, (String)search);
        if (!dto.getUnselectedIds().isEmpty()) {
            specification = specification.and(ProcessoArquivoAssinaturaSpecificationHelper.filterUnselectedIds((List)dto.getUnselectedIds()));
        }
        return this.repositoryArquivoAssinatura.findAll(specification).stream().map(ProcessoArquivoAssinatura::getId).collect(Collectors.toList());
    }

    private static String buildSearch(AssinaturaLoteDTO dto) {
        return String.format("entidade==%d  and usuario.id==%s  and situacao=='PENDENTE' %s ", RequestHeaderHelper.getEntidadeLogada(), SecurityContextHolder.getContext().getAuthentication().getName(), dto.getRsql());
    }

    private void validarSenhaUsuario(AssinaturaLoteDTO dto) {
        Usuario user = this.usuarioService.findUsuarioByName(SecurityContextHolder.getContext().getAuthentication().getName());
        if (!Boolean.TRUE.equals(this.usuarioService.validarSenha(dto.getPassword(), user))) {
            throw new EloValidationException("Senha n\u00e3o confere!");
        }
    }

    public Boolean assinarLoteProximo(LoteProcessamentoAssinaturaDTO loteProcessamentoAssinaturaDTO) {
        return this.assinaturaProcessaLoteThreadService.assinarLoteProximo(loteProcessamentoAssinaturaDTO);
    }

    @Generated
    public AssinaturaLoteService(UsuarioService usuarioService, EntidadeService entidadeService, ProcessoArquivoAssinaturaRepository repositoryArquivoAssinatura, EntityManager entityManager, Publisher publisher, NotificationFeign notificationFeign, ProtocoloConfigService protocoloConfigService, AssinaturaProcessaLoteThreadService assinaturaProcessaLoteThreadService) {
        this.usuarioService = usuarioService;
        this.entidadeService = entidadeService;
        this.repositoryArquivoAssinatura = repositoryArquivoAssinatura;
        this.entityManager = entityManager;
        this.publisher = publisher;
        this.notificationFeign = notificationFeign;
        this.protocoloConfigService = protocoloConfigService;
        this.assinaturaProcessaLoteThreadService = assinaturaProcessaLoteThreadService;
    }
}

