/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service.assinatura;

import br.com.elotech.adm.exception.RegistroNaoEncontradoException;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.outbox.domain.EntityEvent;
import br.com.elotech.outbox.domain.OutboxActions;
import br.com.elotech.outbox.publisher.Publisher;
import br.com.elotech.protocolo.converter.HashMapConverter;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.FluxoAssinatura;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoArquivo;
import br.com.elotech.protocolo.domain.ProcessoArquivoAssinatura;
import br.com.elotech.protocolo.domain.ProcessoAssinaturaConfig;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.dto.AssinaturaIntegracaoRequestDTO;
import br.com.elotech.protocolo.dto.AssinaturaIntegracaoResponseDTO;
import br.com.elotech.protocolo.dto.AssuntoDTO;
import br.com.elotech.protocolo.dto.EntidadeDTO;
import br.com.elotech.protocolo.dto.Funcao;
import br.com.elotech.protocolo.dto.LocalDTO;
import br.com.elotech.protocolo.dto.PessoaDTO;
import br.com.elotech.protocolo.dto.PkProcessoDTO;
import br.com.elotech.protocolo.dto.ProcessoDTO;
import br.com.elotech.protocolo.dto.ProtocoloArquivoStatusDTO;
import br.com.elotech.protocolo.dto.RetornoIntegracaoAssinaturaDTO;
import br.com.elotech.protocolo.dto.SituacaoDTO;
import br.com.elotech.protocolo.dto.TipoProcessoSimpleDTO;
import br.com.elotech.protocolo.dto.TramiteProcessosWrapper;
import br.com.elotech.protocolo.dto.UsuarioAssinanteDTO;
import br.com.elotech.protocolo.enums.TipoIntegracaoEnum;
import br.com.elotech.protocolo.mail.senders.impl.ProcessoArquivoAssinaturaEmailSender;
import br.com.elotech.protocolo.repository.ProcessoArquivoAssinaturaRepository;
import br.com.elotech.protocolo.repository.ProcessoArquivoRepository;
import br.com.elotech.protocolo.repository.ProcessoRepository;
import br.com.elotech.protocolo.service.FluxoAssinaturaService;
import br.com.elotech.protocolo.service.ProcessoArquivoService;
import br.com.elotech.protocolo.service.ProcessoAssinaturaConfigService;
import br.com.elotech.protocolo.service.ProcessoPesquisaService;
import br.com.elotech.protocolo.service.ProcessoService;
import br.com.elotech.protocolo.service.ProcessoUsuarioViewService;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AssinaturaIntegracaoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssinaturaIntegracaoService.class);
    private final ProcessoService processoService;
    private final ProcessoPesquisaService processoPesquisaService;
    private final ProcessoAssinaturaConfigService processoAssinaturaConfigService;
    private final Publisher publisher;
    private final FluxoAssinaturaService fluxoAssinaturaService;
    private final ProcessoArquivoAssinaturaEmailSender assinaturaEmailSender;
    private final ProcessoRepository repository;
    private final ProcessoArquivoRepository processoArquivoRepository;
    private final ProcessoArquivoAssinaturaRepository processoArquivoAssinaturaRepository;
    private final ProcessoUsuarioViewService processoUsuarioViewService;
    private final ProtocoloMapper mapper;
    private final ProcessoArquivoService processoArquivoService;

    @Autowired
    public AssinaturaIntegracaoService(ProcessoService processoService, ProcessoAssinaturaConfigService processoAssinaturaConfigService, Publisher publisher, ProcessoPesquisaService processoPesquisaService, FluxoAssinaturaService fluxoAssinaturaService, ProcessoArquivoAssinaturaEmailSender assinaturaEmailSender, ProcessoRepository repository, ProcessoArquivoRepository processoArquivoRepository, ProcessoArquivoAssinaturaRepository processoArquivoAssinaturaRepository, ProcessoUsuarioViewService processoUsuarioViewService, ProtocoloMapper mapper, ProcessoArquivoService processoArquivoService) {
        this.processoService = processoService;
        this.processoAssinaturaConfigService = processoAssinaturaConfigService;
        this.publisher = publisher;
        this.processoPesquisaService = processoPesquisaService;
        this.fluxoAssinaturaService = fluxoAssinaturaService;
        this.assinaturaEmailSender = assinaturaEmailSender;
        this.repository = repository;
        this.processoArquivoRepository = processoArquivoRepository;
        this.processoArquivoAssinaturaRepository = processoArquivoAssinaturaRepository;
        this.processoUsuarioViewService = processoUsuarioViewService;
        this.mapper = mapper;
        this.processoArquivoService = processoArquivoService;
    }

    private ProcessoAssinaturaConfig getProcessoAssinaturaConfig(AssinaturaIntegracaoRequestDTO assinaturaIntegracaoDTO) {
        log.debug("saveProcessoIntegracao - getProcessoAssinaturaConfig");
        ProcessoAssinaturaConfig config = this.processoAssinaturaConfigService.getProcessoAssinaturaConfigByEntidadeAndTipo(assinaturaIntegracaoDTO.getIdEntidade(), assinaturaIntegracaoDTO.getTipoIntegracao());
        if (Objects.isNull(config)) {
            throw new RegistroNaoEncontradoException(String.format("Configura\u00e7\u00e3o para a entidade %s e tipo integra\u00e7\u00e3o %s n\u00e3o foi encontrada.", assinaturaIntegracaoDTO.getIdEntidade(), assinaturaIntegracaoDTO.getTipoIntegracao().value));
        }
        return config;
    }

    private Processo atualizaArquivosProcessoExistente(AssinaturaIntegracaoRequestDTO assinaturaIntegracaoDTO) {
        Processo processo = this.repository.findByUuid(assinaturaIntegracaoDTO.getProcessoExistenteUuid().toString());
        if (Objects.isNull(processo)) {
            throw new RegistroNaoEncontradoException(String.format("Processo existente informado n\u00e3o encontrado. [%s]", assinaturaIntegracaoDTO.getProcessoExistenteUuid()));
        }
        if (processo.getArquivos().stream().anyMatch(arquivo -> arquivo.isArquivoIntegracao() && arquivo.getCancelado() == false)) {
            throw new EloValidationException(String.format("J\u00e1 existem arquivos de integra\u00e7\u00e3o para este processo. [%s]", assinaturaIntegracaoDTO.getProcessoExistenteUuid()));
        }
        this.processoArquivoService.addProcessoArquivoAssinatura(processo, assinaturaIntegracaoDTO);
        return processo;
    }

    private Processo criaProcessoAssinatura(AssinaturaIntegracaoRequestDTO assinaturaIntegracaoDTO) {
        ProcessoAssinaturaConfig config = this.getProcessoAssinaturaConfig(assinaturaIntegracaoDTO);
        ProcessoDTO processoDTO = new ProcessoDTO();
        processoDTO.setEntidade(EntidadeDTO.of((Long)config.getEntidade()));
        processoDTO.setAssunto(AssuntoDTO.of((Long)config.getAssunto().getId()));
        processoDTO.setDataProcesso(LocalDate.now());
        processoDTO.setLocalOrigem(LocalDTO.of((Long)config.getLocalOrigem().getId().getId()));
        processoDTO.setLocalDestino(LocalDTO.of((Long)config.getLocalDestino().getId().getId()));
        processoDTO.setLocalAtual(LocalDTO.of((Long)config.getLocalOrigem().getId().getId()));
        processoDTO.setTipo(TipoProcessoSimpleDTO.of((Long)config.getTipoProcesso().getId()));
        processoDTO.setPessoa(PessoaDTO.of((Long)config.getPessoa().getId()));
        processoDTO.setSituacao(SituacaoDTO.of((Long)config.getSituacao().getId()));
        processoDTO.setAssinaturaIntegracao(assinaturaIntegracaoDTO);
        log.debug("saveProcessoIntegracao - processoDTO criado");
        Processo saved = this.processoService.saveProcessoExterno(processoDTO, null);
        log.debug("saveProcessoIntegracao - Processo Assinatura criado");
        return saved;
    }

    private Processo createOrUpdateProcessoAssinatura(AssinaturaIntegracaoRequestDTO assinaturaIntegracaoDTO) {
        if (Objects.nonNull(assinaturaIntegracaoDTO.getProcessoExistenteUuid())) {
            log.debug("saveProcessoIntegracao - Processo existente informado");
            return this.atualizaArquivosProcessoExistente(assinaturaIntegracaoDTO);
        }
        log.debug("saveProcessoIntegracao - Processo ser\u00e1 criado");
        return this.criaProcessoAssinatura(assinaturaIntegracaoDTO);
    }

    private void referenciarProcessos(Processo saved, Set<PkProcessoDTO> processosReferencia) {
        if (Objects.isNull(processosReferencia)) {
            return;
        }
        processosReferencia.forEach(referencia -> {
            ProcessoPK idProcessoPai = ProcessoPK.of((Entidade)new Entidade(referencia.getEntidade()), (TipoProcesso)new TipoProcesso(referencia.getTipo()), (Long)referencia.getNumero(), (Long)referencia.getAno());
            this.processoService.referenciarProcesso(saved, idProcessoPai);
        });
    }

    @Transactional
    public RetornoIntegracaoAssinaturaDTO saveProcessoIntegracao(AssinaturaIntegracaoRequestDTO assinaturaIntegracaoDTO) {
        log.debug("saveProcessoIntegracao - Inicio");
        Processo saved = this.createOrUpdateProcessoAssinatura(assinaturaIntegracaoDTO);
        log.debug("saveProcessoIntegracao - Atualizando arquivos");
        saved.getArquivos().forEach(processoArquivo -> {
            processoArquivo.setOrdem(processoArquivo.getId().getSequencia());
            processoArquivo.setVariaveis(HashMapConverter.toString((HashMap)assinaturaIntegracaoDTO.getVariaveis()));
        });
        log.debug("saveProcessoIntegracao - Enviando email Solicitacao.");
        this.enviarEmailSolicitacaoAssinatura(saved.getArquivos());
        log.debug("saveProcessoIntegracao - Referenciando processos.");
        this.referenciarProcessos(saved, assinaturaIntegracaoDTO.getProcessoReferencia());
        RetornoIntegracaoAssinaturaDTO retornoDTO = new RetornoIntegracaoAssinaturaDTO();
        retornoDTO.setPkProcesso(saved.toPkProcessoDTO());
        retornoDTO.setTipoIntegracao(assinaturaIntegracaoDTO.getTipoIntegracao());
        retornoDTO.setIdMovimento(assinaturaIntegracaoDTO.getIdMovimento());
        log.debug("saveProcessoIntegracao - Finalizado.");
        return retornoDTO;
    }

    private void enviarEmailSolicitacaoAssinatura(List<ProcessoArquivo> processosArquivos) {
        if (Objects.nonNull(processosArquivos) && !processosArquivos.isEmpty()) {
            processosArquivos.stream().findFirst().ifPresent(procArq -> procArq.getAssinaturas().forEach(arg_0 -> ((ProcessoArquivoAssinaturaEmailSender)this.assinaturaEmailSender).enviarEmailSolicitandoAssinatura(arg_0)));
        }
    }

    public List<RetornoIntegracaoAssinaturaDTO> saveProcessoIntegracaoLote(List<AssinaturaIntegracaoRequestDTO> assinaturasIntegracaoDTO) {
        return assinaturasIntegracaoDTO.stream().map(arg_0 -> this.saveProcessoIntegracao(arg_0)).collect(Collectors.toList());
    }

    public void finalizarProcessoAssinatura(Processo processo, String usuarioAtual) {
        if (processo.isProcessoIntegracaoLegado()) {
            AssinaturaIntegracaoResponseDTO dtoIntegracao = new AssinaturaIntegracaoResponseDTO();
            dtoIntegracao.setId(processo.getId().getNumero());
            dtoIntegracao.setTipoIntegracao(processo.getTipoIntegracaoAssinatura());
            dtoIntegracao.setProcesso(processo.toPkProcessoDTO());
            dtoIntegracao.setProcessoFila(processo.getFilaIntegracaoAssinatura());
            dtoIntegracao.setIntegracaoId(processo.getIdIntegracaoAssinatura());
            this.publisher.publish(OutboxActions.CREATED, (EntityEvent)dtoIntegracao);
            this.arquivamentoAutomatico(processo, usuarioAtual);
        }
    }

    public void atualizarProcessoAssinaturaParaEmAndamento(Processo processo) {
        if (processo.isProcessoIntegracaoLegado()) {
            AssinaturaIntegracaoResponseDTO dtoIntegracao = new AssinaturaIntegracaoResponseDTO();
            dtoIntegracao.setId(processo.getId().getNumero());
            dtoIntegracao.setTipoIntegracao(processo.getTipoIntegracaoAssinatura());
            dtoIntegracao.setProcesso(processo.toPkProcessoDTO());
            dtoIntegracao.setProcessoFila(processo.getFilaIntegracaoAssinatura());
            dtoIntegracao.setIntegracaoId(processo.getIdIntegracaoAssinatura());
            this.publisher.publish(OutboxActions.UPDATED, (EntityEvent)dtoIntegracao);
        }
    }

    public void finalizarRecusaAssinatura(ProcessoArquivoAssinatura processoArquivoAssinatura, String motivo) {
        Processo processo = processoArquivoAssinatura.getArquivo().getId().getProcesso();
        if (processo.isProcessoIntegracaoLegado()) {
            AssinaturaIntegracaoResponseDTO dtoIntegracao = new AssinaturaIntegracaoResponseDTO();
            dtoIntegracao.setId(processo.getId().getNumero());
            dtoIntegracao.setTipoIntegracao(processo.getTipoIntegracaoAssinatura());
            dtoIntegracao.setProcesso(processo.toPkProcessoDTO());
            dtoIntegracao.setProcessoFila(processo.getFilaIntegracaoAssinatura());
            dtoIntegracao.setMotivoRejeicao(motivo);
            dtoIntegracao.setUsuarioRejeicao(processoArquivoAssinatura.getUsuario().getCpf());
            dtoIntegracao.setUsuarioSolicitante(processoArquivoAssinatura.getUsuarioSolicitante().getCpf());
            dtoIntegracao.setIntegracaoId(processo.getIdIntegracaoAssinatura());
            this.publisher.publish(OutboxActions.CREATED, (EntityEvent)dtoIntegracao);
            this.arquivamentoAutomatico(processo, processoArquivoAssinatura.getUsuario().getId());
        }
    }

    public void republish() {
        List processos = this.processoPesquisaService.findAllProcessosIntegracaoAssinatura();
        processos.forEach(processo -> {
            if (processo.isProcessoIntegracaoLegado()) {
                this.publisher.publish(OutboxActions.UPDATED, (EntityEvent)processo.toAssinaturaIntegracaoResponseDTO());
                return;
            }
            processo.getArquivos().forEach(processoArquivo -> this.publicarAtualizacaoArquivo(processoArquivo, OutboxActions.UPDATED));
        });
    }

    @Transactional
    public RetornoIntegracaoAssinaturaDTO gerarProcessoFluxoAssinatura(AssinaturaIntegracaoRequestDTO dto) {
        FluxoAssinatura fluxoAssinatura = this.fluxoAssinaturaService.getFluxoAssinatura(dto.getTipoIntegracao(), dto.getIdEntidade());
        List usuarioAssinantes = this.fluxoAssinaturaService.getUsuarioAssinantesDTO(null, fluxoAssinatura, dto.getVariaveis());
        for (UsuarioAssinanteDTO usuarioAssinanteDTO : usuarioAssinantes) {
            dto.addAssinante(usuarioAssinanteDTO.getCpf(), usuarioAssinanteDTO.getGrupo());
            dto.setFluxoAssinanteSequencia(usuarioAssinanteDTO.getSequencia());
        }
        return this.saveProcessoIntegracao(dto);
    }

    @Transactional
    public void removerProcesso(UUID protocoloId, Boolean ignoraAssinaturas) {
        Processo processo = this.repository.findByUuid(protocoloId.toString());
        if (!Boolean.TRUE.equals(ignoraAssinaturas) && Boolean.TRUE.equals(this.processoArquivoAssinaturaRepository.exitsAssinaturaDiferenteDePendente(processo.getId().getTipo().getId(), processo.getId().getAno(), processo.getId().getNumero()))) {
            throw new EloValidationException("Processo de assinatura j\u00e1 foi iniciado. N\u00e3o \u00e9 poss\u00edvel gerar um novo fluxo de assinatura. ");
        }
        processo.getArquivos().forEach(processoArquivo -> {
            if (processoArquivo.isArquivoIntegracao()) {
                this.publicarAtualizacaoArquivo(processoArquivo, OutboxActions.DELETED);
            }
            this.processoArquivoRepository.deleteById((Object)processoArquivo.getId());
        });
        List processoToDelete = this.processoArquivoAssinaturaRepository.findByArquivoAssinaturaProcessoId(processo.getId().getTipo().getId(), processo.getId().getAno(), processo.getId().getNumero());
        processoToDelete.forEach(arg_0 -> ((ProcessoArquivoAssinaturaRepository)this.processoArquivoAssinaturaRepository).deleteById(arg_0));
        this.processoUsuarioViewService.deleteByProcessoId(processo.getId());
        this.repository.deleteById((Object)processo.getId());
    }

    protected void arquivamentoAutomatico(Processo processo, String userName) {
        Entidade entidade = processo.getId().getEntidade();
        ProcessoAssinaturaConfig config = this.processoAssinaturaConfigService.getProcessoAssinaturaConfigByEntidadeAndTipo(entidade.getId(), processo.getTipoIntegracaoAssinatura());
        if (Objects.isNull(config.getParecerArquivamento()) || Objects.isNull(config.getLocalArquivamento()) || Objects.isNull(config.getSituacaoArquivamento())) {
            return;
        }
        List<Processo> processos = List.of(processo);
        TramiteProcessosWrapper tramiteWrapper = new TramiteProcessosWrapper();
        tramiteWrapper.setFuncao(Funcao.ARQUIVADO);
        tramiteWrapper.setParecer(config.getParecerArquivamento());
        tramiteWrapper.setLocal(this.mapper.toLocalDTO(config.getLocalArquivamento()));
        tramiteWrapper.setSituacao(this.mapper.toSituacaoDTO(config.getSituacaoArquivamento()));
        this.processoService.tramitar(processos, tramiteWrapper, entidade, userName);
    }

    public void publicarAtualizacaoArquivo(ProcessoArquivo arquivo, OutboxActions action) {
        if (!arquivo.isArquivoIntegracao()) {
            log.debug("Arquivo {} n\u00e3o \u00e9 de integra\u00e7\u00e3o assinatura", (Object)arquivo);
            return;
        }
        ProtocoloArquivoStatusDTO dto = ProtocoloArquivoStatusDTO.builder().processo(this.mapper.toProcessoPKDTO(arquivo.getId().getProcesso().getId())).arquivo(this.mapper.toProcessoArquivoDTO(arquivo)).build();
        log.debug("Vai publicar arquivo {} na fila {} com situa\u00e7\u00e3o {}", new Object[]{arquivo, dto.getAggregateType(), arquivo.getSituacao()});
        this.publisher.publish(action, (EntityEvent)dto);
    }

    @Transactional
    public void removerArquivosAssinatura(TipoIntegracaoEnum tipoIntegracaoAssinatura, String idIntegracaoAssinatura) {
        this.processoArquivoRepository.deleteByTipoIntegracaoAssinaturaAndIdIntegracaoAssinatura(tipoIntegracaoAssinatura, idIntegracaoAssinatura);
    }
}

