/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service.arquivo;

import br.com.elotech.arquivos.domain.response.ArquivoUrl;
import br.com.elotech.protocolo.domain.ProcessoArquivo;
import br.com.elotech.protocolo.service.ProtocoloConfigService;
import br.com.elotech.protocolo.service.arquivo.ArquivoCloudService;
import br.com.elotech.protocolo.service.arquivo.ArquivoStandaloneService;
import br.com.elotech.protocolo.service.arquivo.ArquivoStrategyService;
import br.com.elotech.unico.client.ArquivoStorageFeignClient;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import br.com.elotech.unico.client.dto.EloArquivoDTO;
import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ArquivoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ArquivoService.class);
    private final ArquivoStandaloneService arquivoStandaloneService;
    private final ArquivoCloudService arquivoCloudService;
    private final ProtocoloConfigService protocoloConfigService;
    private final ArquivoStorageFeignClient arquivoStorageFeignClient;

    private ArquivoStrategyService getService() {
        if (Boolean.TRUE.equals(this.protocoloConfigService.getConfig().getIsFileCloud())) {
            log.debug("Utilizando arquivos cloud");
            return this.arquivoCloudService;
        }
        log.debug("Utilizando arquivos banco");
        return this.arquivoStandaloneService;
    }

    private ArquivoStrategyService getServiceByArquivo(Long idArquivo) {
        if (Boolean.TRUE.equals(this.getService().isFileCloud(idArquivo))) {
            log.debug("O arquivo {} \u00e9 cloud", (Object)idArquivo);
            return this.arquivoCloudService;
        }
        log.debug("O arquivo {} n\u00e3o \u00e9 cloud", (Object)idArquivo);
        return this.arquivoStandaloneService;
    }

    public ArquivoDTO addArquivo(MultipartFile file) {
        this.protocoloConfigService.throwExceptionIfSomenteLeitura();
        return this.getService().addArquivo(file);
    }

    public ArquivoDTO addArquivo(File file) {
        this.protocoloConfigService.throwExceptionIfSomenteLeitura();
        return this.getService().addArquivo(file);
    }

    public void deletarArquivo(Long id) {
        this.protocoloConfigService.throwExceptionIfSomenteLeitura();
        this.getService().deletarArquivo(id);
    }

    public Optional<EloArquivoDTO> downloadArquivo(Long idArquivo) {
        return this.getServiceByArquivo(idArquivo).downloadArquivo(idArquivo);
    }

    public File downloadArquivoFisico(Long idArquivo, String path) {
        return this.getServiceByArquivo(idArquivo).downloadArquivoFisico(idArquivo, path);
    }

    public void updateContent(ProcessoArquivo processoArquivo, Path path) {
        this.protocoloConfigService.throwExceptionIfSomenteLeitura();
        this.getService().updateContent(processoArquivo, path);
    }

    public ArquivoUrl getUrlDownload(String fullPath, String fileName) {
        return this.getService().getUrlDownload(fullPath, fileName);
    }

    public ArquivoUrl getUrlUpload(String fileName, String contentType) {
        this.protocoloConfigService.throwExceptionIfSomenteLeitura();
        return this.getService().getUrlUpload(fileName, contentType);
    }

    public ArquivoDTO addArquivoEntity(ArquivoUrl arquivoUrl, String fileName, String contentType) {
        this.protocoloConfigService.throwExceptionIfSomenteLeitura();
        return this.getService().addArquivoEntity(arquivoUrl, fileName, contentType);
    }

    public String getFullPath(Long arquivoId) {
        return this.getService().getFullPath(arquivoId);
    }

    public void markAsSigned(Long id) {
        this.protocoloConfigService.throwExceptionIfSomenteLeitura();
        this.arquivoStorageFeignClient.markAsSigned(id);
    }

    @Generated
    public ArquivoService(ArquivoStandaloneService arquivoStandaloneService, ArquivoCloudService arquivoCloudService, ProtocoloConfigService protocoloConfigService, ArquivoStorageFeignClient arquivoStorageFeignClient) {
        this.arquivoStandaloneService = arquivoStandaloneService;
        this.arquivoCloudService = arquivoCloudService;
        this.protocoloConfigService = protocoloConfigService;
        this.arquivoStorageFeignClient = arquivoStorageFeignClient;
    }
}

