/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service.arquivo;

import br.com.elotech.adm.arquivo.domain.enums.FilePathEnum;
import br.com.elotech.adm.utils.CharsetConverterUtils;
import br.com.elotech.arquivos.domain.response.ArquivoUrl;
import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.protocolo.domain.ProcessoArquivo;
import br.com.elotech.protocolo.exception.UploadFileCloudException;
import br.com.elotech.protocolo.service.ProtocoloConfigService;
import br.com.elotech.protocolo.service.UsuarioService;
import br.com.elotech.protocolo.service.arquivo.ArquivoStrategyService;
import br.com.elotech.unico.client.ArquivoStorageFeignClient;
import br.com.elotech.unico.client.domain.TipoArquivoEnum;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import br.com.elotech.unico.client.dto.EloArquivoContentDTO;
import br.com.elotech.unico.client.dto.EloArquivoDTO;
import java.io.File;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Duration;
import java.time.LocalDate;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ArquivoCloudService
implements ArquivoStrategyService {
    private static final Duration TIMEOUT = Duration.ofDays(10L);
    private final ArquivoStorageFeignClient arquivoUnicoClient;
    private final UsuarioService usuarioService;
    private final ProtocoloConfigService protocoloConfigService;

    protected ArquivoCloudService(ArquivoStorageFeignClient arquivoUnicoClient, UsuarioService usuarioService, ProtocoloConfigService protocoloConfigService) {
        this.arquivoUnicoClient = arquivoUnicoClient;
        this.usuarioService = usuarioService;
        this.protocoloConfigService = protocoloConfigService;
    }

    @Transactional
    public ArquivoDTO addArquivo(MultipartFile file) {
        String fileName = file.getOriginalFilename();
        String fileNameUnaccent = CharsetConverterUtils.removeSymbols((String)fileName);
        ArquivoUrl arquivoUrl = this.getUrlUpload(fileNameUnaccent, file.getContentType());
        HttpResponse<byte[]> response = HttpClient.newBuilder().build().send(HttpRequest.newBuilder().uri(URI.create(arquivoUrl.getUrlAssinada())).header("Content-Type", file.getContentType()).timeout(TIMEOUT).PUT(HttpRequest.BodyPublishers.ofByteArray(file.getBytes())).build(), HttpResponse.BodyHandlers.ofByteArray());
        if (response.statusCode() != HttpStatus.OK.value()) {
            throw new UploadFileCloudException(fileName, arquivoUrl.getUrlAssinada(), response.statusCode());
        }
        return this.addArquivoEntity(arquivoUrl, fileName, file.getContentType());
    }

    @Transactional
    public ArquivoDTO addArquivo(File file) {
        String fileName = file.getName();
        String fileNameUnaccent = CharsetConverterUtils.removeSymbols((String)fileName);
        String contentType = Optional.ofNullable(ContentType.fromExtension((String)fileName)).filter(x -> Stream.of(ContentType.OCTET_STREAM, ContentType.APPLICATION_RAR).noneMatch(arg_0 -> x.equals(arg_0))).map(ContentType::getType).orElse("application/octet-stream");
        ArquivoUrl arquivoUrl = this.getUrlUpload(fileNameUnaccent, contentType);
        HttpResponse<String> response = HttpClient.newBuilder().build().send(HttpRequest.newBuilder().uri(URI.create(arquivoUrl.getUrlAssinada())).header("Content-Type", contentType).timeout(TIMEOUT).PUT(HttpRequest.BodyPublishers.ofFile(Path.of(file.toURI()))).build(), HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != HttpStatus.OK.value()) {
            throw new UploadFileCloudException(fileName, arquivoUrl.getUrlAssinada(), response.statusCode());
        }
        return this.addArquivoEntity(arquivoUrl, fileName, contentType);
    }

    public ArquivoDTO addArquivoEntity(ArquivoUrl arquivoUrl, String fileName, String contentType) {
        Object principal;
        ArquivoDTO novoArquivo = new ArquivoDTO();
        if (StringUtils.isBlank((CharSequence)contentType)) {
            contentType = ContentType.fromExtension((String)fileName).getType();
        }
        novoArquivo.setMimeType(contentType);
        novoArquivo.setNome(CharsetConverterUtils.sanitize((String)fileName));
        novoArquivo.setTipo(TipoArquivoEnum.OUTROS);
        novoArquivo.setModulo(Modulo.OXY_PROCESSOS);
        novoArquivo.setDataCriacao(LocalDate.now());
        novoArquivo.setFullPath(arquivoUrl.getFullPath());
        novoArquivo.setFullPathOriginal(arquivoUrl.getFullPath());
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && this.protocoloConfigService.isModoCloud() && (principal = authentication.getPrincipal()) instanceof String && !principal.equals("anonymousUser")) {
            UUID idUsuarioLogado = this.usuarioService.getIdUsuarioLogadoKeycloak();
            novoArquivo.setUsuario(idUsuarioLogado);
        }
        return this.arquivoUnicoClient.create(novoArquivo);
    }

    public Optional<EloArquivoDTO> downloadArquivo(Long idArquivo) {
        ArquivoDTO arquivoUnico = this.arquivoUnicoClient.findOne(idArquivo);
        String nomeArquivoUTF8 = URLEncoder.encode(arquivoUnico.getNome(), StandardCharsets.UTF_8);
        String nomeArquivoSemAcentos = StringUtils.stripAccents((String)arquivoUnico.getNome());
        String urlDownload = this.getUrlDownload(arquivoUnico.getFullPath(), nomeArquivoUTF8).getUrlAssinada();
        byte[] responseBody = HttpClient.newBuilder().build().send(HttpRequest.newBuilder().uri(URI.create(urlDownload)).timeout(TIMEOUT).GET().build(), HttpResponse.BodyHandlers.ofByteArray()).body();
        EloArquivoContentDTO fileContent = new EloArquivoContentDTO();
        fileContent.setBinary(responseBody);
        fileContent.setMimeType(arquivoUnico.getMimeType());
        EloArquivoDTO file = new EloArquivoDTO();
        file.setId(arquivoUnico.getId());
        file.setNome(nomeArquivoSemAcentos);
        file.setContent(fileContent);
        file.setDataCriacao(arquivoUnico.getDataCriacao());
        return Optional.of(file);
    }

    public File downloadArquivoFisico(Long idArquivo, String path) {
        ArquivoDTO arquivoUnico = this.arquivoUnicoClient.findOne(idArquivo);
        String nomeArquivoUTF8 = URLEncoder.encode(arquivoUnico.getNome(), StandardCharsets.UTF_8);
        String urlDownload = this.getUrlDownload(arquivoUnico.getFullPath(), nomeArquivoUTF8).getUrlAssinada();
        Path responseBody = HttpClient.newBuilder().build().send(HttpRequest.newBuilder().uri(URI.create(urlDownload)).timeout(TIMEOUT).GET().build(), HttpResponse.BodyHandlers.ofFile(Path.of(path, new String[0]))).body();
        return new File(responseBody.toString());
    }

    public void deletarArquivo(Long idArquivo) {
        this.arquivoUnicoClient.delete(idArquivo);
    }

    @Transactional
    public void updateContent(ProcessoArquivo processoArquivo, Path path) {
        ArquivoDTO arquivo = this.arquivoUnicoClient.findOne(processoArquivo.getIdArquivo());
        String nomeArquivoSemAcento = CharsetConverterUtils.removeSymbols((String)arquivo.getNome());
        String contentType = ContentType.APPLICATION_PDF.getValue();
        ArquivoUrl arquivoUrl = this.arquivoUnicoClient.getUrlUpload(Modulo.OXY_PROCESSOS, FilePathEnum.PROTOCOLO.getFilePath(), nomeArquivoSemAcento, contentType);
        processoArquivo.setUrlS3(arquivoUrl.getFullPath());
        HttpResponse<byte[]> response = HttpClient.newBuilder().build().send(HttpRequest.newBuilder().uri(URI.create(arquivoUrl.getUrlAssinada())).header("Content-Type", contentType).timeout(TIMEOUT).PUT(HttpRequest.BodyPublishers.ofFile(path)).build(), HttpResponse.BodyHandlers.ofByteArray());
        if (response.statusCode() != HttpStatus.OK.value()) {
            throw new UploadFileCloudException(arquivo.getNome(), arquivoUrl.getUrlAssinada(), response.statusCode());
        }
        arquivo.setFullPath(arquivoUrl.getFullPath());
        this.arquivoUnicoClient.update(processoArquivo.getIdArquivo(), arquivo);
    }

    public ArquivoUrl getUrlDownload(String fullPath, String fileName) {
        String nomeArquivoUTF8 = URLEncoder.encode(fileName, StandardCharsets.UTF_8);
        return this.arquivoUnicoClient.getUrlDownload(fullPath, nomeArquivoUTF8);
    }

    public ArquivoUrl getUrlUpload(String fileName, String contentType) {
        if (StringUtils.isBlank((CharSequence)contentType)) {
            contentType = ContentType.fromExtension((String)fileName).getType();
        }
        return this.arquivoUnicoClient.getUrlUpload(Modulo.OXY_PROCESSOS, FilePathEnum.PROTOCOLO.getFilePath(), fileName, contentType);
    }

    public Boolean isFileCloud(Long idArquivo) {
        return StringUtils.isNotBlank((CharSequence)Optional.ofNullable(this.arquivoUnicoClient.findOne(idArquivo)).map(ArquivoDTO::getFullPath).orElse(""));
    }

    public String getFullPath(Long arquivoId) {
        return this.arquivoUnicoClient.findOne(arquivoId).getFullPath();
    }
}

