/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.adm.exception.RegistroNaoEncontradoException;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.MissingConfigurationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Local;
import br.com.elotech.protocolo.domain.Modulo;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Seletor;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.domain.UsuarioEntidade;
import br.com.elotech.protocolo.domain.UsuarioEntidadePK;
import br.com.elotech.protocolo.domain.UsuarioLocal;
import br.com.elotech.protocolo.domain.UsuarioLocalPK;
import br.com.elotech.protocolo.domain.UsuarioSeletor;
import br.com.elotech.protocolo.domain.UsuarioSeletorPK;
import br.com.elotech.protocolo.domain.UsuarioTipoProcesso;
import br.com.elotech.protocolo.repository.UsuarioEntidadeRepository;
import br.com.elotech.protocolo.repository.UsuarioLocalRepository;
import br.com.elotech.protocolo.repository.UsuarioRepository;
import br.com.elotech.protocolo.repository.UsuarioSeletorRepository;
import br.com.elotech.protocolo.repository.UsuarioTipoProcessoRepository;
import br.com.elotech.protocolo.service.LocalService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.assinatura.validators.UsuarioSenhaValidator;
import br.com.elotech.protocolo.utils.UsuarioUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.OidcKeycloakAccount;
import org.keycloak.adapters.springsecurity.token.KeycloakAuthenticationToken;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.JsonWebToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Transactional(readOnly=true)
public class UsuarioService
extends CrudService<Usuario, String> {
    private static final String ENTIDADE_NAO_CONFIGURADA = "N\u00e3o existem entidades dispon\u00edveis para o usu\u00e1rio [%s]";
    private final UsuarioRepository usuarioRepository;
    private final UsuarioLocalRepository usuarioLocalRepository;
    private final UsuarioEntidadeRepository usuarioEntidadeRepository;
    private final UsuarioTipoProcessoRepository usuarioTipoProcessoRepository;
    private final UsuarioSeletorRepository usuarioSeletorRepository;
    private final ParametroService parametroService;
    private final UsuarioSenhaValidator usuarioSenhaValidator;
    private final LocalService localService;

    @Autowired
    public UsuarioService(UsuarioRepository usuarioRepository, UsuarioLocalRepository usuarioLocalRepository, UsuarioEntidadeRepository usuarioEntidadeRepository, UsuarioTipoProcessoRepository usuarioTipoProcessoRepository, UsuarioSeletorRepository usuarioSeletorRepository, @Lazy UsuarioSenhaValidator usuarioSenhaValidator, @Lazy ParametroService parametroService, @Lazy LocalService localService) {
        this.usuarioRepository = usuarioRepository;
        this.usuarioLocalRepository = usuarioLocalRepository;
        this.usuarioEntidadeRepository = usuarioEntidadeRepository;
        this.usuarioTipoProcessoRepository = usuarioTipoProcessoRepository;
        this.usuarioSeletorRepository = usuarioSeletorRepository;
        this.usuarioSenhaValidator = usuarioSenhaValidator;
        this.parametroService = parametroService;
        this.localService = localService;
    }

    public Boolean validarSenha(String senha, Usuario usuario) {
        return this.usuarioSenhaValidator.validarSenha(senha, usuario);
    }

    public List<UsuarioLocal> listarLocaisUsuario(Usuario usuario) {
        return this.usuarioLocalRepository.findByIdUsuario(usuario);
    }

    public List<UsuarioLocal> getUsuarioLocalByLocal(Local local) {
        return this.usuarioLocalRepository.findByIdLocal(local);
    }

    public List<UsuarioTipoProcesso> listarTipoProcessoUsuario(Usuario usuario) {
        return this.usuarioTipoProcessoRepository.findByIdUsuario(usuario);
    }

    public Usuario findUsuarioByName(String username) {
        return (Usuario)this.usuarioRepository.findById((Object)username).orElseThrow(() -> new RegistroNaoEncontradoException(String.format("Usu\u00e1rio %s n\u00e3o encontrado no Protocolo.", username)));
    }

    public List<Usuario> findByCpf(String cpf) {
        return this.usuarioRepository.findByCpf(cpf);
    }

    public UsuarioEntidade getUsuarioEntidadePadraoUsuario(String username) {
        List entidadesUsuario = this.usuarioEntidadeRepository.findByIdUsuarioId(username);
        return entidadesUsuario.stream().filter(UsuarioEntidade::getPadrao).findFirst().orElseGet(() -> (UsuarioEntidade)entidadesUsuario.stream().findFirst().orElseThrow(() -> new MissingConfigurationException(String.format("N\u00e3o existem entidades dispon\u00edveis para o usu\u00e1rio [%s]", username))));
    }

    public List<UsuarioEntidade> findEntidadesByUsername(String username) {
        return this.usuarioEntidadeRepository.findByIdUsuarioId(username);
    }

    protected void beforeSave(Usuario entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        for (UsuarioTipoProcesso usuarioTipoProcesso : entity.getUsuarioTipoProcesso()) {
            if (entity.equals((Object)usuarioTipoProcesso.getId().getUsuario())) continue;
            usuarioTipoProcesso.getId().setUsuario(entity);
        }
    }

    public List<Local> getLocaisUsuario(Usuario usuario) {
        return this.listarLocaisUsuario(usuario).stream().map(ul -> ul.getId().getLocal()).collect(Collectors.toList());
    }

    public List<TipoProcesso> getTiposProcessoUsuario(Usuario usuario) {
        return this.listarTipoProcessoUsuario(usuario).stream().map(ul -> ul.getId().getTipoProcesso()).collect(Collectors.toList());
    }

    public UsuarioSeletor getAcessosSeletor(String nomeSeletor, Usuario usuario) {
        UsuarioSeletorPK pk = UsuarioSeletorPK.of((Modulo)Modulo.of((String)ModuloEnum.MODULO_PROTOCOLO.getValue()), (Seletor)Seletor.of((String)nomeSeletor), (Usuario)usuario);
        return (UsuarioSeletor)this.usuarioSeletorRepository.findOne((Object)pk);
    }

    @Transactional(readOnly=true)
    public Boolean isServiceAccount() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof KeycloakAuthenticationToken) {
            KeycloakAuthenticationToken token = (KeycloakAuthenticationToken)authentication;
            return Optional.ofNullable(token).map(KeycloakAuthenticationToken::getAccount).map(OidcKeycloakAccount::getKeycloakSecurityContext).map(KeycloakSecurityContext::getToken).map(AccessToken::getRealmAccess).map(realmAccess -> realmAccess.isUserInRole("service_account")).orElse(false);
        }
        return Boolean.FALSE;
    }

    public Optional<AccessToken> getAccessToken() {
        return UsuarioService.getSecurityContext().map(KeycloakSecurityContext::getToken);
    }

    private static Optional<KeycloakSecurityContext> getSecurityContext() {
        return Optional.ofNullable(RequestContextHolder.getRequestAttributes()).map(requestAttributes -> (KeycloakSecurityContext)requestAttributes.getAttribute(KeycloakSecurityContext.class.getName(), 0));
    }

    public UUID getIdUsuarioLogadoKeycloak() {
        return this.getAccessToken().map(JsonWebToken::getSubject).map(UUID::fromString).orElseThrow(() -> new IllegalStateException("Usu\u00e1rio n\u00e3o encontrado"));
    }

    protected void afterSave(Usuario entity, Authentication authentication) {
        Boolean addFilhos = this.parametroService.getParamValueAsBoolean(ParametroEnum.ATRIBUI_PERMISSAO_LOCAIS_FILHOS.getCodigo());
        Set idsLocaisAssociados = entity.getUsuarioLocal().stream().map(ul -> ul.getId().getLocal().getId()).collect(Collectors.toSet());
        Arrays.stream(entity.getUsuarioLocal().toArray()).forEach(obj -> {
            UsuarioLocal usuarioLocal = (UsuarioLocal)obj;
            if (addFilhos.booleanValue()) {
                List locais = this.localService.findAllByLocalPai(usuarioLocal.getId().getLocal().getId()).stream().filter(local -> !idsLocaisAssociados.contains(local.getId())).map(ul -> new UsuarioLocal(new UsuarioLocalPK(entity, ul))).collect(Collectors.toList());
                entity.getUsuarioLocal().addAll(locais);
            }
        });
        this.usuarioRepository.saveAndFlush((Object)entity);
    }

    public String findUserNameById(String id) {
        Usuario usuario = (Usuario)this.usuarioRepository.findById((Object)id).orElseThrow();
        return usuario.getNome();
    }

    public Boolean isUsuarioAdministrador(String id, Long entidadeId) {
        Usuario usuario = (Usuario)this.usuarioRepository.findById((Object)id).orElseThrow();
        return UsuarioUtils.isAlteraTodosProc((Usuario)usuario, (Long)entidadeId);
    }

    public void updateIsUsuarioAdministrador(Boolean alteraTodosProc, String id, Long entidadeId) {
        UsuarioEntidadePK usuarioEntidadePK = new UsuarioEntidadePK();
        usuarioEntidadePK.setEntidade(Entidade.of((Long)entidadeId));
        usuarioEntidadePK.setUsuario((Usuario)this.findOne((Serializable)((Object)id)));
        UsuarioEntidade usuarioEntidade = (UsuarioEntidade)this.usuarioEntidadeRepository.findOne((Object)usuarioEntidadePK);
        usuarioEntidade.setAlteraTodosProc(alteraTodosProc);
        this.usuarioEntidadeRepository.save((Object)usuarioEntidade);
    }
}

