/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.adm.utils.CpfCnpjUtils;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.protocolo.domain.Local;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.domain.UsuarioLocal;
import br.com.elotech.protocolo.domain.UsuarioLocalPK;
import br.com.elotech.protocolo.dto.UsuarioLocalDTO;
import br.com.elotech.protocolo.dto.UsuarioPermissaoLocalDTO;
import br.com.elotech.protocolo.repository.LocalRepository;
import br.com.elotech.protocolo.repository.UsuarioLocalRepository;
import br.com.elotech.protocolo.repository.UsuarioRepository;
import br.com.elotech.protocolo.service.EntidadeService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.utils.UsuarioUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UsuarioLocalService
extends CrudService<UsuarioLocal, UsuarioLocalPK> {
    private final UsuarioLocalRepository repository;
    private final UsuarioRepository usuarioRepository;
    private final ProtocoloMapper mapper;
    private final ParametroService parametroService;
    private final LocalRepository localRepository;
    private final EntidadeService entidadeService;

    public UsuarioLocalService(UsuarioLocalRepository repository, UsuarioRepository usuarioRepository, ProtocoloMapper mapper, ParametroService parametroService, LocalRepository localRepository, @Lazy EntidadeService entidadeService) {
        this.repository = repository;
        this.usuarioRepository = usuarioRepository;
        this.mapper = mapper;
        this.parametroService = parametroService;
        this.localRepository = localRepository;
        this.entidadeService = entidadeService;
    }

    public Page<UsuarioPermissaoLocalDTO> getUsuariosByLocal(Long local, String search, Pageable pageable) {
        List result = this.repository.findAllByLocalAndAlteraTodosProcessos(local, this.entidadeService.getEntidadeLogada());
        return this.processaResult(result, StringUtils.stripAccents((String)search).toLowerCase(), pageable);
    }

    public Page<UsuarioPermissaoLocalDTO> getUsuariosByEntidade(String search, Pageable pageable) {
        List result = this.repository.findAllByEntidadeAndAlteraTodosProcessos(this.entidadeService.getEntidadeLogada());
        return this.processaResult(result, StringUtils.stripAccents((String)search).toLowerCase(), pageable);
    }

    public Page<UsuarioPermissaoLocalDTO> processaResult(List<UsuarioPermissaoLocalDTO> result, String loCaseUnaccentSearch, Pageable pageable) {
        if (StringUtils.isNotBlank((CharSequence)loCaseUnaccentSearch)) {
            result = result.stream().filter(u -> Boolean.TRUE.equals(u.getAtivo())).filter(ul -> StringUtils.stripAccents((String)ul.getLoginUsuario()).toLowerCase().contains(loCaseUnaccentSearch) || StringUtils.stripAccents((String)ul.getNomeUsuario()).toLowerCase().contains(loCaseUnaccentSearch)).collect(Collectors.toList());
        }
        Boolean isMaskUser = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBE_USUARIO_COM_MASCARA_COM_CPF_LGPD.getCodigo());
        result.forEach(usuarioPermissaoLocalDTO -> {
            usuarioPermissaoLocalDTO.setLoginUsuarioMask(usuarioPermissaoLocalDTO.getLoginUsuario());
            if (Boolean.TRUE.equals(isMaskUser) && usuarioPermissaoLocalDTO.getLoginUsuario().equals(usuarioPermissaoLocalDTO.getCpfUsuario())) {
                usuarioPermissaoLocalDTO.setLoginUsuarioMask(CpfCnpjUtils.getMaskCnpjCpf((String)usuarioPermissaoLocalDTO.getLoginUsuario()));
            }
        });
        return new PageImpl(result, pageable, (long)pageable.getPageSize());
    }

    public List<UsuarioPermissaoLocalDTO> findAllUsuariosByLocal(Long local) {
        return this.repository.findAllUsuariosByLocal(local, this.entidadeService.getEntidadeLogada());
    }

    @Transactional
    public UsuarioPermissaoLocalDTO addUserByLocal(String username, UsuarioLocalDTO dto) {
        Usuario user = (Usuario)this.usuarioRepository.findOne((Object)username);
        Local local = this.mapper.toLocal(dto.getLocal());
        UsuarioLocal usuarioLocal = new UsuarioLocal(new UsuarioLocalPK(user, local), dto.getPadrao());
        this.repository.saveAndFlush((Object)usuarioLocal);
        if (this.parametroService.getParamValueAsBoolean(ParametroEnum.ATRIBUI_PERMISSAO_LOCAIS_FILHOS.getCodigo()).booleanValue()) {
            List locais = this.localRepository.findAllByLocalPaiIdAndAtivoIsTrue(local.getId());
            locais.forEach(filho -> this.repository.saveAndFlush((Object)new UsuarioLocal(new UsuarioLocalPK(user, filho), dto.getPadrao())));
        }
        return new UsuarioPermissaoLocalDTO(user.getId(), user.getId(), user.getNome(), user.getAtivo(), UsuarioUtils.isAlteraTodosProc((Usuario)user, (Long)this.entidadeService.getEntidadeLogada()), user.getCpf());
    }
}

