/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.adm.domain.support.UsuarioLogado;
import br.com.elotech.adm.exception.UsuarioNaoLogadoException;
import br.com.elotech.adm.service.UsuarioLogadoService;
import br.com.elotech.console.client.UsuarioClient;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.console.dto.RolesUsuarioDTO;
import br.com.elotech.console.dto.UsuarioDTO;
import br.com.elotech.protocolo.repository.UsuarioRepository;
import br.com.elotech.protocolo.service.EntidadeService;
import br.com.elotech.protocolo.service.ProtocoloConfigService;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.JsonWebToken;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Profile(value={"cloud"})
@Primary
public class UsuarioCloudService
implements UsuarioLogadoService {
    private static final String HOME = "home";
    private static final String READ = "read";
    private final UsuarioClient usuarioClient;
    private final EntidadeService entidadeService;
    private final UsuarioRepository usuarioRepository;
    private final ProtocoloConfigService protocoloConfigService;

    public Boolean existsUserByIdKeycloak(String idKeycloak) {
        return this.usuarioRepository.existsByIdKeycloak(idKeycloak);
    }

    public RolesUsuarioDTO getAllRolesUser(String idKeycloak) {
        RolesUsuarioDTO roles = this.usuarioClient.findAllRolesByUsuarioAndEntidadeAndModulo(UUID.fromString(idKeycloak), this.entidadeService.getEntidadeAtual().getEntidadeConsole(), Modulo.OXY_PROCESSOS);
        this.removeRolesSeSomenteLeitura(roles);
        return roles;
    }

    public UsuarioLogado getUsuarioLogado() {
        AccessToken accessToken = (AccessToken)this.getAccessToken().orElseThrow(UsuarioNaoLogadoException::new);
        UsuarioDTO usuarioSistema = this.usuarioClient.findUsuarioById(UUID.fromString(accessToken.getSubject()));
        UsuarioLogado usuarioLogado = new UsuarioLogado();
        usuarioLogado.setId(usuarioSistema.getId());
        usuarioLogado.setAtivo(usuarioSistema.getAtivo());
        usuarioLogado.setCpf(usuarioSistema.getUsername());
        usuarioLogado.setUsername(usuarioSistema.getUsername());
        usuarioLogado.setNome(usuarioSistema.getNome());
        usuarioLogado.setSobrenome(usuarioSistema.getSobrenome());
        usuarioLogado.setEmail(usuarioSistema.getEmail());
        usuarioLogado.setNomeCompleto(usuarioSistema.getNomeCompleto());
        return usuarioLogado;
    }

    public String getIdUsuarioLogado() {
        return this.getAccessToken().map(JsonWebToken::getId).orElse("system_user");
    }

    public RolesUsuarioDTO getPermissoesUsuario() {
        AccessToken accessToken = (AccessToken)this.getAccessToken().orElseThrow(UsuarioNaoLogadoException::new);
        RolesUsuarioDTO roles = this.usuarioClient.findAllRolesByUsuarioAndEntidadeAndModulo(UUID.fromString(accessToken.getSubject()), this.entidadeService.getEntidadeAtual().getEntidadeConsole(), Modulo.OXY_PROCESSOS);
        this.removeRolesSeSomenteLeitura(roles);
        return roles;
    }

    private void removeRolesSeSomenteLeitura(RolesUsuarioDTO roles) {
        if (!Boolean.TRUE.equals(this.protocoloConfigService.getConfig().getProtocoloSomenteLeitura())) {
            return;
        }
        Set newRoles = roles.getClientRoles().stream().filter(role -> {
            if ("home".equals(role.getName()) || Objects.isNull(role.getName())) {
                return true;
            }
            return role.getName().toLowerCase().contains("read");
        }).collect(Collectors.toSet());
        roles.setClientRoles(newRoles);
    }

    public Optional<AccessToken> getAccessToken() {
        return UsuarioCloudService.getSecurityContext().map(KeycloakSecurityContext::getToken);
    }

    private static Optional<KeycloakSecurityContext> getSecurityContext() {
        return Optional.ofNullable(RequestContextHolder.getRequestAttributes()).map(requestAttributes -> (KeycloakSecurityContext)requestAttributes.getAttribute(KeycloakSecurityContext.class.getName(), 0));
    }

    @Generated
    public UsuarioCloudService(UsuarioClient usuarioClient, EntidadeService entidadeService, UsuarioRepository usuarioRepository, ProtocoloConfigService protocoloConfigService) {
        this.usuarioClient = usuarioClient;
        this.entidadeService = entidadeService;
        this.usuarioRepository = usuarioRepository;
        this.protocoloConfigService = protocoloConfigService;
    }
}

