/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.adm.exception.CriacaoNaoPermitidaException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.protocolo.converter.UsuarioAusenciaDTOConverter;
import br.com.elotech.protocolo.domain.UsuarioAusencia;
import br.com.elotech.protocolo.dto.UsuarioAusenciaDTO;
import br.com.elotech.protocolo.repository.UsuarioAusenciaRepository;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class UsuarioAusenciaService
extends CrudService<UsuarioAusencia, Long> {
    @Autowired
    private UsuarioAusenciaRepository repository;

    protected void beforeSave(UsuarioAusencia entity, Authentication authentication) {
        Long id = Optional.ofNullable(entity.getId()).orElse(0L);
        Boolean validDateInicio = this.repository.existsByIdNotAndDataInicioLessThanEqualAndDataTerminoGreaterThanEqualAndUsuarioId(id, entity.getDataInicio(), entity.getDataInicio(), entity.getUsuario().getId());
        Boolean validDateTermino = this.repository.existsByIdNotAndDataInicioLessThanEqualAndDataTerminoGreaterThanEqualAndUsuarioId(id, entity.getDataTermino(), entity.getDataTermino(), entity.getUsuario().getId());
        if (validDateInicio.booleanValue() || validDateTermino.booleanValue()) {
            throw new CriacaoNaoPermitidaException("Aus\u00eancia j\u00e1 cadastrada para data selecionada!");
        }
    }

    public List<UsuarioAusenciaDTO> findAusencias(String usuarioId, LocalDate data) {
        LocalDate paramData = Optional.ofNullable(data).orElse(LocalDate.now());
        return this.repository.findAllByUsuarioAndDate(usuarioId, paramData).stream().map(arg_0 -> ((UsuarioAusenciaDTOConverter)new UsuarioAusenciaDTOConverter()).to(arg_0)).collect(Collectors.toList());
    }
}

