/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.adm.utils.UrlUtils;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.protocolo.domain.Contato;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Pessoa;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.dto.BoletoRequestTributosDTO;
import br.com.elotech.protocolo.dto.BoletoTributosDTO;
import br.com.elotech.protocolo.dto.CadastroAvulsoTributosDTO;
import br.com.elotech.protocolo.dto.DebitoTributosDTO;
import br.com.elotech.protocolo.dto.PessoaDebitoDTO;
import br.com.elotech.protocolo.dto.PessoaTributosDTO;
import br.com.elotech.protocolo.dto.RequisicaoDebitoTributosDTO;
import br.com.elotech.protocolo.dto.TaxaAssuntoTributosDTO;
import br.com.elotech.protocolo.dto.TaxaServicoDTO;
import br.com.elotech.protocolo.exception.UriTributosNaoConfiguradaException;
import br.com.elotech.protocolo.service.EntidadeService;
import br.com.elotech.protocolo.service.ExercicioService;
import br.com.elotech.protocolo.service.ParametroService;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class TributosService {
    private static final Long PRAZO_PAGAMENTO_DEFAULT = 0L;
    private static final String ERRO_CONSULTA_TRIBUTOS = "Erro ao se comunicar com tributos: [{}] ";
    private static final String TRIBUTOS_EXCEPTION_MESSAGE_COMPLEMENT = "Verifique o sistema tribut\u00e1rio para mais informa\u00e7\u00f5es.";
    private static final String URL_INVALIDA_EXCEPTION_MESSAGE = "A URL do sistema tribut\u00e1rio n\u00e3o est\u00e1 configurada corretamente.";
    private static final String URL_NAO_CONFIGURADA_EXCEPTION_MESSAGE = "A URL do sistema tribut\u00e1rio ainda n\u00e3o est\u00e1 configurada.";
    private final Logger logger = LoggerFactory.getLogger(TributosService.class);
    private final RestTemplate restTemplate;
    private final ExercicioService exercicioService;
    private final EntidadeService entidadeService;
    private final ParametroService parametroService;
    @Value(value="${elotech.protocolo.integracao.tributos-ignore:false}")
    private boolean ignoreTributosInt;

    public TributosService(RestTemplateBuilder restTemplateBuilder, ExercicioService exercicioService, EntidadeService entidadeService, ParametroService parametroService) {
        this.restTemplate = restTemplateBuilder.setConnectTimeout(Duration.ofSeconds(5L)).build();
        this.exercicioService = exercicioService;
        this.entidadeService = entidadeService;
        this.parametroService = parametroService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tributosIsUP(String urlTributos) {
        Duration timeOut = Duration.ofSeconds(5L);
        URI uri = URI.create(urlTributos.concat("/actuator/health"));
        HttpClient httpClient = HttpClient.newBuilder().connectTimeout(timeOut).build();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).timeout(timeOut).GET().build();
        try {
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == HttpStatus.OK.value()) {
                this.logger.debug("Resposta actuator/health tributos  {} ", (Object)response.body());
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode root = objectMapper.readTree(response.body());
                boolean bl = "UP".equals(root.get("status").asText());
                return bl;
            }
            this.logger.info("Erro na requisi\u00e7\u00e3o:{} Status:{} Erro:{}", new Object[]{uri.getHost().concat(uri.getPath()), response.statusCode(), response.body()});
        }
        catch (IOException | InterruptedException e) {
            this.logger.error(ERRO_CONSULTA_TRIBUTOS, (Object)e.getMessage(), (Object)e);
        }
        finally {
            httpClient.close();
        }
        return false;
    }

    public boolean integradoTributos() {
        if (this.ignoreTributosInt) {
            return false;
        }
        String urlTributos = "";
        try {
            urlTributos = this.getUrlTributosOrElseThrowUriTributosNaoConfiguradaException();
        }
        catch (UriTributosNaoConfiguradaException ex) {
            this.logger.warn(ex.getMessage(), (Throwable)ex);
            return false;
        }
        return this.tributosIsUP(urlTributos);
    }

    public Boolean possuiDebitosTributario(String cnpjCpf) {
        URI uriRequest = UriComponentsBuilder.fromHttpUrl((String)this.getUrlTributosOrElseThrowUriTributosNaoConfiguradaException()).path("/api/debitos/documento/{documento}").buildAndExpand(new Object[]{cnpjCpf}).toUri();
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
            HttpEntity entity = new HttpEntity((Object)"parameters", (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(uriRequest, HttpMethod.GET, entity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (response.getStatusCode().is2xxSuccessful()) {
                this.logger.debug("Response from server {} ", response.getBody());
                return ((PessoaDebitoDTO)response.getBody()).getPossuiDebitos();
            }
        }
        catch (RestClientException ex) {
            this.logger.error(ERRO_CONSULTA_TRIBUTOS, (Object)ex.getMessage(), (Object)ex);
        }
        return Boolean.FALSE;
    }

    public Optional<CadastroAvulsoTributosDTO> salvarPessoaCadastroAvulsoTributos(PessoaTributosDTO pessoaTributos) {
        URI uriRequest = UriComponentsBuilder.fromHttpUrl((String)this.getUrlTributosOrElseThrowUriTributosNaoConfiguradaException()).path("/api/cadastros-avulso").build().toUri();
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        HttpEntity httpEntity = new HttpEntity((Object)pessoaTributos, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(uriRequest, HttpMethod.POST, httpEntity, CadastroAvulsoTributosDTO.class);
            if (response.getStatusCode().is2xxSuccessful()) {
                return Optional.ofNullable((CadastroAvulsoTributosDTO)response.getBody());
            }
        }
        catch (RestClientException ex) {
            this.logger.error(ERRO_CONSULTA_TRIBUTOS, (Object)ex.getMessage(), (Object)ex);
        }
        return Optional.empty();
    }

    public Pessoa checkPessoaCredentials(Pessoa pessoa) {
        Contato contato = pessoa.getContato();
        if (contato == null) {
            contato = new Contato();
            contato.setCelular("");
            contato.setEmail("");
            pessoa.setContato(contato);
            return pessoa;
        }
        if (contato.getEmail() == null) {
            contato.setEmail("");
        }
        if (contato.getCelular() == null) {
            contato.setCelular("");
        }
        pessoa.setContato(contato);
        return pessoa;
    }

    public Optional<DebitoTributosDTO> gerarDebito(CadastroAvulsoTributosDTO cadastroAvulso, Processo processo, BigDecimal valor, List<TaxaServicoDTO> taxas) {
        TaxaAssuntoTributosDTO taxaAssunto = this.findTaxasByAssunto(processo.getAssunto().getId());
        RequisicaoDebitoTributosDTO requisicaoDebito = new RequisicaoDebitoTributosDTO();
        requisicaoDebito.setCadastroGeral(cadastroAvulso.getCadastroGeral());
        requisicaoDebito.setTipoCadastro(cadastroAvulso.getTipoCadastro());
        requisicaoDebito.setDataLancamento(processo.getDataProcesso());
        requisicaoDebito.setDataVencimento(LocalDate.now().plusDays(Optional.ofNullable(taxaAssunto.getPrazoPagamento()).orElse(PRAZO_PAGAMENTO_DEFAULT)));
        requisicaoDebito.setEntidade(Long.valueOf(1L));
        requisicaoDebito.setExercicio(Long.valueOf(LocalDate.now().getYear()));
        requisicaoDebito.setGuiaRecolhimento(taxaAssunto.getDivida());
        requisicaoDebito.setReceitaLista(taxaAssunto.getReceitaLista(taxas));
        requisicaoDebito.setObservacao(RequisicaoDebitoTributosDTO.montarObservacao((Processo)processo, taxas));
        requisicaoDebito.setTelaOrigemDebito("Protocolo - Taxa processo");
        requisicaoDebito.setValorPrincipal(valor);
        URI uriRequest = UriComponentsBuilder.fromHttpUrl((String)this.getUrlTributosOrElseThrowUriTributosNaoConfiguradaException()).path("/api/debitos").build().toUri();
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        HttpEntity httpEntity = new HttpEntity((Object)requisicaoDebito, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(uriRequest, HttpMethod.POST, httpEntity, DebitoTributosDTO.class);
            if (response.getStatusCode().is2xxSuccessful()) {
                return Optional.ofNullable((DebitoTributosDTO)response.getBody());
            }
        }
        catch (RestException ex) {
            this.logger.error(ERRO_CONSULTA_TRIBUTOS, (Object)ex.getMessage(), (Object)ex);
            throw new RestException(ex.getStatus(), "Houve um problema ao gerar debito no tributos. Verifique o sistema tribut\u00e1rio para mais informa\u00e7\u00f5es.", (Throwable)ex);
        }
        return Optional.empty();
    }

    public Optional<BoletoTributosDTO> gerarBoleto(DebitoTributosDTO debito) {
        BoletoRequestTributosDTO boleto = new BoletoRequestTributosDTO();
        boleto.setIdDebito(debito.getIdDebito());
        boleto.setParcelas(Arrays.asList(1));
        List<BoletoRequestTributosDTO> body = Arrays.asList(boleto);
        URI uriRequest = UriComponentsBuilder.fromHttpUrl((String)this.getUrlTributosOrElseThrowUriTributosNaoConfiguradaException()).path("/api/mobile/bloqueto/gera").build().toUri();
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        HttpEntity httpEntity = new HttpEntity(body, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(uriRequest, HttpMethod.POST, httpEntity, BoletoTributosDTO.class);
            if (response.getStatusCode().is2xxSuccessful()) {
                return Optional.ofNullable((BoletoTributosDTO)response.getBody());
            }
        }
        catch (RestException ex) {
            this.logger.error(ERRO_CONSULTA_TRIBUTOS, (Object)ex.getMessage(), (Object)ex);
            throw new RestException(ex.getStatus(), "Houve um problema ao gerar boleto no tributos. Verifique o sistema tribut\u00e1rio para mais informa\u00e7\u00f5es.", (Throwable)ex);
        }
        return Optional.empty();
    }

    public TaxaAssuntoTributosDTO findTaxasByAssunto(Long assunto) {
        URI uriRequest = UriComponentsBuilder.fromHttpUrl((String)this.getUrlTributosOrElseThrowUriTributosNaoConfiguradaException()).path("/api/tipos-requerimentos/com-taxas/assunto/".concat(assunto.toString())).build().toUri();
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        HttpEntity entity = new HttpEntity((Object)"parameters", (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(uriRequest, HttpMethod.GET, entity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (response.getStatusCode().is2xxSuccessful()) {
                return (TaxaAssuntoTributosDTO)response.getBody();
            }
        }
        catch (RestException ex) {
            this.logger.error(ERRO_CONSULTA_TRIBUTOS, (Object)ex.getMessage(), (Object)ex);
            throw new RestException(ex.getStatus(), "Houve um problema ao carregar as taxas do tributos. Verifique o sistema tribut\u00e1rio para mais informa\u00e7\u00f5es.", (Throwable)ex);
        }
        return null;
    }

    public Optional<PessoaTributosDTO> existsPessoa(String cnpjCpf) {
        URI uriRequest = UriComponentsBuilder.fromHttpUrl((String)this.getUrlTributosOrElseThrowUriTributosNaoConfiguradaException()).path("/api/pessoa").queryParam("cnpjCpf", new Object[]{cnpjCpf}).build().toUri();
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        HttpEntity entity = new HttpEntity((Object)"parameters", (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(uriRequest, HttpMethod.GET, entity, PessoaTributosDTO.class);
            if (response.getStatusCode().is2xxSuccessful()) {
                return Optional.ofNullable((PessoaTributosDTO)response.getBody());
            }
        }
        catch (RestClientException ex) {
            this.logger.error(ERRO_CONSULTA_TRIBUTOS, (Object)ex.getMessage(), (Object)ex);
        }
        return Optional.empty();
    }

    public String getUrlTributosOrElseThrowUriTributosNaoConfiguradaException() {
        String urlTributosDoParametro = this.parametroService.getParamValueAsString(ParametroEnum.URL_TRIBUTOS.getCodigo(), this.entidadeService.getEntidadeLogada(), this.exercicioService.getExercicioAtual());
        if (StringUtils.isBlank((CharSequence)urlTributosDoParametro)) {
            throw new UriTributosNaoConfiguradaException(URL_NAO_CONFIGURADA_EXCEPTION_MESSAGE);
        }
        if (Boolean.FALSE.equals(UrlUtils.isValidUrl((String)urlTributosDoParametro))) {
            throw new UriTributosNaoConfiguradaException(URL_INVALIDA_EXCEPTION_MESSAGE);
        }
        return urlTributosDoParametro;
    }

    public boolean contemUrlDeIntegracaoComTributos() {
        if (this.ignoreTributosInt) {
            return false;
        }
        try {
            return StringUtils.isNotBlank((CharSequence)this.getUrlTributosOrElseThrowUriTributosNaoConfiguradaException());
        }
        catch (UriTributosNaoConfiguradaException ex) {
            this.logger.warn(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }
}

