/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.support.EloInterval;
import br.com.elotech.core.utils.NumberUtils;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Local;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.domain.Situacao;
import br.com.elotech.protocolo.domain.Tramite;
import br.com.elotech.protocolo.domain.TramiteCountProjection;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.dto.Funcao;
import br.com.elotech.protocolo.dto.ParecerAuditDTO;
import br.com.elotech.protocolo.dto.TramiteDTO;
import br.com.elotech.protocolo.dto.TramiteLocalDTO;
import br.com.elotech.protocolo.dto.params.PesquisaTramiteParams;
import br.com.elotech.protocolo.exception.RegistroNaoEncontradoException;
import br.com.elotech.protocolo.repository.TramiteRepository;
import br.com.elotech.protocolo.service.LocalService;
import br.com.elotech.protocolo.service.ProcessoPesquisaService;
import br.com.elotech.protocolo.service.SituacaoService;
import br.com.elotech.protocolo.service.UsuarioService;
import br.com.elotech.protocolo.utils.UsuarioUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TramiteService {
    private final TramiteRepository tramiteRepository;
    private final SituacaoService situacaoService;
    private final ProtocoloMapper mapper;
    private final ProcessoPesquisaService processoPesquisaService;
    private final LocalService localService;
    private final UsuarioService usuarioService;

    public TramiteService(TramiteRepository tramiteRepository, SituacaoService situacaoService, ProtocoloMapper mapper, ProcessoPesquisaService processoPesquisaService, LocalService localService, UsuarioService usuarioService) {
        this.tramiteRepository = tramiteRepository;
        this.situacaoService = situacaoService;
        this.mapper = mapper;
        this.processoPesquisaService = processoPesquisaService;
        this.localService = localService;
        this.usuarioService = usuarioService;
    }

    public OptionalDouble getMediaDiasParadoSetor(Long exercicio, String usuario, Long entidadeId) {
        return this.tramiteRepository.findIntervaloRecebidosAndEncaminhadosByExercicioAndUsuario(exercicio, usuario, entidadeId).stream().map(this.toIntervaloData()).mapToLong(i -> ((LocalDate)i.getInicio()).until((Temporal)i.getFim(), ChronoUnit.DAYS)).average();
    }

    public Long getDiasParadoSetor(List<TramiteDTO> tramitesDto, TramiteDTO currentTramiteDTO) {
        long qtdDias = 0L;
        if (currentTramiteDTO.getFuncao() == null || !currentTramiteDTO.getFuncao().equals((Object)Funcao.ARQUIVADO)) {
            LocalDate dataInicial = currentTramiteDTO.getData();
            LocalDate dataFinal = LocalDate.now();
            Optional<TramiteDTO> nextTramiteDTO = tramitesDto.stream().filter(tramite -> tramite.getSequencia() > currentTramiteDTO.getSequencia() && !Objects.equals(tramite.getLocal(), currentTramiteDTO.getLocal())).min(Comparator.comparingLong(TramiteDTO::getSequencia));
            if (nextTramiteDTO.isPresent()) {
                dataFinal = nextTramiteDTO.get().getData();
            }
            qtdDias = dataInicial.until(dataFinal, ChronoUnit.DAYS);
        }
        return qtdDias;
    }

    private Function<Object[], EloInterval<LocalDate>> toIntervaloData() {
        return from -> {
            LocalDate dataInicio = ((Timestamp)from[0]).toLocalDateTime().toLocalDate();
            LocalDate dataFim = Optional.ofNullable(from[1]).map(i -> ((Timestamp)i).toLocalDateTime().toLocalDate()).orElse(LocalDate.now());
            return new EloInterval((Object)dataInicio, (Object)dataFim);
        };
    }

    public Map<Funcao, Long> findTramitacoesMensal(Entidade entidade, String username, LocalDate dataBase) {
        LocalDate inicio = LocalDate.of(dataBase.getYear(), dataBase.getMonth(), BigDecimal.ONE.intValue());
        EloInterval periodo = new EloInterval((Object)inicio, (Object)dataBase);
        Set tramiteCount = this.tramiteRepository.findTramitacoesByDataAndEntidade((LocalDate)periodo.getInicio(), (LocalDate)periodo.getFim(), entidade, username);
        Map<Funcao, Long> result = tramiteCount.stream().collect(Collectors.groupingBy(TramiteCountProjection::getFuncao, Collectors.summingLong(TramiteCountProjection::getTotal)));
        return this.inicializarFuncoes(result);
    }

    public TramiteDTO initializeTemplate(Funcao funcao, Entidade entidade, Long exercicio) {
        Optional situacao = this.getSituacaoPadrao(funcao, entidade, exercicio);
        if (situacao.isPresent()) {
            return new TramiteDTO(this.mapper.toSituacaoDTO((Situacao)situacao.get()));
        }
        return new TramiteDTO();
    }

    public TramiteDTO updateParecer(PesquisaTramiteParams params, Entidade entidade, String parecer, String usuario) {
        List locais = this.localService.findByUsuario(usuario);
        Processo processo = this.processoPesquisaService.loadProcesso(entidade, params.getTipo(), Long.valueOf(NumberUtils.toLong((String)params.getNumero())), params.getAno());
        Usuario usuarioLogado = (Usuario)this.usuarioService.findById((Serializable)((Object)usuario)).orElseThrow();
        Optional<Tramite> tramite = processo.getTramites().stream().filter(t -> Objects.equals(t.getId().getSequencia(), params.getSequencia())).findFirst();
        if (tramite.isPresent() && this.canUpdateParecer(locais, processo, usuarioLogado)) {
            tramite.get().setParecer(parecer);
            tramite.get().setUsuarioAlteracao(usuario);
            tramite.get().setData(LocalDate.now());
            tramite.get().setHora(LocalTime.now());
            return this.mapper.tramiteToDTO((Tramite)this.tramiteRepository.save((Object)tramite.get()));
        }
        throw new EloValidationException("Sem permiss\u00e3o para editar este parecer.");
    }

    public TramiteDTO updateParecerResposta(Processo processo, TramiteDTO tramiteDTO) {
        Tramite tramite = processo.getTramites().stream().filter(t -> t.getId().getSequencia().equals(tramiteDTO.getSequencia())).findFirst().orElseThrow(() -> new RegistroNaoEncontradoException(String.format("N\u00e3o foi poss\u00edvel encontrar o tramite com sequ\u00eancia %s no processo %s", processo.getId().getNumero(), tramiteDTO.getSequencia())));
        tramite.setParecerResposta(tramiteDTO.getParecerResposta());
        tramite.setDataParecerResposta(LocalDateTime.now().withSecond(0).withNano(0));
        return this.mapper.tramiteToDTO((Tramite)this.tramiteRepository.save((Object)tramite));
    }

    public List<TramiteLocalDTO> getTramitesPorLocalByAno(Long ano, Long entidade) {
        return this.tramiteRepository.findTramitacoesPorLocalByAnoAndEntidade(ano, entidade);
    }

    private boolean canUpdateParecer(List<Local> locais, Processo processo, Usuario usuario) {
        return UsuarioUtils.isAlteraTodosProc((Usuario)usuario, (Processo)processo) != false || locais.contains(processo.getLocalAtual());
    }

    private Optional<Situacao> getSituacaoPadrao(Funcao funcao, Entidade entidade, Long exercicio) {
        if (funcao.permiteSituacaoPadrao()) {
            return this.situacaoService.getSituacaoPadrao(entidade, exercicio);
        }
        return Optional.empty();
    }

    private Map<Funcao, Long> inicializarFuncoes(Map<Funcao, Long> map) {
        Stream.of(Funcao.values()).forEach(f -> map.putIfAbsent((Funcao)f, 0L));
        return map;
    }

    public List<ParecerAuditDTO> listaAlteracaoParecer(Long numero, Long tipo, Long ano, Long sequencia, Long entidade) {
        return this.tramiteRepository.listaAlteracaoParecer(numero, tipo, ano, sequencia, entidade);
    }
}

