/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.fluent.ReportDatasource;
import br.com.elotech.fluent.dataset.loader.DatasetLoaders;
import br.com.elotech.fluent.dataset.loader.ReportDataLoader;
import br.com.elotech.fluent.param.HashMapParamsLoader;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.protocolo.enums.TipoRelatorioTramiteEnum;
import br.com.elotech.protocolo.report.RelatorioProtocolo;
import br.com.elotech.protocolo.repository.ProcessoRepository;
import br.com.elotech.protocolo.web.controller.params.RelatorioTramiteParams;
import br.com.elotech.protocolo.web.controller.params.RelatorioTramitePorLocalParams;
import br.com.elotech.report.EloReportFactory;
import br.com.elotech.report.file.ReportFileResolverFactory;
import java.util.Objects;
import javax.sql.DataSource;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.stereotype.Service;

@Service
public class TramiteRelatorioService {
    public static final String DATASET_CABECALHO = "Cabe\u00e7alho";
    public static final String DATASET_TRAMITE = "TramitacaoDetalhado";
    public static final String DATASET_TRAMITE_RESUMO = "ResumoTramitacaoDetalhado";
    public static final String DATASET_TRAMITE_LOCAL = "TramitacaoPorLocal";
    private static final String TRAMITE = "sql/tramite.sql";
    private static final String TRAMITE_RESUMO = "sql/tramite-agrupado-local-destino.sql";
    private static final String TRAMITE_POR_LOCAL = "sql/tramite-por-local.sql";
    private final DataSource dataSource;
    private final ReportFileResolverFactory reportFileResolverFactory;
    private final ProcessoRepository processoRepository;

    public TramiteRelatorioService(DataSource dataSource, ReportFileResolverFactory reportFileResolverFactor, ProcessoRepository processoRepository) {
        this.dataSource = dataSource;
        this.reportFileResolverFactory = reportFileResolverFactor;
        this.processoRepository = processoRepository;
    }

    public byte[] createTramiteGeralPdfReport(RelatorioTramiteParams params) {
        StringBuilder sql = this.getSqlRelatorioTramitePadrao(params);
        String defaultRpt = RelatorioProtocolo.TRAMITE.getDefaultRpt();
        String nameDataSetCrystal = DATASET_TRAMITE;
        if (TipoRelatorioTramiteEnum.AGRUPADO_LOCAL_DESTINO.getValor().equals(params.getReportOptions())) {
            sql = this.getSqlRelatorioTramiteAgrupado(params);
            defaultRpt = RelatorioProtocolo.TRAMITE_AGRUPADO_LOCAL_DESTINO.getDefaultRpt();
            nameDataSetCrystal = DATASET_TRAMITE_RESUMO;
        }
        ReportDatasource datasource = ReportDatasource.builder().add(DATASET_CABECALHO, () -> this.processoRepository.getCabecalhoEntidade(params.getEntidade(), params.getExercicio())).add(nameDataSetCrystal, (ReportDataLoader)DatasetLoaders.jdbc((String)sql.toString(), (MapSqlParameterSource)params.toJdbcParameters(), (DataSource)this.dataSource)).params((ParamLoader)new HashMapParamsLoader(params.toJdbcParameters().getValues())).build();
        if (Objects.nonNull(params.getExportarExcel()) && params.getExportarExcel().booleanValue()) {
            return EloReportFactory.crystal().reportFile(this.reportFileResolverFactory.fromFile(defaultRpt)).setReportDatasource(datasource).build().exportToCsv();
        }
        return EloReportFactory.crystal().reportFile(this.reportFileResolverFactory.fromFile(defaultRpt)).setReportDatasource(datasource).build().exportToPdf();
    }

    private StringBuilder getSqlRelatorioTramitePadrao(RelatorioTramiteParams params) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)TRAMITE));
        if (params.getLocalBase() > 0L) {
            sql.append(" AND ((SELECT T2.LOCAL      FROM TRAMITACAO T2     WHERE P.TIPO = T2.TIPO       AND P.ANO = T2.ANO       AND P.NUMERO = T2.NUMERO       AND P.ENTIDADE = T2.ENTIDADE       AND T2.FUNCAO <> 'E'       AND T2.SEQUENCIA = (T.SEQUENCIA - 1)) = :localbase ) ");
        }
        sql.append(" ORDER BY LOCAL_BASE, T.LOCAL, P.LOCALDESTINO ");
        return sql;
    }

    private StringBuilder getSqlRelatorioTramiteAgrupado(RelatorioTramiteParams params) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)TRAMITE_RESUMO));
        if (params.getLocalBase() > 0L) {
            sql.append(" AND ((SELECT T2.LOCAL      FROM TRAMITACAO T2     WHERE P.TIPO = T2.TIPO       AND P.ANO = T2.ANO       AND P.NUMERO = T2.NUMERO       AND P.ENTIDADE = T2.ENTIDADE       AND T2.FUNCAO <> 'E'       AND T2.SEQUENCIA = (T.SEQUENCIA - 1)) = :localbase ) ");
        }
        sql.append(" GROUP BY P.ENTIDADE, P.STATUS, P.LOCALDESTINO ORDER BY P.LOCALDESTINO ");
        return sql;
    }

    public byte[] createTramitePorLocalReport(RelatorioTramitePorLocalParams params) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)TRAMITE_POR_LOCAL));
        if (Objects.nonNull(params.getEntidade())) {
            sql.append(" AND P.ENTIDADE = :entidade ");
        }
        if (Objects.nonNull(params.getTipo())) {
            sql.append(" AND P.TIPO = :tipo ");
        }
        if (Objects.nonNull(params.getStatus()) && !params.getStatus().isEmpty()) {
            sql.append(" AND P.STATUS = :status");
        }
        if (Objects.nonNull(params.getAssunto())) {
            sql.append(" AND P.CODASSUNTO = :assunto");
        }
        if (Objects.nonNull(params.getPeriodoProcessoInicial())) {
            sql.append(" AND P.DATAPROCESSO >= :periodoProcessoInicial");
        }
        if (Objects.nonNull(params.getPeriodoProcessoFinal())) {
            sql.append(" AND P.DATAPROCESSO <= :periodoProcessoFinal");
        }
        if (Objects.nonNull(params.getPeriodoTramiteInicial())) {
            sql.append(" AND P.DATA >= :periodoTramiteInicial");
        }
        if (Objects.nonNull(params.getPeriodoTramiteFinal())) {
            sql.append(" AND P.DATA <= :periodoTramiteFinal");
        }
        if (Objects.nonNull(params.getLocalBase())) {
            sql.append(" AND (P.LOCAL_ABERTURA = :localAbertura ").append("   OR (P.CODLOCAL_ATUAL = :localAbertura AND P.CODLOCAL_ATUAL <> P.LOCAL_ABERTURA) ").append("   OR (P.LOCAL_BASE = :localAbertura and P.LOCAL_BASE <> P.LOCAL_ABERTURA)) ");
        }
        sql.append(" ORDER BY P.LOCAL_ABERTURA, P.FUNCAO, P.LOCAL_BASE, P.CODLOCAL_ATUAL ");
        ReportDatasource datasource = ReportDatasource.builder().add(DATASET_CABECALHO, () -> this.processoRepository.getCabecalhoEntidade(params.getEntidade(), params.getExercicio())).add(DATASET_TRAMITE_LOCAL, (ReportDataLoader)DatasetLoaders.jdbc((String)sql.toString(), (MapSqlParameterSource)params.toJdbcParameters(), (DataSource)this.dataSource)).params((ParamLoader)new HashMapParamsLoader(params.toJdbcParameters().getValues())).build();
        if (Objects.nonNull(params.getExportarExcel()) && params.getExportarExcel().booleanValue()) {
            return EloReportFactory.crystal().reportFile(this.reportFileResolverFactory.fromFile(RelatorioProtocolo.TRAMITE_POR_LOCAL.getDefaultRpt())).setReportDatasource(datasource).build().exportToCsv();
        }
        return EloReportFactory.crystal().reportFile(this.reportFileResolverFactory.fromFile(RelatorioProtocolo.TRAMITE_POR_LOCAL.getDefaultRpt())).setReportDatasource(datasource).build().exportToPdf();
    }
}

