/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.adm.service.EntidadeLogadaService;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.outbox.domain.EntityEvent;
import br.com.elotech.outbox.domain.OutboxActions;
import br.com.elotech.outbox.publisher.Publisher;
import br.com.elotech.protocolo.converter.TipoProcessoQueueDTOConverter;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.domain.UsuarioTipoProcesso;
import br.com.elotech.protocolo.dto.TipoProcessoDTO;
import br.com.elotech.protocolo.repository.TipoProcessoEntidadeRepository;
import br.com.elotech.protocolo.repository.TipoProcessoRepository;
import br.com.elotech.protocolo.repository.UsuarioTipoProcessoRepository;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.util.RsqlEntidadeUtil;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class TipoProcessoService
extends CrudService<TipoProcesso, Long> {
    private final UsuarioTipoProcessoRepository usuarioTipoProcessoRepository;
    private final TipoProcessoEntidadeRepository tipoProcessoEntidadeRepository;
    private final EntidadeLogadaService entidadeLogadaService;
    private final ProtocoloMapper protocoloMapper;
    private final Publisher publisher;
    private final ParametroService parametroService;

    @Autowired
    public TipoProcessoService(UsuarioTipoProcessoRepository usuarioTipoProcessoRepository, TipoProcessoEntidadeRepository tipoProcessoEntidadeRepository, EntidadeLogadaService entidadeLogadaService, ProtocoloMapper protocoloMapper, Publisher publisher, ParametroService parametroService) {
        this.usuarioTipoProcessoRepository = usuarioTipoProcessoRepository;
        this.tipoProcessoEntidadeRepository = tipoProcessoEntidadeRepository;
        this.entidadeLogadaService = entidadeLogadaService;
        this.protocoloMapper = protocoloMapper;
        this.publisher = publisher;
        this.parametroService = parametroService;
    }

    public TipoProcessoRepository getRepository() {
        return (TipoProcessoRepository)super.getRepository();
    }

    public Optional<TipoProcesso> getTipoProcessoPrioritarioByUsuario(String usuario) {
        List tiposProcessoUsuario = this.usuarioTipoProcessoRepository.findByIdUsuarioId(usuario);
        return tiposProcessoUsuario.stream().filter(UsuarioTipoProcesso::isPrioritario).map(ut -> ut.getId().getTipoProcesso()).findFirst();
    }

    public List<TipoProcessoDTO> findAllComFiltroDeEntidade(String search, Long entidadeAtual, Pageable pageable) {
        Long entidadeLogada = Optional.ofNullable(entidadeAtual).orElse(this.entidadeLogadaService.getEntidadeLogada());
        List todosTiposProcessoVinculadosAEntidades = this.tipoProcessoEntidadeRepository.findAllTiposProcessoIds();
        List todosTiposProcessoVinculadosAEntidadeLogada = this.tipoProcessoEntidadeRepository.findAllTiposProcessoIdsByEntidadeId(entidadeLogada);
        Object filtroRsql = RsqlEntidadeUtil.montaRsql((List)todosTiposProcessoVinculadosAEntidades, (List)todosTiposProcessoVinculadosAEntidadeLogada, (String)search);
        filtroRsql = (String)filtroRsql + this.getFiltroUsuarioTipoProcesso();
        return this.findByRsql((String)filtroRsql, pageable).getContent().stream().map(arg_0 -> ((ProtocoloMapper)this.protocoloMapper).toTipoProcessoDTO(arg_0)).collect(Collectors.toList());
    }

    private String getFiltroUsuarioTipoProcesso() {
        boolean filtraSomenteTiposPorUsuario = this.parametroService.getParamValueAsBoolean(ParametroEnum.CONTROLA_PERMISSAO_TIPOS_PROCESSO.getCodigo());
        String filtroRsqlUsuario = "";
        boolean isAnonymous = Optional.ofNullable(SecurityContextHolder.getContext()).map(SecurityContext::getAuthentication).map(authentication -> authentication.getAuthorities().stream().map(GrantedAuthority::toString).anyMatch("ROLE_ANONYMOUS"::equals)).orElse(false);
        if (filtraSomenteTiposPorUsuario && !isAnonymous) {
            String userName = SecurityContextHolder.getContext().getAuthentication().getName();
            List listaTpProcessoPorUsuario = this.usuarioTipoProcessoRepository.findByIdUsuarioId(userName);
            String idsTipoVinculado = listaTpProcessoPorUsuario.stream().map(usuarioTipoProcesso -> usuarioTipoProcesso.getId().getTipoProcesso().getId()).map(Object::toString).distinct().collect(Collectors.joining(","));
            if (!listaTpProcessoPorUsuario.isEmpty()) {
                filtroRsqlUsuario = String.format(" and (id=in=(%s))", idsTipoVinculado);
            }
        }
        return filtroRsqlUsuario;
    }

    protected void afterSave(TipoProcesso tipo, Authentication authentication) {
        this.publisher.publish(OutboxActions.CREATED, (EntityEvent)new TipoProcessoQueueDTOConverter().to(tipo));
    }

    protected void afterDelete(TipoProcesso tipo, Authentication authentication) {
        this.publisher.publish(OutboxActions.DELETED, (EntityEvent)new TipoProcessoQueueDTOConverter().to(tipo));
    }

    @Transactional
    public void republish() {
        this.getRepository().findAll().forEach(tipo -> this.publisher.publish(OutboxActions.CREATED, (EntityEvent)new TipoProcessoQueueDTOConverter().to(tipo)));
    }
}

