/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.protocolo.domain.TipoParticipante;
import br.com.elotech.protocolo.repository.TipoParticipanteRepository;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TipoParticipanteService
extends CrudService<TipoParticipante, Long> {
    public TipoParticipanteRepository getRepository() {
        return (TipoParticipanteRepository)super.getRepository();
    }

    @Transactional(readOnly=true)
    public Boolean isDescricaoDuplicada(TipoParticipante tipoComDescricao) {
        return this.getRepository().existsWithOtherIdAndSameDescricao(tipoComDescricao.getId(), tipoComDescricao.getDescricao()) > 0L;
    }

    protected void beforeSave(TipoParticipante entity, Authentication authentication) {
        if (this.isDescricaoDuplicada(entity).booleanValue()) {
            throw new RestException(HttpStatus.BAD_REQUEST, String.format("Existe um Tipo de Participante cadastrado com a mesma descri\u00e7\u00e3o: %s", entity.getDescricao()));
        }
    }
}

