/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.protocolo.conditional.UnicoConditional;
import br.com.elotech.protocolo.exception.UnicoCommunicationFailedException;
import br.com.elotech.protocolo.service.TenantService;
import br.com.elotech.unico.client.EntidadeFeignClient;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Conditional(value={UnicoConditional.class})
@Service
public class TenantUnicoService
implements TenantService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantUnicoService.class);
    private final EntidadeFeignClient entidadeFeignClient;
    @Value(value="${multitenant.enabled:false}")
    private final Boolean multitenant = false;
    @Value(value="${elotech.tenantId:}")
    private String tenantId = "";

    public TenantUnicoService(EntidadeFeignClient entidadeFeignClient) {
        this.entidadeFeignClient = entidadeFeignClient;
    }

    private String getTenantFixoFromUnico() {
        try {
            log.debug("Vai obter tenant do \u00fanico");
            return Optional.ofNullable(this.entidadeFeignClient.getTenantId()).orElse("");
        }
        catch (Exception e) {
            log.error("GetTenantFixoFromUnico", (Throwable)new UnicoCommunicationFailedException(String.format("Erro ao se comunicar com o servidor \u00danico, ou met\u00f3do n\u00e3o encontrado, devido o \u00fanico n\u00e3o estar atualizado.: %s", e.getMessage())));
            return "";
        }
    }

    public String getCurrentTenantId() {
        String tenant;
        if (this.multitenant.booleanValue()) {
            log.debug("Vai obter tenant do ContextHolder pois \u00e9 multitenant");
            tenant = TenantContextHolder.getCurrentTenantId();
        } else {
            log.debug("Como n\u00e3o est\u00e1 configurado multiclient, vai obter tenant da propriedade ou do \u00fanico");
            tenant = StringUtils.isNotBlank((CharSequence)this.tenantId) ? this.tenantId : this.getTenantFixoFromUnico();
        }
        log.debug("Tenant atual: {}", (Object)tenant);
        return tenant;
    }
}

