/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.multitenant.client.TenantClient;
import br.com.elotech.multitenant.domain.Tenant;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TenantHelperService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantHelperService.class);
    private final Optional<TenantClient> tenantClient;

    public TenantHelperService(Optional<TenantClient> tenantClient) {
        this.tenantClient = tenantClient;
    }

    public void executeForAllTenants(Runnable runnable) {
        List<Tenant> tenants;
        try {
            tenants = this.tenantClient.map(client -> client.getAllTenants().stream().filter(t -> StringUtils.isNotBlank((CharSequence)t.getDatabaseUrl())).collect(Collectors.toList())).orElse(Collections.emptyList());
        }
        catch (Exception ex) {
            log.error("Erro ao carregar os tenants", (Throwable)ex);
            throw ex;
        }
        tenants.forEach(tenant -> {
            try {
                TenantContextHolder.setTenant((Tenant)tenant);
                runnable.run();
            }
            catch (Exception ex) {
                log.error("Erro ao realizar a integra\u00e7\u00e3o do Tenant {}", (Object)tenant.getId(), (Object)ex);
            }
            finally {
                TenantContextHolder.resetTenant();
            }
        });
    }
}

