/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.protocolo.domain.SqlModelo;
import br.com.elotech.protocolo.repository.SqlModeloRepository;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SqlModeloService
extends CrudService<SqlModelo, Long> {
    public SqlModeloRepository getCrudRepository() {
        return (SqlModeloRepository)super.getCrudRepository();
    }

    protected void beforeSave(SqlModelo entity, Authentication authentication) {
        if (Boolean.TRUE.equals(this.existsWithOtherIdAndSameDescricao(entity.getId(), entity.getIdentificador()))) {
            throw new EloValidationException("J\u00e1 existe uma Vari\u00e1vel/Sql com o identificador: " + entity.getIdentificador());
        }
        entity.getParametros().forEach(p -> p.setSql(entity));
    }

    @Transactional(readOnly=true)
    public Boolean existsWithOtherIdAndSameDescricao(Long id, String identificador) {
        return this.getCrudRepository().existsWithOtherIdAndSameDescricao(id, identificador);
    }
}

