/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.outbox.domain.EntityEvent;
import br.com.elotech.outbox.domain.OutboxActions;
import br.com.elotech.outbox.publisher.Publisher;
import br.com.elotech.protocolo.converter.SituacaoQueueDTOConverter;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.domain.Situacao;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.dto.SituacaoDTO;
import br.com.elotech.protocolo.exception.ParameterNotFoundException;
import br.com.elotech.protocolo.exception.RegistroNaoEncontradoException;
import br.com.elotech.protocolo.repository.SituacaoRepository;
import br.com.elotech.protocolo.repository.TipoProcessoRepository;
import br.com.elotech.protocolo.service.ParametroService;
import java.util.Objects;
import java.util.Optional;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class SituacaoService
extends CrudService<Situacao, Long> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SituacaoService.class);
    private final ParametroService parametroService;
    private final Publisher publisher;
    private final ProtocoloMapper mapper;
    private final TipoProcessoRepository tipoProcessoRepository;

    @Autowired
    public SituacaoService(ParametroService parametroService, Publisher publisher, ProtocoloMapper mapper, TipoProcessoRepository tipoProcessoRepository) {
        this.parametroService = parametroService;
        this.publisher = publisher;
        this.mapper = mapper;
        this.tipoProcessoRepository = tipoProcessoRepository;
    }

    public SituacaoRepository getRepository() {
        return (SituacaoRepository)super.getRepository();
    }

    public Optional<Situacao> getSituacaoPadrao(Entidade entidade, Long exercicio) {
        Long parametro = this.parametroService.getParamValueAsLong(ParametroEnum.SITUACAO_PADRAO.getCodigo(), entidade.getId(), exercicio);
        if (Objects.isNull(parametro)) {
            LOGGER.warn("Par\u00e2metro {} n\u00e3o est\u00e1 configurado", (Object)ParametroEnum.SITUACAO_PADRAO.getDescricao());
            return Optional.empty();
        }
        return Optional.ofNullable((Situacao)this.getRepository().findOne((Object)parametro));
    }

    public Situacao getSituacaoReaberturaPeloRequerente(Long entidade, Long exercicio) {
        Long parametro = this.parametroService.getParamValueAsLong(ParametroEnum.SITUACAO_REABERTURA_PROCESSO_PELO_REQUERENTE.getCodigo(), entidade, exercicio);
        if (Objects.isNull(parametro)) {
            throw new ParameterNotFoundException("A situa\u00e7\u00e3o de reabertura pelo requerente n\u00e3o foi definida pela entidade.");
        }
        return Optional.ofNullable((Situacao)this.getRepository().findOne((Object)parametro)).orElseThrow(() -> new RegistroNaoEncontradoException("O c\u00f3digo da situa\u00e7\u00e3o de reabertura pelo requerente foi informado incorretamente pela entidade."));
    }

    protected void afterSave(Situacao situacao, Authentication authentication) {
        this.publisher.publish(OutboxActions.CREATED, (EntityEvent)new SituacaoQueueDTOConverter().to(situacao));
    }

    protected void afterDelete(Situacao situacao, Authentication authentication) {
        this.publisher.publish(OutboxActions.DELETED, (EntityEvent)new SituacaoQueueDTOConverter().to(situacao));
    }

    @Transactional
    public void republish() {
        this.getRepository().findAll().forEach(situacao -> this.publisher.publish(OutboxActions.CREATED, (EntityEvent)new SituacaoQueueDTOConverter().to(situacao)));
    }

    public Page<SituacaoDTO> findAll(Long idTipoProcesso, Optional<String> search, Pageable pageable) {
        Object searchFilter = search.get();
        Optional tipoProcesso = this.tipoProcessoRepository.findById((Object)idTipoProcesso);
        if (tipoProcesso.isPresent() && !((TipoProcesso)tipoProcesso.get()).getSituacoes().isEmpty()) {
            searchFilter = (String)searchFilter + " and tipos.id==" + idTipoProcesso;
        }
        return this.findByRsql((String)searchFilter, pageable).map(arg_0 -> ((ProtocoloMapper)this.mapper).toSituacaoDTO(arg_0));
    }
}

