/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.utils.DateUtils;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.service.ParametroService;
import java.util.Date;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service(value="sequenciamentoProcessoService")
public class SequenciamentoProcessoService {
    private static final String START_BY_DATE = "GEN_PROCESSO";
    private static final String START_DEFAULT = "GEN_NUMEROPROCESSO";
    private final ParametroService parametroService;

    public SequenciamentoProcessoService(ParametroService parametroService) {
        this.parametroService = parametroService;
    }

    private boolean isPKValida(ProcessoPK pk) {
        return Objects.nonNull(pk) && Objects.nonNull(pk.getEntidade()) && Objects.nonNull(pk.getEntidade().getId()) && pk.getEntidade().getId() > 0L && Objects.nonNull(pk.getAno()) && pk.getAno() > 0L;
    }

    public String getExpression() {
        return this.getExpression(null);
    }

    public String getExpression(Object entity) {
        ProcessoPK pk = (ProcessoPK)entity;
        boolean pkValida = this.isPKValida(pk);
        Boolean controlaSequenciaPorTipo = pkValida ? this.parametroService.getParamValueAsBoolean(ParametroEnum.NUMERACAO_SEQUENCIA_TIPO, pk.getEntidade(), pk.getAno()) : this.parametroService.getParamValueAsBoolean(ParametroEnum.NUMERACAO_SEQUENCIA_TIPO.getCodigo());
        Boolean controlaSequenciaPorEntidade = pkValida ? this.parametroService.getParamValueAsBoolean(ParametroEnum.NUMERACAO_SEQUENCIA_ENTIDADE, pk.getEntidade(), pk.getAno()) : this.parametroService.getParamValueAsBoolean(ParametroEnum.NUMERACAO_SEQUENCIA_ENTIDADE.getCodigo());
        Boolean controlaSequenciaPorData = pkValida ? this.parametroService.getParamValueAsBoolean(ParametroEnum.NUMERACAO_SEQUENCIA_DATA, pk.getEntidade(), pk.getAno()) : this.parametroService.getParamValueAsBoolean(ParametroEnum.NUMERACAO_SEQUENCIA_DATA.getCodigo());
        StringBuilder sequenceName = new StringBuilder();
        if (Boolean.TRUE.equals(controlaSequenciaPorData)) {
            sequenceName.append(START_BY_DATE).append(String.format("_%s", DateUtils.formatDate((String)"ddMMyyyy", (Date)new Date())));
        } else {
            sequenceName.append(START_DEFAULT);
            if (Boolean.TRUE.equals(controlaSequenciaPorEntidade)) {
                sequenceName.append("_#{entidade.id}");
            }
            sequenceName.append("_#{ano}");
        }
        if (Boolean.TRUE.equals(controlaSequenciaPorTipo)) {
            sequenceName.append("_#{tipo.id}");
        }
        return sequenceName.toString();
    }
}

