/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.domain.Roteiro;
import br.com.elotech.protocolo.domain.RoteiroLocal;
import br.com.elotech.protocolo.dto.RoteiroDTO;
import br.com.elotech.protocolo.repository.RoteiroRepository;
import java.util.ArrayList;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class RoteiroService
extends CrudService<Roteiro, Long> {
    private final RoteiroRepository repository;
    private final ProtocoloMapper mapper;

    public RoteiroService(ProtocoloMapper mapper, RoteiroRepository repository) {
        this.mapper = mapper;
        this.repository = repository;
    }

    public RoteiroDTO save(RoteiroDTO dto, Entidade entidade, Authentication authentication) {
        Roteiro roteiro = this.mapper.toRoteiro(dto);
        roteiro.setEntidade(entidade);
        ArrayList locaisRoteiro = new ArrayList(roteiro.getRoteiroLocal());
        roteiro.setRoteiroLocal(new ArrayList());
        Roteiro saved = (Roteiro)super.save((EloEntity)roteiro, authentication);
        this.getEm().flush();
        this.getEm().clear();
        Long sequencia = 1L;
        for (RoteiroLocal localRoteiro : locaisRoteiro) {
            localRoteiro.setEntidade(roteiro.getEntidade());
            localRoteiro.setRoteiro(saved);
            Long l = sequencia;
            sequencia = sequencia + 1L;
            localRoteiro.setSequencia(l);
        }
        saved.setRoteiroLocal(locaisRoteiro);
        return this.mapper.toRoteiroDTO((Roteiro)super.save((EloEntity)saved, authentication));
    }

    public RoteiroDTO findOne(Long id, Entidade entidade) {
        Roteiro roteiro = this.repository.findByIdAndEntidade(id, entidade);
        return this.mapper.toRoteiroDTO(roteiro);
    }
}

