/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.adm.exception.RegistroNaoEncontradoException;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.Tramite;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.domain.UsuarioLocal;
import br.com.elotech.protocolo.domain.UsuarioLocalPK;
import br.com.elotech.protocolo.dto.ConfigRestricao;
import br.com.elotech.protocolo.dto.Funcao;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.UsuarioService;
import br.com.elotech.protocolo.utils.UsuarioUtils;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class RestricaoService {
    private final ParametroService parametroService;
    private final UsuarioService usuarioService;

    public RestricaoService(ParametroService parametroService, UsuarioService usuarioService) {
        this.parametroService = parametroService;
        this.usuarioService = usuarioService;
    }

    public ConfigRestricao getConfigRestricao() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String userName = authentication.getName();
        Usuario usuario = (Usuario)this.usuarioService.findById((Serializable)((Object)userName)).orElseThrow(() -> new RegistroNaoEncontradoException(Usuario.class, userName));
        Boolean paramBloqueiaPorTipo = this.parametroService.getParamValueAsBoolean(ParametroEnum.CONTROLA_PERMISSAO_TIPOS_PROCESSO.getCodigo());
        Boolean bloqueiaSemNenhumaTramitacaoEmLocalDeAcesso = this.parametroService.getParamValueAsBoolean(ParametroEnum.BLOQUEIA_ACESSO_E_LISTAGEM_PROCESSOS_SEM_TRAMITACOES_EM_LOCAIS_PERMITIDOS.getCodigo());
        Boolean bloqueioPermissaoLocalExcetoTramiteCriacao = this.parametroService.getParamValueAsBoolean(ParametroEnum.BLOQUEIA_ACESSO_MAS_LISTA_SEM_TRAMITACOES_EM_LOCAIS_PERMITIDOS_EXCETO_CRIACAO.getCodigo());
        Boolean liberaDevidoSolicitacaoAssinatura = this.parametroService.getParamValueAsBoolean(ParametroEnum.PERMITE_VISUALIZAR_PROCESSO_SOLICITACAO_ASSINATURA.getCodigo());
        Boolean bloqueiaSemAcessoLocalAtual = this.parametroService.getParamValueAsBoolean(ParametroEnum.BLOQUEIA_ACESSO_E_LISTAGEM_SEM_PERMISSAO_LOCAL_ATUAL.getCodigo());
        Boolean processoSigilosoApenasLocalAtual = this.parametroService.getParamValueAsBoolean(ParametroEnum.PROCESSO_SIGILOSO_APENAS_LOCAL_ATUAL.getCodigo());
        return ConfigRestricao.builder().bloqueiaPorTipo(paramBloqueiaPorTipo).bloqueiaSemNenhumaTramitacaoEmLocalDeAcesso(bloqueiaSemNenhumaTramitacaoEmLocalDeAcesso).bloqueioPermissaoLocalExcetoTramiteCriacao(bloqueioPermissaoLocalExcetoTramiteCriacao).bloqueiaSemAcessoLocalAtual(bloqueiaSemAcessoLocalAtual).liberaDevidoSolicitacaoAssinatura(liberaDevidoSolicitacaoAssinatura).processoSigilosoApenasLocalAtual(processoSigilosoApenasLocalAtual).usuario(usuario).build();
    }

    private Boolean hasPermissionOnCurrentOrNextLocation(Processo processo, Usuario usuario) {
        HashSet locaisFinais = new HashSet();
        Optional.ofNullable(processo.getLocalAtual()).ifPresent(locaisFinais::add);
        Optional.ofNullable(processo.getLocalDestino()).ifPresent(locaisFinais::add);
        processo.getUltimoTramite().map(Tramite::getLocal).ifPresent(locaisFinais::add);
        return usuario.getUsuarioLocal().stream().map(UsuarioLocal::getId).map(UsuarioLocalPK::getLocal).anyMatch(locaisFinais::contains);
    }

    public Boolean podeAcessarProcessoSigiloso(ConfigRestricao configRestricao, Processo processo) {
        return UsuarioUtils.isAlteraTodosProc((Usuario)configRestricao.getUsuario(), (Processo)processo) != false || this.possuiPermissaoLocalTramites(processo, configRestricao) != false || this.isTramiteCreated(processo, configRestricao.getUsuario().getId()) != false;
    }

    private Boolean isTramiteCreated(Processo processo, String username) {
        return processo.getTramites().size() <= 2 && processo.getUsuarioRegistro().equals(username);
    }

    private Boolean possuiPermissaoLocalTramites(Processo processo, ConfigRestricao configRestricao) {
        Boolean permissionOnCurrentOrNextLocation = this.hasPermissionOnCurrentOrNextLocation(processo, configRestricao.getUsuario());
        if (Boolean.TRUE.equals(configRestricao.getProcessoSigilosoApenasLocalAtual())) {
            return permissionOnCurrentOrNextLocation;
        }
        return permissionOnCurrentOrNextLocation != false || this.possuiPermissaoEmPeloMenosUmLocalDosTramites(processo, configRestricao.getUsuario()) != false;
    }

    private Boolean possuiPermissaoEmPeloMenosUmLocalDosTramites(Processo processo, Usuario usuario) {
        Set locaisProcesso = processo.getTramites().stream().filter(t -> !t.getFuncao().equals((Object)Funcao.ABERTO)).map(Tramite::getLocal).collect(Collectors.toSet());
        Set locaisUsuario = usuario.getUsuarioLocal().stream().map(UsuarioLocal::getId).map(UsuarioLocalPK::getLocal).collect(Collectors.toSet());
        return locaisProcesso.stream().anyMatch(locaisUsuario::contains);
    }

    public Boolean bloqueiaVisualizacaoProcesso(ConfigRestricao configRestricao, Processo processo) {
        boolean usuarioAssinante;
        boolean precisaRestringirLocais;
        boolean bloqueiaPorTipo;
        if (Boolean.TRUE.equals(UsuarioUtils.isAlteraTodosProc((Usuario)configRestricao.getUsuario(), (Processo)processo))) {
            return false;
        }
        if (Boolean.TRUE.equals(configRestricao.getBloqueiaPorTipo()) && (bloqueiaPorTipo = configRestricao.getUsuario().getUsuarioTipoProcesso().stream().noneMatch(t -> t.getId().getTipoProcesso().equals((Object)processo.getId().getTipo())))) {
            return true;
        }
        boolean bl = precisaRestringirLocais = configRestricao.getBloqueioPermissaoLocalExcetoTramiteCriacao() != false || configRestricao.getBloqueiaSemNenhumaTramitacaoEmLocalDeAcesso() != false || configRestricao.getBloqueiaSemAcessoLocalAtual() != false;
        if (!precisaRestringirLocais) {
            return false;
        }
        if (Boolean.TRUE.equals(configRestricao.getLiberaDevidoSolicitacaoAssinatura()) && (usuarioAssinante = processo.getArquivos().stream().anyMatch(arquivo -> arquivo.getAssinaturas().stream().anyMatch(assinatura -> configRestricao.getUsuario().equals((Object)assinatura.getUsuario()))))) {
            return false;
        }
        List locaisUsuario = configRestricao.getUsuario().getUsuarioLocal().stream().map(UsuarioLocal::getId).map(UsuarioLocalPK::getLocal).collect(Collectors.toList());
        if (Boolean.TRUE.equals(configRestricao.getBloqueiaSemAcessoLocalAtual())) {
            return locaisUsuario.stream().noneMatch(l -> l.equals((Object)processo.getLocalDestino()));
        }
        List locaisProcesso = Boolean.TRUE.equals(configRestricao.getBloqueioPermissaoLocalExcetoTramiteCriacao()) ? processo.getTramites().stream().filter(t -> !Funcao.ABERTO.equals((Object)t.getFuncao())).map(Tramite::getLocal).collect(Collectors.toList()) : processo.getTramites().stream().map(Tramite::getLocal).collect(Collectors.toList());
        return locaisProcesso.stream().noneMatch(locaisUsuario::contains);
    }

    public Boolean permiteAcessoAoProcesso(ConfigRestricao configRestricao, Processo processo) {
        boolean temBloqueio = processo.getSigiloso() != false && this.podeAcessarProcessoSigiloso(configRestricao, processo) == false || this.bloqueiaVisualizacaoProcesso(configRestricao, processo) != false;
        processo.setPermiteAcessoUsuarioLogado(!temBloqueio);
        return !temBloqueio;
    }
}

