/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.console.client.ConsoleClient;
import br.com.elotech.console.client.config.ConsoleClientConfiguration;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.config.DBConfigConfiguration;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.web.request.ContextHolder;
import br.com.elotech.multitenant.domain.Tenant;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Parametro;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.dto.ConfiguracaoProtocoloDTO;
import br.com.elotech.protocolo.exception.ProtocoloSomenteLeituraException;
import br.com.elotech.protocolo.service.EntidadeService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.TenantService;
import br.com.elotech.protocolo.service.util.ActiveProfileUtils;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;

@Service
@Import(value={DBConfigConfiguration.class, ConsoleClientConfiguration.class})
public class ProtocoloConfigService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProtocoloConfigService.class);
    private static final String NOME_MODULO_OUVIDORIA = "Ouvidoria";
    private static final String NOME_MODULO_PROTOCOLO = "Protocolo";
    public static final String PROTOCOLO_SOMENTE_LEITURA = "PROTOCOLO_SOMENTE_LEITURA";
    public static final String POSSUI_ASSINATURA_CONTRATADA = "POSSUI_ASSINATURA_CONTRATADA";
    public static final String POSSUI_ASSINATURA_CORTESIA = "POSSUI_ASSINATURA_CORTESIA";
    @Value(value="${elotech.unicoParcial:false}")
    private final Boolean unicoParcial = Boolean.FALSE;
    @Value(value="${elotech.notification.enabled:false}")
    private final Boolean notificacaoHabilitada = Boolean.FALSE;
    private final Environment environment;
    private final EntidadeService entidadeService;
    private final ParametroService parametroService;
    private final ConsoleClient consoleClient;
    private final TenantService tenantService;
    private final ThreadLocal<Tenant> tenant = new ThreadLocal();

    public ProtocoloConfigService(Environment environment, EntidadeService entidadeService, ParametroService parametroService, ConsoleClient consoleClient, TenantService tenantService) {
        this.environment = environment;
        this.entidadeService = entidadeService;
        this.parametroService = parametroService;
        this.consoleClient = consoleClient;
        this.tenantService = tenantService;
    }

    private boolean isIntegradoUnicoTotal() {
        return ActiveProfileUtils.isProfileActive((Environment)this.environment, (String)"onpremise") != false || ActiveProfileUtils.isProfileActive((Environment)this.environment, (String)"unico") != false || ActiveProfileUtils.isProfileActive((Environment)this.environment, (String)"cloud") != false;
    }

    private boolean isModoStandalone() {
        return ActiveProfileUtils.isProfileActive((Environment)this.environment, (String)"standalone");
    }

    public boolean isModoCloud() {
        return ActiveProfileUtils.isProfileActive((Environment)this.environment, (String)"cloud");
    }

    public Boolean isUnicoWhathever() {
        return ActiveProfileUtils.isProfileActive((Environment)this.environment, (String)"unico") != false || this.unicoParcial != false;
    }

    public ConfiguracaoProtocoloDTO getConfig(Long idEntidade) {
        Integer entidadeLogada = ContextHolder.getHeaderValueEntidade();
        Optional.ofNullable(RequestContextHolder.getRequestAttributes()).ifPresent(headers -> headers.setAttribute("ENTIDADE", (Object)idEntidade, 0));
        ContextHolder.setKeyValue((String)"ENTIDADE", (String)idEntidade.toString());
        ConfiguracaoProtocoloDTO config = this.getConfig();
        Entidade findEntidade = (Entidade)this.entidadeService.findOne((Serializable)idEntidade);
        Optional.ofNullable(findEntidade).ifPresent(entidade -> {
            config.setEntidade(entidade.getNome());
            config.setIdEntidade(entidade.getId());
        });
        log.debug("Obtida configura\u00e7\u00e3o do protocolo para entidade {}: {}", (Object)idEntidade, (Object)config);
        Optional.ofNullable(RequestContextHolder.getRequestAttributes()).ifPresent(headers -> headers.setAttribute("ENTIDADE", (Object)entidadeLogada, 0));
        ContextHolder.setKeyValue((String)"ENTIDADE", (String)entidadeLogada.toString());
        return config;
    }

    public boolean isEnderecoRequired(Entidade entidade, Long exercicio) {
        return !this.isModoStandalone() || !Boolean.TRUE.equals(this.parametroService.getParamValueAsBoolean(ParametroEnum.NAO_OBRIGA_ENDERECO, entidade, exercicio));
    }

    public boolean isEnderecoRequired() {
        return this.isEnderecoRequired(this.entidadeService.getEntidadeAtual(), Long.valueOf(LocalDate.now().getYear()));
    }

    public ConfiguracaoProtocoloDTO getConfig() {
        ConfiguracaoProtocoloDTO config = new ConfiguracaoProtocoloDTO();
        config.setTenant(this.getCurrentTenantId());
        config.setIsCloud(Boolean.valueOf(this.isModoCloud()));
        this.carregarDadosConsole(config);
        try {
            config.setNotificacaoHabilitada(this.notificacaoHabilitada);
            config.setIsStandalone(Boolean.valueOf(this.isModoStandalone()));
            config.setIntegradoUnico(Boolean.valueOf(this.isIntegradoUnicoTotal()));
            config.setCubejsIp(this.parametroService.getParamValueAsString(ParametroEnum.ENDERECO_IP_CUBEJS.getCodigo()));
            config.setEntidade(Optional.ofNullable(this.entidadeService.getEntidadeAtual()).orElse(new Entidade()).getNome());
            config.setUsaProcessoExterno(this.getParametroUsaProcessoExterno());
            config.setControlaProcessoRequerente(this.getParametroControlaProcessoRequerente());
            config.setNotaExplicativa(this.parametroService.getParamValueAsString(ParametroEnum.NOTA_EXPLICATIVA.getCodigo()));
            config.setUrlOxyCidadao(this.parametroService.getParamValueAsString(ParametroEnum.URL_OXY_CIDADAO.getCodigo()));
            config.setUsaOuvidoria(this.getParametroUsaOuvidoria());
            config.setNomeModulo(this.getNomeModulo());
            config.setUnicoParcial(this.unicoParcial);
            config.setPossuiAssinaturaCortesia(Boolean.valueOf(this.possuiAssinaturaCortesia() != false || this.possuiAssinaturaContratada() != false));
            config.setPossuiAssinaturaContratada(this.possuiAssinaturaContratada());
            config.setProtocoloSomenteLeitura(Boolean.valueOf(this.isProtocoloSomenteLeitura()));
            config.setIsFileCloud(Boolean.valueOf(config.getIsCloud() != false || this.possuiAssinaturaContratada() != false));
            config.setIsProcessoMp(this.parametroService.getParamValueAsBoolean(ParametroEnum.UTILIZA_CRIACAO_PROCESSO_MP.getCodigo()));
            config.setIsSelecionaEntidade(this.parametroService.getParamValueAsBoolean(ParametroEnum.POSSIBILITAR_SELECAO_ENTIDADE_AMBIENTE_EXTERNO.getCodigo()));
            log.debug("Obtida configura\u00e7\u00e3o do protocolo: {}", (Object)config);
            ConfiguracaoProtocoloDTO configuracaoProtocoloDTO = config;
            return configuracaoProtocoloDTO;
        }
        finally {
            this.tenant.remove();
        }
    }

    private Boolean possuiAssinaturaContratada() {
        if (Objects.isNull(((Tenant)this.tenant.get()).getAttributes())) {
            log.debug("N\u00e3o possui configura\u00e7\u00e3o no console para verificar assinatura contratada");
            return Boolean.FALSE;
        }
        String valor = (String)((Tenant)this.tenant.get()).getAttributes().get(POSSUI_ASSINATURA_CONTRATADA);
        Boolean result = this.incluiEntidadeAtual(valor);
        log.debug("Configura\u00e7\u00e3o de assinatura contratada: {}. Assinatura contratada = {}", (Object)valor, (Object)result);
        return result;
    }

    private Boolean possuiAssinaturaCortesia() {
        if (Objects.isNull(((Tenant)this.tenant.get()).getAttributes())) {
            return Boolean.FALSE;
        }
        String valor = (String)((Tenant)this.tenant.get()).getAttributes().get(POSSUI_ASSINATURA_CORTESIA);
        return this.incluiEntidadeAtual(valor);
    }

    private boolean incluiEntidadeAtual(String property) {
        if (StringUtils.isBlank((CharSequence)property)) {
            return false;
        }
        if (property.equalsIgnoreCase(SimNao.SIM.getDescricao())) {
            return true;
        }
        Long entidadeLogada = this.entidadeService.getEntidadeLogada();
        return Pattern.compile(String.format("\\b%d\\b", entidadeLogada)).matcher(property).find();
    }

    private boolean isProtocoloSomenteLeitura() {
        if (Optional.ofNullable((Tenant)this.tenant.get()).map(Tenant::getAttributes).isEmpty()) {
            log.debug("N\u00e3o possui configura\u00e7\u00e3o no console para verificar se \u00e9 somente leitura");
            return false;
        }
        String valor = (String)((Tenant)this.tenant.get()).getAttributes().get(PROTOCOLO_SOMENTE_LEITURA);
        boolean result = this.incluiEntidadeAtual(valor);
        if (result) {
            log.debug("Configura\u00e7\u00e3o de protocolo somente leitura: {}", (Object)valor);
        }
        return result;
    }

    private void carregarDadosConsole(ConfiguracaoProtocoloDTO config) {
        this.tenant.set(new Tenant());
        if (config.getTenant().isBlank()) {
            log.debug("N\u00e3o vai obter dados do console pois o tenant est\u00e1 em branco");
            return;
        }
        try {
            this.consoleClient.getTenantConfig(config.getTenant(), Modulo.OXY_PROCESSOS).ifPresent(this.tenant::set);
            log.debug("Obteve dados do console: {}", (Object)this.tenant);
        }
        catch (Exception e) {
            if (Boolean.TRUE.equals(config.getIsCloud())) {
                log.error("Falha ao obter os dados do console", (Throwable)e);
            }
            log.debug("Falha ao obter os dados do console", (Throwable)e);
        }
    }

    private Boolean getParametroUsaProcessoExterno() {
        return this.isNullOrEmpty(this.parametroService.getByCodigo(ParametroEnum.PROCESSO_EXTERNO_ENTIDADE.getCodigo())) == false;
    }

    private Boolean getParametroControlaProcessoRequerente() {
        return this.parametroService.getParamValueAsBoolean(ParametroEnum.PROCESSO_EXTERNO_AVALIA.getCodigo());
    }

    private Boolean isNullOrEmpty(Parametro parametro) {
        return parametro == null || parametro.getValor() == null || parametro.getValor().isEmpty();
    }

    private String getNomeModulo() {
        Parametro parametro = this.parametroService.getByCodigo(ParametroEnum.MOSTRAR_NOME_MODULO_OUVIDORIA.getCodigo());
        if (parametro != null && SimNao.SIM.getSigla().equals(parametro.getValor())) {
            return NOME_MODULO_OUVIDORIA;
        }
        return NOME_MODULO_PROTOCOLO;
    }

    private Boolean getParametroUsaOuvidoria() {
        return this.isNullOrEmpty(this.parametroService.getByCodigo(ParametroEnum.ENTIDADE_OUVIDORIA.getCodigo())) == false;
    }

    public String getCurrentTenantId() {
        return Optional.ofNullable(this.tenantService.getCurrentTenantId()).orElse("");
    }

    public void throwExceptionIfSomenteLeitura() {
        if (Boolean.TRUE.equals(this.getConfig().getProtocoloSomenteLeitura())) {
            throw new ProtocoloSomenteLeituraException();
        }
    }
}

