/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.dto.Funcao;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.ProcessoService;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class ProcessoValidacaoService {
    private final ProcessoService processoService;
    private final ParametroService parametroService;

    public ProcessoValidacaoService(ProcessoService processoService, ParametroService parametroService) {
        this.processoService = processoService;
        this.parametroService = parametroService;
    }

    public void validarEncaminhamentoProcesso(List<Processo> processos) {
        this.verificarSituacaoPagamentoEmProcessoComTaxa(processos);
        this.throwIfProcessoNaoEncontrado(processos, Funcao.ENCAMINHADO.getStatus());
        Processo processo = processos.get(0);
        if (processo.getAssunto().getControlaTramitacao().booleanValue() && !processo.podeSerTramitado().booleanValue()) {
            throw new RestException(HttpStatus.BAD_REQUEST, "Processo encontra-se no ultimo n\u00edvel de tramita\u00e7\u00e3o, s\u00f3 \u00e9 poss\u00edvel arquiv\u00e1-lo.");
        }
        Boolean possuiParametroBloqueioTramitacao = this.parametroService.getParamValueAsBoolean(ParametroEnum.BLOQUEIA_TRAMITACAO.getCodigo());
        if (processo.getAssunto().getControlaTramitacao().booleanValue() && possuiParametroBloqueioTramitacao.booleanValue()) {
            processo.validarQuantidadeDiasParadoLocalTramite();
        }
    }

    public void validarRecebimentoProcesso(List<Processo> processos) {
        this.verificarSituacaoPagamentoEmProcessoComTaxa(processos);
        this.throwIfProcessoNaoEncontrado(processos, Funcao.RECEBIDO.getStatus());
    }

    public void validarArquivamentoProcesso(List<Processo> processos) {
        this.throwIfProcessoNaoEncontrado(processos, Funcao.ARQUIVADO.getStatus());
        Processo processo = processos.get(0);
        if (processo.getFechado().booleanValue()) {
            throw new RestException(HttpStatus.BAD_REQUEST, "Processo com fechamento completo finalizado. N\u00e3o \u00e9 poss\u00edvel reabrir sem antes desfazer o procedimento");
        }
    }

    public void validarReaberturaProcesso(List<Processo> processos) {
        if (processos.isEmpty()) {
            throw new RestException(HttpStatus.NOT_FOUND, "O processo n\u00e3o foi encontrado, ou n\u00e3o est\u00e1 Arquivado.");
        }
        Processo processo = processos.get(0);
        if (processo.getAssunto().getControlaTramitacao().booleanValue() && !processo.podeSerTramitado().booleanValue()) {
            throw new RestException(HttpStatus.BAD_REQUEST, "N\u00e3o \u00e9 poss\u00edvel reabrir o processo pois o fluxo de tramita\u00e7\u00e3o foi encerrado");
        }
    }

    private void verificarSituacaoPagamentoEmProcessoComTaxa(List<Processo> processos) {
        if (processos.size() == 1 && processos.get(0).getIdProcessoTaxa() != null) {
            this.processoService.verificarStatusPagamento(processos.get(0));
        }
    }

    private void throwIfProcessoNaoEncontrado(List<Processo> processos, Character status) {
        if (processos.isEmpty()) {
            throw new RestException(HttpStatus.NOT_FOUND, String.format("O processo n\u00e3o foi encontrado, ou n\u00e3o est\u00e1 pronto para %S", Funcao.fromStatus((Character)status).getAcao()));
        }
    }

    public void validarTramitacaoProcessoByFuncao(List<Processo> processos, Funcao funcao) {
        switch (funcao.getValue()) {
            case "A": {
                this.validarArquivamentoProcesso(processos);
                break;
            }
            case "E": {
                this.validarEncaminhamentoProcesso(processos);
                break;
            }
            case "R": {
                this.validarRecebimentoProcesso(processos);
                break;
            }
            default: {
                this.validarReaberturaProcesso(processos);
            }
        }
    }
}

