/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.protocolo.domain.Pessoa;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.domain.ProcessoUsuarioView;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.repository.ProcessoRepository;
import br.com.elotech.protocolo.repository.ProcessoUsuarioViewRepository;
import br.com.elotech.protocolo.service.PessoaService;
import br.com.elotech.protocolo.service.UsuarioService;
import java.time.LocalDateTime;
import java.util.UUID;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProcessoUsuarioViewService
extends ReadOnlyService<ProcessoUsuarioView, String> {
    private final UsuarioService usuarioService;
    private final ProcessoUsuarioViewRepository repository;
    private final ProcessoRepository processoRepository;
    private final PessoaService pessoaService;

    public ProcessoUsuarioViewService(UsuarioService usuarioService, ProcessoUsuarioViewRepository repository, ProcessoRepository processoRepository, PessoaService pessoaService) {
        this.usuarioService = usuarioService;
        this.repository = repository;
        this.processoRepository = processoRepository;
        this.pessoaService = pessoaService;
    }

    @Transactional
    public ProcessoUsuarioView save(ProcessoPK pkProcesso) {
        Processo processo = (Processo)this.processoRepository.findOne((Object)pkProcesso);
        if (processo == null) {
            processo = this.processoRepository.findByProcessoByEntidadeTipoNumeroAno(pkProcesso.getEntidade().getId(), pkProcesso.getTipo().getId(), pkProcesso.getNumero(), pkProcesso.getAno());
        }
        ProcessoUsuarioView processoUsuarioView = new ProcessoUsuarioView();
        processoUsuarioView.setId(UUID.randomUUID().toString());
        processoUsuarioView.setProcesso(processo);
        Usuario usuario = this.usuarioService.findUsuarioByName(SecurityContextHolder.getContext().getAuthentication().getName());
        processoUsuarioView.setUsuario(usuario);
        processoUsuarioView.setData(LocalDateTime.now());
        return (ProcessoUsuarioView)this.repository.save((Object)processoUsuarioView);
    }

    @Transactional
    public void saveExterno(Processo processo, String cpf) {
        Usuario usuario = new Usuario();
        usuario.setId("USER_EXTERNO");
        Pessoa pessoa = (Pessoa)this.pessoaService.getPessoaByCnpjCpfOrderById(cpf).stream().sorted((p1, p2) -> Boolean.compare(p2.getAtivo(), p1.getAtivo())).findFirst().get();
        ProcessoUsuarioView view = new ProcessoUsuarioView();
        view.setId(UUID.randomUUID().toString());
        view.setProcesso(processo);
        view.setUsuario(usuario);
        view.setPessoa(pessoa);
        view.setData(LocalDateTime.now());
        this.repository.save((Object)view);
    }

    @Transactional
    public void deleteByProcessoId(ProcessoPK processoId) {
        this.repository.deleteByProcessoId(processoId);
    }
}

