/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.adm.utils.CpfCnpjUtils;
import br.com.elotech.protocolo.exception.TokenException;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.Clock;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.security.interfaces.RSAPublicKey;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.util.JWKSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class ProcessoTokenService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessoTokenService.class);
    private final Map<String, Map<String, Algorithm>> algorithms = new ConcurrentHashMap();
    private final RestTemplate restTemplate;
    private Clock clock;

    @Autowired
    public ProcessoTokenService(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    private DecodedJWT decodeToken(String tokenCidadao) {
        try {
            DecodedJWT decodedTokenCidadao = JWT.decode((String)tokenCidadao);
            Map allVerifiers = this.algorithms.computeIfAbsent(decodedTokenCidadao.getIssuer(), arg_0 -> this.getVerifiersFromIssuer(arg_0));
            Algorithm algorithm = Optional.ofNullable((Algorithm)allVerifiers.get(decodedTokenCidadao.getKeyId())).orElseThrow(() -> new TokenException("O KeyID informado no Token \u00e9 inv\u00e1lido"));
            algorithm.verify(decodedTokenCidadao);
            return this.getVerifier(algorithm).verify(decodedTokenCidadao);
        }
        catch (JWTDecodeException e) {
            throw new TokenException("Formato do Token inv\u00e1lido", (Throwable)e);
        }
        catch (TokenExpiredException e) {
            throw new TokenException("Token expirado", (Throwable)e);
        }
        catch (JWTVerificationException e) {
            throw new TokenException.Fatal("Assinatura do Token inv\u00e1lida", (Throwable)e);
        }
    }

    private JWTVerifier getVerifier(Algorithm algorithm) {
        JWTVerifier.BaseVerification verifier = (JWTVerifier.BaseVerification)JWT.require((Algorithm)algorithm);
        return Objects.nonNull(this.clock) ? verifier.build(this.clock) : verifier.build();
    }

    private void validateIssuer(String issuer) {
        if (StringUtils.isBlank((CharSequence)issuer)) {
            throw new TokenException.Fatal("Issuer em branco");
        }
        if (!issuer.matches("https://[^/]*?.elotech.com.br/.*")) {
            throw new TokenException.Fatal("Token n\u00e3o foi gerado pela Elotech");
        }
    }

    private Map<String, Algorithm> getVerifiersFromIssuer(String issuer) {
        JSONWebKeySet keys;
        this.validateIssuer(issuer);
        String url = String.format("%s/protocol/openid-connect/certs", issuer);
        log.debug("Obtendo certificados da URL {}", (Object)url);
        try {
            keys = (JSONWebKeySet)this.restTemplate.getForEntity(url, JSONWebKeySet.class, new Object[0]).getBody();
        }
        catch (RestClientException e) {
            throw new TokenException(String.format("Falha ao obter certificados do Keycloak pela url %s", url), (Throwable)e);
        }
        if (Objects.isNull(keys)) {
            throw new TokenException("Resposta inv\u00e1lida do Keycloak");
        }
        ConcurrentHashMap<String, Algorithm> result = new ConcurrentHashMap<String, Algorithm>();
        JWKSUtils.getKeysForUse((JSONWebKeySet)keys, (JWK.Use)JWK.Use.SIG).forEach((kid, publicKey) -> result.computeIfAbsent((String)kid, k -> Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)publicKey), null)));
        return result;
    }

    public boolean isTokenCidadaoValid(String tokenCidadao, String cpf) {
        if (StringUtils.isBlank((CharSequence)tokenCidadao) || StringUtils.isBlank((CharSequence)cpf)) {
            log.trace("Token do Cidad\u00e3o ou CPF em branco");
            return false;
        }
        if (!CpfCnpjUtils.isValid((String)cpf)) {
            log.trace("O CPF informado \u00e9 inv\u00e1lido, talvez seja a senha");
            return false;
        }
        String cpfToken = this.getCpfFromToken(tokenCidadao = tokenCidadao.replace("Bearer ", ""));
        if (!cpf.equals(cpfToken)) {
            throw new TokenException("O usu\u00e1rio logado n\u00e3o possui permiss\u00e3o para acessar o processo atrav\u00e9s deste CPF");
        }
        log.debug("Utilizou o token do cidad\u00e3o {} para n\u00e3o precisar da senha", (Object)cpfToken);
        return true;
    }

    private String getCpfFromToken(String tokenCidadao) {
        DecodedJWT decodedTokenCidadao = this.decodeToken(tokenCidadao);
        return Optional.ofNullable(decodedTokenCidadao.getClaim("preferred_username")).map(Claim::asString).orElseThrow(() -> new TokenException("Usu\u00e1rio n\u00e3o informado no token"));
    }

    @Generated
    public void setClock(Clock clock) {
        this.clock = clock;
    }
}

