/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoTaxa;
import br.com.elotech.protocolo.domain.ProcessoTaxaItem;
import br.com.elotech.protocolo.dto.BoletoTributosDTO;
import br.com.elotech.protocolo.dto.CadastroAvulsoTributosDTO;
import br.com.elotech.protocolo.dto.DebitoTributosDTO;
import br.com.elotech.protocolo.dto.IdDebitoDTO;
import br.com.elotech.protocolo.dto.PessoaTributosDTO;
import br.com.elotech.protocolo.dto.StatusPagamentoDebitoEnum;
import br.com.elotech.protocolo.dto.TaxaServicoDTO;
import br.com.elotech.protocolo.dto.params.tributos.RequerimentoSimplificadoDTO;
import br.com.elotech.protocolo.feign.TributosClient;
import br.com.elotech.protocolo.function.PessoaToTributosDTO;
import br.com.elotech.protocolo.repository.ProcessoRepository;
import br.com.elotech.protocolo.repository.ProcessoTaxaRepository;
import br.com.elotech.protocolo.service.TaxaAssuntoService;
import br.com.elotech.protocolo.service.TributosService;
import java.math.BigDecimal;
import java.net.URI;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.transaction.Transactional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class ProcessoTaxaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessoTaxaService.class);
    private final ProcessoTaxaRepository repository;
    private final ProcessoRepository processoRepository;
    private final TaxaAssuntoService taxaAssuntoService;
    private final TributosService tributosService;
    private final TributosClient tributosClient;
    private final RestTemplate restTemplate;

    public BigDecimal getValorTaxas(Processo processo) {
        List taxas = this.taxaAssuntoService.findTaxaAssuntoByAssunto(processo.getAssunto().getId());
        if (taxas.isEmpty()) {
            return BigDecimal.ZERO;
        }
        return taxas.stream().map(TaxaServicoDTO::getValor).filter(Objects::nonNull).reduce(BigDecimal.ZERO, (a, b) -> a.add((BigDecimal)b));
    }

    public Optional<BoletoTributosDTO> gerarTaxaPagamento(Processo processo, List<TaxaServicoDTO> taxas) {
        Optional boletoGerado;
        Optional cadastroGeral;
        if (!this.tributosService.integradoTributos()) {
            return Optional.empty();
        }
        ProcessoTaxa processoTaxa = new ProcessoTaxa();
        List taxasTributos = this.taxaAssuntoService.findTaxaAssuntoByAssunto(processo.getAssunto().getId());
        List taxasItens = this.validarTaxasItens(taxasTributos, taxas);
        processoTaxa.setItens(taxasItens);
        ProcessoTaxa processoTaxaSaved = (ProcessoTaxa)this.repository.saveAndFlush((Object)processoTaxa);
        processo.setIdProcessoTaxa(processoTaxaSaved.getId());
        this.processoRepository.saveAndFlush((Object)processo);
        PessoaTributosDTO pessoaTributos = new PessoaToTributosDTO().apply(processo.getPessoa());
        if (Boolean.TRUE.equals(processo.getExterno())) {
            pessoaTributos = PessoaTributosDTO.byProcessoExterno((Processo)processo);
        }
        if (!(cadastroGeral = this.tributosService.salvarPessoaCadastroAvulsoTributos(pessoaTributos)).isPresent()) {
            throw new IllegalStateException("N\u00e3o foi poss\u00edvel cadastrar a pessoa no sistema tribut\u00e1rio");
        }
        Optional debitoGerado = this.validarExistenciaDebito(processo.getIdProcessoTaxa());
        if (!debitoGerado.isPresent()) {
            debitoGerado = this.gerarDebito(processo, taxas, cadastroGeral, taxasItens);
            processoTaxaSaved.setIdDebito(((DebitoTributosDTO)debitoGerado.orElseThrow(() -> new IllegalStateException("N\u00e3o foi poss\u00edvel gerar o debito no sistema tribut\u00e1rio"))).getIdDebito());
            this.repository.saveAndFlush((Object)processoTaxaSaved);
        }
        if ((boletoGerado = this.tributosService.gerarBoleto((DebitoTributosDTO)debitoGerado.orElseThrow(() -> new IllegalStateException("N\u00e3o foi poss\u00edvel encontrar o debito gerado no sistema tribut\u00e1rio")))).isPresent()) {
            BoletoTributosDTO boleto = (BoletoTributosDTO)boletoGerado.get();
            processoTaxaSaved.setDataVencimento(boleto.getDataVencimento());
            processoTaxaSaved.setIdBoleto(boleto.getId());
            processoTaxaSaved.setUrlBoleto(boleto.getUrlImpressao());
            this.repository.saveAndFlush((Object)processoTaxaSaved);
        }
        return boletoGerado;
    }

    private List<ProcessoTaxaItem> validarTaxasItens(List<TaxaServicoDTO> taxasTributos, List<TaxaServicoDTO> taxas) {
        ArrayList<ProcessoTaxaItem> taxasItens = new ArrayList<ProcessoTaxaItem>();
        taxas.stream().forEach(taxa -> {
            TaxaServicoDTO taxaExistenteTributos = taxasTributos.stream().filter(taxaTributos -> taxaTributos.equals(taxa)).findFirst().orElseThrow(() -> new RestException(HttpStatus.BAD_REQUEST, String.format("Taxa: %s n\u00e3o encontrada no sistema tributos.", taxa.getDescricao())));
            if (!taxa.isQuantidadeValida(taxaExistenteTributos).booleanValue()) {
                throw new RestException(HttpStatus.BAD_REQUEST, String.format("Taxa: %s deve possu\u00edr no m\u00ednimo: %.2f itens.", taxa.getDescricao(), taxaExistenteTributos.getQuantidade()));
            }
            taxasItens.add(new ProcessoTaxaItem(taxa.getQuantidade(), taxaExistenteTributos.getQuantidade(), taxa.getId(), taxaExistenteTributos.getValor(), taxaExistenteTributos.getDescricao()));
        });
        return taxasItens;
    }

    public Optional<DebitoTributosDTO> gerarDebito(Processo processo, List<TaxaServicoDTO> taxas, Optional<CadastroAvulsoTributosDTO> cadastroGeral, List<ProcessoTaxaItem> taxasItens) {
        BigDecimal valorTaxas = taxasItens.stream().map(taxaObject -> taxaObject.getQuantidade().multiply(taxaObject.getValor())).reduce((x, y) -> x.add((BigDecimal)y)).orElse(BigDecimal.ZERO);
        if (valorTaxas.compareTo(BigDecimal.ZERO) <= 0) {
            throw new IllegalStateException("N\u00e3o \u00e9 poss\u00edvel gerar boleto para um taxa zerada");
        }
        Optional debitoGerado = this.tributosService.gerarDebito((CadastroAvulsoTributosDTO)cadastroGeral.orElse(null), processo, valorTaxas, taxas);
        if (!debitoGerado.isPresent()) {
            throw new IllegalStateException("N\u00e3o foi poss\u00edvel gerar o d\u00e9bito no sistema tribut\u00e1rio");
        }
        return debitoGerado;
    }

    @Transactional
    public Optional<BoletoTributosDTO> gerarBoleto(ProcessoTaxa processoTaxa, LocalDate dataAtual) {
        if (!this.tributosService.integradoTributos()) {
            return Optional.empty();
        }
        Optional boletoGerado = this.validarGerarBoleto(processoTaxa, dataAtual);
        if (!boletoGerado.isPresent()) {
            DebitoTributosDTO debito = new DebitoTributosDTO();
            debito.setIdDebito(processoTaxa.getIdDebito());
            boletoGerado = this.tributosService.gerarBoleto(debito);
            processoTaxa.atualizarProcessoTaxa((BoletoTributosDTO)boletoGerado.orElse(null));
        }
        return boletoGerado;
    }

    public StatusPagamentoDebitoEnum verificarStatusPagamento(Processo processo) {
        if (Objects.nonNull(processo.getRequerimentoTributos())) {
            return this.verificarStatusPagamentoRequerimento(processo);
        }
        if (!this.tributosService.integradoTributos() || processo.getIdProcessoTaxa() == null) {
            return StatusPagamentoDebitoEnum.DESCONHECIDO;
        }
        ProcessoTaxa taxa = (ProcessoTaxa)this.repository.findOne((Object)processo.getIdProcessoTaxa());
        if (taxa != null && taxa.getIdDebito() != null) {
            URI uriRequest = this.uriTributosBuilder();
            try {
                List debitos = this.verificaStatusDebitoTributos(Arrays.asList(new IdDebitoDTO(taxa.getIdDebito())), uriRequest);
                if (!debitos.isEmpty()) {
                    return StatusPagamentoDebitoEnum.PAGAMENTO_REALIZADO;
                }
            }
            catch (HttpServerErrorException e) {
                return StatusPagamentoDebitoEnum.DESCONHECIDO;
            }
        }
        return StatusPagamentoDebitoEnum.PAGAMENTO_NAO_REALIZADO;
    }

    public Optional<DebitoTributosDTO> validarExistenciaDebito(Long idProcessoTaxa) {
        if (idProcessoTaxa == null) {
            return Optional.empty();
        }
        Optional processoTaxa = this.repository.findById((Object)idProcessoTaxa);
        if (processoTaxa.isPresent() && ((ProcessoTaxa)processoTaxa.get()).getIdDebito() != null) {
            DebitoTributosDTO debito = new DebitoTributosDTO();
            debito.setIdDebito(((ProcessoTaxa)processoTaxa.get()).getIdDebito());
            return Optional.of(debito);
        }
        return Optional.empty();
    }

    public Optional<BoletoTributosDTO> validarGerarBoleto(ProcessoTaxa processoTaxa, LocalDate dataAtual) {
        if (processoTaxa != null && processoTaxa.getIdBoleto() != null && processoTaxa.getDataVencimento().isAfter(dataAtual)) {
            BoletoTributosDTO boleto = new BoletoTributosDTO();
            boleto.setId(processoTaxa.getIdBoleto());
            boleto.setUrlImpressao(processoTaxa.getUrlBoleto());
            boleto.setDataVencimento(processoTaxa.getDataVencimento());
            return Optional.of(boleto);
        }
        return Optional.empty();
    }

    public List<IdDebitoDTO> verificaStatusDebitoTributos(List<IdDebitoDTO> debitos, URI uriRequest) {
        return (List)this.restTemplate.exchange(uriRequest, HttpMethod.POST, new HttpEntity(debitos), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).getBody();
    }

    public URI uriTributosBuilder() {
        return UriComponentsBuilder.fromHttpUrl((String)this.tributosService.getUrlTributosOrElseThrowUriTributosNaoConfiguradaException()).path("/api/debitos/verificar-pagos").build().toUri();
    }

    public ProcessoTaxa findOne(Long id) {
        return (ProcessoTaxa)this.repository.findOne((Object)id);
    }

    public StatusPagamentoDebitoEnum verificarStatusPagamentoRequerimento(Processo processo) {
        try {
            RequerimentoSimplificadoDTO requerimento = this.tributosClient.getRequerimentoSimplificado(processo.getEntidadeId(), processo.getAno(), processo.getRequerimentoTributos());
            if (Objects.isNull(requerimento.getBoleto())) {
                return StatusPagamentoDebitoEnum.DESCONHECIDO;
            }
            if (Boolean.TRUE.equals(requerimento.getBoleto().getPago())) {
                return StatusPagamentoDebitoEnum.PAGAMENTO_REALIZADO;
            }
            return StatusPagamentoDebitoEnum.PAGAMENTO_NAO_REALIZADO;
        }
        catch (Exception e) {
            return StatusPagamentoDebitoEnum.DESCONHECIDO;
        }
    }

    @Generated
    public ProcessoTaxaService(ProcessoTaxaRepository repository, ProcessoRepository processoRepository, TaxaAssuntoService taxaAssuntoService, TributosService tributosService, TributosClient tributosClient, RestTemplate restTemplate) {
        this.repository = repository;
        this.processoRepository = processoRepository;
        this.taxaAssuntoService = taxaAssuntoService;
        this.tributosService = tributosService;
        this.tributosClient = tributosClient;
        this.restTemplate = restTemplate;
    }
}

