/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.protocolo.dto.IdDebitoDTO;
import br.com.elotech.protocolo.repository.ProcessoRepository;
import br.com.elotech.protocolo.service.EntidadeService;
import br.com.elotech.protocolo.service.ProcessoTaxaService;
import br.com.elotech.protocolo.service.TributosService;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.HttpServerErrorException;

@Service
public class ProcessoTaxaPagamentoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessoTaxaPagamentoService.class);
    private final ProcessoRepository processoRepository;
    private final EntidadeService entidadeService;
    private final ProcessoTaxaService processoTaxaService;
    private final TributosService tributosService;
    @Value(value="${schedulerTributos.quantidadeMesesAnteriores}")
    private long dataInicialProcessos;

    public ProcessoTaxaPagamentoService(ProcessoRepository processoRepository, EntidadeService entidadeService, ProcessoTaxaService processoTaxaService, TributosService tributosService) {
        this.processoRepository = processoRepository;
        this.entidadeService = entidadeService;
        this.processoTaxaService = processoTaxaService;
        this.tributosService = tributosService;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void atualizaStatusPagamentoProcesso(Long meses) {
        log.info("Integra\u00e7\u00e3o com as taxas - ProcessoTaxaPagamentoService.");
        if (!this.tributosService.integradoTributos()) {
            return;
        }
        meses = Objects.requireNonNullElse(meses, this.dataInicialProcessos);
        Date dataInicial = Date.valueOf(LocalDate.now().minusMonths(meses));
        List processos = this.processoRepository.findAllProcessosComDebitosNaoPago(this.entidadeService.getEntidadeAtual().getId(), dataInicial);
        try {
            log.info("Iniciando integra\u00e7\u00e3o com o Tribut\u00e1rio -  ProcessoTaxaPagamentoService. Qtd. Processos {} ", (Object)processos.size());
            List debitosPago = this.processoTaxaService.verificaStatusDebitoTributos(processos.stream().map(processo -> new IdDebitoDTO(processo.getIdDebitoDTO())).collect(Collectors.toList()), this.processoTaxaService.uriTributosBuilder());
            for (IdDebitoDTO debito : debitosPago) {
                processos.stream().filter(processoTaxa -> Objects.equals(processoTaxa.getIdDebitoDTO(), debito.getIdDebito())).findFirst().filter(processoTaxa -> processoTaxa.getBoletoPago() == false).ifPresent(processoTaxa -> this.processoRepository.atualizaStatusBoletoParaPago(processoTaxa.getTipo(), processoTaxa.getAno(), processoTaxa.getNumero(), processoTaxa.getEntidade()));
            }
            log.info("Integra\u00e7\u00e3o com o tributos conclu\u00edda com sucesso!");
        }
        catch (HttpServerErrorException e) {
            log.error("Erro na integra\u00e7\u00e3o com o Tribut\u00e1rio. {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

