/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.adm.exception.RegistroNaoEncontradoException;
import br.com.elotech.adm.utils.HtmlUtils;
import br.com.elotech.adm.utils.SequenceUtils;
import br.com.elotech.client.painel.feign.NotificationFeign;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.core.validation.EloViolation;
import br.com.elotech.core.web.request.ContextHolder;
import br.com.elotech.lib.painel.dto.DataNotificationDTO;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.outbox.domain.OutboxActions;
import br.com.elotech.protocolo.config.PessoaClientUnico;
import br.com.elotech.protocolo.config.SecurityUtils;
import br.com.elotech.protocolo.converter.LocalDTOConverter;
import br.com.elotech.protocolo.domain.Assunto;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoAnexo;
import br.com.elotech.protocolo.domain.ProcessoArquivo;
import br.com.elotech.protocolo.domain.ProcessoArquivoPK;
import br.com.elotech.protocolo.domain.ProcessoAssinaturaConfig;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.domain.Situacao;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.domain.Tramite;
import br.com.elotech.protocolo.domain.TramitePK;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.dto.AssuntoDTO;
import br.com.elotech.protocolo.dto.AvaliacaoProcessoDTO;
import br.com.elotech.protocolo.dto.EntidadeDTO;
import br.com.elotech.protocolo.dto.Funcao;
import br.com.elotech.protocolo.dto.LocalDTO;
import br.com.elotech.protocolo.dto.PessoaDTO;
import br.com.elotech.protocolo.dto.PessoaTributosDTO;
import br.com.elotech.protocolo.dto.ProcessoAssuntoDTO;
import br.com.elotech.protocolo.dto.ProcessoContagemMesAnoDTO;
import br.com.elotech.protocolo.dto.ProcessoDTO;
import br.com.elotech.protocolo.dto.ProcessoIntegracaoDTO;
import br.com.elotech.protocolo.dto.ProcessoPKDTO;
import br.com.elotech.protocolo.dto.ProcessoReferenciaDTO;
import br.com.elotech.protocolo.dto.RequerimentoObservacaoProcessoAuditDTO;
import br.com.elotech.protocolo.dto.SituacaoDTO;
import br.com.elotech.protocolo.dto.StatusPagamentoDebitoEnum;
import br.com.elotech.protocolo.dto.TipoProcessoSimpleDTO;
import br.com.elotech.protocolo.dto.TramiteProcessosWrapper;
import br.com.elotech.protocolo.dto.params.PesquisaProcessoParams;
import br.com.elotech.protocolo.enums.StatusAgrupamento;
import br.com.elotech.protocolo.enums.TipoPapeletaProcessoEnum;
import br.com.elotech.protocolo.exception.ReaberturaNaoPermitidaException;
import br.com.elotech.protocolo.function.PessoaToTributosDTO;
import br.com.elotech.protocolo.function.ProcessoAnexoPkToProcessoPK;
import br.com.elotech.protocolo.mail.exception.SendMailException;
import br.com.elotech.protocolo.mail.senders.impl.ProcessoEmailSender;
import br.com.elotech.protocolo.mail.senders.impl.TramiteEmailSender;
import br.com.elotech.protocolo.mp.domain.DadosProcessoMP;
import br.com.elotech.protocolo.repository.ProcessoRepository;
import br.com.elotech.protocolo.repository.TramiteRepository;
import br.com.elotech.protocolo.repository.impl.ProcessoRepositoryImpl;
import br.com.elotech.protocolo.service.EntidadeService;
import br.com.elotech.protocolo.service.ExercicioService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.PessoaService;
import br.com.elotech.protocolo.service.ProcessoAnexoService;
import br.com.elotech.protocolo.service.ProcessoArquivoService;
import br.com.elotech.protocolo.service.ProcessoAssinaturaConfigService;
import br.com.elotech.protocolo.service.ProcessoInitializerService;
import br.com.elotech.protocolo.service.ProcessoIntegracaoService;
import br.com.elotech.protocolo.service.ProcessoObservadorExternoService;
import br.com.elotech.protocolo.service.ProcessoPesquisaService;
import br.com.elotech.protocolo.service.ProcessoRelatorioService;
import br.com.elotech.protocolo.service.ProcessoTaxaService;
import br.com.elotech.protocolo.service.ProtocoloConfigService;
import br.com.elotech.protocolo.service.SequenciamentoProcessoService;
import br.com.elotech.protocolo.service.SituacaoService;
import br.com.elotech.protocolo.service.TributosService;
import br.com.elotech.protocolo.service.UsuarioService;
import br.com.elotech.protocolo.service.assinatura.AssinaturaIntegracaoService;
import br.com.elotech.protocolo.service.util.ProcessoReferenciaDTOBuilder;
import br.com.elotech.protocolo.specs.ProcessoSpecificationHelper;
import br.com.elotech.protocolo.strategy.SalvaProcessoStrategy;
import br.com.elotech.protocolo.strategy.TramiteBusinessStrategy;
import br.com.elotech.protocolo.strategy.impl.processo.SalvaProcessoStrategyFactory;
import br.com.elotech.protocolo.strategy.impl.tramite.TramiteStrategyFactory;
import br.com.elotech.protocolo.utils.ByteMultipartFile;
import br.com.elotech.protocolo.web.controller.params.RelatorioContagemMesAnoParams;
import br.com.elotech.unico.exception.UnicoClientException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import feign.FeignException;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@Service
public class ProcessoService
extends CrudService<Processo, ProcessoPK> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessoService.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessoService.class);
    private static final int NUMERO_ATRIBUTOS_PK = 3;
    public static final String PDF = "pdf";
    private final ProcessoAnexoService processoAnexoService;
    private final ProcessoAssinaturaConfigService processoAssinaturaConfigService;
    private final ProcessoInitializerService processoInitializer;
    private final ProcessoEmailSender processoEmailSender;
    private final TramiteEmailSender tramiteEmailSender;
    private final ProtocoloMapper mapper;
    private final PessoaService pessoaService;
    private final ParametroService parametroService;
    private final EntidadeService entidadeService;
    private final ExercicioService exercicioService;
    private final ProcessoTaxaService processoTaxaService;
    private final EntityManager entityManager;
    private final Optional<PessoaClientUnico> pessoaClient;
    private final SituacaoService situacaoService;
    private final ProcessoIntegracaoService processoIntegracaoService;
    private final ProcessoRelatorioService relatorioService;
    private final ProcessoArquivoService arquivoService;
    private final TributosService tributosService;
    @Autowired
    private final UsuarioService usuarioService;
    private final TramiteRepository tramiteRepository;
    private final ProcessoPesquisaService processoPesquisaService;
    private final SequenciamentoProcessoService sequenciamentoProcessoService;
    private final ProcessoRepositoryImpl processoRepositoryImpl;
    private final ProcessoObservadorExternoService processoObservadorExternoService;
    private final SequenceUtils sequenceUtils;
    private final AssinaturaIntegracaoService assinaturaIntegracaoService;
    private final NotificationFeign notificationFeign;
    private final ProtocoloConfigService protocoloConfigService;

    public ProcessoService(ProcessoAnexoService processoAnexoService, ProcessoAssinaturaConfigService processoAssinaturaConfigService, ProcessoInitializerService processoInitializer, ProcessoEmailSender processoEmailSender, TramiteEmailSender tramiteEmailSender, ProtocoloMapper mapper, UsuarioService usuarioService, PessoaService pessoaService, ParametroService parametroService, EntidadeService entidadeService, ExercicioService exercicioService, Optional<PessoaClientUnico> pessoaClient, ProcessoTaxaService processoTaxaService, TramiteRepository tramiteRepository, EntityManager entityManager, SituacaoService situacaoService, ProcessoIntegracaoService processoIntegracaoService, ProcessoRelatorioService relatorioService, ProcessoArquivoService arquivoService, TributosService tributosService, ProcessoPesquisaService processoPesquisaService, SequenciamentoProcessoService sequenciamentoProcessoService, ProcessoRepositoryImpl processoRepositoryImpl, ProcessoObservadorExternoService processoObservadorExternoService, SequenceUtils sequenceUtils, @Lazy AssinaturaIntegracaoService assinaturaIntegracaoService, NotificationFeign notificationFeign, ProtocoloConfigService protocoloConfigService) {
        this.processoAnexoService = processoAnexoService;
        this.processoAssinaturaConfigService = processoAssinaturaConfigService;
        this.processoInitializer = processoInitializer;
        this.processoEmailSender = processoEmailSender;
        this.tramiteEmailSender = tramiteEmailSender;
        this.mapper = mapper;
        this.usuarioService = usuarioService;
        this.pessoaService = pessoaService;
        this.parametroService = parametroService;
        this.entidadeService = entidadeService;
        this.exercicioService = exercicioService;
        this.pessoaClient = pessoaClient;
        this.processoTaxaService = processoTaxaService;
        this.tramiteRepository = tramiteRepository;
        this.entityManager = entityManager;
        this.situacaoService = situacaoService;
        this.processoIntegracaoService = processoIntegracaoService;
        this.relatorioService = relatorioService;
        this.arquivoService = arquivoService;
        this.tributosService = tributosService;
        this.processoPesquisaService = processoPesquisaService;
        this.sequenciamentoProcessoService = sequenciamentoProcessoService;
        this.processoRepositoryImpl = processoRepositoryImpl;
        this.processoObservadorExternoService = processoObservadorExternoService;
        this.sequenceUtils = sequenceUtils;
        this.assinaturaIntegracaoService = assinaturaIntegracaoService;
        this.notificationFeign = notificationFeign;
        this.protocoloConfigService = protocoloConfigService;
    }

    public ProcessoRepository getRepository() {
        return (ProcessoRepository)super.getRepository();
    }

    protected void beforeInsert(Processo processo) {
        this.protocoloConfigService.throwExceptionIfSomenteLeitura();
        this.verificaSeJaExisteProcessoComEsseAnoTipoIdENumero(processo);
        this.atualizarSequenceProcesso(processo);
        processo.getInteressados().forEach(interessado -> interessado.getId().setProcessoPK(processo.getId()));
        super.beforeInsert((EloEntity)processo);
        processo.atualizarDatasOrigemDestino().tramitarAbertura().gerarSenha();
    }

    protected void beforeEdit(Processo processo) {
        processo.atualizarTramites();
        processo.setProcessoMp((DadosProcessoMP)Optional.ofNullable(processo.getProcessoMp()).map(arg_0 -> ((EntityManager)this.entityManager).merge(arg_0)).orElse(null));
        this.protocoloConfigService.throwExceptionIfSomenteLeitura();
    }

    @Transactional
    public Processo save(Processo processo, Authentication auth) {
        if (processo.getUuid() == null) {
            processo.setUuid(UUID.randomUUID().toString());
        }
        if (Objects.nonNull(auth)) {
            processo.setUsuarioAlteracao(auth.getName());
            if (processo.isNew()) {
                processo.setUsuarioRegistro(auth.getName());
            }
        }
        return (Processo)super.save((EloEntity)processo, auth);
    }

    protected void afterSave(Processo processo, Authentication authentication) {
        if (this.tributosService.integradoTributos()) {
            PessoaTributosDTO pessoaTributos = new PessoaToTributosDTO().apply(processo.getPessoa());
            this.tributosService.salvarPessoaCadastroAvulsoTributos(pessoaTributos);
        }
        this.processoIntegracaoService.salvarProcessoIntegracao(processo);
        Tramite ultimoTramite = (Tramite)processo.getUltimoTramite().orElseThrow(() -> new IllegalStateException(String.format("O processo %s n\u00e3o possui \u00faltimo tr\u00e2mite", processo.getId())));
        try {
            if (Boolean.FALSE.equals(processo.isOuvidoriaAnonima())) {
                this.tramiteEmailSender.enviarEmailTramite(ultimoTramite);
            }
            this.processoObservadorExternoService.sendEmailWithAndamento(processo);
        }
        catch (SendMailException e) {
            LOGGER.warn("Falha ao enviar e-mail do tr\u00e2mite ou andamento", (Throwable)e);
            this.sendEmailErrorsNotification(processo);
        }
        this.publicarSituacaoArquivosIntegrados(processo);
        super.afterSave((EloEntity)processo, authentication);
    }

    protected boolean shouldRefreshAfterSave() {
        return true;
    }

    private void publicarSituacaoArquivosIntegrados(Processo processo) {
        processo.getArquivos().forEach(processoArquivo -> this.assinaturaIntegracaoService.publicarAtualizacaoArquivo(processoArquivo, OutboxActions.UPDATED));
    }

    private void sendEmailErrorsNotification(Processo processo) {
        String processoNumero = String.format("%d-%d/%d", processo.getId().getTipo().getId(), processo.getId().getNumero(), processo.getId().getAno());
        DataNotificationDTO dataNotificationDTO = new DataNotificationDTO();
        dataNotificationDTO.setMessage("Verifique suas configura\u00e7\u00f5es de email.");
        dataNotificationDTO.setMessageDetail(String.format("O Processo %s foi salvo com sucesso. No entanto, n\u00e3o foi poss\u00edvel enviar os avisos por email devido \u00e0 erros inesperados. Por favor, verifique suas configura\u00e7\u00f5es de email.", processoNumero));
        dataNotificationDTO.setModulo(Modulo.OXY_PROCESSOS);
        dataNotificationDTO.setStatus(NotificationStatus.FAILED);
        dataNotificationDTO.setType("Notification");
        dataNotificationDTO.setLink("/protocolo/parametros");
        dataNotificationDTO.setUsername(SecurityUtils.getUsername());
        this.notificationFeign.publishMessage(dataNotificationDTO);
    }

    protected void beforeSave(Processo processo, Authentication auth) {
        super.beforeSave((EloEntity)processo, auth);
        this.atualizaProcessoRoteiro(processo);
        processo.setBloqueioAnexoExterno(this.parametroService.getParamValueAsBoolean(ParametroEnum.BLOQUEIA_ANEXOS_CONSULTA_EXTERNA_SEM_LIBERACAO_USUARIO_INTERNO, processo.getId().getEntidade(), processo.getId().getAno()));
        boolean isIntegradoTributario = this.parametroService.getParamValueAsBoolean(ParametroEnum.INTEGRADO_TRIBUTACAO, processo.getId().getEntidade(), processo.getId().getAno());
        if (isIntegradoTributario) {
            try {
                if (this.pessoaClient.isPresent()) {
                    br.com.elotech.unico.client.dto.PessoaDTO pessoaUnico = ((PessoaClientUnico)this.pessoaClient.get()).getPessoaById(processo.getPessoa().getIdUnico());
                    ((PessoaClientUnico)this.pessoaClient.get()).ativaContribuinte(pessoaUnico);
                }
            }
            catch (FeignException ex) {
                LOGGER.error("Erro inesperado ao ativar contribuinte no \u00fanico. [{}]", (Object)ex.getMessage(), (Object)ex);
                throw new UnicoClientException("N\u00e3o foi poss\u00edvel ativar a pessoa contribuinte no \u00fanico", (Throwable)ex);
            }
        }
        if (processo.getAssunto().getObrigaDadosImovel().booleanValue()) {
            if (Objects.isNull(processo.getZona()) || processo.getZona().isEmpty()) {
                throw new EloValidationException("Zona Inv\u00e1lida. Informe os dados do Im\u00f3vel.");
            }
            if (Objects.isNull(processo.getQuadra()) || processo.getQuadra().isEmpty()) {
                throw new EloValidationException("Quadra Inv\u00e1lida. Informe os dados do Im\u00f3vel.");
            }
            if (Objects.isNull(processo.getData()) || processo.getData().isEmpty()) {
                throw new EloValidationException("Lote Inv\u00e1lido. Informe os dados do Im\u00f3vel.");
            }
            if (Objects.isNull(processo.getCadastro()) || processo.getCadastro().isEmpty()) {
                throw new EloValidationException("Cadastro Inv\u00e1lido. Informe os dados do Im\u00f3vel.");
            }
        }
    }

    @Transactional
    public Processo saveProcessoExterno(ProcessoDTO processoDto, Long idEntidade) {
        if (!processoDto.isIntegracaoAssinatura().booleanValue()) {
            this.validaProcesso(processoDto);
        }
        if (processoDto.bloqueiaAberturaExternaAnonima().booleanValue()) {
            throw new EloValidationException("Este assunto est\u00e1 parametrizado na entidade para ser aberto apenas em modo identificado. Por favor, retorne a etapa de Informa\u00e7\u00f5es Pessoa e preencha os dados do Requerente");
        }
        SalvaProcessoStrategy strategy = SalvaProcessoStrategyFactory.get((ProcessoDTO)processoDto, (ProtocoloMapper)this.mapper, (EntidadeService)this.entidadeService, (ExercicioService)this.exercicioService, (ParametroService)this.parametroService, (PessoaService)this.pessoaService, (ProcessoArquivoService)this.arquivoService, (UsuarioService)this.usuarioService, (Boolean)false);
        Processo processo = Objects.isNull(idEntidade) ? strategy.criar(processoDto) : strategy.criar(processoDto, idEntidade);
        this.beforeInsert(processo);
        Processo savedProcesso = (Processo)this.getProcessoRepository().saveAndFlush((Object)processo);
        processoDto.setNumero(savedProcesso.getId().getNumero());
        if (Boolean.TRUE.equals(processoDto.isIntegracaoAssinatura())) {
            this.publicarSituacaoArquivosIntegrados(savedProcesso);
        } else {
            this.afterSave(savedProcesso, null);
        }
        return savedProcesso;
    }

    @Transactional
    public Processo saveProcessoIntegracao(ProcessoDTO processoDto) {
        SalvaProcessoStrategy strategy = SalvaProcessoStrategyFactory.get((ProcessoDTO)processoDto, (ProtocoloMapper)this.mapper, (EntidadeService)this.entidadeService, (ExercicioService)this.exercicioService, (ParametroService)this.parametroService, (PessoaService)this.pessoaService, (ProcessoArquivoService)this.arquivoService, (UsuarioService)this.usuarioService, (Boolean)true);
        Processo processo = strategy.criar(processoDto, processoDto.getEntidade().getId());
        this.beforeInsert(processo);
        Processo savedProcesso = (Processo)this.getProcessoRepository().saveAndFlush((Object)processo);
        processoDto.setNumero(savedProcesso.getId().getNumero());
        return savedProcesso;
    }

    private void validaProcesso(ProcessoDTO processoDto) {
        if (processoDto.deveValidarOsArquivos().booleanValue() && processoDto.isQuantidadeDeArquivosInvalida().booleanValue()) {
            throw new EloValidationException("\u00c9 necess\u00e1rio adicionar um arquivo para cada documento exigido");
        }
        if (Objects.nonNull(processoDto.getPessoa())) {
            if (Objects.nonNull(processoDto.getPessoa().getEmail())) {
                processoDto.setEmail(processoDto.getPessoa().getEmail());
            }
            if (Objects.nonNull(processoDto.getPessoa().getCelular())) {
                processoDto.setCelular(processoDto.getPessoa().getCelular());
            }
        }
    }

    @Transactional
    public void fecharReabrirProcesso(Processo processo, Authentication authentication) {
        this.protocoloConfigService.throwExceptionIfSomenteLeitura();
        processo.setFechado(Boolean.valueOf(processo.getFechado() == false));
        Tramite ultimoTramiteArquivado = processo.getUltimoTramiteByFuncao(Funcao.ARQUIVADO);
        Tramite novoTramite = new Tramite();
        BeanUtils.copyProperties((Object)ultimoTramiteArquivado, (Object)novoTramite, (String[])new String[]{"id"});
        TramitePK id = new TramitePK();
        id.setProcesso(processo);
        id.setSequencia(Long.valueOf(processo.getUltimaSequenciaTramite() + 1L));
        novoTramite.setId(id);
        novoTramite.setUsuarioRegistro(authentication.getName());
        novoTramite.setParecer(processo.getParecerByFechado());
        novoTramite.setDataRegistro(LocalDate.now());
        novoTramite.setHora(LocalTime.now());
        novoTramite.setData(LocalDate.now());
        processo.addTramite(novoTramite);
        this.getProcessoRepository().save((Object)processo);
    }

    public void enviarListaProcessoPorEmail(List<Processo> processos) {
        this.processoEmailSender.enviarListaProcessoPorEmail(processos);
    }

    @Transactional
    public Processo removerProcessoReferenciado(Processo processoReferenciado) {
        return (Processo)this.getProcessoRepository().save((Object)processoReferenciado.removerReferencia());
    }

    @Transactional
    public Processo referenciarProcesso(Processo processoReferenciar, Processo processoPai) {
        return (Processo)this.getProcessoRepository().save((Object)processoPai.referenciar(processoReferenciar));
    }

    public Processo referenciarProcesso(Processo processoReferenciar, ProcessoPK pk) {
        Processo processo = (Processo)this.getProcessoRepository().findOne((Object)pk);
        return this.referenciarProcesso(processoReferenciar, processo);
    }

    public Processo initializeTemplate(Authentication auth) {
        return this.processoInitializer.initialize(auth.getName());
    }

    @Transactional
    public List<Processo> tramitar(List<Processo> processos, TramiteProcessosWrapper tramite, Entidade entidade, String username) {
        this.protocoloConfigService.throwExceptionIfSomenteLeitura();
        TramiteBusinessStrategy strategy = TramiteStrategyFactory.get((Funcao)tramite.getFuncao(), (Entidade)entidade, (ProtocoloMapper)this.mapper, (ParametroService)this.parametroService);
        return this.validaRecebimentoAutomatico(this.tramitar(processos, tramite, entidade, username, strategy), tramite, entidade, username);
    }

    @Transactional
    public List<Processo> tramitar(List<Processo> processos, TramiteProcessosWrapper tramite, Entidade entidade, String username, TramiteBusinessStrategy strategy) {
        this.protocoloConfigService.throwExceptionIfSomenteLeitura();
        Long lote = Optional.ofNullable(this.tramiteRepository.findNextLote(entidade.getId())).orElse(1L);
        lote = lote + 1L;
        tramite.setLote(lote);
        AtomicLong loteSequencia = new AtomicLong(0L);
        List<Processo> processosTramitados = processos.stream().map(processo -> {
            tramite.setLoteSequencia(Long.valueOf(loteSequencia.incrementAndGet()));
            return this.tramitarProcesso(processo, tramite, strategy, username);
        }).collect(Collectors.toList());
        processosTramitados.stream().forEach(processo -> this.tramiteEmailSender.enviarEmailTramite((Tramite)processo.getUltimoTramite().get()));
        return processosTramitados;
    }

    protected Processo tramitarProcesso(Processo processo, TramiteProcessosWrapper tramite, Entidade entidade, String username) {
        TramiteBusinessStrategy strategy = TramiteStrategyFactory.get((Funcao)tramite.getFuncao(), (Entidade)entidade, (ProtocoloMapper)this.mapper, (ParametroService)this.parametroService);
        return this.tramitarProcesso(processo, tramite, strategy, username);
    }

    protected Processo tramitarProcesso(Processo processo, TramiteProcessosWrapper tramite, TramiteBusinessStrategy strategy, String username) {
        this.protocoloConfigService.throwExceptionIfSomenteLeitura();
        if (tramite.getFuncao() != Funcao.ARQUIVADO && (processo.getIdProcessoTaxa() != null || processo.getPossuiTaxa().booleanValue())) {
            this.verificarStatusPagamento(processo);
        }
        List violations = this.validarProcessoTramitacao(processo);
        strategy.validar(processo, violations, tramite.getLocal());
        Tramite tramitacao = strategy.tramitar(processo, tramite, username);
        Boolean deveGerarPapeletaAutomatico = this.parametroService.getParamValueAsBoolean(ParametroEnum.GERA_PAPELETA_PROCESSO.getCodigo());
        if (Boolean.TRUE.equals(deveGerarPapeletaAutomatico)) {
            Usuario usuario = this.usuarioService.findUsuarioByName(username);
            tramitacao.setUsuario(usuario);
            byte[] papeletaPdfReport = this.relatorioService.createPapeletaPdfReport(Collections.singletonList(tramitacao), TipoPapeletaProcessoEnum.LOCAL, processo.getId().getEntidade().getId(), processo.getId().getAno());
            try {
                this.arquivoService.addArquivo(processo, username, (MultipartFile)new ByteMultipartFile(papeletaPdfReport, "application/pdf", this.getNamePapelataByTramite(tramite)), null, null, Boolean.FALSE, Boolean.TRUE, Boolean.valueOf(false));
            }
            catch (IOException | InterruptedException ex) {
                LOGGER.error("Erro ao anexar papeleta ao processo. [{}]", (Object)ex.getMessage(), (Object)ex);
            }
        }
        Boolean deveAtivarProcessosParalisados = this.parametroService.getParamValueAsBoolean(ParametroEnum.ATIVA_AUTOMATICAMENTE_PROCESSOS_PARALISADOS_AO_TRAMITAR.getCodigo());
        processo.getProcessosAnexos().stream().map(ProcessoAnexo::getId).map(new ProcessoAnexoPkToProcessoPK()).map(arg_0 -> ((ProcessoRepository)this.getRepository()).findOne(arg_0)).forEach(p -> {
            if (deveAtivarProcessosParalisados.booleanValue()) {
                p.ativar();
            }
            strategy.tramitar(p, tramite, username);
        });
        if (deveAtivarProcessosParalisados.booleanValue()) {
            processo.ativar();
        }
        Processo processoSaved = (Processo)this.getProcessoRepository().save((Object)processo);
        this.processoIntegracaoService.salvarProcessoIntegracao(processoSaved);
        return processoSaved;
    }

    protected String getNamePapelataByTramite(TramiteProcessosWrapper tramite) {
        if (Funcao.RECEBIDO.equals((Object)tramite.getFuncao())) {
            return "papeleta_recebimento.pdf";
        }
        if (Funcao.ENCAMINHADO.equals((Object)tramite.getFuncao())) {
            return "papeleta_encaminhamento.pdf";
        }
        if (Funcao.ARQUIVADO.equals((Object)tramite.getFuncao())) {
            return "papeleta_arquivamento.pdf";
        }
        return "papeleta.pdf";
    }

    public void verificarStatusPagamento(Processo processo) {
        StatusPagamentoDebitoEnum statusPagamento = this.processoTaxaService.verificarStatusPagamento(processo);
        if ((StatusPagamentoDebitoEnum.PAGAMENTO_NAO_REALIZADO.equals((Object)statusPagamento) || StatusPagamentoDebitoEnum.DESCONHECIDO.equals((Object)statusPagamento)) && !statusPagamento.getBoletoPago().booleanValue()) {
            throw new RestException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel tramitar o processo. Pagamento pendente.");
        }
    }

    private List<EloViolation> validarProcessoTramitacao(Processo processo) {
        Boolean avaliaProcessoExterno;
        ArrayList violations = Lists.newArrayList();
        if (this.processoAnexoService.isProcessoAnexado(processo).booleanValue()) {
            violations.add(new EloViolation(String.format("O processo de Tipo:%d N\u00famero:%d Ano:%d est\u00e1 anexado em outro processo", processo.getId().getTipo().getId(), processo.getId().getNumero(), processo.getId().getAno())));
        }
        if (processo.isAberto().booleanValue() && processo.getExterno().booleanValue() && (avaliaProcessoExterno = this.parametroService.getParamValueAsBoolean(ParametroEnum.PROCESSO_EXTERNO_AVALIA.getCodigo())).booleanValue() && !processo.isAvaliado().booleanValue()) {
            violations.add(new EloViolation("N\u00e3o foi poss\u00edvel tramitar o processo. O processo ainda n\u00e3o foi avaliado"));
        }
        return violations;
    }

    @VisibleForTesting
    protected ProcessoRepository getProcessoRepository() {
        return (ProcessoRepository)this.getCrudRepository();
    }

    public ProcessoPKDTO getProcessoPai(ProcessoPK pkProcessoFilho) {
        ProcessoPK pkProcessoPai = this.processoAnexoService.getPkProcessoPai(pkProcessoFilho);
        return this.mapper.toProcessoPKDTO(pkProcessoPai);
    }

    public List<ProcessoAssuntoDTO> findQuantidadeProcessosPorAssunto(Long entidade, Long ano) {
        Long entidadeParametrizada = entidade;
        if (Objects.isNull(entidade)) {
            entidadeParametrizada = ((Entidade)this.entidadeService.findOne((Serializable)this.parametroService.getParamLongEntidadeProcessoExterno())).getId();
        }
        return this.getProcessoRepository().findProcessosPorAssuntoByEntidadeAndAno(entidadeParametrizada, ano);
    }

    public Optional<String> defaultSearchFilter() {
        String exercicio = ContextHolder.getHeaderValueExercicio().toString();
        if (exercicio.isBlank() || exercicio.equals("0")) {
            return Optional.empty();
        }
        return Optional.of(" id.ano == " + exercicio);
    }

    public ProcessoDTO findProcessoByNumeroAnoTipoConcat(String pkConcatenada) {
        String[] infosProcesso = StringUtils.split((String)(pkConcatenada = pkConcatenada.replace("*", "")), (String)"$");
        if (infosProcesso.length < 3) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Erro na leitura do c\u00f3digo de barras.");
        }
        for (String info : infosProcesso) {
            if (info != null && br.com.elotech.core.utils.StringUtils.isSomenteNumeros((String)info).booleanValue()) continue;
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Erro na leitura do c\u00f3digo de barras.");
        }
        Processo processoSearch = this.getRepository().findOneByIdAnoAndIdTipoIdAndIdNumero(Long.valueOf(infosProcesso[0]), Long.valueOf(infosProcesso[1]), Long.valueOf(infosProcesso[2]));
        if (processoSearch == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "N\u00e3o foi encontrado nenhum processo referente ao c\u00f3digo de barras.");
        }
        return this.mapper.toProcessoDTO(processoSearch);
    }

    public ProcessoContagemMesAnoDTO relatorioContagemPorMesEAno(RelatorioContagemMesAnoParams params) {
        ProcessoContagemMesAnoDTO dto = new ProcessoContagemMesAnoDTO();
        dto.setAnoUm(this.getRepository().relatorioContagemPorMesEAno(params.getAnoUm(), params.getIdEntidade(), params.getIdLocal(), params.getIdAssunto(), params.getIdSituacao(), params.getComplementoAssunto(), params.getIdUsuario(), Boolean.valueOf(false), params.getOuvidoria()));
        dto.setArquivadosAnoUm(this.getRepository().relatorioContagemPorMesEAno(params.getAnoUm(), params.getIdEntidade(), params.getIdLocal(), params.getIdAssunto(), params.getIdSituacao(), params.getComplementoAssunto(), params.getIdUsuario(), Boolean.valueOf(true), params.getOuvidoria()));
        dto.setAnoDois(this.getRepository().relatorioContagemPorMesEAno(params.getAnoDois(), params.getIdEntidade(), params.getIdLocal(), params.getIdAssunto(), params.getIdSituacao(), params.getComplementoAssunto(), params.getIdUsuario(), Boolean.valueOf(false), params.getOuvidoria()));
        dto.setArquivadosAnoDois(this.getRepository().relatorioContagemPorMesEAno(params.getAnoDois(), params.getIdEntidade(), params.getIdLocal(), params.getIdAssunto(), params.getIdSituacao(), params.getComplementoAssunto(), params.getIdUsuario(), Boolean.valueOf(true), params.getOuvidoria()));
        return dto;
    }

    @Transactional
    public Processo alterarStatusParalisado(Processo processo) {
        this.protocoloConfigService.throwExceptionIfSomenteLeitura();
        Boolean paralisado = Boolean.FALSE;
        if (Objects.isNull(processo.getParalisado()) || Objects.nonNull(processo.getParalisado()) && Boolean.FALSE.equals(processo.getParalisado())) {
            paralisado = Boolean.TRUE;
        }
        processo.setParalisado(paralisado);
        return (Processo)this.getRepository().saveAndFlush((Object)processo);
    }

    public Page<ProcessoDTO> findProcessosByUsuario(String cpfCnpj, String search, Pageable pageable) {
        Specification specification = Specification.where((Specification)ProcessoSpecificationHelper.byUsuarioLogado((String)cpfCnpj)).and(ProcessoSpecificationHelper.byEntidade((Entidade)this.entidadeService.getEntidadeAtual()));
        if (!Strings.isNullOrEmpty((String)search)) {
            specification = specification.and(RsqlUtils.createSpecFrom((EntityManager)this.entityManager, (String)search));
        }
        return this.getRepository().findAll(specification, pageable).map(arg_0 -> ((ProtocoloMapper)this.mapper).toProcessoDTO(arg_0));
    }

    @Transactional
    public void avaliarProcesso(Processo processo, AvaliacaoProcessoDTO avaliacao) {
        this.protocoloConfigService.throwExceptionIfSomenteLeitura();
        processo.setNota(avaliacao.getNota());
        processo.setNotaObservacao(avaliacao.getNotaObservacao());
        this.getRepository().saveAndFlush((Object)processo);
    }

    @Transactional
    public void reabrirProcessoRequerente(Processo processo, String parecer) {
        this.protocoloConfigService.throwExceptionIfSomenteLeitura();
        ProcessoPK id = processo.getId();
        if (!Funcao.ARQUIVADO.equals((Object)processo.getFuncao())) {
            throw new ReaberturaNaoPermitidaException(String.format("O processo de n\u00famero %s n\u00e3o pode ser reaberto, o processo precisa estar arquivado.", id.getNumero().toString()));
        }
        Situacao situacao = this.situacaoService.getSituacaoReaberturaPeloRequerente(id.getEntidade().getId(), id.getAno());
        TramiteProcessosWrapper tramite = new TramiteProcessosWrapper();
        processo.getUltimoTramite().ifPresent(ultimoTramite -> tramite.setLocal(new LocalDTOConverter().to(ultimoTramite.getLocal())));
        tramite.setSituacao(this.mapper.toSituacaoDTO(situacao));
        tramite.setFuncao(Funcao.ENCAMINHADO);
        tramite.setParecerResposta(parecer);
        this.tramitar(List.of(processo), tramite, id.getEntidade(), SecurityUtils.getUsername()).stream().findFirst().ifPresent(p -> p.setSituacao(situacao));
    }

    public void validaPermissoesExclusaoArquivoProcesso(Processo processo, ProcessoArquivo processoArquivo, String username) {
        Usuario usuario = this.usuarioService.findUsuarioByName(username);
        if (!usuario.getExcluirArquivos().booleanValue()) {
            this.bloquearExclusaoArquivosAssinados(processoArquivo);
            this.bloquearExclusaoArquivoUsuarioLogadoDiferente(processoArquivo);
            this.bloquearExclusaoArquivoAnteriorAoArquivoAgrupado(processo, processoArquivo);
            this.permitirExcluirAnexoAgrupadoComArquivosPosteriores(processo, processoArquivo);
            this.bloquearExclusaoAnexosAntigos(processo, processoArquivo);
        }
    }

    public void bloquearExclusaoArquivosAssinados(ProcessoArquivo processoArquivo) {
        if (!processoArquivo.getAssinaturas().isEmpty() && Boolean.TRUE.equals(this.parametroService.getParamValueAsBoolean(ParametroEnum.BLOQUEIA_EXCLUSAO_ANEXOS_COM_SOLICITACOES_ASSINATURAS.getCodigo()))) {
            throw new EloValidationException("N\u00e3o \u00e9 permitido excluir arquivos que possuem assinatura ou solicita\u00e7\u00e3o de assinatura.");
        }
    }

    public void bloquearExclusaoArquivoUsuarioLogadoDiferente(ProcessoArquivo processoArquivo) {
        if (!Objects.equals(processoArquivo.getUsuario(), SecurityContextHolder.getContext().getAuthentication().getName()) && Boolean.TRUE.equals(this.parametroService.getParamValueAsBoolean(ParametroEnum.BLOQUEIA_EXCLUSAO_ARQUIVOS_USUARIO_DIFERENTE_INCLUSAO.getCodigo()))) {
            throw new EloValidationException("N\u00e3o \u00e9 permitido excluir arquivos enviados por outro usuario.");
        }
    }

    public void bloquearExclusaoArquivoAnteriorAoArquivoAgrupado(Processo processo, ProcessoArquivo processoArquivo) {
        boolean possuiArquivoAgrupado = processo.getArquivos().stream().anyMatch(arquivo -> arquivo.getAgrupamento() != false && processoArquivo.getDataCriacao().isBefore(arquivo.getDataCriacao()));
        if (possuiArquivoAgrupado && Boolean.TRUE.equals(this.parametroService.getParamValueAsBoolean(ParametroEnum.BLOQUEIA_EXCLUSAO_ARQUIVOS_ANTERIOR_GERACAO_ANEXO.getCodigo()))) {
            throw new EloValidationException("N\u00e3o \u00e9 permitido excluir arquivos enviados antes da cria\u00e7\u00e3o do arquivo de agrupamento.");
        }
    }

    public void permitirExcluirAnexoAgrupadoComArquivosPosteriores(Processo processo, ProcessoArquivo processoArquivo) {
        boolean possuiArquivoPosteriorAoAgrupado;
        if (Boolean.TRUE.equals(processoArquivo.getAgrupamento()) && (possuiArquivoPosteriorAoAgrupado = processo.getArquivos().stream().anyMatch(arquivo -> processoArquivo.getDataCriacao().isBefore(arquivo.getDataCriacao()))) && Boolean.FALSE.equals(this.parametroService.getParamValueAsBoolean(ParametroEnum.PERMITE_EXCLUSAO_ANEXO_AGRUPADO_COM_ARQUIVOS_POSTERIORES.getCodigo()))) {
            throw new EloValidationException("N\u00e3o \u00e9 permitido excluir arquivos de agrupamento, gerados antes da adi\u00e7\u00e3o de novos arquivos.");
        }
    }

    public void bloquearExclusaoAnexosAntigos(Processo processo, ProcessoArquivo processoArquivo) {
        boolean possuiArquivoPosteriorAoSelecionado = processo.getArquivos().stream().anyMatch(arquivo -> !arquivo.getIdentificador().equals(processoArquivo.getIdentificador()) && processoArquivo.getDataCriacao().isBefore(arquivo.getDataCriacao()));
        if (possuiArquivoPosteriorAoSelecionado && Boolean.TRUE.equals(this.parametroService.getParamValueAsBoolean(ParametroEnum.BLOQUEIA_EXCLUSAO_ANEXO_COM_ANEXOS_POSTERIORES.getCodigo()))) {
            throw new EloValidationException("N\u00e3o \u00e9 permitido excluir arquivos que possuirem novos arquivos inseridos posteriomente.");
        }
    }

    public List<RequerimentoObservacaoProcessoAuditDTO> listaAlteracaoRequerimento(Long numero, Long tipo, Long ano, Long entidade) {
        return this.getProcessoRepository().listaAlteracaoRequerimento(numero, tipo, ano, entidade);
    }

    public List<RequerimentoObservacaoProcessoAuditDTO> listaAlteracaoObservacao(Long numero, Long tipo, Long ano, Long entidade) {
        return this.getProcessoRepository().listaAlteracaoObservacao(numero, tipo, ano, entidade);
    }

    private List<Processo> validaRecebimentoAutomatico(List<Processo> processos, TramiteProcessosWrapper tramite, Entidade entidade, String username) {
        if (Boolean.TRUE.equals(tramite.getFuncao().equals((Object)Funcao.ENCAMINHADO) && this.parametroService.getParamValueAsBoolean(ParametroEnum.RECEBE_AUTOMATICAMENTE_PROCESSO_NAO_FISICO_ENCAMINHAMENTO.getCodigo()) != false)) {
            List processosRecebidos = this.tramitar(processos.stream().filter(processo -> processo.getProcessoFisico().equals(Boolean.FALSE)).collect(Collectors.toList()), tramite, entidade, username, TramiteStrategyFactory.get((Funcao)Funcao.RECEBIDO, (Entidade)entidade, (ProtocoloMapper)this.mapper, (ParametroService)this.parametroService));
            processosRecebidos.forEach(processo -> processo.getUltimoTramite().ifPresent(ultimoTramite -> {
                ultimoTramite.setParecer("Processo Digital recebido automaticamente pelo local do encaminhamento");
                this.tramiteRepository.save(ultimoTramite);
            }));
            return processosRecebidos;
        }
        return processos;
    }

    public boolean permiteUsuarioEditarProcessoTramitado() {
        Authentication usuarioAuthentication = SecurityContextHolder.getContext().getAuthentication();
        if (usuarioAuthentication != null) {
            Usuario usuarioLogado = (Usuario)this.usuarioService.findOne((Serializable)((Object)usuarioAuthentication.getName()));
            return usuarioLogado.getEditarProcessoTramitado();
        }
        return false;
    }

    public ProcessoDTO criarProcessoIntegracao(ProcessoIntegracaoDTO processoIntegracaoDTO) {
        ProcessoDTO processoDTO = new ProcessoDTO();
        ProcessoAssinaturaConfig config = this.processoAssinaturaConfigService.getProcessoAssinaturaConfigByEntidadeAndTipo(processoIntegracaoDTO.getIdEntidade(), processoIntegracaoDTO.getTipoIntegracaoEnum());
        if (Objects.isNull(config)) {
            throw new RegistroNaoEncontradoException(String.format("Configura\u00e7\u00e3o para a entidade %s e tipo integra\u00e7\u00e3o %s n\u00e3o foi encontrada.", processoIntegracaoDTO.getIdEntidade(), processoIntegracaoDTO.getTipoIntegracaoEnum().value));
        }
        PessoaDTO pessoaDTO = new PessoaDTO();
        pessoaDTO.setId(config.getPessoa().getId());
        pessoaDTO.setNome(config.getPessoa().getNome());
        pessoaDTO.setCnpjCpf(config.getPessoa().getCnpjCpf());
        processoDTO.setEntidade(EntidadeDTO.of((Long)config.getEntidade()));
        processoDTO.setAssunto(AssuntoDTO.of((Long)config.getAssunto().getId()));
        processoDTO.setDataProcesso(LocalDate.now());
        processoDTO.setLocalOrigem(LocalDTO.of((Long)config.getLocalOrigem().getId().getId()));
        processoDTO.setLocalDestino(LocalDTO.of((Long)config.getLocalDestino().getId().getId()));
        processoDTO.setLocalAtual(LocalDTO.of((Long)config.getLocalOrigem().getId().getId()));
        processoDTO.setTipo(TipoProcessoSimpleDTO.of((Long)config.getTipoProcesso().getId()));
        processoDTO.setPessoa(pessoaDTO);
        processoDTO.setSituacao(SituacaoDTO.of((Long)config.getSituacao().getId()));
        processoDTO.setUsuarioRegistro(processoIntegracaoDTO.getUsername());
        Processo processoSalvo = this.saveProcessoIntegracao(processoDTO);
        processoDTO.setUuid(processoSalvo.getUuid());
        processoDTO.setNumero(processoSalvo.getId().getNumero());
        TipoProcessoSimpleDTO tipoProcessoSimpleDTO = new TipoProcessoSimpleDTO();
        tipoProcessoSimpleDTO.setId(processoSalvo.getId().getTipo().getId());
        tipoProcessoSimpleDTO.setDescricao(processoSalvo.getId().getTipo().getDescricao());
        processoDTO.setTipo(tipoProcessoSimpleDTO);
        return processoDTO;
    }

    @Transactional
    public void cloneArquivoReferenciado(PesquisaProcessoParams params) {
        Processo processo = this.processoPesquisaService.loadProcesso(Entidade.of((Long)params.getEntidade()), params.getTipo(), params.getNumero(), params.getAno());
        if (StringUtils.isNotBlank((CharSequence)processo.getProcessoReferencia())) {
            ProcessoReferenciaDTO processoRefDTO = ProcessoReferenciaDTOBuilder.buildProcessoReferenciaDTO((Processo)processo);
            if (Objects.isNull(processoRefDTO)) {
                log.warn("Processo refer\u00eancia inv\u00e1lido: {}", (Object)processo.getProcessoReferencia());
                return;
            }
            Processo processoReferencia = this.processoPesquisaService.loadProcesso(Entidade.of((Long)processoRefDTO.getEntidade()), processoRefDTO.getTipo(), processoRefDTO.getNumero(), processoRefDTO.getAno());
            processoReferencia.getArquivos().forEach(arquivo -> {
                ProcessoArquivo novoArquivo = new ProcessoArquivo();
                BeanUtils.copyProperties((Object)arquivo, (Object)novoArquivo, (String[])new String[]{"id", "identificador"});
                novoArquivo.setId(new ProcessoArquivoPK(processo));
                novoArquivo.setIdentificador(UUID.randomUUID().toString());
                processo.getArquivos().add(novoArquivo);
            });
            this.getProcessoRepository().saveAndFlush((Object)processo);
        }
    }

    @Transactional
    public void atualizarAssunto(PesquisaProcessoParams params, AssuntoDTO assuntoDTO) {
        this.protocoloConfigService.throwExceptionIfSomenteLeitura();
        Entidade entidade = new Entidade(params.getEntidade());
        Processo processo = this.processoPesquisaService.loadProcesso(entidade, params.getTipo(), params.getNumero(), params.getAno());
        processo.setAssunto(new Assunto(assuntoDTO.getId()));
        this.getRepository().saveAndFlush((Object)processo);
    }

    protected void atualizarSequenceProcesso(Processo processo) {
        if (Boolean.TRUE.equals(processo.getNumeroJaExistente())) {
            return;
        }
        String expression = this.sequenciamentoProcessoService.getExpression((Object)processo.getId());
        String sequenceName = this.getSequenceName(processo, expression);
        if (!this.sequenceUtils.sequenceExists(sequenceName)) {
            Long initialValue = this.getProcessoRepository().getNumeroRecomendado(processo.getId(), expression);
            this.sequenceUtils.createSequence(sequenceName, Integer.valueOf(initialValue.intValue()));
        }
        boolean continuaLooping = true;
        while (continuaLooping) {
            Long numero = this.sequenceUtils.nextVal(sequenceName);
            if (this.existsProcesso(processo.getId().getAno(), processo.getId().getTipo().getId(), numero)) continue;
            processo.getId().setNumero(numero);
            continuaLooping = false;
        }
    }

    protected String getSequenceName(Processo processo, String expression) {
        String sequenceName = expression;
        sequenceName = sequenceName.replace("#{entidade.id}", processo.getId().getEntidade().getId().toString());
        sequenceName = sequenceName.replace("#{ano}", processo.getId().getAno().toString());
        sequenceName = sequenceName.replace("#{tipo.id}", processo.getId().getTipo().getId().toString());
        return sequenceName;
    }

    protected void verificaSeJaExisteProcessoComEsseAnoTipoIdENumero(Processo processo) {
        Long ano = processo.getId().getAno();
        Long tipoId = processo.getId().getTipo().getId();
        Long numero = processo.getId().getNumero();
        Boolean processoExistente = processo.getNumeroJaExistente();
        if (Boolean.TRUE.equals(processoExistente) && this.existsProcesso(ano, tipoId, numero)) {
            throw new EloValidationException("J\u00e1 existe um processo com este n\u00famero, tipo e ano.");
        }
    }

    protected boolean existsProcesso(Long ano, Long tipoId, Long numero) {
        return this.getProcessoRepository().existsByIdAnoAndIdTipoIdAndIdNumero(ano, tipoId, numero);
    }

    @Transactional
    public void alterarTramitarEntreEntidades(PesquisaProcessoParams params) {
        this.protocoloConfigService.throwExceptionIfSomenteLeitura();
        Entidade entidade = new Entidade(params.getEntidade());
        Processo processo = this.processoPesquisaService.loadProcesso(entidade, params.getTipo(), params.getNumero(), params.getAno());
        processo.setTramitaEntreEntidades(Boolean.valueOf(processo.getTramitaEntreEntidades() == false));
        this.getRepository().saveAndFlush((Object)processo);
    }

    public void atualizaProcessoRoteiro(Processo processo) {
        Assunto assunto = processo.getAssunto();
        processo.setRoteiro(Boolean.valueOf(assunto.getControlaTramitacao() != false && assunto.getRoteiro() != null));
    }

    private Boolean isProcessoMP() {
        return this.parametroService.getParamValueAsBoolean(ParametroEnum.UTILIZA_CRIACAO_PROCESSO_MP.getCodigo());
    }

    @Transactional
    public void enviaEmailsProcessosAtrasados() {
        this.protocoloConfigService.throwExceptionIfSomenteLeitura();
        Long entidade = this.entidadeService.getEntidadeAtual().getId();
        Page processosVencidos = this.processoRepositoryImpl.getProcessosVencidos(LocalDate.now(), "", entidade, Boolean.TRUE, this.isProcessoMP());
        this.processoEmailSender.enviarEmailProcessosAtrasados(processosVencidos.getContent());
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void updateStatusAgrupamentoById(StatusAgrupamento statusAgrupamento, ProcessoPK id) {
        String status = null;
        if (Objects.nonNull(statusAgrupamento)) {
            status = statusAgrupamento.name();
        }
        this.getRepository().updateStatusAgrupamentoById(status, id.getEntidade().getId(), id.getAno(), id.getTipo().getId(), id.getNumero());
    }

    @Transactional
    public void updateDigitacaoEtiqueta(Long entidade, Long tipo, Long ano, Long numero) {
        this.protocoloConfigService.throwExceptionIfSomenteLeitura();
        ProcessoPK processoPK = ProcessoPK.of((Entidade)Entidade.of((Long)entidade), (TipoProcesso)TipoProcesso.of((Long)tipo), (Long)numero, (Long)ano);
        this.getRepository().findById((Object)processoPK).ifPresent(processo -> {
            processo.setDigitacao(HtmlUtils.toText((String)processo.getDigitacao()));
            this.getRepository().saveAndFlush(processo);
        });
    }
}

