/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.fluent.ReportDatasource;
import br.com.elotech.fluent.dataset.Dataset;
import br.com.elotech.fluent.dataset.SimpleDataset;
import br.com.elotech.fluent.param.Param;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.domain.Tramite;
import br.com.elotech.protocolo.dto.params.PesquisaProcessoParams;
import br.com.elotech.protocolo.enums.TipoPapeletaProcessoEnum;
import br.com.elotech.protocolo.report.RelatorioProtocolo;
import br.com.elotech.protocolo.report.datasetrecord.PapeletaDatasetRecord;
import br.com.elotech.protocolo.report.function.TramiteToPapeletaDatasetRecord;
import br.com.elotech.protocolo.report.loader.CabecalhoParamLoader;
import br.com.elotech.protocolo.report.loader.CapaProcessoParamLoader;
import br.com.elotech.protocolo.report.loader.ComprovanteProcessoParamLoader;
import br.com.elotech.protocolo.report.loader.RequerimentoProcessoParamLoader;
import br.com.elotech.protocolo.report.resolver.ParametroReportResolver;
import br.com.elotech.protocolo.repository.ProcessoRepository;
import br.com.elotech.protocolo.repository.TipoProcessoRepository;
import br.com.elotech.report.EloReportFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class ProcessoRelatorioService {
    public static final String DATASET_CABECALHO = "Cabe\u00e7alho";
    public static final String DATASET_COMPROVANTE_PROCESSO = "ComprovanteProcessoGeral";
    public static final String DATASET_CAPA_PROCESSO_GERAL = "CapaProcessoGeral";
    public static final String DATASET_CAPA_PROCESSO_COMPRA = "CapaProcessoCompra";
    public static final String DATASET_REQUERIMENTO = "Requerimento";
    public static final String DATASET_PAPELETA = "Papeleta";
    public static final String DATASET_PROTOCOLO_ARQUIVOS = "ProtocoloArquivos";
    public static final String DATASET_PROCESSO_INTERESSADO = "ProcessoInteressado";
    private final ProcessoRepository processoRepository;
    private final ComprovanteProcessoParamLoader comprovanteProcessoParamLoader;
    private final CapaProcessoParamLoader capaProcessoParamLoader;
    private final ParametroReportResolver parametroRelatorioResolver;
    private final CabecalhoParamLoader cabecalhoLoader;
    private final TipoProcessoRepository tipoProcessoRepository;
    private final ObjectMapper objectMapper;

    public ProcessoRelatorioService(ProcessoRepository processoRepository, ComprovanteProcessoParamLoader comprovanteProcessoParamLoader, CapaProcessoParamLoader capaProcessoaParamLoader, ParametroReportResolver parametroRelatorioResolver, CabecalhoParamLoader cabecalhoLoader, TipoProcessoRepository tipoProcessoRepository, ObjectMapper objectMapper) {
        this.processoRepository = processoRepository;
        this.comprovanteProcessoParamLoader = comprovanteProcessoParamLoader;
        this.capaProcessoParamLoader = capaProcessoaParamLoader;
        this.parametroRelatorioResolver = parametroRelatorioResolver;
        this.cabecalhoLoader = cabecalhoLoader;
        this.tipoProcessoRepository = tipoProcessoRepository;
        this.objectMapper = objectMapper;
    }

    public byte[] createComprovantePdfReport(Processo processo) {
        ReportDatasource datasource = ReportDatasource.builder().add(DATASET_CABECALHO, () -> this.processoRepository.getCabecalhoEntidade(processo.getId().getEntidade().getId(), processo.getId().getAno())).add(DATASET_COMPROVANTE_PROCESSO, () -> this.processoRepository.getComprovanteProcesso(processo)).add(DATASET_PROTOCOLO_ARQUIVOS, () -> this.processoRepository.getProcessosArquivosDataSetRecord(processo)).add(DATASET_PROCESSO_INTERESSADO, () -> this.processoRepository.getProcessoInteressadoDatasetRecord(processo)).params((ParamLoader)this.comprovanteProcessoParamLoader).build();
        return EloReportFactory.crystal().reportFile(() -> this.parametroRelatorioResolver.resolveFromParametro(RelatorioProtocolo.COMPROVANTE_PROCESSO, ParametroEnum.COMPROVANTE_PROCESSO)).setReportDatasource(datasource).build().exportToPdf();
    }

    public byte[] createRequerimentoPdfReport(PesquisaProcessoParams params) {
        Processo processo = this.processoRepository.findOneByIdAnoAndIdTipoIdAndIdNumeroAndIdEntidadeId(params.getAno(), params.getTipo(), params.getNumero(), params.getEntidade());
        ReportDatasource datasource = ReportDatasource.builder().add(DATASET_CABECALHO, () -> this.processoRepository.getCabecalhoEntidade(processo.getId().getEntidade().getId(), processo.getId().getAno())).add(DATASET_REQUERIMENTO, () -> this.processoRepository.getRequerimentoProcesso(processo)).params((ParamLoader)new RequerimentoProcessoParamLoader(processo)).build();
        String caminhoRequerimento = processo.getId().getTipo().getCaminhoRequerimento();
        String modelo = params.getModelo();
        String rptName = Optional.of(caminhoRequerimento).filter(cr -> !cr.isEmpty()).or(() -> Optional.of(modelo).filter(m -> !m.isEmpty())).orElse(RelatorioProtocolo.REQUERIMENTO_PROCESSO.getDefaultRpt());
        return EloReportFactory.crystal().reportFile(this.parametroRelatorioResolver.resolveFromRelatorio(rptName)).setReportDatasource(datasource).build().exportToPdf();
    }

    public byte[] createCapaPdfReport(Processo processo, boolean agrupamento) {
        String datasetCapaProcesso = this.getDatasetCapaProcesso(processo);
        String caminhoCapa = processo.getId().getTipo().getCaminhoCapa();
        if (agrupamento) {
            TipoProcesso tipoProcesso = (TipoProcesso)this.tipoProcessoRepository.findOne((Object)processo.getId().getTipo().getId());
            caminhoCapa = tipoProcesso.getCaminhoCapaAgrupamentoArquivo().isEmpty() ? RelatorioProtocolo.CAPA_PROCESSO.getDefaultRpt() : tipoProcesso.getCaminhoCapaAgrupamentoArquivo();
        }
        ReportDatasource datasource = ReportDatasource.builder().add(DATASET_CABECALHO, () -> this.processoRepository.getCabecalhoEntidade(processo.getId().getEntidade().getId(), processo.getId().getAno())).add(datasetCapaProcesso, () -> this.processoRepository.getCapaProcesso(processo)).add(DATASET_PROTOCOLO_ARQUIVOS, () -> this.processoRepository.getProcessosArquivosDataSetRecord(processo)).add(DATASET_PROCESSO_INTERESSADO, () -> this.processoRepository.getProcessoInteressadoDatasetRecord(processo)).params((ParamLoader)this.capaProcessoParamLoader.beforeLoad(datasetCapaProcesso)).build();
        return EloReportFactory.crystal().reportFile(this.parametroRelatorioResolver.fromFile(caminhoCapa)).setReportDatasource(datasource).build().exportToPdf();
    }

    public byte[] createVisualizacaoPdfReport(Processo processo) {
        ReportDatasource datasource = ReportDatasource.builder().add("main", () -> this.processoRepository.getVisualizacaoProcesso(processo)).params((ParamLoader)this.cabecalhoLoader).build();
        return EloReportFactory.jasper().reportFile(() -> this.parametroRelatorioResolver.resolveFromRelatorio(RelatorioProtocolo.VISUALIZACAO_PROCESSO)).setReportDatasource(datasource).setObjectMapper(this.objectMapper).build().exportToPdf();
    }

    public byte[] createPapeletaPdfReport(List<Tramite> tramites, TipoPapeletaProcessoEnum tipo, Long entidade, Long exercicio) {
        ArrayList<PapeletaDatasetRecord> records = new ArrayList<PapeletaDatasetRecord>();
        List tramitesOrdenados = Tramite.ordenarTramitesPorSequenciaNoLote(tramites);
        for (Tramite tramite : tramitesOrdenados) {
            PapeletaDatasetRecord papeletaRecord = new TramiteToPapeletaDatasetRecord().apply(tramite);
            records.add(papeletaRecord);
        }
        SimpleDataset papeletaDataset = SimpleDataset.of(records, PapeletaDatasetRecord.class);
        ReportDatasource datasource = ReportDatasource.builder().add(DATASET_CABECALHO, () -> this.processoRepository.getCabecalhoEntidade(entidade, exercicio)).add(DATASET_PAPELETA, () -> ProcessoRelatorioService.lambda$createPapeletaPdfReport$17((Dataset)papeletaDataset)).param(Param.of((String)"nomeresponsavel", (Object)"")).build();
        return EloReportFactory.crystal().reportFile(() -> {
            File dataSourceReportFile = this.parametroRelatorioResolver.resolveFromParametro(RelatorioProtocolo.PAPELETA_PROCESSO, ParametroEnum.CAMINHO_PAPELETA);
            if (TipoPapeletaProcessoEnum.LOTE.equals((Object)tipo)) {
                dataSourceReportFile = this.parametroRelatorioResolver.resolveFromRelatorio(RelatorioProtocolo.PAPELETA_PROCESSO_LOTE);
            }
            return dataSourceReportFile;
        }).setReportDatasource(datasource).build().exportToPdf();
    }

    private String getDatasetCapaProcesso(Processo processo) {
        if (processo.getId().getTipo().isProcessoCompras().booleanValue()) {
            return DATASET_CAPA_PROCESSO_COMPRA;
        }
        return DATASET_CAPA_PROCESSO_GERAL;
    }

    private static /* synthetic */ Object lambda$createPapeletaPdfReport$17(Dataset papeletaDataset) {
        return papeletaDataset;
    }
}

