/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.adm.rsql.RsqlSpecification;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.utils.StringUtils;
import br.com.elotech.core.web.request.ContextHolder;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoFavorito;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.dto.ConfigRestricao;
import br.com.elotech.protocolo.dto.Funcao;
import br.com.elotech.protocolo.dto.QuantidadeProcessosOuvidoriaDTO;
import br.com.elotech.protocolo.dto.StatusPrazo;
import br.com.elotech.protocolo.dto.params.TramitacaoListagemParams;
import br.com.elotech.protocolo.repository.ProcessoRepository;
import br.com.elotech.protocolo.service.EntidadeService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.TipoProcessoService;
import br.com.elotech.protocolo.service.UsuarioService;
import br.com.elotech.protocolo.service.util.ProcessoReferenciaDTOBuilder;
import br.com.elotech.protocolo.specs.ProcessoSpecificationHelper;
import br.com.elotech.protocolo.utils.UsuarioUtils;
import br.com.elotech.protocolo.web.rest.dto.chart.SerieItemDTO;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import lombok.Generated;
import org.apache.commons.lang3.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProcessoPesquisaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessoPesquisaService.class);
    private static final Long DIAS_AVENCER_DEFAULT = 5L;
    private final TipoProcessoService tipoProcessoService;
    private final ProcessoRepository repository;
    private final UsuarioService usuarioService;
    private final ParametroService parametroService;
    private final EntidadeService entidadeService;
    private final EntityManager entityManager;

    public ProcessoPesquisaService(TipoProcessoService tipoProcessoService, ProcessoRepository repository, UsuarioService usuarioService, ParametroService parametroService, EntidadeService entidadeService, EntityManager entityManager) {
        this.tipoProcessoService = tipoProcessoService;
        this.repository = repository;
        this.usuarioService = usuarioService;
        this.parametroService = parametroService;
        this.entidadeService = entidadeService;
        this.entityManager = entityManager;
    }

    private Boolean isProcessoMP() {
        return this.parametroService.getParamValueAsBoolean(ParametroEnum.UTILIZA_CRIACAO_PROCESSO_MP.getCodigo());
    }

    private Long getQtdDiasAVencerMP() {
        return this.parametroService.getParamValueAsLong(ParametroEnum.QTD_DIAS_AVENCER_MP.getCodigo());
    }

    public Processo loadProcesso(Entidade entidade, Long tipo, Long numero, Long ano) {
        return (Processo)this.loadProcessoOptional(entidade, tipo, numero, ano).orElseThrow(RestException::notFound);
    }

    private Optional<Processo> loadProcessoOptional(Entidade entidade, Long tipo, Long numero, Long ano) {
        ProcessoPK pk = this.loadPkById(tipo, numero, ano, entidade);
        Processo processo = (Processo)this.repository.findOne((Object)pk);
        if (processo == null) {
            processo = this.repository.findByProcessoByEntidadeTipoNumeroAno(entidade.getId(), tipo, numero, ano);
        }
        return Optional.ofNullable(processo);
    }

    public ProcessoPK loadPkById(Long tipo, Long numero, Long ano, Entidade entidade) {
        TipoProcesso tipoProcesso = (TipoProcesso)this.tipoProcessoService.findOne((Serializable)tipo);
        if (Objects.isNull(tipoProcesso)) {
            throw RestException.notFound((String)String.format("N\u00e3o foi poss\u00edvel encontrar o tipo de processo %d", tipo));
        }
        return ProcessoPK.of((Entidade)entidade, (TipoProcesso)tipoProcesso, (Long)numero, (Long)ano);
    }

    public Page<Processo> findByPessoaIdOrderByDataProcessoDesc(Long pessoa, Pageable pageable) {
        return this.repository.findByPessoaIdOrderByDataProcessoDesc(pessoa, pageable);
    }

    public List<Processo> getTodosProcessosReferenciadosAndPrincipal(Processo processo) {
        List listaProcessosReferencia = this.getProcessosReferenciados(processo);
        if (!processo.getProcessoReferencia().isEmpty()) {
            Optional.ofNullable(ProcessoReferenciaDTOBuilder.buildProcessoReferenciaDTO((Processo)processo)).flatMap(processoReferenciaDTO -> this.loadProcessoOptional(Entidade.of((Long)processoReferenciaDTO.getEntidade()), processoReferenciaDTO.getTipo(), processoReferenciaDTO.getNumero(), processoReferenciaDTO.getAno())).ifPresent(listaProcessosReferencia::add);
        }
        return listaProcessosReferencia;
    }

    public List<Processo> getProcessosReferenciados(Processo processo) {
        return this.repository.findByProcessoReferencia(processo.getProcessoReferenciadoAsText());
    }

    public List<Processo> getProcessosByFuncao(String username, Long tipo, String numeros, Long ano, Set<Funcao> funcoes) {
        Optional intervaloNumeros = StringUtils.parseRange((String)numeros);
        Specification spec = Specification.where((Specification)ProcessoSpecificationHelper.byFuncoes(funcoes)).and(ProcessoSpecificationHelper.byAno((Long)ano)).and(ProcessoSpecificationHelper.byTipo((Long)tipo));
        if (intervaloNumeros.isPresent()) {
            spec = spec.and(ProcessoSpecificationHelper.byIntervaloNumero((Range)((Range)intervaloNumeros.get())));
        }
        spec = this.getSpecificationByPermissoesUsuario(username, spec);
        return this.repository.findAll(spec);
    }

    public List<Processo> getProcessosByLote(Long lote, String username) {
        HashSet funcoes = Sets.newHashSet((Object[])new Funcao[]{Funcao.ENCAMINHADO, Funcao.RECEBIDO, Funcao.ARQUIVADO});
        Specification spec = Specification.where((Specification)ProcessoSpecificationHelper.byFuncoes((Set)funcoes)).and(ProcessoSpecificationHelper.byTramiteLote((Long)lote));
        spec = this.getSpecificationByPermissoesUsuario(username, spec);
        return this.repository.findAll(spec);
    }

    private Specification<Processo> getSpecificationByPermissoesUsuario(String username, Specification<Processo> spec) {
        Boolean controlaPermissaoTipoProcesso;
        Long entidadeId;
        Usuario usuario = this.usuarioService.findUsuarioByName(username);
        if (!UsuarioUtils.isAlteraTodosProc((Usuario)usuario, (Long)(entidadeId = this.entidadeService.getEntidadeLogada())).booleanValue()) {
            List locaisUsuario = this.usuarioService.getLocaisUsuario(usuario);
            spec = spec.and(ProcessoSpecificationHelper.byLocalDestinoIn((List)locaisUsuario));
        }
        if ((controlaPermissaoTipoProcesso = this.parametroService.getParamValueAsBoolean(ParametroEnum.CONTROLA_PERMISSAO_TIPOS_PROCESSO.getCodigo())).booleanValue()) {
            List tiposProcessoUsuario = this.usuarioService.getTiposProcessoUsuario(usuario);
            spec = spec.and(ProcessoSpecificationHelper.byTipoIn((List)tiposProcessoUsuario));
        }
        return spec;
    }

    public Processo getProcessoPermissaoLocal(Entidade entidade, String username, Long tipo, Long numero, Long ano) {
        Long entidadeId;
        if (Objects.isNull(tipo) || Objects.isNull(numero) || Objects.isNull(ano)) {
            throw new EloValidationException("Campos Tipo, N\u00famero e Ano devem ser preenchidos!");
        }
        Usuario usuario = this.usuarioService.findUsuarioByName(username);
        if (!UsuarioUtils.isAlteraTodosProc((Usuario)usuario, (Long)(entidadeId = this.entidadeService.getEntidadeLogada())).booleanValue()) {
            List locaisUsuario = this.usuarioService.getLocaisUsuario(usuario);
            return this.repository.findOneByIdAnoAndIdTipoIdAndIdNumeroAndIdEntidadeIdAndLocaisIn(ano, tipo, numero, entidade.getId(), locaisUsuario);
        }
        return this.repository.findOneByIdAnoAndIdTipoIdAndIdNumeroAndIdEntidadeId(ano, tipo, numero, entidade.getId());
    }

    public Long getQuantidadeProcessosReceber(String usuario) {
        Boolean controlaPermissaoTipoProcesso = this.parametroService.getParamValueAsBoolean(ParametroEnum.CONTROLA_PERMISSAO_TIPOS_PROCESSO.getCodigo());
        if (this.isFilterUser(usuario).booleanValue()) {
            if (controlaPermissaoTipoProcesso.booleanValue()) {
                return this.repository.countProcessosByUsuario(this.entidadeService.getEntidadeAtual().getId(), Funcao.ENCAMINHADO.getStatus(), usuario);
            }
            return this.repository.countProcessosByUsuarioIgnoreTipoProcesso(this.entidadeService.getEntidadeAtual().getId(), Funcao.ENCAMINHADO.getStatus(), usuario);
        }
        return this.repository.countProcessos(this.entidadeService.getEntidadeAtual().getId(), Funcao.ENCAMINHADO.getStatus());
    }

    public Map<String, BigDecimal> getQuantidadeProcessosOuvidoriaPorTipo(Long idEntidade) {
        Entidade entidade = (Entidade)this.entidadeService.findOne((Serializable)this.parametroService.getParamLongEntidadeProcessoExterno());
        if (Objects.nonNull(idEntidade)) {
            entidade = (Entidade)this.entidadeService.findOne((Serializable)idEntidade);
        }
        List list = this.repository.findQuantidadeProcessosOuvidoriaPorTipo(entidade);
        return list.stream().collect(Collectors.toMap(QuantidadeProcessosOuvidoriaDTO::getDescricao, QuantidadeProcessosOuvidoriaDTO::getQuantidade));
    }

    public Map<String, BigDecimal> getQuantidadeProcessosOuvidoriaPorStatus(Long idEntidade) {
        Entidade entidade = (Entidade)this.entidadeService.findOne((Serializable)this.parametroService.getParamLongEntidadeProcessoExterno());
        if (Objects.nonNull(idEntidade)) {
            entidade = (Entidade)this.entidadeService.findOne((Serializable)idEntidade);
        }
        List list = this.repository.findQuantidadeProcessosOuvidoriaPorStatus(entidade);
        return list.stream().collect(Collectors.toMap(QuantidadeProcessosOuvidoriaDTO::getDescricao, QuantidadeProcessosOuvidoriaDTO::getQuantidade));
    }

    public Long getQuantidadeProcessosEncaminhar(String usuario) {
        Boolean controlaPermissaoTipoProcesso = this.parametroService.getParamValueAsBoolean(ParametroEnum.CONTROLA_PERMISSAO_TIPOS_PROCESSO.getCodigo());
        if (this.isFilterUser(usuario).booleanValue()) {
            if (controlaPermissaoTipoProcesso.booleanValue()) {
                return this.repository.countProcessosByUsuarioAndParalisado(this.entidadeService.getEntidadeAtual().getId(), Funcao.RECEBIDO.getStatus(), usuario, SimNao.fromBoolean((Boolean)Boolean.FALSE));
            }
            return this.repository.countProcessosByUsuarioIgnoreTipoProcessoAndParalisado(this.entidadeService.getEntidadeAtual().getId(), Funcao.RECEBIDO.getStatus(), usuario, SimNao.fromBoolean((Boolean)Boolean.FALSE));
        }
        return this.repository.countProcessosByParalisado(this.entidadeService.getEntidadeAtual().getId(), Funcao.RECEBIDO.getStatus(), SimNao.fromBoolean((Boolean)Boolean.FALSE));
    }

    private Boolean isFilterUser(String usuario) {
        Long entidadeId;
        Usuario usuarioFinder = this.usuarioService.findUsuarioByName(usuario);
        return UsuarioUtils.isAlteraTodosProc((Usuario)usuarioFinder, (Long)(entidadeId = this.entidadeService.getEntidadeLogada())) == false;
    }

    public Page<Processo> listarProcessosEncaminhar(TramitacaoListagemParams params, Boolean filtrarResponsavelTramite, Boolean paralisado) {
        HashSet funcoes = Sets.newHashSet((Object[])new Funcao[]{Funcao.RECEBIDO});
        Specification specProcessosEncaminhar = this.buildSpecificationFilterProcessos((Set)funcoes, params).and(ProcessoSpecificationHelper.byProcessoPago()).and(ProcessoSpecificationHelper.byParalisado((Boolean)paralisado));
        if (filtrarResponsavelTramite.booleanValue()) {
            specProcessosEncaminhar = specProcessosEncaminhar.and(ProcessoSpecificationHelper.byUsuarioResponsavelTramite((String)params.getUsuario()));
        }
        return this.repository.findAll(specProcessosEncaminhar, params.getPageable());
    }

    public Page<Processo> listarProcessosFavoritos(TramitacaoListagemParams params) {
        HashSet funcoes = Sets.newHashSet((Object[])new Funcao[]{Funcao.RECEBIDO, Funcao.ENCAMINHADO, Funcao.ENCAMINHADO, Funcao.ABERTO});
        Specification spec = this.buildSpecificationFilterProcessos((Set)funcoes, params);
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(Processo.class);
        Root rootProcesso = query.from(Processo.class);
        Root rootFavorito = query.from(ProcessoFavorito.class);
        Predicate favoritoPredicate = cb.and(new Predicate[]{cb.equal((Expression)rootFavorito.get("id").get("usuario").get("id"), (Object)params.getUsuario()), cb.equal((Expression)rootFavorito.get("id").get("processo").get("id").get("numero"), (Expression)rootProcesso.get("id").get("numero")), cb.equal((Expression)rootFavorito.get("id").get("processo").get("id").get("ano"), (Expression)rootProcesso.get("id").get("ano")), cb.equal((Expression)rootFavorito.get("id").get("processo").get("id").get("tipo").get("id"), (Expression)rootProcesso.get("id").get("tipo").get("id")), cb.equal((Expression)rootFavorito.get("id").get("processo").get("id").get("entidade").get("id"), (Expression)rootProcesso.get("id").get("entidade").get("id"))});
        query.select((Selection)rootProcesso).where(new Predicate[]{spec.toPredicate(rootProcesso, query, cb), favoritoPredicate});
        TypedQuery typedResultQuery = this.entityManager.createQuery(query);
        List result = typedResultQuery.getResultList();
        int startIndex = (int)params.getPageable().getOffset();
        int endIndex = Math.min(startIndex + params.getPageable().getPageSize(), result.size());
        return new PageImpl(result.subList(startIndex, endIndex), params.getPageable(), (long)result.size());
    }

    public Page<Processo> listarProcessosReceber(TramitacaoListagemParams params, Boolean filtrarResponsavelTramite) {
        HashSet funcoes = Sets.newHashSet((Object[])new Funcao[]{Funcao.ENCAMINHADO});
        Specification specificationProcesso = this.buildSpecificationFilterProcessos((Set)funcoes, params).and(ProcessoSpecificationHelper.byProcessoPago());
        if (filtrarResponsavelTramite.booleanValue()) {
            specificationProcesso = specificationProcesso.and(ProcessoSpecificationHelper.byUsuarioResponsavelTramite((String)params.getUsuario()));
        }
        Pageable pageable = params.getPageable();
        Sort sort = pageable.getSort();
        if (params.getSearch() != null && params.getSearch().contains("lote")) {
            sort = Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"tramites.loteSequencia")});
        }
        PageRequest orderByHora = PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)sort);
        return this.repository.findAll(specificationProcesso, (Pageable)orderByHora);
    }

    public Page<Processo> listarProcessosArquivar(TramitacaoListagemParams params) {
        HashSet funcoes = Sets.newHashSet((Object[])new Funcao[]{Funcao.ABERTO, Funcao.RECEBIDO, Funcao.ENCAMINHADO});
        Specification specProcessosArquivar = this.buildSpecificationFilterProcessos((Set)funcoes, params).and(ProcessoSpecificationHelper.filtrarProcessosSemControleDeTramitacao());
        return this.repository.findAll(specProcessosArquivar, params.getPageable());
    }

    public Page<Processo> listarProcessosArquivados(TramitacaoListagemParams params) {
        HashSet funcoes = Sets.newHashSet((Object[])new Funcao[]{Funcao.ARQUIVADO});
        Specification specProcessosArquivar = this.buildSpecificationFilterProcessos((Set)funcoes, params).and(ProcessoSpecificationHelper.filtrarProcessosSemControleDeTramitacao());
        return this.repository.findAll(specProcessosArquivar, params.getPageable());
    }

    public Page<Processo> listarProcessosVencidos(String usuario) {
        Usuario usuarioLogado = this.usuarioService.findUsuarioByName(usuario);
        Long entidade = this.entidadeService.getEntidadeLogada();
        return this.repository.getProcessosVencidos(LocalDate.now(), usuarioLogado.getId(), entidade, UsuarioUtils.isAlteraTodosProc((Usuario)usuarioLogado, (Long)entidade), this.isProcessoMP());
    }

    public Page<Processo> listarProcessosAVencer(String usuario) {
        Usuario usuarioLogado = this.usuarioService.findUsuarioByName(usuario);
        Long entidade = this.entidadeService.getEntidadeAtual().getId();
        Long diasAVencer = Optional.ofNullable(this.parametroService.getParamValueAsLong(ParametroEnum.PARAMETRO_DIAS_AVENCER.getCodigo())).orElse(DIAS_AVENCER_DEFAULT);
        return this.repository.getProcessosAVencer(LocalDate.now(), usuarioLogado.getId(), diasAVencer, entidade, UsuarioUtils.isAlteraTodosProc((Usuario)usuarioLogado, (Long)entidade), this.isProcessoMP(), this.getQtdDiasAVencerMP());
    }

    public Page<Processo> listarProcessosDentroDoPrazo(String usuario) {
        Usuario usuarioLogado = this.usuarioService.findUsuarioByName(usuario);
        Long entidade = this.entidadeService.getEntidadeAtual().getId();
        return this.repository.getProcessosEmDia(LocalDate.now(), usuarioLogado.getId(), entidade, UsuarioUtils.isAlteraTodosProc((Usuario)usuarioLogado, (Long)entidade), this.isProcessoMP(), this.getQtdDiasAVencerMP());
    }

    public Page<Processo> listarProcessosEncaminhadosUsuario(TramitacaoListagemParams params, Boolean filtrarUsuarioReg) {
        HashSet funcoes = Sets.newHashSet((Object[])new Funcao[]{Funcao.ABERTO, Funcao.RECEBIDO, Funcao.ENCAMINHADO, Funcao.ARQUIVADO});
        Specification specProcessosEncaminhar = this.buildSpecificationFilterProcessos((Set)funcoes, params, Boolean.FALSE, Boolean.TRUE);
        if (Boolean.TRUE.equals(filtrarUsuarioReg)) {
            specProcessosEncaminhar = specProcessosEncaminhar.and(ProcessoSpecificationHelper.byUsuarioRegistroTramite((String)params.getUsuario()));
        }
        if (!Strings.isNullOrEmpty((String)params.getSearch())) {
            specProcessosEncaminhar = specProcessosEncaminhar.and((Specification)new RsqlSpecification(this.entityManager, params.getSearch()));
        }
        return this.repository.findAll(specProcessosEncaminhar, params.getPageable());
    }

    public Page<Processo> getProcessos(TramitacaoListagemParams params, ConfigRestricao configRestricao) {
        HashSet funcoes = Sets.newHashSet((Object[])new Funcao[]{Funcao.ABERTO, Funcao.RECEBIDO, Funcao.ENCAMINHADO, Funcao.ARQUIVADO});
        Specification spec = this.buildSpecificationFilterProcessos((Set)funcoes, params, Boolean.FALSE, Boolean.FALSE);
        Long entidadeId = this.entidadeService.getEntidadeLogada();
        if (!UsuarioUtils.isAlteraTodosProc((Usuario)configRestricao.getUsuario(), (Long)entidadeId).booleanValue() && configRestricao.getLiberaDevidoSolicitacaoAssinatura().booleanValue()) {
            spec = spec.or(ProcessoSpecificationHelper.filtrarProcessosUsuarioComAssinatura((String)configRestricao.getUsuario().getId()));
        }
        if (!Strings.isNullOrEmpty((String)params.getSearch())) {
            spec = spec.and((Specification)new RsqlSpecification(this.entityManager, params.getSearch()));
        }
        return this.repository.findAll(spec, params.getPageable());
    }

    private Specification<Processo> buildSpecificationFilterProcessos(Set<Funcao> funcoes, TramitacaoListagemParams params) {
        Specification spec = this.buildSpecificationFilterProcessos(funcoes, params, Boolean.TRUE, Boolean.FALSE);
        if (!Strings.isNullOrEmpty((String)params.getSearch())) {
            spec = spec.and((Specification)new RsqlSpecification(this.entityManager, params.getSearch()));
        }
        return spec;
    }

    private Specification<Processo> buildSpecificationFilterProcessos(Set<Funcao> funcoes, TramitacaoListagemParams params, Boolean consideraApenasLocalUltimoTramite, Boolean consideraApenasEncaminhadosPorMim) {
        Specification spec = Specification.where((Specification)ProcessoSpecificationHelper.byFuncoes(funcoes));
        Usuario usuario = this.usuarioService.findUsuarioByName(params.getUsuario());
        boolean naoBloqueiaVisualizacaoProcessosEncaminhadosPorMim = this.parametroService.getParamValueAsBoolean(ParametroEnum.NAO_BLOQUEIA_VISUALIZACAO_PROCESSOS_ENCAMINHADOS_POR_MIM.getCodigo());
        if (consideraApenasEncaminhadosPorMim.booleanValue() && naoBloqueiaVisualizacaoProcessosEncaminhadosPorMim) {
            boolean processoSigilosoApenasLocal = this.parametroService.getParamValueAsBoolean(ParametroEnum.PROCESSO_SIGILOSO_APENAS_LOCAL_ATUAL.getCodigo());
            if (processoSigilosoApenasLocal) {
                spec = spec.and(ProcessoSpecificationHelper.processoNaoSigiloso().or(ProcessoSpecificationHelper.usuarioPermissaoTramitacaoAtualOuLocalAtual((Usuario)usuario)));
            }
            return spec;
        }
        spec = this.permissaoLocal(usuario, consideraApenasLocalUltimoTramite, spec);
        Boolean controlaPermissaoTipoProcesso = this.parametroService.getParamValueAsBoolean(ParametroEnum.CONTROLA_PERMISSAO_TIPOS_PROCESSO.getCodigo());
        if (controlaPermissaoTipoProcesso.booleanValue()) {
            spec = spec.and(ProcessoSpecificationHelper.usuarioTipoProcesso((Usuario)usuario));
        }
        return spec;
    }

    private Specification<Processo> permissaoLocal(Usuario usuario, Boolean consideraApenasLocalUltimoTramite, Specification<Processo> spec) {
        boolean restringirQuandoNaoTiverAcessoAoLocalAtual;
        Long entidadeId = this.entidadeService.getEntidadeLogada();
        if (UsuarioUtils.isAlteraTodosProc((Usuario)usuario, (Long)entidadeId).booleanValue()) {
            return spec;
        }
        if (consideraApenasLocalUltimoTramite.booleanValue()) {
            return spec.and(ProcessoSpecificationHelper.usuarioPermissaoTramitacaoAtual((Usuario)usuario));
        }
        boolean processoSigilosoApenasLocal = this.parametroService.getParamValueAsBoolean(ParametroEnum.PROCESSO_SIGILOSO_APENAS_LOCAL_ATUAL.getCodigo());
        if (processoSigilosoApenasLocal) {
            spec = spec.and(ProcessoSpecificationHelper.processoNaoSigiloso().or(ProcessoSpecificationHelper.usuarioPermissaoTramitacaoAtualOuLocalAtual((Usuario)usuario)));
        }
        if (restringirQuandoNaoTiverAcessoAoLocalAtual = this.parametroService.getParamValueAsBoolean(ParametroEnum.BLOQUEIA_ACESSO_E_LISTAGEM_SEM_PERMISSAO_LOCAL_ATUAL.getCodigo()).booleanValue()) {
            return spec.and(ProcessoSpecificationHelper.usuarioPermissaoTramitacaoAtualOuLocalAtual((Usuario)usuario));
        }
        boolean restringirQuandoNaoHouverNenhumaTramitacaoComAcesso = this.parametroService.getParamValueAsBoolean(ParametroEnum.BLOQUEIA_ACESSO_E_LISTAGEM_PROCESSOS_SEM_TRAMITACOES_EM_LOCAIS_PERMITIDOS.getCodigo());
        if (restringirQuandoNaoHouverNenhumaTramitacaoComAcesso) {
            return spec.and(ProcessoSpecificationHelper.usuarioPermissaoLocal((Usuario)usuario));
        }
        return spec;
    }

    public List<ProcessoPK> findPKProcessoByAssuntoAndPessoaAndPeriodoDataProcesso(Long idAssunto, Long idPessoa, LocalDate dataInicial, LocalDate dataFinal) {
        List processos = this.repository.findProcessoByAssuntoAndPessoaAndPeriodoDataProcesso(this.entidadeService.getEntidadeAtual().getId(), idAssunto, idPessoa, dataInicial, dataFinal);
        return processos.stream().map(Processo::getId).collect(Collectors.toList());
    }

    @Cacheable(cacheNames={"CACHE_DASHBOARD"}, cacheManager="caffeineCacheManager")
    public List<SerieItemDTO> quantidadeProcessosPorSituacao(Optional<LocalDate> dataBase, String usuario, String tenantId) {
        log.debug("quantidadeProcessosPorSituacao Tenant:{}", (Object)tenantId);
        LocalDate data = dataBase.orElse(LocalDate.now());
        Long diasAVencer = Optional.ofNullable(this.parametroService.getParamValueAsLong(ParametroEnum.PARAMETRO_DIAS_AVENCER.getCodigo())).orElse(DIAS_AVENCER_DEFAULT);
        Long entidade = this.entidadeService.getEntidadeAtual().getId();
        Usuario usuarioAcesso = Optional.ofNullable(this.usuarioService.findUsuarioByName(usuario)).orElse(new Usuario());
        ArrayList<SerieItemDTO> serieItensDTO = new ArrayList<SerieItemDTO>();
        Boolean usuarioAcessoAlteraTodosProc = UsuarioUtils.isAlteraTodosProc((Usuario)usuarioAcesso, (Long)entidade);
        serieItensDTO.add(new SerieItemDTO(StatusPrazo.VENCIDOS.getDescricao(), BigDecimal.valueOf(this.repository.getProcessosVencidos(data, usuario, entidade, usuarioAcessoAlteraTodosProc, this.isProcessoMP()).getTotalElements())));
        serieItensDTO.add(new SerieItemDTO(StatusPrazo.AVENCER.getDescricao(), BigDecimal.valueOf(this.repository.getProcessosAVencer(data, usuario, diasAVencer, entidade, usuarioAcessoAlteraTodosProc, this.isProcessoMP(), this.getQtdDiasAVencerMP()).getTotalElements())));
        serieItensDTO.add(new SerieItemDTO(StatusPrazo.EMDIA.getDescricao(), BigDecimal.valueOf(this.repository.getProcessosEmDia(data, usuario, entidade, usuarioAcessoAlteraTodosProc, this.isProcessoMP(), this.getQtdDiasAVencerMP()).getTotalElements())));
        return serieItensDTO;
    }

    @Transactional(readOnly=true)
    public Page<Processo> findProcessosAbertosParaSistemasInternos(Long idAssunto, String search, Pageable pageable) {
        if (!this.usuarioService.isServiceAccount().booleanValue()) {
            throw new AccessDeniedException("Esse m\u00e9todo n\u00e3o pode ser acessado por um usu\u00e1rio comum. Apenas service-account");
        }
        HashSet funcoes = Sets.newHashSet((Object[])new Funcao[]{Funcao.ABERTO, Funcao.RECEBIDO, Funcao.ENCAMINHADO, Funcao.ARQUIVADO});
        long entidadeId = ContextHolder.getHeaderValueEntidade().intValue();
        Specification specification = Specification.where(null);
        if (entidadeId > 0L) {
            specification = specification.and(ProcessoSpecificationHelper.byEntidade((Entidade)this.entidadeService.getEntidadeAtual()));
        }
        specification = specification.and(ProcessoSpecificationHelper.byFuncoes((Set)funcoes));
        if (!Strings.isNullOrEmpty((String)search)) {
            specification = specification.and((Specification)new RsqlSpecification(this.entityManager, search));
        }
        if (Objects.nonNull(idAssunto)) {
            specification = specification.and(ProcessoSpecificationHelper.byIdAssunto((Long)idAssunto));
        }
        return this.repository.findAll(specification, pageable);
    }

    public Long getQuantidadeProcessosReceberPeloUsuario(String usuario) {
        return this.repository.countProcessosByUsuarioParaUsuarioResponsavel(this.entidadeService.getEntidadeAtual().getId(), Funcao.ENCAMINHADO.getStatus(), usuario);
    }

    public List<Processo> findProcessoByTramiteLotePorUltimoTramite(Long lote) {
        return this.repository.findByTramiteLoteUltimoTramite(lote);
    }

    public Processo findProcessoByPkAndUsuario(Long ano, Long tipo, Long numero, Long entidade, String cpfCnpj) {
        return this.repository.findOneByIdAnoAndIdTipoIdAndIdNumeroAndIdEntidadeIdAndPessoaCnpjCpf(ano, tipo, numero, entidade, cpfCnpj);
    }

    public List<Processo> findAllProcessosIntegracaoAssinatura() {
        return this.repository.findAllProcessosIntegracaoAssinatura();
    }

    public Page<Processo> findAllPortal(String search, Pageable pageable) {
        Specification spec = Specification.where((Specification)new RsqlSpecification(this.entityManager, search));
        return this.repository.findAll(spec, pageable);
    }

    public Long getQuantidadeProcessosEncaminharParalisado(String usuario) {
        Boolean controlaPermissaoTipoProcesso = this.parametroService.getParamValueAsBoolean(ParametroEnum.CONTROLA_PERMISSAO_TIPOS_PROCESSO.getCodigo());
        if (this.isFilterUser(usuario).booleanValue()) {
            if (controlaPermissaoTipoProcesso.booleanValue()) {
                return this.repository.countProcessosByUsuarioAndParalisado(this.entidadeService.getEntidadeAtual().getId(), Funcao.RECEBIDO.getStatus(), usuario, SimNao.fromBoolean((Boolean)Boolean.TRUE));
            }
            return this.repository.countProcessosByUsuarioIgnoreTipoProcessoAndParalisado(this.entidadeService.getEntidadeAtual().getId(), Funcao.RECEBIDO.getStatus(), usuario, SimNao.fromBoolean((Boolean)Boolean.TRUE));
        }
        return this.repository.countProcessosByParalisado(this.entidadeService.getEntidadeAtual().getId(), Funcao.RECEBIDO.getStatus(), SimNao.fromBoolean((Boolean)Boolean.TRUE));
    }

    public Page<Processo> findByRsql(String search, Pageable pageable) {
        search = search == null || ((String)search).isEmpty() ? "id.entidade.id==" + ContextHolder.getHeaderValueEntidade() : (String)search + " and id.entidade.id==" + ContextHolder.getHeaderValueEntidade();
        Specification specification = Specification.where((Specification)new RsqlSpecification(this.entityManager, (String)search));
        return this.repository.findAll(specification, pageable);
    }

    public Processo findByUuid(String uuid) {
        return this.repository.findByUuid(uuid);
    }
}

