/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.domain.UsuarioSeletor;
import br.com.elotech.protocolo.dto.AcessoProcessoDTO;
import br.com.elotech.protocolo.service.ProtocoloConfigService;
import br.com.elotech.protocolo.service.UsuarioService;
import br.com.elotech.protocolo.utils.UsuarioUtils;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ProcessoPermissaoService {
    private static final String SELETOR_ARQUIVO_DIGITAL = "Frm_ProcDocumentos";
    private final UsuarioService usuarioService;
    private final ProtocoloConfigService protocoloConfigService;

    public AcessoProcessoDTO checkPermissionsProcesso(Processo processo, String username) {
        Boolean protocoloSomenteLeitura = this.protocoloConfigService.getConfig().getProtocoloSomenteLeitura();
        if (Boolean.TRUE.equals(protocoloSomenteLeitura)) {
            return AcessoProcessoDTO.of((Boolean)Boolean.FALSE);
        }
        Usuario usuario = this.usuarioService.findUsuarioByName(username);
        UsuarioSeletor acessos = this.usuarioService.getAcessosSeletor(SELETOR_ARQUIVO_DIGITAL, usuario);
        if (acessos == null) {
            return AcessoProcessoDTO.of((Boolean)Boolean.TRUE);
        }
        Boolean podeAlterarProcesso = UsuarioUtils.isAlteraTodosProc((Usuario)usuario, (Processo)processo) != false || usuario.getUsuarioLocal().stream().anyMatch(predicate -> processo.getLocalDestino().equals((Object)predicate.getId().getLocal()));
        Boolean podeExlcuirArquivoDigital = podeAlterarProcesso != false && acessos.getExcluir() != false;
        Boolean podeAlterarArquivoDigital = podeAlterarProcesso != false && acessos.getAlterar() != false;
        Boolean podeIncluirArquivoDigital = podeAlterarProcesso != false && acessos.getInserir() != false;
        AcessoProcessoDTO acesso = new AcessoProcessoDTO();
        acesso.setAlteraArquivosDigitais(podeAlterarArquivoDigital);
        acesso.setExcluiArquivosDigitais(podeExlcuirArquivoDigital);
        acesso.setIncluiArquivosDigitais(podeIncluirArquivoDigital);
        return acesso;
    }

    @Generated
    public ProcessoPermissaoService(UsuarioService usuarioService, ProtocoloConfigService protocoloConfigService) {
        this.usuarioService = usuarioService;
        this.protocoloConfigService = protocoloConfigService;
    }
}

