/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.mail.MailService;
import br.com.elotech.core.mail.impl.MailParams;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.protocolo.config.ProtocoloProperties;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoObservadorExterno;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.dto.ProcessoAndamentoAutomaticoDTO;
import br.com.elotech.protocolo.mail.exception.SendMailException;
import br.com.elotech.protocolo.repository.ProcessoObservadorExternoRepository;
import br.com.elotech.protocolo.repository.ProcessoRepository;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.ProcessoAndamentoService;
import br.com.elotech.protocolo.service.ProcessoUsuarioViewService;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class ProcessoObservadorExternoService
extends CrudService<ProcessoObservadorExterno, UUID> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessoObservadorExternoService.class);
    private final ProcessoObservadorExternoRepository repository;
    private final MailService mailService;
    private final ProtocoloProperties emailProperties;
    private final ParametroService parametroService;
    private final ProcessoUsuarioViewService processoUsuarioViewService;
    private final ProcessoAndamentoService processoAndamentoService;
    private final ProcessoRepository processoRepository;

    public ProcessoObservadorExternoService(ProcessoObservadorExternoRepository repository, MailService mailService, ProtocoloProperties emailProperties, ParametroService parametroService, ProcessoUsuarioViewService processoUsuarioViewService, ProcessoAndamentoService processoAndamentoService, ProcessoRepository processoRepository) {
        this.mailService = mailService;
        this.repository = repository;
        this.emailProperties = emailProperties;
        this.parametroService = parametroService;
        this.processoUsuarioViewService = processoUsuarioViewService;
        this.processoAndamentoService = processoAndamentoService;
        this.processoRepository = processoRepository;
    }

    @Transactional
    public Processo findProcessoByCpfAndChave(String cpf, String chave) {
        Processo processo = this.repository.findProcessoByCpfAndChave(cpf, chave);
        if (processo == null) {
            throw RestException.notFound((String)"Processo n\u00e3o encontrado.");
        }
        this.processoAndamentoService.finalizarAndamentoByObservadorExtId(chave);
        this.processoUsuarioViewService.saveExterno(processo, cpf);
        return processo;
    }

    @Transactional
    public void sendEmail(UUID id) throws ExecutionException, InterruptedException, TimeoutException {
        ProcessoObservadorExterno processoObservadorExerno = (ProcessoObservadorExterno)this.repository.findOne((Object)id);
        if (!processoObservadorExerno.hasEmail().booleanValue()) {
            log.info(String.format("Observador Externo %s n\u00e3o possui email configurado", processoObservadorExerno.getId()));
            return;
        }
        String remetente = this.parametroService.getParamValueAsString(ParametroEnum.EMAIL_REMETENTE_PADRAO.getCodigo());
        String email = processoObservadorExerno.getEmail();
        String cpf = processoObservadorExerno.getPessoa().getCnpjCpf();
        String chave = processoObservadorExerno.getId().toString();
        String mensagem = processoObservadorExerno.getMensagem();
        Processo processo = processoObservadorExerno.getProcesso();
        ProcessoPK processoPK = processo.getId();
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        String origin = Objects.requireNonNull(servletRequestAttributes).getRequest().getHeader("Origin");
        String url = String.format("%s/protocolo/consulta-processo-chave?cpf=%s&chave=%s", origin, cpf, chave);
        String subject = processo.getAssunto().getDescricao() + " - " + processoPK.getNumero() + '/' + processoPK.getAno();
        String content = mensagem + "<br><br><b>Processo: </b>" + processoPK.getTipo().getDescricao() + " - " + processoPK.getNumero() + '/' + processoPK.getAno() + "<br><b>CPF/CNPJ: </b>" + cpf + "<br><b>Chave de Acesso: </b>" + chave + String.format("<br><a href='%s'>Clique aqui para visualizar o processo</a>", url);
        MailParams mailParams = MailParams.builder().encoding(this.emailProperties.getMail().getEncoding()).to(email).from(remetente).subject(subject).html(Boolean.TRUE.booleanValue()).multipart(Boolean.FALSE.booleanValue()).content(content).build();
        this.mailService.sendEmail(mailParams).get(1L, TimeUnit.MINUTES);
    }

    public Processo removeArquivosSigilosos(Processo processo) {
        if (Objects.nonNull(processo)) {
            processo.getArquivos().removeIf(arquivo -> Boolean.TRUE.equals(arquivo.getSigiloExterno()));
        }
        return processo;
    }

    protected void afterSave(ProcessoObservadorExterno saved, Authentication authentication) {
        Processo processo = (Processo)this.processoRepository.findOne((Object)saved.getProcesso().getId());
        processo.setUltimaAtualizacao(LocalDateTime.now());
        this.processoRepository.saveAndFlush((Object)processo);
        this.sendEmailWithAndamento(processo);
    }

    @Transactional
    public void sendEmailWithAndamento(Processo processo) {
        processo.getObservadoresExternos().forEach(p -> {
            try {
                if (processo.getAndamentos().stream().noneMatch(a -> p.getId().equals(a.getObservadorExtId()))) {
                    this.sendEmail(p.getId());
                    this.processoAndamentoService.createAndamentoAutomatico(ProcessoAndamentoAutomaticoDTO.builder().processo(processo).tipoAndamento(p.getTipoAndamento()).descricao("Andamento gerado automaticamente no envio de email de chave de acesso").observadorExtId(p.getId()).build());
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new SendMailException((Throwable)e);
            }
        });
    }
}

