/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.protocolo.converter.ProcessoInteressadoDTOConverter;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Pessoa;
import br.com.elotech.protocolo.domain.ProcessoInteressado;
import br.com.elotech.protocolo.domain.ProcessoInteressadoPK;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.domain.TipoParticipante;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.dto.ProcessoInteressadoDTO;
import br.com.elotech.protocolo.dto.params.ProcessoInteressadoParams;
import br.com.elotech.protocolo.repository.ProcessoInteressadoRepository;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ProcessoInteressadoService {
    private final ProcessoInteressadoRepository repository;

    public List<ProcessoInteressadoDTO> findByProcesso(ProcessoInteressadoParams params) {
        return this.repository.findByProcessoId(this.createProcesso(params)).stream().map(interessado -> new ProcessoInteressadoDTOConverter().to(interessado, Boolean.valueOf(true), Boolean.valueOf(true))).collect(Collectors.toList());
    }

    @Transactional
    public ProcessoInteressadoDTO create(ProcessoInteressadoParams params, ProcessoInteressadoDTO dto) {
        ProcessoPK processoPK = this.createProcesso(params);
        Long maxCodigo = this.repository.findByProcessoId(processoPK).stream().mapToLong(interessado -> interessado.getId().getCodigo()).max().orElse(0L);
        ProcessoInteressado processoInteressado = new ProcessoInteressado();
        maxCodigo = maxCodigo + 1L;
        processoInteressado.setId(ProcessoInteressadoPK.of((ProcessoPK)processoPK, (Long)maxCodigo));
        processoInteressado.setPessoa(Pessoa.of((Long)dto.getPessoa().getId()));
        processoInteressado.setTipoParticipante(TipoParticipante.of((Long)dto.getTipoParticipante().getId()));
        ProcessoInteressado processoInteressadoSaved = (ProcessoInteressado)this.repository.saveAndFlush((Object)processoInteressado);
        return new ProcessoInteressadoDTOConverter().to(processoInteressadoSaved, Boolean.valueOf(true), Boolean.valueOf(true));
    }

    @Transactional
    public void deleteById(ProcessoInteressadoParams params) {
        ProcessoInteressadoPK processoInteressadoPK = ProcessoInteressadoPK.of((ProcessoPK)this.createProcesso(params), (Long)params.getCodigo());
        this.repository.deleteById((Object)processoInteressadoPK);
    }

    protected ProcessoPK createProcesso(ProcessoInteressadoParams params) {
        return ProcessoPK.of((Entidade)Entidade.of((Long)params.getEntidade()), (TipoProcesso)TipoProcesso.of((Long)params.getTipo()), (Long)params.getNumero(), (Long)params.getAno());
    }

    @Generated
    public ProcessoInteressadoService(ProcessoInteressadoRepository repository) {
        this.repository = repository;
    }
}

