/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.outbox.domain.EntityEvent;
import br.com.elotech.outbox.domain.OutboxActions;
import br.com.elotech.outbox.publisher.Publisher;
import br.com.elotech.protocolo.config.ResponseErrorHandlerConfig;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoIntegracao;
import br.com.elotech.protocolo.dto.ProcessoPKSimplesDTO;
import br.com.elotech.protocolo.dto.ProcessoQueueDTO;
import br.com.elotech.protocolo.enums.StatusIntegracaoEnum;
import br.com.elotech.protocolo.repository.ProcessoIntegracaoRepository;
import br.com.elotech.protocolo.repository.ProcessoRepository;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.time.Duration;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.AmqpException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.data.domain.Pageable;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class ProcessoIntegracaoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessoIntegracaoService.class);
    private static final String PUBLICAR_PROCESSO_FILA_PROPERTY = "${elotech.outbox-data-integration.producer.enabled:false}";
    private static final String PUBLICAR_PROCESSO_INTEGRADOR_URL_PROPERTY = "${elotech.protocolo-integrador.url:}";
    private static final String BATCH_SIZE_PROPERTY = "${elotech.protocolo-integrador.batch-size:1000}";
    private final ProcessoIntegracaoRepository repository;
    private final ProcessoRepository processoRepository;
    private final Publisher publisher;
    private final Boolean publicarProcessoFila;
    private final URI processoIntegradorUrl;
    private final Integer batchSize;
    private final RestTemplate restTemplate;
    private final EntityManager em;

    public ProcessoIntegracaoService(ProcessoIntegracaoRepository repository, Publisher publisher, ProcessoRepository processoRepository, @Value(value="${elotech.outbox-data-integration.producer.enabled:false}") Boolean publicarProcessoFila, @Value(value="${elotech.protocolo-integrador.url:}") String processoIntegradorUrl, @Value(value="${elotech.protocolo-integrador.batch-size:1000}") Integer batchSize, RestTemplateBuilder restTemplateBuilder, ObjectMapper objectMapper, EntityManager em) {
        this.repository = repository;
        this.publisher = publisher;
        this.processoRepository = processoRepository;
        this.publicarProcessoFila = publicarProcessoFila;
        this.processoIntegradorUrl = Optional.ofNullable(processoIntegradorUrl).filter(StringUtils::isNotBlank).map(URI::create).map(url -> url.resolve("./api/processos/integrar")).orElse(null);
        this.em = em;
        this.batchSize = batchSize;
        this.restTemplate = restTemplateBuilder.setConnectTimeout(Duration.ofSeconds(5L)).errorHandler((ResponseErrorHandler)new ResponseErrorHandlerConfig(objectMapper)).build();
        log.info("Publicando Processo na Fila: {}", (Object)publicarProcessoFila);
        log.info("Processo Integrador URL: {}", Objects.nonNull(this.processoIntegradorUrl) ? this.processoIntegradorUrl : "N\u00c3O INTEGRADO");
    }

    @Transactional
    public void salvarProcessoIntegracao(Processo processo) {
        if (!Boolean.TRUE.equals(this.publicarProcessoFila) && Objects.isNull(this.processoIntegradorUrl)) {
            log.debug("N\u00e3o integra nada com tributos porque n\u00e3o est\u00e1 nada parametrizado");
            return;
        }
        if (processo.getUuid() == null) {
            processo.setUuid(UUID.randomUUID().toString());
        }
        if (this.repository.existsByIdProcessoAndIntegradoFalse(processo.getUuid())) {
            log.debug("J\u00e1 existe processo integra\u00e7\u00e3o para o processo {} e n\u00e3o est\u00e1 integrado", (Object)processo.getUuid());
            return;
        }
        ProcessoIntegracao processoIntegracao = new ProcessoIntegracao(processo.getUuid());
        processoIntegracao.setIntegrado(StatusIntegracaoEnum.NAO_INTEGRADO);
        this.repository.saveAndFlush((Object)processoIntegracao);
        this.enviarProcessoIntegracao(processoIntegracao);
    }

    public boolean enviarProcessoFila(ProcessoIntegracao processoIntegracao, ProcessoQueueDTO processo) {
        if (!Boolean.TRUE.equals(this.publicarProcessoFila)) {
            log.debug("N\u00e3o est\u00e1 programado para enviar processo para fila");
            return false;
        }
        try {
            log.info("Enviando processo integra\u00e7\u00e3o para Rabbit {}", (Object)processoIntegracao);
            this.publisher.publish(OutboxActions.CREATED, (EntityEvent)processo);
            processoIntegracao.setIntegrado(StatusIntegracaoEnum.setIntegradoRabbit((StatusIntegracaoEnum)processoIntegracao.getIntegrado()));
            log.info(String.format("Processo:  %s/%s/%s/%s enviado para fila.", processo.getEntidade(), processo.getProcesso(), processo.getTipoProcesso(), processo.getExercicio()));
            return true;
        }
        catch (AmqpException e) {
            log.warn("Erro ao enviar processo para fila. {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    public boolean enviarProcessoIntegrador(ProcessoIntegracao processoIntegracao, ProcessoQueueDTO processoQueueDTO) {
        if (Objects.isNull(this.processoIntegradorUrl)) {
            log.debug("N\u00e3o vai enviar para o integrador por url pois n\u00e3o est\u00e1 configurada");
            return false;
        }
        try {
            log.debug("Enviando processo integra\u00e7\u00e3o para integrador {}", (Object)processoIntegracao);
            RequestEntity req = RequestEntity.post((URI)this.processoIntegradorUrl).contentType(MediaType.APPLICATION_JSON).body((Object)processoQueueDTO);
            ResponseEntity response = this.restTemplate.exchange(req, String.class);
            if (!response.getStatusCode().is2xxSuccessful()) {
                throw new RestException(response.getStatusCode(), (String)response.getBody());
            }
            processoIntegracao.setIntegrado(StatusIntegracaoEnum.setIntegradoIntegrador((StatusIntegracaoEnum)processoIntegracao.getIntegrado()));
            return true;
        }
        catch (RestException | RestClientException e) {
            log.warn("Falha ao enviar processo ao integrador: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    @Transactional
    public void enviarProcessoIntegracao(ProcessoIntegracao processoIntegracao) {
        log.info("Enviando processo {}", (Object)processoIntegracao);
        if (!Boolean.TRUE.equals(this.processoRepository.existsByUuid(processoIntegracao.getIdProcesso()))) {
            log.info("Processo Integra\u00e7\u00e3o {} n\u00e3o existe nos processos.", (Object)processoIntegracao.getIdProcesso());
            return;
        }
        ProcessoQueueDTO processo = this.processoRepository.findProcessosPorUuid(processoIntegracao.getIdProcesso());
        boolean enviouProcessoFila = this.enviarProcessoFila(processoIntegracao, processo);
        boolean enviouProcessoIntegrador = this.enviarProcessoIntegrador(processoIntegracao, processo);
        if (enviouProcessoFila || enviouProcessoIntegrador) {
            log.debug("Salvando Processo Integra\u00e7\u00e3o {}", (Object)processoIntegracao);
            processoIntegracao.setDataIntegracao(LocalDate.now());
            this.repository.saveAndFlush((Object)processoIntegracao);
            this.em.detach((Object)processoIntegracao);
            this.repository.updateIntegradoByIdProcesso(processoIntegracao.getIdProcesso(), processoIntegracao.getIntegrado());
        } else {
            log.debug("N\u00e3o atualiza Processo Integra\u00e7\u00e3o {}", (Object)processoIntegracao);
        }
    }

    public Set<StatusIntegracaoEnum> getStatusIntegracaoEnums() {
        HashSet<StatusIntegracaoEnum> integracoes = new HashSet<StatusIntegracaoEnum>();
        if (Objects.nonNull(this.processoIntegradorUrl)) {
            integracoes.add(StatusIntegracaoEnum.APENAS_RABBIT);
        }
        if (Boolean.TRUE.equals(this.publicarProcessoFila)) {
            integracoes.add(StatusIntegracaoEnum.APENAS_INTEGRADOR);
        }
        if (integracoes.isEmpty()) {
            log.info("N\u00e3o vai buscar processos n\u00e3o integrados pois n\u00e3o est\u00e1 configurado para integrar");
            return Set.of();
        }
        integracoes.add(StatusIntegracaoEnum.NAO_INTEGRADO);
        return integracoes;
    }

    public List<ProcessoPKSimplesDTO> findAllProcessosNaoIntegrados() {
        return this.processoRepository.findAllProcessosByStatusIntegracao(this.getStatusIntegracaoEnums());
    }

    public List<ProcessoIntegracao> findAllPendenteIntegrado(Set<StatusIntegracaoEnum> integracoes) {
        return this.repository.findAllByIntegradoIn(integracoes, Pageable.ofSize((int)this.batchSize)).getContent();
    }
}

