/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.LocalPK;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.Situacao;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.service.EntidadeService;
import br.com.elotech.protocolo.service.ExercicioService;
import br.com.elotech.protocolo.service.LocalService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.SituacaoService;
import br.com.elotech.protocolo.service.TipoProcessoService;
import br.com.elotech.protocolo.service.UsuarioService;
import java.io.Serializable;
import java.util.Optional;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ProcessoInitializerService {
    private final SituacaoService situacaoService;
    private final EntidadeService entidadeService;
    private final ExercicioService exercicioService;
    private final TipoProcessoService tipoProcessoService;
    private final ParametroService parametroService;
    private final LocalService localService;
    private final UsuarioService usuarioService;

    public Processo initialize(String username) {
        Page locaisPermissao;
        long one = 1L;
        Processo processoInicial = new Processo();
        Situacao situacaoPadrao = this.getSituacaoPadrao();
        processoInicial.getId().setEntidade(this.entidadeService.getEntidadeAtual());
        processoInicial.setSituacao(situacaoPadrao);
        processoInicial.getId().setTipo((TipoProcesso)this.tipoProcessoService.getTipoProcessoPrioritarioByUsuario(username).orElse(null));
        Optional.ofNullable(this.parametroService.getParamValueAsLong(ParametroEnum.PROCESSO_MP_LOCAL_BASE.getCodigo())).map(idLocal -> this.localService.findById((Serializable)LocalPK.of((Entidade)this.entidadeService.getEntidadeAtual(), (Long)idLocal)).orElse(null)).ifPresent(local -> processoInicial.setLocalDestino(local));
        if (Boolean.FALSE.equals(this.usuarioService.isServiceAccount()) && (locaisPermissao = this.localService.searchByUsuarioAndDescricao(username, "", null, Pageable.ofSize((int)10))).stream().count() == 1L) {
            locaisPermissao.stream().findFirst().ifPresent(arg_0 -> ((Processo)processoInicial).setLocalOrigem(arg_0));
        }
        return processoInicial;
    }

    private Situacao getSituacaoPadrao() {
        return this.situacaoService.getSituacaoPadrao(this.entidadeService.getEntidadeAtual(), this.exercicioService.getExercicioAtual()).orElse(null);
    }

    @Generated
    public ProcessoInitializerService(SituacaoService situacaoService, EntidadeService entidadeService, ExercicioService exercicioService, TipoProcessoService tipoProcessoService, ParametroService parametroService, LocalService localService, UsuarioService usuarioService) {
        this.situacaoService = situacaoService;
        this.entidadeService = entidadeService;
        this.exercicioService = exercicioService;
        this.tipoProcessoService = tipoProcessoService;
        this.parametroService = parametroService;
        this.localService = localService;
        this.usuarioService = usuarioService;
    }
}

