/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.fluent.ReportDatasource;
import br.com.elotech.fluent.param.HashMapParamsLoader;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.protocolo.report.RelatorioProtocolo;
import br.com.elotech.protocolo.repository.ProcessoRepository;
import br.com.elotech.protocolo.web.controller.params.RelatorioProcessoParams;
import br.com.elotech.report.EloReportFactory;
import br.com.elotech.report.file.ReportFileResolverFactory;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service
public class ProcessoGeralRelatorioService {
    public static final String DATASET_CABECALHO = "Cabe\u00e7alho";
    public static final String DATASET_PROCESSOS_GERAL = "ProcessosGeral";
    private final ProcessoRepository processoRepository;
    private final ReportFileResolverFactory reportFileResolverFactory;

    public ProcessoGeralRelatorioService(ProcessoRepository processoRepository, ReportFileResolverFactory reportFileResolverFactory) {
        this.processoRepository = processoRepository;
        this.reportFileResolverFactory = reportFileResolverFactory;
    }

    public byte[] createProcessoGeralPdfReport(RelatorioProcessoParams params) {
        ReportDatasource datasource = ReportDatasource.builder().add(DATASET_CABECALHO, () -> this.processoRepository.getCabecalhoEntidade(params.getEntidade(), params.getExercicio())).add(DATASET_PROCESSOS_GERAL, () -> this.processoRepository.getProcessoGeral(params)).params((ParamLoader)new HashMapParamsLoader(params.toJdbcParameters().getValues())).build();
        if (Objects.nonNull(params.getExportarExcel()) && params.getExportarExcel().booleanValue()) {
            return EloReportFactory.crystal().reportFile(this.reportFileResolverFactory.fromFile(RelatorioProtocolo.PROCESSOS_GERAL.getDefaultRpt())).setReportDatasource(datasource).build().exportToCsv();
        }
        return EloReportFactory.crystal().reportFile(this.reportFileResolverFactory.fromFile(RelatorioProtocolo.PROCESSOS_GERAL.getDefaultRpt())).setReportDatasource(datasource).build().exportToPdf();
    }
}

