/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.fluent.ReportDatasource;
import br.com.elotech.fluent.dataset.loader.DatasetLoaders;
import br.com.elotech.fluent.dataset.loader.ReportDataLoader;
import br.com.elotech.fluent.param.HashMapParamsLoader;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.report.RelatorioProtocolo;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.ProcessoService;
import br.com.elotech.protocolo.web.controller.params.RelatorioEtiquetaParams;
import br.com.elotech.report.EloReportFactory;
import br.com.elotech.report.file.ReportFileResolverFactory;
import java.util.Objects;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.stereotype.Service;

@Configuration
@Service
public class ProcessoEtiquetaRelatorioService {
    private static final String PROP_MAXIMO_COPIAS = "${elotech.protocolo.report.etiqueta.quantidadeMaximaCopias}";
    private static final String PROP_ETIQUETA_INICIAL_MAXIMA = "${elotech.protocolo.report.etiqueta.etiquetaMaximaInicial}";
    private static final String PROCESSO_ETIQUETA = "sql/processo-etiqueta.sql";
    private static final String DATASET_ETIQUETA = "Etiqueta";
    private final DataSource dataSource;
    private final Long quantidadeMaximaCopias;
    private final Long qtdMaxEtiquetaInicial;
    private final ReportFileResolverFactory reportFileResolverFactory;
    private ParametroService parametroService;
    private ProcessoService processoService;

    public ProcessoEtiquetaRelatorioService(DataSource dataSource, @Value(value="${elotech.protocolo.report.etiqueta.quantidadeMaximaCopias}") Long quantidadeMaximaCopias, @Value(value="${elotech.protocolo.report.etiqueta.etiquetaMaximaInicial}") Long etiquetaMaximaInicial, ReportFileResolverFactory reportFileResolverFactory, ParametroService parametroService, ProcessoService processoService) {
        this.dataSource = dataSource;
        this.quantidadeMaximaCopias = quantidadeMaximaCopias;
        this.qtdMaxEtiquetaInicial = etiquetaMaximaInicial;
        this.reportFileResolverFactory = reportFileResolverFactory;
        this.parametroService = parametroService;
        this.processoService = processoService;
    }

    public byte[] createProcessoEtiquetaPdfReport(RelatorioEtiquetaParams params) {
        if (Objects.nonNull(params.getEntidade()) && Objects.nonNull(params.getTipo()) && Objects.nonNull(params.getAno()) && Objects.nonNull(params.getNumeroini())) {
            this.processoService.updateDigitacaoEtiqueta(params.getEntidade(), params.getTipo(), params.getAno(), params.getNumeroini());
        }
        String sqlInicial = this.montaFiltroSqlIntervalo(params, FileUtils.readResourceAsString((String)PROCESSO_ETIQUETA));
        MapSqlParameterSource jdbcParameters = params.toJdbcParameters();
        if (params.getQtdecopias() > this.quantidadeMaximaCopias) {
            params.setQtdecopias(this.quantidadeMaximaCopias);
        }
        if (params.getEtiquetainicial() > this.qtdMaxEtiquetaInicial) {
            params.setEtiquetainicial(this.qtdMaxEtiquetaInicial);
        }
        StringBuffer sqlFinal = new StringBuffer().append(this.montarCopiasSql(params.getQtdecopias(), sqlInicial)).append(this.montarSqlEtiquetaInicial(params.getEtiquetainicial(), params.getEntidade())).append("\n order by 1,2,3");
        ReportDatasource datasource = ReportDatasource.builder().add(DATASET_ETIQUETA, (ReportDataLoader)DatasetLoaders.jdbc((String)sqlFinal.toString(), (MapSqlParameterSource)jdbcParameters, (DataSource)this.dataSource)).params((ParamLoader)new HashMapParamsLoader(jdbcParameters.getValues())).build();
        String rptName = params.getModelo();
        if (rptName.isEmpty()) {
            rptName = RelatorioProtocolo.ETIQUETA.getDefaultRpt("", this.parametroService.getParamValueAsString(ParametroEnum.MODELO_ETIQUETA.getCodigo()));
        }
        return EloReportFactory.crystal().reportFile(this.reportFileResolverFactory.fromFile(rptName)).setReportDatasource(datasource).build().exportToPdf();
    }

    private String montarSqlEtiquetaInicial(Long etiquetaInicial, Long entidade) {
        StringBuilder sql = new StringBuilder();
        int i = 1;
        while ((long)i < etiquetaInicial) {
            sql.append(" \n  union all \n ").append(" select 0 as tipo, 0 as numero, 0 as ano ,null as dataprocesso, null as horaorigem,").append("        '' as horaorigemformatada, '.' as nome , '' as tipodescricao, '' as assuntodescricao, 0 as assuntocodigo,").append("        '' as endereco , '' as endnumero, '' as endbairro, '' as digitacao, '' as telefone, '' as localorigem, '' as localorigemdescricao, ").append("        '' as localdestino, '' as localdestinodescricao, '' as senhainternet, '' as endcomplemento, '' as endcep, '' as enduf, ").append("        '' as endcidade, '.' as assuntocomplemento, '' as processocomplemento, '' as descentidade, '' as codbarra ").append(" from entidade where entidade = ").append(entidade);
            ++i;
        }
        return sql.toString();
    }

    private String montarCopiasSql(Long qtdCopias, String sql) {
        StringBuffer novoSql = new StringBuffer();
        int i = 0;
        while ((long)i < qtdCopias) {
            if (!novoSql.toString().isEmpty()) {
                novoSql.append(" \n union all  ");
            }
            novoSql.append(sql);
            ++i;
        }
        return novoSql.toString();
    }

    private String montaFiltroSqlIntervalo(RelatorioEtiquetaParams params, String sql) {
        StringBuilder novoSql = new StringBuilder(sql);
        if (!params.getNumeroIntervalo().isEmpty()) {
            novoSql.append(" and (p.numero in (").append(params.getNumeroIntervalo()).append("))");
        }
        return novoSql.toString();
    }
}

