/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.protocolo.domain.ProcessoAssinaturaConfig;
import br.com.elotech.protocolo.enums.TipoIntegracaoEnum;
import br.com.elotech.protocolo.repository.ProcessoAssinaturaConfigRepository;
import org.springframework.stereotype.Service;

@Service
public class ProcessoAssinaturaConfigService
extends CrudService<ProcessoAssinaturaConfig, Long> {
    private final ProcessoAssinaturaConfigRepository repository;

    public ProcessoAssinaturaConfigService(ProcessoAssinaturaConfigRepository repository) {
        this.repository = repository;
    }

    public ProcessoAssinaturaConfig getProcessoAssinaturaConfigByEntidadeAndTipo(Long idEntidade, TipoIntegracaoEnum tipoIntegracao) {
        return this.repository.findByEntidadeAndTipoIntegracao(idEntidade, tipoIntegracao);
    }

    protected void beforeInsert(ProcessoAssinaturaConfig entity) {
        if (this.repository.findByEntidadeAndTipoIntegracao(entity.getEntidade(), entity.getTipoIntegracao()) != null) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel salvar. J\u00e1 existe um par\u00e2metro com o tipo de integra\u00e7\u00e3o: \"" + entity.getTipoIntegracao().getDescricao() + "\" para esta entidade.");
        }
    }
}

