/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.adm.utils.CharsetConverterUtils;
import br.com.elotech.adm.validator.ArquivoValidator;
import br.com.elotech.arquivos.domain.response.ArquivoUrl;
import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.web.request.ContextHolder;
import br.com.elotech.outbox.domain.OutboxActions;
import br.com.elotech.protocolo.config.ProtocoloHibernateIntegratorDatabaseEncodingConverter;
import br.com.elotech.protocolo.domain.AssinaturaConfiguracao;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoArquivo;
import br.com.elotech.protocolo.domain.ProcessoArquivoAssinatura;
import br.com.elotech.protocolo.domain.ProcessoArquivoPK;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.dto.ArquivoAtualizarNomeDTO;
import br.com.elotech.protocolo.dto.ArquivoDocumentoDTO;
import br.com.elotech.protocolo.dto.AssinantesIntegracaoDTO;
import br.com.elotech.protocolo.dto.AssinaturaIntegracaoRequestDTO;
import br.com.elotech.protocolo.dto.ProcessoArquivoDTO;
import br.com.elotech.protocolo.dto.ProcessoArquivoZipDTO;
import br.com.elotech.protocolo.dto.ProcessoDTO;
import br.com.elotech.protocolo.enums.AssinaturaSituacaoEnum;
import br.com.elotech.protocolo.exception.RegistroNaoEncontradoException;
import br.com.elotech.protocolo.repository.ProcessoArquivoRepository;
import br.com.elotech.protocolo.repository.ProcessoRepository;
import br.com.elotech.protocolo.service.AssinaturaConfiguracaoService;
import br.com.elotech.protocolo.service.DocumentoService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.ProcessoAndamentoService;
import br.com.elotech.protocolo.service.ProcessoIntegracaoService;
import br.com.elotech.protocolo.service.UsuarioService;
import br.com.elotech.protocolo.service.arquivo.ArquivoService;
import br.com.elotech.protocolo.service.assinatura.AssinaturaIntegracaoService;
import br.com.elotech.protocolo.signer.PdfMarginaliaUtils;
import br.com.elotech.protocolo.utils.UsuarioUtils;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import br.com.elotech.unico.client.dto.EloArquivoContentDTO;
import br.com.elotech.unico.client.dto.EloArquivoDTO;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccessStreamCache;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ProcessoArquivoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessoArquivoService.class);
    private static final String TEXTO_CANCELADO = "CANCELADO";
    private static final String USER_EXTERNO = "USER_EXTERNO";
    private static final String MSG_PERMISSAO_USUARIO_LOCAL_ATUAL = "Conforme parametriza\u00e7\u00e3o na Entidade, n\u00e3o \u00e9 poss\u00edvel a inclus\u00e3o de novos arquivos caso usu\u00e1rio n\u00e3o possua permiss\u00e3o ao local atual do processo.";
    private static final PDType1Font FONT_BOLD = new PDType1Font(Standard14Fonts.FontName.HELVETICA_BOLD);
    private static final PDType1Font FONT_DEFAULT = new PDType1Font(Standard14Fonts.FontName.HELVETICA);
    private final ArquivoService arquivoService;
    private final DocumentoService documentoService;
    private final ProcessoRepository processoRepository;
    private final ProtocoloMapper protocoloMapper;
    private final ProcessoArquivoRepository processoArquivoRepository;
    private final ProcessoIntegracaoService processoIntegracaoService;
    private final UsuarioService usuarioService;
    private final ParametroService parametroService;
    private final ProcessoAndamentoService processoAndamentoService;
    private final AssinaturaIntegracaoService assinaturaIntegracaoService;
    private final AssinaturaConfiguracaoService assinaturaConfiguracaoService;

    public ProcessoArquivoService(ArquivoService arquivoService, DocumentoService documentoService, ProcessoRepository processoRepository, ProtocoloMapper protocoloMapper, ProcessoArquivoRepository processoArquivoRepository, ProcessoIntegracaoService processoIntegracaoService, UsuarioService usuarioService, ParametroService parametroService, @Lazy ProcessoAndamentoService processoAndamentoService, @Lazy AssinaturaIntegracaoService assinaturaIntegracaoService, AssinaturaConfiguracaoService assinaturaConfiguracaoService) {
        this.arquivoService = arquivoService;
        this.documentoService = documentoService;
        this.processoRepository = processoRepository;
        this.protocoloMapper = protocoloMapper;
        this.processoArquivoRepository = processoArquivoRepository;
        this.processoIntegracaoService = processoIntegracaoService;
        this.usuarioService = usuarioService;
        this.parametroService = parametroService;
        this.processoAndamentoService = processoAndamentoService;
        this.assinaturaIntegracaoService = assinaturaIntegracaoService;
        this.assinaturaConfiguracaoService = assinaturaConfiguracaoService;
    }

    public ArquivoDTO addEloArquivo(MultipartFile file) {
        return this.arquivoService.addArquivo(file);
    }

    public ArquivoDTO addEloArquivo(ArquivoUrl arquivoUrl, String fileName, String contentType) {
        return this.arquivoService.addArquivoEntity(arquivoUrl, fileName, contentType);
    }

    public ProcessoDTO vincularArquivoProcesso(Processo processo, ArquivoDocumentoDTO arquivo, String userAuth) {
        Usuario usuario = this.usuarioService.findUsuarioByName(userAuth);
        Long idAndamento = null;
        if (userAuth.equalsIgnoreCase(USER_EXTERNO)) {
            idAndamento = this.processoAndamentoService.createAndamentoAnexoExterno(processo, arquivo.getNome());
        } else {
            this.permiteIncluirArquivoLocalAtual(processo, usuario);
        }
        ProcessoArquivo processoArquivo = new ProcessoArquivo();
        processoArquivo.setId(new ProcessoArquivoPK(processo));
        processoArquivo.setDescricao(arquivo.getNome());
        processoArquivo.setNome(arquivo.getNome());
        processoArquivo.setUsuario(userAuth);
        processoArquivo.setIdArquivo(arquivo.getId());
        processoArquivo.setUrlS3(arquivo.getFullPath());
        processoArquivo.setIdentificador(UUID.randomUUID().toString());
        processoArquivo.setDocumento(this.documentoService.findDocumentoArquivo(arquivo.getDocumento()));
        processoArquivo.setUsuarioNome(Optional.ofNullable(usuario).map(Usuario::getNome).orElse(userAuth));
        processoArquivo.setSigiloExterno(this.parametroService.getParamValueAsBoolean(ParametroEnum.MARCA_BLOQUEADA_VISUALIZACAO_EXTERNA.getCodigo()));
        processoArquivo.setAgrupamento(Boolean.valueOf(false));
        processoArquivo.setSalvoPeloSistema(Boolean.valueOf(false));
        processoArquivo.setSequenciaTramitacao(Long.valueOf(1L));
        processoArquivo.setIdAndamento(idAndamento);
        return this.addArquivo(processo, processoArquivo);
    }

    @Transactional
    public ProcessoDTO addArquivo(Processo processo, String userAuth, MultipartFile file, Long documentoId, Boolean isAgrupamento, Boolean isSalvoPeloSistema, Boolean ignoraValidacaoLocal, Boolean hasSignatures) throws InterruptedException, IOException {
        Usuario usuario = this.usuarioService.findUsuarioByName(userAuth);
        String fileName = file.getOriginalFilename();
        Long idAndamento = null;
        if (!userAuth.equalsIgnoreCase(USER_EXTERNO) || LocalDateTime.now().minusMinutes(5L).truncatedTo(ChronoUnit.SECONDS).isAfter(processo.getDataRegistro().truncatedTo(ChronoUnit.SECONDS))) {
            idAndamento = this.validacoesUsuario(processo, userAuth, usuario, fileName, ignoraValidacaoLocal);
        }
        ArquivoDTO arquivoDTOSalvo = this.arquivoService.addArquivo(file);
        ProcessoArquivo processoArquivo = this.gerarProcessoArquivo(processo, userAuth, fileName, documentoId, isAgrupamento, isSalvoPeloSistema, usuario, arquivoDTOSalvo);
        processoArquivo.setIdAndamento(idAndamento);
        if (!Boolean.TRUE.equals(isAgrupamento)) {
            processoArquivo.setObrigaPosicionamentoAssinatura(hasSignatures);
            processoArquivo.setPossuiAssinaturaExterna(hasSignatures);
        }
        return this.addArquivo(processo, processoArquivo);
    }

    @Transactional
    public ProcessoDTO addArquivo(Processo processo, String userAuth, File file, Long documentoId, Boolean isAgrupamento, Boolean isSalvoPeloSistema, Boolean ignoraValidacaoLocal) throws InterruptedException, IOException {
        Usuario usuario = this.usuarioService.findUsuarioByName(userAuth);
        String fileName = file.getName();
        Long idAndamento = this.validacoesUsuario(processo, userAuth, usuario, fileName, ignoraValidacaoLocal);
        ArquivoDTO arquivoDTOSalvo = this.arquivoService.addArquivo(file);
        ProcessoArquivo processoArquivo = this.gerarProcessoArquivo(processo, userAuth, fileName, documentoId, isAgrupamento, isSalvoPeloSistema, usuario, arquivoDTOSalvo);
        processoArquivo.setIdAndamento(idAndamento);
        return this.addArquivo(processo, processoArquivo);
    }

    public ProcessoArquivo gerarProcessoArquivo(Processo processo, String userAuth, String fileName, Long documentoId, Boolean isAgrupamento, Boolean isSalvoPeloSistema, Usuario usuario, ArquivoDTO arquivoDTOSalvo) {
        ProcessoArquivo processoArquivo = new ProcessoArquivo();
        processoArquivo.setId(new ProcessoArquivoPK(processo));
        processoArquivo.setDescricao(fileName);
        processoArquivo.setNome(fileName);
        processoArquivo.setUsuario(userAuth);
        processoArquivo.setIdArquivo(arquivoDTOSalvo.getId());
        processoArquivo.setUrlS3(arquivoDTOSalvo.getFullPath());
        processoArquivo.setIdentificador(UUID.randomUUID().toString());
        processoArquivo.setDocumento(this.documentoService.findDocumentoArquivo(documentoId));
        processoArquivo.setAgrupamento(isAgrupamento);
        processoArquivo.setUsuarioNome(Optional.ofNullable(usuario).map(Usuario::getNome).orElse(userAuth));
        processoArquivo.setSalvoPeloSistema(isSalvoPeloSistema);
        processoArquivo.setSequenciaTramitacao(processo.getUltimaSequenciaTramite());
        if (!USER_EXTERNO.equalsIgnoreCase(userAuth)) {
            processoArquivo.setSigiloExterno(this.parametroService.getParamValueAsBoolean(ParametroEnum.MARCA_BLOQUEADA_VISUALIZACAO_EXTERNA.getCodigo()));
        }
        if (Boolean.TRUE.equals(isAgrupamento)) {
            processoArquivo.setPossuiAssinaturaExterna(Boolean.valueOf(false));
            processoArquivo.setObrigaPosicionamentoAssinatura(Boolean.valueOf(false));
        }
        return processoArquivo;
    }

    private Long validacoesUsuario(Processo processo, String userAuth, Usuario usuario, String fileName, Boolean ignoraValidacaoLocal) {
        Long idAndamento = null;
        if (userAuth.equalsIgnoreCase(USER_EXTERNO)) {
            idAndamento = this.processoAndamentoService.createAndamentoAnexoExterno(processo, fileName);
        } else if (!Boolean.TRUE.equals(ignoraValidacaoLocal)) {
            this.permiteIncluirArquivoLocalAtual(processo, usuario);
        }
        return idAndamento;
    }

    @Transactional
    public ProcessoDTO addArquivo(Processo processo, ProcessoArquivoDTO processoArquivoDTO) {
        ProcessoArquivo processoArquivo = this.protocoloMapper.toProcessoArquivo(processoArquivoDTO, new ProcessoArquivo());
        processoArquivo.setIdArquivo(processoArquivoDTO.getIdArquivo());
        processoArquivo.setId(new ProcessoArquivoPK(processo));
        return this.addArquivo(processo, processoArquivo);
    }

    @Transactional
    public ProcessoDTO addArquivo(Processo processo, ProcessoArquivo processoArquivo) {
        if (ProtocoloHibernateIntegratorDatabaseEncodingConverter.didIntegrate) {
            processoArquivo.setNome(CharsetConverterUtils.sanitize((String)processoArquivo.getNome()));
            processoArquivo.setDescricao(CharsetConverterUtils.sanitize((String)processoArquivo.getDescricao()));
        }
        processo.getArquivos().add(processoArquivo);
        processo.setUltimaAtualizacao(LocalDateTime.now());
        Processo saved = (Processo)this.processoRepository.saveAndFlush((Object)processo);
        this.processoIntegracaoService.salvarProcessoIntegracao(processo);
        saved.getArquivos().stream().filter(a -> Objects.nonNull(a.getIdArquivo()) && a.getIdArquivo().equals(processoArquivo.getIdArquivo())).findFirst().ifPresent(a -> a.setOrdem(processoArquivo.getId().getSequencia()));
        return this.protocoloMapper.toProcessoDTO(saved);
    }

    public Optional<EloArquivoDTO> downloadArquivo(ProcessoArquivo processoArquivo) {
        return this.arquivoService.downloadArquivo(processoArquivo.getIdArquivo());
    }

    public Optional<EloArquivoDTO> downloadArquivoByIdEloArquivo(Long idArquivo) {
        return this.arquivoService.downloadArquivo(idArquivo);
    }

    public File downloadArquivoFisico(Long idArquivo, String path) {
        return this.arquivoService.downloadArquivoFisico(idArquivo, path);
    }

    public void deletarArquivo(ProcessoArquivo processoArquivo) {
        this.arquivoService.deletarArquivo(processoArquivo.getIdArquivo());
    }

    @Transactional
    public void atualizarArquivos(Processo processo, List<ProcessoArquivoDTO> arquivos) {
        List processoArquivos = arquivos.stream().map(dto -> {
            ProcessoArquivo encontrado = this.processoArquivoRepository.findByIdentificador(dto.getIdentificador());
            ProcessoArquivo novoProcessoArquivo = new ProcessoArquivo();
            ProcessoArquivo processoArquivo = this.protocoloMapper.toProcessoArquivo(dto, novoProcessoArquivo);
            processoArquivo.getId().setProcesso(processo);
            processoArquivo.setIdArquivo(encontrado.getIdArquivo());
            processoArquivo.getAssinaturas().clear();
            processoArquivo.getAssinaturas().addAll(encontrado.getAssinaturas());
            processoArquivo.setUsuario(encontrado.getUsuario());
            processoArquivo.setUsuarioNome(encontrado.getUsuarioNome());
            processoArquivo.setUsuarioAnalise(encontrado.getUsuarioAnalise());
            processoArquivo.setUsuarioCpf(encontrado.getUsuarioCpf());
            return processoArquivo;
        }).collect(Collectors.toList());
        this.processoArquivoRepository.saveAll(processoArquivos);
    }

    @Transactional
    public ProcessoArquivo findByIdentificador(String identificador) {
        return this.processoArquivoRepository.findByIdentificador(identificador);
    }

    public ArquivoUrl getUrlDownload(String fullPath, String fileName) {
        return this.arquivoService.getUrlDownload(fullPath, fileName);
    }

    public ArquivoUrl getUrlUpload(String fileName, String contentType) {
        return this.arquivoService.getUrlUpload(fileName, contentType);
    }

    @Transactional
    public void addArquivoEntity(Processo processo, String userAuth, ArquivoUrl arquivoUrl, String fileName, String contentType, Long documentoId, Boolean hasSignatures) {
        ArquivoDTO arquivoDTOSalvo;
        Usuario usuario = this.usuarioService.findUsuarioByName(userAuth);
        if (!userAuth.equalsIgnoreCase(USER_EXTERNO)) {
            this.permiteIncluirArquivoLocalAtual(processo, usuario);
        }
        if (Objects.isNull(arquivoDTOSalvo = this.arquivoService.addArquivoEntity(arquivoUrl, fileName, contentType))) {
            return;
        }
        ProcessoArquivo processoArquivo = new ProcessoArquivo();
        processoArquivo.setId(new ProcessoArquivoPK(processo));
        processoArquivo.setDescricao(fileName);
        processoArquivo.setNome(fileName);
        processoArquivo.setUsuario(userAuth);
        processoArquivo.setIdArquivo(arquivoDTOSalvo.getId());
        processoArquivo.setUrlS3(arquivoDTOSalvo.getFullPath());
        processoArquivo.setIdentificador(UUID.randomUUID().toString());
        processoArquivo.setObrigaPosicionamentoAssinatura(hasSignatures);
        processoArquivo.setPossuiAssinaturaExterna(hasSignatures);
        processoArquivo.setDocumento(this.documentoService.findDocumentoArquivo(documentoId));
        processoArquivo.setAgrupamento(Boolean.FALSE);
        processoArquivo.setUsuarioNome(Optional.ofNullable(usuario).map(Usuario::getNome).orElse(userAuth));
        processoArquivo.setSigiloExterno(this.parametroService.getParamValueAsBoolean(ParametroEnum.MARCA_BLOQUEADA_VISUALIZACAO_EXTERNA.getCodigo()));
        processoArquivo.setSequenciaTramitacao(processo.getUltimaSequenciaTramite());
        this.addArquivo(processo, processoArquivo);
    }

    public void permiteIncluirArquivoLocalAtual(Processo processo, Usuario usuario) {
        Boolean permiteUploadSemRestricao = Optional.ofNullable(processo.getId().getTipo()).map(tipoProcesso -> tipoProcesso.getUploadAnexoSemRestricao()).orElse(false);
        if (Boolean.TRUE.equals(permiteUploadSemRestricao)) {
            return;
        }
        Boolean bloqueiaUsuarioPorLocalAtual = this.parametroService.getParamValueAsBoolean(ParametroEnum.BLOQUEIA_UPLOAD_ANEXOS_PROCESSOS_USUARIO_SEM_PERMISSAO_LOCAL_ATUAL.getCodigo());
        if (Boolean.TRUE.equals(bloqueiaUsuarioPorLocalAtual)) {
            List usuarioComPermissaoLocalAtual = usuario.getUsuarioLocal().stream().filter(usuarioLocal -> usuarioLocal.getId().getLocal().equals((Object)processo.getLocalAtual())).collect(Collectors.toList());
            if (Boolean.FALSE.equals(UsuarioUtils.isAlteraTodosProc((Usuario)usuario, (Processo)processo)) && usuarioComPermissaoLocalAtual.isEmpty()) {
                throw new EloValidationException(MSG_PERMISSAO_USUARIO_LOCAL_ATUAL);
            }
        }
    }

    private void validaAtualizarNomeArquivo(String novoNome) {
        if (!Boolean.TRUE.equals(this.parametroService.getParamValueAsBoolean(ParametroEnum.PERMITE_RENOMEAR_ANEXOS.getCodigo()))) {
            throw new EloValidationException("N\u00e3o \u00e9 permitido alterar a nomenclatura dos anexos");
        }
        if (novoNome.length() <= this.getExtension(novoNome).length()) {
            throw new EloValidationException("O arquivo n\u00e3o poder\u00e1 ser salvo sem um nome");
        }
        ArquivoValidator.validateInvalidChars((String)novoNome);
    }

    private String ajustarNomeArquivo(String nomeNovo, String nomeAntigo) {
        nomeNovo = ((String)nomeNovo).replaceAll("^[. ]+|[. ]+$", "").replaceAll("[.]+", ".");
        String extensao = this.getExtension(nomeAntigo);
        if (!extensao.equalsIgnoreCase(this.getExtension((String)nomeNovo)) && extensao.length() > 1) {
            nomeNovo = (String)nomeNovo + extensao;
        }
        return nomeNovo;
    }

    @Transactional
    public ProcessoArquivo atualizarNomeArquivo(ArquivoAtualizarNomeDTO arquivoAtualizarNomeDTO) {
        ProcessoArquivo file = this.processoArquivoRepository.findByIdentificador(arquivoAtualizarNomeDTO.getIdentificador());
        String nomeArquivo = this.ajustarNomeArquivo(arquivoAtualizarNomeDTO.getNome(), file.getNome());
        this.validaAtualizarNomeArquivo(nomeArquivo);
        file.setNome(nomeArquivo);
        file.setDescricao(nomeArquivo);
        return file;
    }

    protected String getExtension(String nomeArquivo) {
        int lastIndex = nomeArquivo.lastIndexOf(".");
        return lastIndex >= 0 ? nomeArquivo.substring(lastIndex) : "";
    }

    public File gerarZipProcessoArquivo(ProcessoArquivoZipDTO arquivos) throws IOException {
        log.warn("Iniciando o processo de compacta\u00e7\u00e3o de arquivos.");
        List processoArquivos = this.processoArquivoRepository.findByIdentificadorIn(arquivos.getArquivos().stream().map(ProcessoArquivo::getIdentificador).toList());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        String fileName = LocalDateTime.now().format(formatter) + ".zip";
        File file = new File(fileName);
        try (FileOutputStream destino = new FileOutputStream(file);
             ZipOutputStream saidaZip = new ZipOutputStream(new BufferedOutputStream(destino));){
            processoArquivos.forEach(arquivo -> {
                Optional arquivoDTO = this.downloadArquivo(arquivo);
                if (StringUtils.isBlank((CharSequence)arquivo.getNome()) || arquivoDTO.isEmpty()) {
                    log.warn("Arquivo {} n\u00e3o encontrado ou sem nome definido. Pulando compacta\u00e7\u00e3o.", arquivo);
                    return;
                }
                try {
                    byte[] arquivoBytes = this.getArquivoBinary((EloArquivoDTO)arquivoDTO.get(), arquivo);
                    saidaZip.putNextEntry(new ZipEntry(arquivo.getNome()));
                    saidaZip.write(arquivoBytes);
                }
                catch (IOException e) {
                    log.error("Erro ao ler arquivo: {}s", (Object)e.getMessage());
                    log.warn("Falha ao compactar o arquivo: {}", (Object)arquivo.getNome());
                }
            });
        }
        log.warn("Processo de compacta\u00e7\u00e3o de arquivos conclu\u00eddo.");
        return file;
    }

    private byte[] getArquivoBinary(EloArquivoDTO eloArquivoDTO, ProcessoArquivo arquivo) {
        return Optional.ofNullable(eloArquivoDTO).map(EloArquivoDTO::getContent).map(EloArquivoContentDTO::getBinary).orElseThrow(() -> new IllegalArgumentException(String.format("O arquivo com chave %s n\u00e3o tem conte\u00fado ou est\u00e1 inv\u00e1lido", arquivo.getIdentificador())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void cancelarArquivo(String identificador, String motivo) throws IOException {
        File tmpFile;
        log.debug("Iniciando cancelamento do arquivo {}", (Object)identificador);
        ProcessoArquivo processoArquivo = Optional.ofNullable(this.processoArquivoRepository.findByIdentificador(identificador)).orElseThrow(() -> new RegistroNaoEncontradoException("Arquivo n\u00e3o encontrado"));
        if (Boolean.TRUE.equals(processoArquivo.getCancelado())) {
            throw new EloValidationException("O documento j\u00e1 est\u00e1 cancelado");
        }
        log.trace("Baixando arquivo {}", (Object)identificador);
        EloArquivoDTO arquivoDTO = (EloArquivoDTO)this.downloadArquivo(processoArquivo).orElseThrow(() -> new RegistroNaoEncontradoException("N\u00e3o foi poss\u00edvel localizar o conte\u00fado do arquivo"));
        processoArquivo.setCancelado(Boolean.valueOf(true));
        processoArquivo.setDataCancelamento(LocalDateTime.now());
        processoArquivo.setMotivoCancelamento(motivo);
        log.trace("Carregando PDF do arquivo {}", (Object)identificador);
        try (PDDocument document = Loader.loadPDF((byte[])this.getArquivoBinary(arquivoDTO, processoArquivo), (String)"", null, null, (RandomAccessStreamCache.StreamCacheCreateFunction)IOUtils.createTempFileOnlyStreamCache());){
            log.trace("Vai editar PDF do arquivo {}", (Object)identificador);
            if (document.isEncrypted()) {
                log.debug("O arquivo {} precisa ser descriptografado", (Object)identificador);
                document.setAllSecurityToBeRemoved(true);
            }
            this.cancelarDocumento(document);
            this.adicionarDetalhesCancelamento(document, processoArquivo);
            tmpFile = Files.createTempFile("cancelamento", ".pdf", new FileAttribute[0]).toFile();
            log.trace("Salvando temporariamente arquivo de cancelamento do {} em {}", (Object)identificador, (Object)tmpFile.getAbsolutePath());
            document.save(tmpFile);
            log.trace("Arquivo {} editado salvo", (Object)identificador);
        }
        catch (IOException e) {
            throw new IOException("Falha ao atualizar conte\u00fado do arquivo", e);
        }
        processoArquivo.getAssinaturas().forEach(assinatura -> {
            assinatura.setDataRecusa(processoArquivo.getDataCancelamento());
            assinatura.setSituacao(AssinaturaSituacaoEnum.REJEITADO);
        });
        this.processoArquivoRepository.saveAndFlush((Object)processoArquivo);
        this.assinaturaIntegracaoService.publicarAtualizacaoArquivo(processoArquivo, OutboxActions.UPDATED);
        log.trace("Carregando arquivo tempor\u00e1rio para atualizar o conte\u00fado do arquivo {}", (Object)identificador);
        try {
            log.trace("Atualizando conte\u00fado do arquivo {}", (Object)identificador);
            this.arquivoService.updateContent(processoArquivo, tmpFile.toPath());
            log.trace("Conte\u00fado do arquivo {} atualizado", (Object)identificador);
        }
        finally {
            if (!tmpFile.delete()) {
                log.warn("Arquivo {} n\u00e3o p\u00f4de ser deletado no cancelamento do arquivo {}", (Object)tmpFile, (Object)identificador);
            }
        }
        log.debug("Cancelamento do arquivo {} finalizado com sucesso", (Object)identificador);
    }

    private void adicionarDetalhesCancelamento(PDDocument document, ProcessoArquivo processoArquivo) throws IOException {
        log.trace("Adicionando detalhes do cancelamento. Data: {}, Motivo: {}", (Object)processoArquivo.getDataCancelamento(), (Object)processoArquivo.getMotivoCancelamento());
        PDPage page = new PDPage();
        page.setMediaBox(PDRectangle.A4);
        try (PDPageContentStream contentStream = new PDPageContentStream(document, page);){
            contentStream.beginText();
            contentStream.setFont((PDFont)FONT_BOLD, 15.0f);
            contentStream.newLineAtOffset(50.0f, page.getMediaBox().getUpperRightY() - 50.0f);
            contentStream.showText("DOCUMENTO CANCELADO");
            contentStream.setFont((PDFont)FONT_DEFAULT, 15.0f);
            contentStream.newLineAtOffset(0.0f, -20.0f);
            contentStream.showText(String.format("Cancelado em: %s", processoArquivo.getDataCancelamento().format(DateTimeFormatter.ofPattern("dd/MM/yyyy hh:mm:ss"))));
            ProcessoPK processoId = processoArquivo.getId().getProcesso().getId();
            contentStream.newLineAtOffset(0.0f, -20.0f);
            contentStream.showText(String.format("Documento vinculado ao Processo %d/%d do Tipo %s (%d)", processoId.getNumero(), processoId.getAno(), processoId.getTipo().getDescricao(), processoId.getTipo().getId()));
            contentStream.newLineAtOffset(0.0f, -20.0f);
            contentStream.setFont((PDFont)FONT_BOLD, 15.0f);
            contentStream.showText("Motivo:");
            contentStream.newLineAtOffset(20.0f, -20.0f);
            contentStream.setFont((PDFont)FONT_DEFAULT, 12.0f);
            for (String texto : WordUtils.wrap((String)processoArquivo.getMotivoCancelamento(), (int)75).split("\\r?\\n")) {
                contentStream.showText(texto);
                contentStream.newLineAtOffset(0.0f, -20.0f);
            }
        }
        document.addPage(page);
    }

    private void cancelarDocumento(PDDocument document) throws IOException {
        AtomicInteger pageNumber = new AtomicInteger(1);
        for (PDPage page : document.getPages()) {
            log.trace("Adicionando cancelamento na p\u00e1gina {}", (Object)pageNumber.getAndIncrement());
            try (PDPageContentStream contentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true, true);){
                float pageWidth = page.getMediaBox().getWidth();
                float pageHeight = page.getMediaBox().getHeight();
                contentStream.setLineWidth(3.0f);
                contentStream.setStrokingColor(Color.RED);
                contentStream.moveTo(0.0f, 0.0f);
                contentStream.lineTo(pageWidth, pageHeight);
                contentStream.stroke();
                contentStream.moveTo(0.0f, pageHeight);
                contentStream.lineTo(pageWidth, 0.0f);
                contentStream.stroke();
                float textHeight = 50.0f;
                float textWidth = FONT_BOLD.getStringWidth(TEXTO_CANCELADO) / 1000.0f * 50.0f;
                contentStream.setFont((PDFont)FONT_BOLD, 50.0f);
                contentStream.setNonStrokingColor(Color.BLACK);
                contentStream.beginText();
                contentStream.newLineAtOffset((pageWidth - textWidth) / 2.0f, (pageHeight - 50.0f) / 2.0f);
                contentStream.showText(TEXTO_CANCELADO);
                contentStream.endText();
            }
            catch (IOException e) {
                throw new IOException(String.format("Falha ao adicionar cancelamento na p\u00e1gina %d", pageNumber.get()), e);
            }
        }
    }

    public void addProcessoArquivoAssinatura(Processo processo, AssinaturaIntegracaoRequestDTO assinaturaIntegracao) {
        if (Objects.isNull(assinaturaIntegracao)) {
            throw new RegistroNaoEncontradoException("N\u00e3o foi poss\u00edvel localizar as informa\u00e7\u00f5es de integra\u00e7\u00e3o.");
        }
        if (Objects.isNull(assinaturaIntegracao.getIdArquivo())) {
            log.debug("N\u00e3o precisa integrar arquivo no processo");
            return;
        }
        Optional eloArquivoDTO = this.downloadArquivoByIdEloArquivo(assinaturaIntegracao.getIdArquivo());
        if (eloArquivoDTO.isEmpty()) {
            log.warn("O Arquivo de integra\u00e7\u00e3o do processo {} n\u00e3o foi encontrado", (Object)processo);
            return;
        }
        Usuario usuarioSolicitacao = (Usuario)this.usuarioService.findById((Serializable)((Object)assinaturaIntegracao.getUsuarioSolicitante())).orElseThrow(() -> new RegistroNaoEncontradoException(String.format("Nenhum usu\u00e1rio solicitante ativo para para o cpf: %s", assinaturaIntegracao.getUsuarioSolicitante())));
        ProcessoArquivoPK pk = new ProcessoArquivoPK(processo);
        ProcessoArquivo processoArquivo = new ProcessoArquivo();
        processoArquivo.setId(pk);
        processoArquivo.setNome(((EloArquivoDTO)eloArquivoDTO.get()).getNome());
        processoArquivo.setDescricao(((EloArquivoDTO)eloArquivoDTO.get()).getNome());
        processoArquivo.setUsuario(assinaturaIntegracao.getUsuarioSolicitante());
        processoArquivo.setIdArquivo(((EloArquivoDTO)eloArquivoDTO.get()).getId());
        processoArquivo.setIdentificador(UUID.randomUUID().toString());
        processoArquivo.setUrlS3(assinaturaIntegracao.getFileKey());
        processoArquivo.setAgrupamento(Boolean.FALSE);
        processoArquivo.setOrdem(pk.getSequencia());
        if (assinaturaIntegracao.getArquivoIntegracao().booleanValue()) {
            processoArquivo.setTipoIntegracaoAssinatura(assinaturaIntegracao.getTipoIntegracao());
            processoArquivo.setIdIntegracaoAssinatura(assinaturaIntegracao.getIdMovimento());
            processoArquivo.setFilaIntegracaoAssinatura(assinaturaIntegracao.getProcessoFila());
        }
        assinaturaIntegracao.getAssinantes().forEach(assinante -> this.adicionarArquivoAssinante(assinaturaIntegracao, assinante, usuarioSolicitacao, processoArquivo));
        processo.addArquivo(processoArquivo);
    }

    private void adicionarArquivoAssinante(AssinaturaIntegracaoRequestDTO assinaturaIntegracao, AssinantesIntegracaoDTO assinante, Usuario usuarioSolicitacao, ProcessoArquivo processoArquivo) {
        Usuario usuario = this.usuarioService.findByCpf(assinante.getCpf()).stream().filter(Usuario::getAtivo).findFirst().orElseThrow(() -> new RegistroNaoEncontradoException(String.format("Nenhum usu\u00e1rio assinatura ativo para para o cpf: %s", assinante)));
        ProcessoArquivoAssinatura arquivoAssinatura = new ProcessoArquivoAssinatura();
        arquivoAssinatura.setUsuarioSolicitante(usuarioSolicitacao);
        arquivoAssinatura.setUsuario(usuario);
        arquivoAssinatura.setDataCriacao(LocalDateTime.now());
        arquivoAssinatura.setSituacao(AssinaturaSituacaoEnum.PENDENTE);
        arquivoAssinatura.setTipoAssinante(assinante.getTipo());
        arquivoAssinatura.setFluxoAssinanteSequencia(assinaturaIntegracao.getFluxoAssinanteSequencia());
        processoArquivo.addArquivoAssinatura(arquivoAssinatura);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void imprimirArquivo(String identificador, HttpServletResponse response) throws IOException {
        ProcessoArquivo processoArquivo = (ProcessoArquivo)this.processoArquivoRepository.findByIdentificadorIn(List.of(identificador)).stream().findFirst().orElseThrow(() -> new RegistroNaoEncontradoException(String.format("Arquivo n\u00e3o encontrado para o identificador: %s", identificador)));
        response.setContentType(ContentType.fromExtension((String)processoArquivo.getNome()).getType());
        String nomeSanitizado = CharsetConverterUtils.removeSymbols((String)processoArquivo.getNome().replace("\"", ""));
        response.setHeader("Content-Disposition", String.format("inline; filename=\"%s\"", nomeSanitizado));
        Path inputPdfPath = Files.createTempFile(String.format("%s-input-", identificador), ".pdf", new FileAttribute[0]).toAbsolutePath();
        File inputPdfFile = this.arquivoService.downloadArquivoFisico(processoArquivo.getIdArquivo(), inputPdfPath.toString());
        if (!inputPdfFile.exists()) {
            throw new RegistroNaoEncontradoException(String.format("Dados do arquivo %s n\u00e3o encontrados", nomeSanitizado));
        }
        File outputPdfFile = Files.createTempFile(String.format("%s-output-", identificador), ".pdf", new FileAttribute[0]).toFile();
        Boolean hasAssinaturas = processoArquivo.possuiAssinaturaSituacao(AssinaturaSituacaoEnum.ASSINADO) != false || processoArquivo.getPossuiAssinaturaExterna() != false;
        try {
            AssinaturaConfiguracao assinaturaConfiguracao = this.assinaturaConfiguracaoService.getAssinaturaConfiguracao(Long.valueOf(ContextHolder.getHeaderValueEntidade().intValue()));
            PdfMarginaliaUtils.addMarginalia((AssinaturaConfiguracao)assinaturaConfiguracao, (ProcessoArquivo)processoArquivo, (File)inputPdfFile, (File)outputPdfFile, (Boolean)hasAssinaturas);
            response.setContentLengthLong(outputPdfFile.length());
            try (FileInputStream fis = FileUtils.openInputStream((File)outputPdfFile);){
                fis.transferTo((OutputStream)response.getOutputStream());
            }
            response.flushBuffer();
        }
        finally {
            outputPdfFile.deleteOnExit();
            inputPdfFile.deleteOnExit();
        }
    }
}

