/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.adm.service.AsyncContext;
import br.com.elotech.adm.service.NotificationWebSocketService;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.dto.AgrupamentoDTO;
import br.com.elotech.protocolo.dto.params.PesquisaProcessoParams;
import br.com.elotech.protocolo.enums.StatusAgrupamento;
import br.com.elotech.protocolo.service.ProcessoArquivoAgrupamentoService;
import br.com.elotech.protocolo.service.ProcessoService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class ProcessoArquivoAsyncService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessoArquivoAsyncService.class);
    private final ProcessoArquivoAgrupamentoService agrupamentoService;
    private final ProcessoService processoService;
    private final NotificationWebSocketService notificationWebSocketService;

    public ProcessoArquivoAsyncService(ProcessoArquivoAgrupamentoService agrupamentoService, ProcessoService processoService, NotificationWebSocketService notificationWebSocketService) {
        this.agrupamentoService = agrupamentoService;
        this.processoService = processoService;
        this.notificationWebSocketService = notificationWebSocketService;
    }

    @Async
    public void montarDocumentoPdf(AgrupamentoDTO agrupamentoDTO, PesquisaProcessoParams params, Entidade entidade, Authentication auth, AsyncContext context) {
        context.restoreContext();
        ProcessoPK processoPK = ProcessoPK.of((Entidade)entidade, (TipoProcesso)TipoProcesso.of((Long)params.getTipo()), (Long)params.getNumero(), (Long)params.getAno());
        try {
            this.agrupamentoService.montarDocumentoAgrupadoPdf(agrupamentoDTO, processoPK, auth);
            this.processoService.updateStatusAgrupamentoById(StatusAgrupamento.SUCCESS, processoPK);
            this.notificationWebSocketService.notifyPageShouldUpdate(new Object[]{true, "Anexos agrupados com sucesso!"});
            log.info(String.format("Anexos do Processo %s agrupados com sucesso.", processoPK));
        }
        catch (Exception e) {
            log.error(String.format("[AGRUPAMENTO] N\u00e3o foi poss\u00edvel agrupar o processo %s", processoPK), (Throwable)e);
            this.processoService.updateStatusAgrupamentoById(StatusAgrupamento.ERROR, processoPK);
            this.notificationWebSocketService.notifyPageShouldUpdate(new Object[]{false, e.getMessage()});
        }
    }
}

