/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.utils.DateUtils;
import br.com.elotech.core.web.request.ContextHolder;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.dto.AgrupamentoDTO;
import br.com.elotech.protocolo.dto.NotificacaoAgrupamentoDTO;
import br.com.elotech.protocolo.dto.ProcessoArquivoDTO;
import br.com.elotech.protocolo.dto.params.PesquisaProcessoParams;
import br.com.elotech.protocolo.enums.StatusAgrupamento;
import br.com.elotech.protocolo.exception.AgrupamentoException;
import br.com.elotech.protocolo.exception.RegistroNaoEncontradoException;
import br.com.elotech.protocolo.report.RelatorioProtocolo;
import br.com.elotech.protocolo.repository.ProcessoArquivoRepository;
import br.com.elotech.protocolo.repository.ProcessoRepository;
import br.com.elotech.protocolo.service.ProcessoArquivoService;
import br.com.elotech.protocolo.service.ProcessoRelatorioService;
import br.com.elotech.protocolo.service.ProcessoService;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProcessoArquivoAgrupamentoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessoArquivoAgrupamentoService.class);
    private static final String ANEXOS_AGRUPADOS_PDF = "anexosAgrupados.pdf";
    private static final String TEMP_DIRECTORY = "temp_agrupador";
    private static final String PDF_EXTENSIONS = ".pdf";
    private Long totalSizeFiles = NumberUtils.LONG_ZERO;
    private final ProcessoArquivoService processoArquivoService;
    private final ProcessoArquivoRepository processoArquivoRepository;
    private final ProcessoRelatorioService processoRelatorioService;
    private final ProcessoRepository processoRepository;
    private final ProcessoService processoService;
    private final EntityManager entityManager;

    public ProcessoArquivoAgrupamentoService(ProcessoArquivoService processoArquivoService, ProcessoArquivoRepository processoArquivoRepository, ProcessoRelatorioService processoRelatorioService, ProcessoRepository processoRepository, ProcessoService processoService, EntityManager entityManager) {
        this.processoArquivoService = processoArquivoService;
        this.processoArquivoRepository = processoArquivoRepository;
        this.processoRelatorioService = processoRelatorioService;
        this.processoRepository = processoRepository;
        this.processoService = processoService;
        this.entityManager = entityManager;
    }

    private boolean filterPDFFiles(ProcessoArquivoDTO arquivo) {
        if (Optional.ofNullable(arquivo.getNome()).orElse("").toLowerCase().endsWith(PDF_EXTENSIONS) || Optional.ofNullable(arquivo.getDescricao()).orElse("").toLowerCase().endsWith(PDF_EXTENSIONS)) {
            return true;
        }
        log.debug("Arquivo {} marcado para agrupamento, por\u00e9m n\u00e3o ser\u00e1 agrupado pois n\u00e3o termina em .pdf.", (Object)arquivo.getNome());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void montarDocumentoAgrupadoPdf(AgrupamentoDTO agrupamentoDTO, ProcessoPK processoPK, Authentication auth) throws IOException, InterruptedException {
        Long entidadeLogada = RequestHeaderHelper.getEntidadeLogada();
        Integer exercicioLogado = ContextHolder.getHeaderValueExercicio();
        log.info("[AGRUPAMENTO] Iniciando processo {}/{} Entidade logada {} Exerc\u00edcio logado {}", new Object[]{processoPK.getNumero(), processoPK.getAno(), entidadeLogada, exercicioLogado});
        File tempDirectory = new File(Paths.get(TEMP_DIRECTORY, UUID.randomUUID().toString()).toString());
        try {
            if (!tempDirectory.mkdirs()) {
                throw new AgrupamentoException("N\u00e3o foi poss\u00edvel criar o diret\u00f3rio tempor\u00e1rio para o agrupamento de arquivos.");
            }
            Processo processo = (Processo)this.processoRepository.findById((Object)processoPK).orElseThrow(() -> new RegistroNaoEncontradoException("Processo n\u00e3o localizado."));
            this.deleteOldProcessoArquivoAgrupamento(processo);
            List filePathList = this.gerarArquivosFisicos(processo, agrupamentoDTO, tempDirectory.getPath());
            File arquivoAgrupado = this.gerarArquivoAgrupado(processo, filePathList, tempDirectory.getPath());
            log.info("Anexos agrupados com sucesso. Iniciando procedimento para salvar arquivo");
            this.entityManager.refresh((Object)processo);
            this.processoArquivoService.addArquivo(processo, auth.getName(), arquivoAgrupado, null, Boolean.TRUE, Boolean.FALSE, Boolean.valueOf(false));
        }
        finally {
            FileUtils.deleteDirectory((File)tempDirectory);
        }
    }

    private void deleteOldProcessoArquivoAgrupamento(Processo processo) {
        this.processoArquivoRepository.deleteByIdProcessoAndAgrupamentoTrue(processo);
        this.processoArquivoRepository.flush();
    }

    private File gerarArquivoAgrupado(Processo processo, List<String> filePathList, String pathDiretorioBase) {
        log.info("[AGRUPAMENTO] - Iniciando mesclagem de documentos {}/{}", (Object)processo.getId().getNumero().toString(), (Object)processo.getId().getAno().toString());
        File mergedFiles = new File(Paths.get(pathDiretorioBase, UUID.randomUUID().toString().concat(PDF_EXTENSIONS)).toString());
        try (FileOutputStream outputStream = new FileOutputStream(mergedFiles);){
            this.agruparArquivos(filePathList, outputStream);
        }
        catch (Exception e) {
            throw new AgrupamentoException("N\u00e3o foi poss\u00edvel gerar o arquivo agrupado.", e);
        }
        return this.addFooter(mergedFiles, pathDiretorioBase);
    }

    private List<String> gerarArquivosFisicos(Processo processo, AgrupamentoDTO agrupamentoDTO, String pathDiretorioBase) {
        this.totalSizeFiles = NumberUtils.LONG_ZERO;
        List<ProcessoArquivoDTO> arquivosParaAgrupar = agrupamentoDTO.getArquivosAgrupamento().stream().filter(arg_0 -> this.filterPDFFiles(arg_0)).collect(Collectors.toList());
        if (arquivosParaAgrupar.isEmpty()) {
            throw new RegistroNaoEncontradoException("Nenhum arquivo para executar o agrupamento.");
        }
        ArrayList<String> filePathList = new ArrayList<String>();
        if (Boolean.TRUE.equals(agrupamentoDTO.getAgruparCapa())) {
            filePathList.add(this.addCapaProcesso(processo, pathDiretorioBase));
        }
        arquivosParaAgrupar.forEach(pa -> filePathList.add(this.addArquivoProcesso(pa, pathDiretorioBase)));
        if (Boolean.TRUE.equals(agrupamentoDTO.getAgruparTramites())) {
            filePathList.add(this.addTramiteProcesso(processo, pathDiretorioBase));
        }
        return filePathList;
    }

    private void agruparArquivos(List<String> filePathList, FileOutputStream outputStream) {
        PDFMergerUtility merger = new PDFMergerUtility();
        merger.setDocumentMergeMode(PDFMergerUtility.DocumentMergeMode.OPTIMIZE_RESOURCES_MODE);
        merger.setDestinationStream((OutputStream)outputStream);
        try {
            for (String filePath : filePathList) {
                merger.addSource(filePath);
            }
            log.info("[AGRUPAMENTO] - Realizando Merge e Salvando Arquivo.");
            merger.mergeDocuments(IOUtils.createTempFileOnlyStreamCache());
            log.info("[AGRUPAMENTO] - Arquivo Agrupado criado.");
        }
        catch (IOException e) {
            throw new AgrupamentoException("Erro ao agrupar arquivos.", (Exception)e);
        }
    }

    private String saveFile(String originalName, String name, byte[] content, String pathDiretorioBase) {
        if (content.length == 0) {
            throw new AgrupamentoException("Conte\u00fado da " + originalName + " est\u00e1 vazio.");
        }
        this.totalSizeFiles = this.totalSizeFiles + (long)content.length;
        log.info("[AGRUPAMENTO] - Tamanho Total: " + FileUtils.byteCountToDisplaySize((Number)this.totalSizeFiles));
        String path = Paths.get(pathDiretorioBase, name).toString();
        File outputFile = new File(path);
        try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);){
            fileOutputStream.write(content);
        }
        catch (IOException e) {
            throw new AgrupamentoException("Falha ao salvar " + originalName, (Exception)e);
        }
        return path;
    }

    private String addCapaProcesso(Processo processo, String pathDiretorioBase) {
        log.info("[AGRUPAMENTO] - Gerando capa do processo para adicionar \u00e0 mesclagem");
        byte[] capaPdfReport = this.processoRelatorioService.createCapaPdfReport(processo, true);
        log.info("[AGRUPAMENTO] - Salvando arquivo f\u00edsico: {} - Tamanho: {}", (Object)RelatorioProtocolo.CAPA_PROCESSO.getNome(), (Object)FileUtils.byteCountToDisplaySize((long)capaPdfReport.length));
        return this.saveFile("Capa do processo", UUID.randomUUID().toString(), capaPdfReport, pathDiretorioBase);
    }

    private String addTramiteProcesso(Processo processo, String pathDiretorioBase) {
        log.info("[AGRUPAMENTO] - Gerando relat\u00f3rio de agrupamento de tramites para adicionar \u00e0 mesclagem");
        byte[] visualizacaoPdfReport = this.processoRelatorioService.createVisualizacaoPdfReport(processo);
        log.info("[AGRUPAMENTO] - Salvando arquivo f\u00edsico: {} - Tamanho: {}", (Object)RelatorioProtocolo.VISUALIZACAO_PROCESSO.getNome(), (Object)FileUtils.byteCountToDisplaySize((long)visualizacaoPdfReport.length));
        return this.saveFile("Tramita\u00e7\u00e3o do processo", UUID.randomUUID().toString(), visualizacaoPdfReport, pathDiretorioBase);
    }

    private String addArquivoProcesso(ProcessoArquivoDTO processoArquivo, String pathDiretorioBase) {
        String nomeArquivo = processoArquivo.getIdentificador();
        log.info("[AGRUPAMENTO] - Pr\u00f3ximo arquivo para download: {} - nome original: {}.", (Object)nomeArquivo, (Object)processoArquivo.getNome());
        try {
            String path = Paths.get(pathDiretorioBase, nomeArquivo).toString();
            File savedFile = this.processoArquivoService.downloadArquivoFisico(processoArquivo.getIdArquivo(), path);
            if (!savedFile.exists()) {
                throw new AgrupamentoException("Arquivo n\u00e3o encontrado ap\u00f3s download.");
            }
            if (savedFile.length() == 0L) {
                throw new AgrupamentoException("Conte\u00fado do arquivo vazio");
            }
            this.desbloquearPdf(savedFile, nomeArquivo);
            log.info("[AGRUPAMENTO] - Arquivo {} baixado com sucesso - Tamanho: {}", (Object)nomeArquivo, (Object)FileUtils.byteCountToDisplaySize((long)savedFile.length()));
            this.totalSizeFiles = this.totalSizeFiles + savedFile.length();
            log.info("[AGRUPAMENTO] - Tamanho Total: " + FileUtils.byteCountToDisplaySize((Number)this.totalSizeFiles));
            return savedFile.getPath();
        }
        catch (Exception e) {
            throw new AgrupamentoException(String.format("Falha ao baixar arquivo %s", processoArquivo.getNome()), e);
        }
    }

    private void desbloquearPdf(File savedFile, String nomeArquivo) {
        File tmpFile = null;
        try (PDDocument document = Loader.loadPDF((File)savedFile);){
            if (document.isEncrypted()) {
                log.info("[AGRUPAMENTO] - Desbloqueando arquivo {}", (Object)nomeArquivo);
                document.setAllSecurityToBeRemoved(true);
                tmpFile = File.createTempFile(nomeArquivo, "-descriptografado", savedFile.getParentFile());
                document.save(tmpFile);
            }
        }
        catch (IOException e) {
            throw new AgrupamentoException("PDF Inv\u00e1lido ou bloqueado", (Exception)e);
        }
        if (Objects.nonNull(tmpFile) && tmpFile.exists()) {
            savedFile.delete();
            tmpFile.renameTo(savedFile);
        }
    }

    private File addFooter(File file, String pathDiretorioBase) {
        File file2;
        block14: {
            log.info("[AGRUPAMENTO] - Adicionando footer ao documento");
            PDDocument document = Loader.loadPDF((File)file);
            try {
                for (int counter = 0; document.getNumberOfPages() > counter; ++counter) {
                    try (PDPageContentStream contentStream = new PDPageContentStream(document, document.getPage(counter), PDPageContentStream.AppendMode.APPEND, true, true);){
                        contentStream.beginText();
                        contentStream.setFont((PDFont)new PDType1Font(Standard14Fonts.FontName.HELVETICA), 8.0f);
                        PDRectangle pageSize = document.getPage(counter).getCropBox();
                        float x = pageSize.getLowerLeftX() + 24.0f;
                        float y = pageSize.getLowerLeftY() + 4.0f;
                        contentStream.newLineAtOffset(x, y);
                        String text = MessageFormat.format("Processo Agrupado - P\u00e1gina {0} / {1} - Gerado em {2}", counter + 1, document.getNumberOfPages(), DateUtils.formatDateBr((LocalDate)LocalDate.now()));
                        contentStream.showText(text);
                        contentStream.endText();
                        continue;
                    }
                }
                File finalFile = new File(Paths.get(pathDiretorioBase, ANEXOS_AGRUPADOS_PDF).toString());
                document.save(finalFile);
                file2 = finalFile;
                if (document == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (document != null) {
                        try {
                            document.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AgrupamentoException("N\u00e3o foi poss\u00edvel gerar o footer do arquivo agrupado.", (Exception)e);
                }
            }
            document.close();
        }
        return file2;
    }

    @Transactional
    public NotificacaoAgrupamentoDTO verificarAgrupamentoPendente(PesquisaProcessoParams params, Entidade entidade) {
        ProcessoPK pk = ProcessoPK.of((Entidade)entidade, (TipoProcesso)TipoProcesso.of((Long)params.getTipo()), (Long)params.getNumero(), (Long)params.getAno());
        NotificacaoAgrupamentoDTO notificacaoAgrupamento = new NotificacaoAgrupamentoDTO();
        try {
            this.buildNotificacaoAgrupamentoIfExists(pk, notificacaoAgrupamento);
            if (StringUtils.isNotBlank((CharSequence)notificacaoAgrupamento.getNotificacao())) {
                this.processoService.updateStatusAgrupamentoById(null, pk);
            }
        }
        catch (Exception e) {
            log.error(String.format("Erro ao verificar agrupamento do Processo %s. Motivo: %s", params.getNumero() + "/" + params.getAno(), e.getMessage()));
            notificacaoAgrupamento = null;
        }
        return notificacaoAgrupamento;
    }

    public boolean existeProcessoEmAgrupamento(Entidade entidade, PesquisaProcessoParams params) {
        ProcessoPK pk = ProcessoPK.of((Entidade)entidade, (TipoProcesso)TipoProcesso.of((Long)params.getTipo()), (Long)params.getNumero(), (Long)params.getAno());
        return this.processoRepository.existsByIdAndStatusAgrupamentoIsNull(pk);
    }

    private void buildNotificacaoAgrupamentoIfExists(ProcessoPK pk, NotificacaoAgrupamentoDTO notificacaoAgrupamento) {
        if (this.processoRepository.existsByIdAndStatusAgrupamento(pk, StatusAgrupamento.PENDENTE)) {
            notificacaoAgrupamento.setStatus(StatusAgrupamento.PENDENTE);
        } else if (this.processoRepository.existsByIdAndStatusAgrupamento(pk, StatusAgrupamento.SUCCESS)) {
            notificacaoAgrupamento.setNotificacao("O agrupamento do processo foi gerado com sucesso! Atualize a p\u00e1gina do Processo para visualizar.");
            notificacaoAgrupamento.setStatus(StatusAgrupamento.SUCCESS);
        } else if (this.processoRepository.existsByIdAndStatusAgrupamento(pk, StatusAgrupamento.ERROR)) {
            notificacaoAgrupamento.setNotificacao("N\u00e3o foi poss\u00edvel gerar o agrupamento do processo.");
            notificacaoAgrupamento.setStatus(StatusAgrupamento.ERROR);
        }
    }
}

